-- mysqldump-php https://github.com/ifsnop/mysqldump-php
--
-- Host: 127.0.0.1	Database: prox_botica
-- ------------------------------------------------------
-- Server version 	10.11.10-MariaDB
-- Date: Tue, 18 Feb 2025 19:42:25 -0500

/*!40101 SET @OLD_CHARACTER_SET_CLIENT=@@CHARACTER_SET_CLIENT */;
/*!40101 SET @OLD_CHARACTER_SET_RESULTS=@@CHARACTER_SET_RESULTS */;
/*!40101 SET @OLD_COLLATION_CONNECTION=@@COLLATION_CONNECTION */;
/*!40101 SET NAMES utf8 */;
/*!40103 SET @OLD_TIME_ZONE=@@TIME_ZONE */;
/*!40103 SET TIME_ZONE='+00:00' */;
/*!40101 SET @OLD_AUTOCOMMIT=@@AUTOCOMMIT */;
/*!40014 SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0 */;
/*!40014 SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0 */;
/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;
/*!40111 SET @OLD_SQL_NOTES=@@SQL_NOTES, SQL_NOTES=0 */;

--
-- Table structure for table `accounting_ledger`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_ledger` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `month` smallint(5) unsigned DEFAULT 0 COMMENT 'Numero de mes',
  `year` mediumint(8) unsigned DEFAULT 0 COMMENT 'Numero de mes',
  `date_of_report` date DEFAULT NULL,
  `code_account` text NOT NULL COMMENT 'Codigo de plan de cuenta',
  `name` longtext NOT NULL COMMENT 'Nombre de cuenta',
  `last_month_total` double(12,2) NOT NULL DEFAULT 0.00 COMMENT 'Debe ser el valor del total del mes pasado',
  `credits` double(12,2) NOT NULL DEFAULT 0.00 COMMENT 'Créditos en el mes',
  `debs` double(12,2) NOT NULL DEFAULT 0.00 COMMENT 'Debitos en el mes',
  `final_total` double(12,2) NOT NULL DEFAULT 0.00 COMMENT 'Saldo Final de mes',
  `serialize_data` longtext NOT NULL COMMENT 'datos serialziados en bruto.',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounting_ledger`
--

LOCK TABLES `accounting_ledger` WRITE;
/*!40000 ALTER TABLE `accounting_ledger` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `accounting_ledger` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `accounting_ledger` with 0 row(s)
--

--
-- Table structure for table `accounting_ledger_task`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounting_ledger_task` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `month` smallint(5) unsigned DEFAULT 0 COMMENT 'Numero de mes',
  `year` mediumint(8) unsigned DEFAULT 0 COMMENT 'Numero de mes',
  `last_rum` datetime DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounting_ledger_task`
--

LOCK TABLES `accounting_ledger_task` WRITE;
/*!40000 ALTER TABLE `accounting_ledger_task` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `accounting_ledger_task` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `accounting_ledger_task` with 0 row(s)
--

--
-- Table structure for table `accounts`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `number` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `accounts`
--

LOCK TABLES `accounts` WRITE;
/*!40000 ALTER TABLE `accounts` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `accounts` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `accounts` with 0 row(s)
--

--
-- Table structure for table `account_payments`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `account_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date_of_payment` date NOT NULL,
  `date_of_payment_real` date DEFAULT NULL,
  `reference_id` int(10) unsigned DEFAULT NULL,
  `payment_method_type_id` int(10) unsigned DEFAULT NULL,
  `has_card` tinyint(1) NOT NULL DEFAULT 0,
  `card_brand_id` int(10) unsigned DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `payment` decimal(12,2) NOT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  `reference_payment` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `account_payments`
--

LOCK TABLES `account_payments` WRITE;
/*!40000 ALTER TABLE `account_payments` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `account_payments` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `account_payments` with 0 row(s)
--

--
-- Table structure for table `agents`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `agents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `internal_id` varchar(255) DEFAULT NULL,
  `email` varchar(255) DEFAULT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `agents_internal_id_unique` (`internal_id`),
  KEY `agents_name_index` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `agents`
--

LOCK TABLES `agents` WRITE;
/*!40000 ALTER TABLE `agents` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `agents` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `agents` with 0 row(s)
--

--
-- Table structure for table `app_configurations`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_configurations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `show_image_item` tinyint(1) NOT NULL DEFAULT 1,
  `print_format_pdf` varchar(255) NOT NULL DEFAULT 'ticket',
  `card_color` varchar(255) NOT NULL DEFAULT 'multicolored',
  `theme_color` varchar(255) NOT NULL DEFAULT 'blue',
  `header_waves` tinyint(1) NOT NULL DEFAULT 0,
  `direct_send_documents_whatsapp` tinyint(1) NOT NULL DEFAULT 0,
  `direct_print` tinyint(1) NOT NULL DEFAULT 0,
  `app_mode` varchar(255) NOT NULL DEFAULT 'default',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_configurations`
--

LOCK TABLES `app_configurations` WRITE;
/*!40000 ALTER TABLE `app_configurations` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `app_configurations` VALUES (1,1,'ticket','multicolored','red',0,0,0,'default','2024-11-10 15:18:44','2024-11-18 09:21:25');
/*!40000 ALTER TABLE `app_configurations` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `app_configurations` with 1 row(s)
--

--
-- Table structure for table `app_modules`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_modules` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `value` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  `order_menu` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `app_modules_value_unique` (`value`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_modules`
--

LOCK TABLES `app_modules` WRITE;
/*!40000 ALTER TABLE `app_modules` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `app_modules` VALUES (1,'invoice','Factura electrónica',1,NULL,NULL),(2,'invoice-ticket','Boleta electrónica',2,NULL,NULL),(3,'sale-note','Nota de venta',3,NULL,NULL),(4,'order-note','Pedido',4,NULL,NULL),(5,'purchase','Compra',5,NULL,NULL),(6,'documents','Lista de comprobantes',6,NULL,NULL),(7,'report-sales','Reportes',7,NULL,NULL),(8,'validate-document','Validar cpe',8,NULL,NULL),(9,'customers','Clientes',9,NULL,NULL),(10,'items','Productos',10,NULL,NULL),(11,'cash','Caja',11,NULL,NULL),(12,'configuration','Configuración',12,NULL,NULL),(13,'quotation','Cotización',13,NULL,NULL);
/*!40000 ALTER TABLE `app_modules` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `app_modules` with 13 row(s)
--

--
-- Table structure for table `app_module_user`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `app_module_user` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `app_module_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `app_module_user`
--

LOCK TABLES `app_module_user` WRITE;
/*!40000 ALTER TABLE `app_module_user` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `app_module_user` VALUES (1,1,1),(2,2,1),(3,3,1),(4,4,1),(5,5,1),(6,6,1),(7,7,1),(8,8,1),(9,9,1),(10,10,1),(11,11,1),(12,12,1),(13,13,1);
/*!40000 ALTER TABLE `app_module_user` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `app_module_user` with 13 row(s)
--

--
-- Table structure for table `authorized_discount_users`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `authorized_discount_users` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `seller_id` int(10) unsigned DEFAULT NULL,
  `date` date NOT NULL,
  `time` time NOT NULL,
  `token` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `authorized_discount_users_token_unique` (`token`),
  KEY `authorized_discount_users_user_id_foreign` (`user_id`),
  KEY `authorized_discount_users_seller_id_foreign` (`seller_id`),
  KEY `authorized_discount_users_date_index` (`date`),
  KEY `authorized_discount_users_active_index` (`active`),
  CONSTRAINT `authorized_discount_users_seller_id_foreign` FOREIGN KEY (`seller_id`) REFERENCES `users` (`id`),
  CONSTRAINT `authorized_discount_users_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `authorized_discount_users`
--

LOCK TABLES `authorized_discount_users` WRITE;
/*!40000 ALTER TABLE `authorized_discount_users` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `authorized_discount_users` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `authorized_discount_users` with 0 row(s)
--

--
-- Table structure for table `banks`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `banks` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `banks`
--

LOCK TABLES `banks` WRITE;
/*!40000 ALTER TABLE `banks` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `banks` VALUES (1,'BANCO SCOTIABANK',NULL,NULL,1),(2,'BANCO DE CREDITO DEL PERU',NULL,NULL,1),(3,'BANCO DE COMERCIO',NULL,NULL,1),(4,'BANCO PICHINCHA',NULL,NULL,1),(5,'BBVA CONTINENTAL',NULL,NULL,1),(6,'INTERBANK',NULL,NULL,1);
/*!40000 ALTER TABLE `banks` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `banks` with 6 row(s)
--

--
-- Table structure for table `bank_accounts`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bank_id` int(10) unsigned NOT NULL,
  `description` varchar(255) NOT NULL,
  `number` varchar(255) NOT NULL,
  `cci` varchar(255) DEFAULT NULL,
  `currency_type_id` varchar(255) NOT NULL,
  `status` tinyint(4) NOT NULL DEFAULT 1,
  `initial_balance` decimal(12,2) NOT NULL DEFAULT 0.00,
  `show_in_documents` tinyint(1) NOT NULL DEFAULT 1,
  `establishment_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `bank_accounts_bank_id_foreign` (`bank_id`),
  KEY `bank_accounts_currency_type_id_foreign` (`currency_type_id`),
  KEY `bank_accounts_establishment_id_foreign` (`establishment_id`),
  CONSTRAINT `bank_accounts_bank_id_foreign` FOREIGN KEY (`bank_id`) REFERENCES `banks` (`id`),
  CONSTRAINT `bank_accounts_currency_type_id_foreign` FOREIGN KEY (`currency_type_id`) REFERENCES `cat_currency_types` (`id`),
  CONSTRAINT `bank_accounts_establishment_id_foreign` FOREIGN KEY (`establishment_id`) REFERENCES `establishments` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank_accounts`
--

LOCK TABLES `bank_accounts` WRITE;
/*!40000 ALTER TABLE `bank_accounts` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `bank_accounts` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `bank_accounts` with 0 row(s)
--

--
-- Table structure for table `bank_loans`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_loans` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `bank_loan_type_id` int(10) unsigned NOT NULL,
  `establishment_id` int(10) unsigned NOT NULL,
  `bank_id` int(10) unsigned NOT NULL,
  `bank_account_id` int(10) unsigned NOT NULL,
  `currency_type_id` varchar(255) NOT NULL,
  `external_id` char(36) NOT NULL,
  `number` int(11) NOT NULL,
  `date_of_issue` date NOT NULL,
  `time_of_issue` time NOT NULL,
  `bank` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`bank`)),
  `exchange_rate_sale` decimal(12,2) DEFAULT 0.00,
  `total` decimal(12,2) DEFAULT 0.00,
  `total_interest` decimal(12,2) DEFAULT 0.00,
  `total_ingress` decimal(12,2) DEFAULT 0.00,
  `soap_type_id` char(2) DEFAULT NULL,
  `state_type_id` char(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank_loans`
--

LOCK TABLES `bank_loans` WRITE;
/*!40000 ALTER TABLE `bank_loans` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `bank_loans` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `bank_loans` with 0 row(s)
--

--
-- Table structure for table `bank_loan_fee`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_loan_fee` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bank_loan_id` int(10) unsigned NOT NULL,
  `date` date NOT NULL,
  `currency_type_id` varchar(255) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `payment_method_type_id` char(2) DEFAULT NULL COMMENT 'Relacion con el metodo de pago, Nulo es pago a cuotas',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank_loan_fee`
--

LOCK TABLES `bank_loan_fee` WRITE;
/*!40000 ALTER TABLE `bank_loan_fee` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `bank_loan_fee` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `bank_loan_fee` with 0 row(s)
--

--
-- Table structure for table `bank_loan_items`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_loan_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bank_loan_id` int(10) unsigned NOT NULL,
  `description` text NOT NULL,
  `total` decimal(12,2) DEFAULT 0.00,
  `total_interest` decimal(12,2) DEFAULT 0.00,
  `total_ingress` decimal(12,2) DEFAULT 0.00,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank_loan_items`
--

LOCK TABLES `bank_loan_items` WRITE;
/*!40000 ALTER TABLE `bank_loan_items` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `bank_loan_items` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `bank_loan_items` with 0 row(s)
--

--
-- Table structure for table `bank_loan_payments`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_loan_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `bank_loan_id` int(10) unsigned NOT NULL,
  `date_of_payment` date NOT NULL,
  `payment_method_type_id` char(2) NOT NULL,
  `has_card` tinyint(1) NOT NULL DEFAULT 0,
  `card_brand_id` char(2) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `payment` decimal(12,2) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank_loan_payments`
--

LOCK TABLES `bank_loan_payments` WRITE;
/*!40000 ALTER TABLE `bank_loan_payments` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `bank_loan_payments` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `bank_loan_payments` with 0 row(s)
--

--
-- Table structure for table `bank_loan_reasons`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_loan_reasons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank_loan_reasons`
--

LOCK TABLES `bank_loan_reasons` WRITE;
/*!40000 ALTER TABLE `bank_loan_reasons` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `bank_loan_reasons` VALUES (1,'Varios');
/*!40000 ALTER TABLE `bank_loan_reasons` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `bank_loan_reasons` with 1 row(s)
--

--
-- Table structure for table `bank_loan_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `bank_loan_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `bank_loan_types`
--

LOCK TABLES `bank_loan_types` WRITE;
/*!40000 ALTER TABLE `bank_loan_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `bank_loan_types` VALUES (1,'Prestamo','2024-11-10 15:18:41','2024-11-10 15:18:41');
/*!40000 ALTER TABLE `bank_loan_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `bank_loan_types` with 1 row(s)
--

--
-- Table structure for table `billing_cycles`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `billing_cycles` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `date_time_start` datetime NOT NULL,
  `renew` tinyint(1) NOT NULL DEFAULT 0,
  `quantity_documents` int(11) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `billing_cycles`
--

LOCK TABLES `billing_cycles` WRITE;
/*!40000 ALTER TABLE `billing_cycles` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `billing_cycles` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `billing_cycles` with 0 row(s)
--

--
-- Table structure for table `brands`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `brands` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `brands_name_index` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `brands`
--

LOCK TABLES `brands` WRITE;
/*!40000 ALTER TABLE `brands` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `brands` VALUES (1,'Varios','2024-11-10 18:48:20','2024-11-10 18:48:20'),(2,'ALKOFARMA','2024-11-12 20:13:35','2024-11-12 20:13:35'),(3,'Yamboly','2024-11-17 00:42:07','2024-11-17 00:42:07'),(4,'Esika','2024-11-18 15:40:48','2024-11-18 15:40:48'),(5,'INFARMA','2024-12-31 18:00:49','2024-12-31 18:00:49');
/*!40000 ALTER TABLE `brands` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `brands` with 5 row(s)
--

--
-- Table structure for table `business_turns`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `business_turns` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `value` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `business_turns`
--

LOCK TABLES `business_turns` WRITE;
/*!40000 ALTER TABLE `business_turns` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `business_turns` VALUES (1,'hotel','Hoteles',1,'2024-11-10 15:18:28','2025-02-07 09:44:11'),(2,'transport','Empresa de transporte de pasajeros',1,'2024-11-10 15:18:28','2024-11-12 20:42:34'),(3,'restaurant','Restaurantes',0,'2024-11-10 15:18:28','2024-11-10 15:18:28'),(4,'tap','Grifos',1,'2024-11-10 15:18:28','2025-02-07 09:44:09');
/*!40000 ALTER TABLE `business_turns` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `business_turns` with 4 row(s)
--

--
-- Table structure for table `card_brands`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `card_brands` (
  `id` char(2) NOT NULL,
  `description` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  KEY `card_brands_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `card_brands`
--

LOCK TABLES `card_brands` WRITE;
/*!40000 ALTER TABLE `card_brands` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `card_brands` VALUES ('01','Visa',1),('02','Mastercard',1),('3','Yape/Plin',1);
/*!40000 ALTER TABLE `card_brands` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `card_brands` with 3 row(s)
--

--
-- Table structure for table `cash`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `date_opening` date NOT NULL,
  `time_opening` time NOT NULL,
  `date_closed` date DEFAULT NULL,
  `time_closed` time DEFAULT NULL,
  `beginning_balance` decimal(12,4) NOT NULL DEFAULT 0.0000,
  `final_balance` decimal(12,4) NOT NULL DEFAULT 0.0000,
  `income` decimal(12,4) NOT NULL DEFAULT 0.0000,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  `reference_number` varchar(20) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `apply_restaurant` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `cash_user_id_foreign` (`user_id`),
  KEY `cash_date_opening_index` (`date_opening`),
  KEY `cash_income_index` (`income`),
  KEY `cash_state_index` (`state`),
  KEY `cash_reference_number_index` (`reference_number`),
  CONSTRAINT `cash_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cash`
--

LOCK TABLES `cash` WRITE;
/*!40000 ALTER TABLE `cash` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cash` VALUES (1,3,'2025-01-10','11:31:02','2025-01-12','22:21:54',861.1000,1062.2200,201.1200,0,'10-01-2025','2025-01-10 11:31:02','2025-01-12 22:21:54',0),(2,3,'2025-01-13','07:24:06','2025-01-14','07:12:21',1062.2200,1432.2200,370.0000,0,'13-01-2025','2025-01-13 07:24:06','2025-01-14 07:12:21',0),(3,3,'2025-01-14','07:12:55','2025-01-14','07:18:40',571.1200,571.1200,0.0000,0,NULL,'2025-01-14 07:12:55','2025-01-14 07:18:40',0),(4,2,'2025-01-14','07:19:12',NULL,NULL,1616.2200,0.0000,0.0000,1,NULL,'2025-01-14 07:19:12','2025-01-14 11:35:43',0),(5,3,'2025-01-14','11:58:00','2025-01-14','14:36:52',1616.2200,1667.2200,51.0000,0,NULL,'2025-01-14 11:58:00','2025-01-14 14:36:52',0),(6,3,'2025-01-14','14:40:51','2025-01-14','22:48:49',1667.2200,1745.8200,78.6000,0,NULL,'2025-01-14 14:40:51','2025-01-14 22:48:49',0),(7,3,'2025-01-15','07:57:40','2025-01-15','14:34:59',286.4000,322.5000,36.1000,0,NULL,'2025-01-15 07:57:40','2025-01-15 14:34:59',0),(8,3,'2025-01-15','14:35:08','2025-01-15','22:29:30',0.0000,51.0000,51.0000,0,NULL,'2025-01-15 14:35:08','2025-01-15 22:29:30',0),(9,3,'2025-01-16','07:26:27','2025-01-16','14:27:51',0.0000,13.5000,13.5000,0,NULL,'2025-01-16 07:26:27','2025-01-16 14:27:51',0),(10,3,'2025-01-16','14:31:35','2025-01-16','22:34:29',0.0000,44.7000,44.7000,0,NULL,'2025-01-16 14:31:35','2025-01-16 22:34:29',0),(11,3,'2025-01-17','08:14:06','2025-01-17','14:31:00',0.0000,47.3500,47.3500,0,NULL,'2025-01-17 08:14:06','2025-01-17 14:31:00',0),(12,3,'2025-01-17','14:32:01','2025-01-17','22:32:47',0.0000,103.3000,103.3000,0,NULL,'2025-01-17 14:32:01','2025-01-17 22:32:47',0),(13,3,'2025-01-18','07:10:00','2025-01-18','22:39:08',0.0000,134.8000,134.8000,0,NULL,'2025-01-18 07:10:00','2025-01-18 22:39:08',0),(14,3,'2025-01-19','07:16:50','2025-01-19','22:00:29',0.0000,280.7000,280.7000,0,NULL,'2025-01-19 07:16:50','2025-01-19 22:00:29',0),(15,3,'2025-01-20','07:31:01','2025-01-20','14:24:56',0.0000,44.0000,44.0000,0,NULL,'2025-01-20 07:31:01','2025-01-20 14:24:56',0),(16,3,'2025-01-20','14:25:03','2025-01-20','22:32:33',0.0000,66.6500,66.6500,0,NULL,'2025-01-20 14:25:03','2025-01-20 22:32:33',0),(17,3,'2025-01-21','07:16:55','2025-01-21','14:30:14',0.0000,36.0000,36.0000,0,NULL,'2025-01-21 07:16:55','2025-01-21 14:30:14',0),(18,3,'2025-01-21','14:30:23','2025-01-22','07:14:12',0.0000,0.0000,0.0000,0,NULL,'2025-01-21 14:30:23','2025-01-22 07:14:12',0),(19,4,'2025-01-21','14:50:41','2025-01-21','22:30:45',0.0000,45.6000,45.6000,0,NULL,'2025-01-21 14:50:41','2025-01-21 22:30:45',0),(20,3,'2025-01-22','07:14:18','2025-01-22','14:27:51',0.0000,75.0500,75.0500,0,NULL,'2025-01-22 07:14:18','2025-01-22 14:27:51',0),(21,4,'2025-01-22','14:33:47','2025-01-22','22:33:00',0.0000,79.4000,79.4000,0,NULL,'2025-01-22 14:33:47','2025-01-22 22:33:00',0),(22,3,'2025-01-23','07:16:24','2025-01-23','14:28:33',0.0000,33.5000,33.5000,0,NULL,'2025-01-23 07:16:24','2025-01-23 14:28:33',0),(23,4,'2025-01-23','14:41:02','2025-01-23','22:34:07',0.0000,94.5000,94.5000,0,NULL,'2025-01-23 14:41:02','2025-01-23 22:34:07',0),(24,3,'2025-01-24','07:29:07','2025-01-24','14:39:09',0.0000,60.5000,60.5000,0,NULL,'2025-01-24 07:29:07','2025-01-24 14:39:09',0),(25,4,'2025-01-24','14:44:35','2025-01-24','22:33:23',0.0000,28.3000,28.3000,0,NULL,'2025-01-24 14:44:35','2025-01-24 22:33:23',0),(26,4,'2025-01-25','07:05:28','2025-01-25','22:32:59',0.0000,157.6000,157.6000,0,NULL,'2025-01-25 07:05:28','2025-01-25 22:32:59',0),(27,3,'2025-01-26','07:40:20','2025-01-26','22:15:26',0.0000,106.4000,106.4000,0,NULL,'2025-01-26 07:40:20','2025-01-26 22:15:26',0),(28,3,'2025-01-27','08:22:48','2025-01-27','14:32:49',0.0000,46.0000,46.0000,0,NULL,'2025-01-27 08:22:48','2025-01-27 14:32:49',0),(29,4,'2025-01-27','14:36:44','2025-01-27','22:32:37',0.0000,87.5000,87.5000,0,NULL,'2025-01-27 14:36:44','2025-01-27 22:32:37',0),(30,3,'2025-01-28','07:20:50','2025-01-28','14:31:08',0.0000,41.0000,41.0000,0,NULL,'2025-01-28 07:20:50','2025-01-28 14:31:08',0),(31,4,'2025-01-28','14:50:25','2025-01-28','22:31:12',0.0000,70.9000,70.9000,0,NULL,'2025-01-28 14:50:25','2025-01-28 22:31:12',0),(32,3,'2025-01-29','07:16:44','2025-01-29','14:31:37',0.0000,23.0000,23.0000,0,NULL,'2025-01-29 07:16:44','2025-01-29 14:31:37',0),(33,4,'2025-01-29','14:38:59','2025-01-29','22:41:40',0.0000,76.6000,76.6000,0,NULL,'2025-01-29 14:38:59','2025-01-29 22:41:40',0),(34,3,'2025-01-30','07:25:37','2025-01-30','14:28:30',0.0000,50.5000,50.5000,0,NULL,'2025-01-30 07:25:37','2025-01-30 14:28:31',0),(35,4,'2025-01-30','14:41:21','2025-01-30','22:31:00',0.0000,107.8000,107.8000,0,NULL,'2025-01-30 14:41:21','2025-01-30 22:31:00',0),(36,3,'2025-01-31','07:13:48','2025-01-31','15:00:11',0.0000,47.0000,47.0000,0,NULL,'2025-01-31 07:13:48','2025-01-31 15:00:11',0),(37,4,'2025-01-31','14:57:12','2025-02-01','07:49:38',0.0000,56.2000,56.2000,0,NULL,'2025-01-31 14:57:12','2025-02-01 07:49:38',0),(38,4,'2025-02-01','07:57:47','2025-02-01','22:33:30',0.0000,120.5500,120.5500,0,NULL,'2025-02-01 07:57:47','2025-02-01 22:33:30',0),(39,3,'2025-02-02','07:47:54','2025-02-02','22:06:22',0.0000,209.8000,209.8000,0,NULL,'2025-02-02 07:47:54','2025-02-02 22:06:22',0),(40,3,'2025-02-03','07:24:40','2025-02-03','14:27:25',0.0000,59.5000,59.5000,0,NULL,'2025-02-03 07:24:40','2025-02-03 14:27:25',0),(41,4,'2025-02-03','14:44:00','2025-02-04','17:07:05',0.0000,58.1000,58.1000,0,NULL,'2025-02-03 14:44:00','2025-02-04 17:07:05',0),(42,4,'2025-02-04','18:09:24','2025-02-04','22:32:19',0.0000,84.1000,84.1000,0,NULL,'2025-02-04 18:09:24','2025-02-04 22:32:19',0),(43,3,'2025-02-04','18:11:17','2025-02-04','18:44:44',0.0000,44.5000,44.5000,0,NULL,'2025-02-04 18:11:17','2025-02-04 18:44:44',0),(44,3,'2025-02-05','07:25:00','2025-02-05','14:30:54',0.0000,39.3000,39.3000,0,NULL,'2025-02-05 07:25:00','2025-02-05 14:30:54',0),(45,4,'2025-02-05','14:45:00','2025-02-05','22:34:53',0.0000,52.5000,52.5000,0,NULL,'2025-02-05 14:45:00','2025-02-05 22:34:54',0),(46,4,'2025-02-06','14:52:31','2025-02-06','22:37:04',0.0000,51.9000,51.9000,0,NULL,'2025-02-06 14:52:31','2025-02-06 22:37:04',0),(47,3,'2025-02-06','14:53:37','2025-02-07','11:00:18',0.0000,3.0000,3.0000,0,NULL,'2025-02-06 14:53:37','2025-02-07 11:00:18',0),(49,3,'2025-02-07','11:00:44','2025-02-07','14:32:11',0.0000,75.5000,75.5000,0,NULL,'2025-02-07 11:00:44','2025-02-07 14:32:11',0),(50,4,'2025-02-07','15:10:48','2025-02-07','22:36:04',0.0000,45.3500,45.3500,0,NULL,'2025-02-07 15:10:48','2025-02-07 22:36:04',0),(51,4,'2025-02-08','07:10:30','2025-02-08','22:35:12',0.0000,150.8500,150.8500,0,NULL,'2025-02-08 07:10:30','2025-02-08 22:35:12',0),(52,3,'2025-02-09','08:35:37','2025-02-10','08:17:34',0.0000,158.0000,158.0000,0,NULL,'2025-02-09 08:35:37','2025-02-10 08:17:34',0),(53,3,'2025-02-10','08:18:57','2025-02-10','14:28:47',158.0000,222.0000,64.0000,0,NULL,'2025-02-10 08:18:57','2025-02-10 14:28:47',0),(54,4,'2025-02-10','14:38:45','2025-02-10','22:35:59',222.0000,281.0000,59.0000,0,NULL,'2025-02-10 14:38:45','2025-02-10 22:35:59',0),(55,3,'2025-02-11','10:11:08','2025-02-11','14:30:41',281.0000,337.0000,56.0000,0,NULL,'2025-02-11 10:11:08','2025-02-11 14:30:41',0),(56,4,'2025-02-11','14:42:35','2025-02-11','22:35:17',337.0000,405.2000,68.2000,0,NULL,'2025-02-11 14:42:35','2025-02-11 22:35:17',0),(57,3,'2025-02-12','07:19:19','2025-02-12','14:28:21',405.2000,426.7000,21.5000,0,NULL,'2025-02-12 07:19:19','2025-02-12 14:28:21',0),(58,4,'2025-02-12','14:34:31','2025-02-12','22:34:43',426.7000,510.7000,84.0000,0,NULL,'2025-02-12 14:34:31','2025-02-12 22:34:43',0),(59,3,'2025-02-13','07:34:10','2025-02-13','14:28:35',510.7000,572.9500,62.2500,0,NULL,'2025-02-13 07:34:10','2025-02-13 14:28:35',0),(60,4,'2025-02-13','14:35:16','2025-02-13','22:37:48',572.9500,653.8500,80.9000,0,NULL,'2025-02-13 14:35:16','2025-02-13 22:37:49',0),(61,3,'2025-02-14','07:20:32','2025-02-14','22:09:14',653.8500,780.5500,126.7000,0,NULL,'2025-02-14 07:20:32','2025-02-14 22:09:14',0),(62,4,'2025-02-15','07:31:26','2025-02-15','22:34:38',0.0000,248.8000,248.8000,0,NULL,'2025-02-15 07:31:26','2025-02-15 22:34:38',0),(63,3,'2025-02-16','07:29:50','2025-02-16','22:00:04',0.0000,219.6500,219.6500,0,NULL,'2025-02-16 07:29:50','2025-02-16 22:00:04',0),(64,3,'2025-02-17','07:50:28','2025-02-17','15:45:07',219.6500,253.6500,34.0000,0,NULL,'2025-02-17 07:50:28','2025-02-17 15:45:07',0),(65,4,'2025-02-17','15:48:29','2025-02-17','22:38:51',253.6500,297.6500,44.0000,0,NULL,'2025-02-17 15:48:29','2025-02-17 22:38:51',0),(66,3,'2025-02-18','07:20:19','2025-02-18','14:30:19',297.6500,323.5500,25.9000,0,NULL,'2025-02-18 07:20:19','2025-02-18 14:30:19',0),(67,4,'2025-02-18','14:37:41',NULL,NULL,323.5500,0.0000,0.0000,1,NULL,'2025-02-18 14:37:41','2025-02-18 14:37:41',0);
/*!40000 ALTER TABLE `cash` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cash` with 66 row(s)
--

--
-- Table structure for table `cash_documents`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_id` int(10) unsigned NOT NULL,
  `document_id` int(10) unsigned DEFAULT NULL,
  `sale_note_id` int(10) unsigned DEFAULT NULL,
  `technical_service_id` int(10) unsigned DEFAULT NULL,
  `expense_payment_id` int(10) unsigned DEFAULT NULL,
  `purchase_id` int(10) unsigned DEFAULT NULL,
  `bank_loan_payment_id` int(10) unsigned DEFAULT NULL,
  `quotation_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_documents_cash_id_foreign` (`cash_id`),
  KEY `cash_documents_document_id_foreign` (`document_id`),
  KEY `cash_documents_sale_note_id_foreign` (`sale_note_id`),
  KEY `cash_documents_expense_payment_id_foreign` (`expense_payment_id`),
  KEY `cash_documents_technical_service_id_foreign` (`technical_service_id`),
  KEY `cash_documents_purchase_id_foreign` (`purchase_id`),
  KEY `cash_documents_quotation_id_foreign` (`quotation_id`),
  CONSTRAINT `cash_documents_cash_id_foreign` FOREIGN KEY (`cash_id`) REFERENCES `cash` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_documents_document_id_foreign` FOREIGN KEY (`document_id`) REFERENCES `documents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_documents_expense_payment_id_foreign` FOREIGN KEY (`expense_payment_id`) REFERENCES `expense_payments` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_documents_purchase_id_foreign` FOREIGN KEY (`purchase_id`) REFERENCES `purchases` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_documents_quotation_id_foreign` FOREIGN KEY (`quotation_id`) REFERENCES `quotations` (`id`),
  CONSTRAINT `cash_documents_sale_note_id_foreign` FOREIGN KEY (`sale_note_id`) REFERENCES `sale_notes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_documents_technical_service_id_foreign` FOREIGN KEY (`technical_service_id`) REFERENCES `technical_services` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=1335 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cash_documents`
--

LOCK TABLES `cash_documents` WRITE;
/*!40000 ALTER TABLE `cash_documents` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cash_documents` VALUES (1,1,NULL,3,NULL,NULL,NULL,NULL,NULL),(2,1,NULL,1,NULL,NULL,NULL,NULL,NULL),(3,1,NULL,2,NULL,NULL,NULL,NULL,NULL),(4,1,NULL,4,NULL,NULL,NULL,NULL,NULL),(5,1,NULL,5,NULL,NULL,NULL,NULL,NULL),(6,1,NULL,6,NULL,NULL,NULL,NULL,NULL),(7,1,NULL,7,NULL,NULL,NULL,NULL,NULL),(8,1,NULL,8,NULL,NULL,NULL,NULL,NULL),(9,1,NULL,9,NULL,NULL,NULL,NULL,NULL),(10,1,NULL,10,NULL,NULL,NULL,NULL,NULL),(11,1,NULL,11,NULL,NULL,NULL,NULL,NULL),(12,1,NULL,12,NULL,NULL,NULL,NULL,NULL),(13,1,NULL,13,NULL,NULL,NULL,NULL,NULL),(14,1,NULL,14,NULL,NULL,NULL,NULL,NULL),(15,1,NULL,15,NULL,NULL,NULL,NULL,NULL),(16,1,NULL,16,NULL,NULL,NULL,NULL,NULL),(17,1,NULL,17,NULL,NULL,NULL,NULL,NULL),(18,1,NULL,18,NULL,NULL,NULL,NULL,NULL),(19,1,NULL,19,NULL,NULL,NULL,NULL,NULL),(20,1,NULL,20,NULL,NULL,NULL,NULL,NULL),(21,1,NULL,21,NULL,NULL,NULL,NULL,NULL),(22,1,NULL,22,NULL,NULL,NULL,NULL,NULL),(23,1,NULL,23,NULL,NULL,NULL,NULL,NULL),(24,1,NULL,24,NULL,NULL,NULL,NULL,NULL),(25,1,NULL,25,NULL,NULL,NULL,NULL,NULL),(26,1,NULL,26,NULL,NULL,NULL,NULL,NULL),(27,1,NULL,27,NULL,NULL,NULL,NULL,NULL),(28,1,NULL,28,NULL,NULL,NULL,NULL,NULL),(29,1,NULL,29,NULL,NULL,NULL,NULL,NULL),(30,1,NULL,30,NULL,NULL,NULL,NULL,NULL),(31,1,NULL,31,NULL,NULL,NULL,NULL,NULL),(32,1,NULL,32,NULL,NULL,NULL,NULL,NULL),(33,1,NULL,33,NULL,NULL,NULL,NULL,NULL),(34,1,NULL,34,NULL,NULL,NULL,NULL,NULL),(35,1,NULL,35,NULL,NULL,NULL,NULL,NULL),(36,1,NULL,36,NULL,NULL,NULL,NULL,NULL),(37,2,NULL,37,NULL,NULL,NULL,NULL,NULL),(38,2,NULL,38,NULL,NULL,NULL,NULL,NULL),(39,2,NULL,39,NULL,NULL,NULL,NULL,NULL),(40,2,NULL,40,NULL,NULL,NULL,NULL,NULL),(41,2,NULL,41,NULL,NULL,NULL,NULL,NULL),(42,2,NULL,42,NULL,NULL,NULL,NULL,NULL),(43,2,NULL,43,NULL,NULL,NULL,NULL,NULL),(44,2,NULL,44,NULL,NULL,NULL,NULL,NULL),(45,2,NULL,45,NULL,NULL,NULL,NULL,NULL),(46,2,NULL,46,NULL,NULL,NULL,NULL,NULL),(47,2,NULL,47,NULL,NULL,NULL,NULL,NULL),(48,2,NULL,48,NULL,NULL,NULL,NULL,NULL),(49,2,NULL,49,NULL,NULL,NULL,NULL,NULL),(50,2,NULL,50,NULL,NULL,NULL,NULL,NULL),(51,2,NULL,51,NULL,NULL,NULL,NULL,NULL),(52,2,NULL,52,NULL,NULL,NULL,NULL,NULL),(53,2,NULL,53,NULL,NULL,NULL,NULL,NULL),(54,2,NULL,54,NULL,NULL,NULL,NULL,NULL),(55,2,NULL,55,NULL,NULL,NULL,NULL,NULL),(56,2,NULL,56,NULL,NULL,NULL,NULL,NULL),(57,2,NULL,57,NULL,NULL,NULL,NULL,NULL),(58,2,NULL,58,NULL,NULL,NULL,NULL,NULL),(59,2,NULL,59,NULL,NULL,NULL,NULL,NULL),(60,2,NULL,60,NULL,NULL,NULL,NULL,NULL),(61,2,NULL,61,NULL,NULL,NULL,NULL,NULL),(62,2,NULL,62,NULL,NULL,NULL,NULL,NULL),(63,2,NULL,63,NULL,NULL,NULL,NULL,NULL),(64,2,NULL,64,NULL,NULL,NULL,NULL,NULL),(65,2,NULL,65,NULL,NULL,NULL,NULL,NULL),(66,2,NULL,66,NULL,NULL,NULL,NULL,NULL),(67,2,NULL,67,NULL,NULL,NULL,NULL,NULL),(68,2,NULL,68,NULL,NULL,NULL,NULL,NULL),(69,2,NULL,69,NULL,NULL,NULL,NULL,NULL),(70,4,NULL,70,NULL,NULL,NULL,NULL,NULL),(71,4,NULL,71,NULL,NULL,NULL,NULL,NULL),(72,4,NULL,72,NULL,NULL,NULL,NULL,NULL),(73,4,NULL,73,NULL,NULL,NULL,NULL,NULL),(74,4,NULL,74,NULL,NULL,NULL,NULL,NULL),(75,4,NULL,75,NULL,NULL,NULL,NULL,NULL),(76,4,NULL,76,NULL,NULL,NULL,NULL,NULL),(77,4,NULL,77,NULL,NULL,NULL,NULL,NULL),(78,4,NULL,78,NULL,NULL,NULL,NULL,NULL),(79,4,NULL,79,NULL,NULL,NULL,NULL,NULL),(80,4,NULL,80,NULL,NULL,NULL,NULL,NULL),(81,4,NULL,81,NULL,NULL,NULL,NULL,NULL),(82,5,NULL,93,NULL,NULL,NULL,NULL,NULL),(83,5,NULL,94,NULL,NULL,NULL,NULL,NULL),(84,5,NULL,95,NULL,NULL,NULL,NULL,NULL),(85,5,NULL,96,NULL,NULL,NULL,NULL,NULL),(86,5,NULL,97,NULL,NULL,NULL,NULL,NULL),(87,5,NULL,98,NULL,NULL,NULL,NULL,NULL),(88,5,NULL,99,NULL,NULL,NULL,NULL,NULL),(89,5,NULL,100,NULL,NULL,NULL,NULL,NULL),(90,5,NULL,101,NULL,NULL,NULL,NULL,NULL),(91,5,NULL,102,NULL,NULL,NULL,NULL,NULL),(92,5,NULL,103,NULL,NULL,NULL,NULL,NULL),(93,5,NULL,104,NULL,NULL,NULL,NULL,NULL),(94,5,NULL,105,NULL,NULL,NULL,NULL,NULL),(95,5,NULL,106,NULL,NULL,NULL,NULL,NULL),(96,6,NULL,107,NULL,NULL,NULL,NULL,NULL),(97,6,NULL,108,NULL,NULL,NULL,NULL,NULL),(98,6,NULL,109,NULL,NULL,NULL,NULL,NULL),(99,6,NULL,110,NULL,NULL,NULL,NULL,NULL),(100,6,NULL,111,NULL,NULL,NULL,NULL,NULL),(101,6,NULL,112,NULL,NULL,NULL,NULL,NULL),(102,6,NULL,113,NULL,NULL,NULL,NULL,NULL),(103,6,NULL,114,NULL,NULL,NULL,NULL,NULL),(104,6,NULL,115,NULL,NULL,NULL,NULL,NULL),(105,6,NULL,116,NULL,NULL,NULL,NULL,NULL),(106,6,NULL,117,NULL,NULL,NULL,NULL,NULL),(107,6,NULL,118,NULL,NULL,NULL,NULL,NULL),(108,6,NULL,119,NULL,NULL,NULL,NULL,NULL),(109,6,NULL,120,NULL,NULL,NULL,NULL,NULL),(110,6,NULL,121,NULL,NULL,NULL,NULL,NULL),(111,6,NULL,122,NULL,NULL,NULL,NULL,NULL),(112,6,NULL,123,NULL,NULL,NULL,NULL,NULL),(113,6,NULL,124,NULL,NULL,NULL,NULL,NULL),(114,6,NULL,125,NULL,NULL,NULL,NULL,NULL),(115,6,NULL,126,NULL,NULL,NULL,NULL,NULL),(116,6,NULL,127,NULL,NULL,NULL,NULL,NULL),(117,6,NULL,128,NULL,NULL,NULL,NULL,NULL),(118,6,NULL,129,NULL,NULL,NULL,NULL,NULL),(119,6,NULL,130,NULL,NULL,NULL,NULL,NULL),(120,6,NULL,131,NULL,NULL,NULL,NULL,NULL),(121,7,NULL,132,NULL,NULL,NULL,NULL,NULL),(122,7,NULL,133,NULL,NULL,NULL,NULL,NULL),(123,7,NULL,134,NULL,NULL,NULL,NULL,NULL),(124,7,NULL,135,NULL,NULL,NULL,NULL,NULL),(125,7,NULL,136,NULL,NULL,NULL,NULL,NULL),(126,7,NULL,137,NULL,NULL,NULL,NULL,NULL),(127,7,NULL,138,NULL,NULL,NULL,NULL,NULL),(128,8,NULL,139,NULL,NULL,NULL,NULL,NULL),(129,8,NULL,140,NULL,NULL,NULL,NULL,NULL),(130,8,NULL,141,NULL,NULL,NULL,NULL,NULL),(131,8,NULL,142,NULL,NULL,NULL,NULL,NULL),(132,8,NULL,143,NULL,NULL,NULL,NULL,NULL),(133,8,NULL,144,NULL,NULL,NULL,NULL,NULL),(134,8,NULL,145,NULL,NULL,NULL,NULL,NULL),(135,8,NULL,146,NULL,NULL,NULL,NULL,NULL),(136,8,NULL,147,NULL,NULL,NULL,NULL,NULL),(137,8,NULL,148,NULL,NULL,NULL,NULL,NULL),(138,8,NULL,149,NULL,NULL,NULL,NULL,NULL),(139,8,NULL,150,NULL,NULL,NULL,NULL,NULL),(140,8,NULL,151,NULL,NULL,NULL,NULL,NULL),(141,8,NULL,152,NULL,NULL,NULL,NULL,NULL),(142,8,NULL,153,NULL,NULL,NULL,NULL,NULL),(143,8,NULL,154,NULL,NULL,NULL,NULL,NULL),(144,8,NULL,155,NULL,NULL,NULL,NULL,NULL),(145,8,NULL,156,NULL,NULL,NULL,NULL,NULL),(146,8,NULL,157,NULL,NULL,NULL,NULL,NULL),(147,9,NULL,158,NULL,NULL,NULL,NULL,NULL),(148,9,NULL,159,NULL,NULL,NULL,NULL,NULL),(149,10,NULL,160,NULL,NULL,NULL,NULL,NULL),(150,10,NULL,161,NULL,NULL,NULL,NULL,NULL),(151,10,NULL,162,NULL,NULL,NULL,NULL,NULL),(152,10,NULL,163,NULL,NULL,NULL,NULL,NULL),(153,10,NULL,164,NULL,NULL,NULL,NULL,NULL),(154,10,NULL,165,NULL,NULL,NULL,NULL,NULL),(155,10,NULL,166,NULL,NULL,NULL,NULL,NULL),(156,10,NULL,167,NULL,NULL,NULL,NULL,NULL),(157,10,NULL,168,NULL,NULL,NULL,NULL,NULL),(158,10,NULL,169,NULL,NULL,NULL,NULL,NULL),(159,10,NULL,170,NULL,NULL,NULL,NULL,NULL),(160,10,NULL,171,NULL,NULL,NULL,NULL,NULL),(161,10,NULL,172,NULL,NULL,NULL,NULL,NULL),(162,10,NULL,173,NULL,NULL,NULL,NULL,NULL),(163,10,NULL,174,NULL,NULL,NULL,NULL,NULL),(164,10,NULL,175,NULL,NULL,NULL,NULL,NULL),(165,10,NULL,176,NULL,NULL,NULL,NULL,NULL),(166,10,NULL,177,NULL,NULL,NULL,NULL,NULL),(167,10,NULL,178,NULL,NULL,NULL,NULL,NULL),(168,10,NULL,179,NULL,NULL,NULL,NULL,NULL),(169,10,NULL,180,NULL,NULL,NULL,NULL,NULL),(170,10,NULL,181,NULL,NULL,NULL,NULL,NULL),(171,10,NULL,182,NULL,NULL,NULL,NULL,NULL),(172,11,NULL,183,NULL,NULL,NULL,NULL,NULL),(173,11,NULL,184,NULL,NULL,NULL,NULL,NULL),(174,11,NULL,185,NULL,NULL,NULL,NULL,NULL),(175,11,NULL,186,NULL,NULL,NULL,NULL,NULL),(176,11,NULL,187,NULL,NULL,NULL,NULL,NULL),(177,11,NULL,188,NULL,NULL,NULL,NULL,NULL),(178,11,NULL,189,NULL,NULL,NULL,NULL,NULL),(179,11,NULL,190,NULL,NULL,NULL,NULL,NULL),(180,11,NULL,191,NULL,NULL,NULL,NULL,NULL),(181,12,NULL,192,NULL,NULL,NULL,NULL,NULL),(182,12,NULL,193,NULL,NULL,NULL,NULL,NULL),(183,12,NULL,194,NULL,NULL,NULL,NULL,NULL),(184,12,NULL,195,NULL,NULL,NULL,NULL,NULL),(185,12,NULL,196,NULL,NULL,NULL,NULL,NULL),(186,12,NULL,197,NULL,NULL,NULL,NULL,NULL),(187,12,NULL,198,NULL,NULL,NULL,NULL,NULL),(188,12,NULL,199,NULL,NULL,NULL,NULL,NULL),(189,12,NULL,200,NULL,NULL,NULL,NULL,NULL),(190,12,NULL,201,NULL,NULL,NULL,NULL,NULL),(191,12,NULL,202,NULL,NULL,NULL,NULL,NULL),(192,12,NULL,203,NULL,NULL,NULL,NULL,NULL),(193,12,NULL,204,NULL,NULL,NULL,NULL,NULL),(194,12,NULL,205,NULL,NULL,NULL,NULL,NULL),(195,12,NULL,206,NULL,NULL,NULL,NULL,NULL),(196,12,NULL,207,NULL,NULL,NULL,NULL,NULL),(197,12,NULL,208,NULL,NULL,NULL,NULL,NULL),(198,12,NULL,209,NULL,NULL,NULL,NULL,NULL),(199,12,NULL,210,NULL,NULL,NULL,NULL,NULL),(200,12,NULL,211,NULL,NULL,NULL,NULL,NULL),(201,12,NULL,212,NULL,NULL,NULL,NULL,NULL),(202,12,NULL,213,NULL,NULL,NULL,NULL,NULL),(203,12,NULL,214,NULL,NULL,NULL,NULL,NULL),(204,12,NULL,215,NULL,NULL,NULL,NULL,NULL),(205,12,NULL,216,NULL,NULL,NULL,NULL,NULL),(206,12,NULL,217,NULL,NULL,NULL,NULL,NULL),(207,12,NULL,218,NULL,NULL,NULL,NULL,NULL),(208,12,NULL,219,NULL,NULL,NULL,NULL,NULL),(209,12,NULL,220,NULL,NULL,NULL,NULL,NULL),(210,12,NULL,221,NULL,NULL,NULL,NULL,NULL),(211,12,NULL,222,NULL,NULL,NULL,NULL,NULL),(212,12,NULL,223,NULL,NULL,NULL,NULL,NULL),(213,13,NULL,224,NULL,NULL,NULL,NULL,NULL),(214,13,NULL,225,NULL,NULL,NULL,NULL,NULL),(215,13,NULL,226,NULL,NULL,NULL,NULL,NULL),(216,13,NULL,227,NULL,NULL,NULL,NULL,NULL),(217,13,NULL,228,NULL,NULL,NULL,NULL,NULL),(218,13,NULL,229,NULL,NULL,NULL,NULL,NULL),(219,13,NULL,230,NULL,NULL,NULL,NULL,NULL),(220,13,NULL,231,NULL,NULL,NULL,NULL,NULL),(221,13,NULL,232,NULL,NULL,NULL,NULL,NULL),(222,13,NULL,233,NULL,NULL,NULL,NULL,NULL),(223,13,NULL,234,NULL,NULL,NULL,NULL,NULL),(224,13,NULL,235,NULL,NULL,NULL,NULL,NULL),(225,13,NULL,236,NULL,NULL,NULL,NULL,NULL),(226,13,NULL,237,NULL,NULL,NULL,NULL,NULL),(227,13,NULL,238,NULL,NULL,NULL,NULL,NULL),(228,13,NULL,239,NULL,NULL,NULL,NULL,NULL),(229,13,NULL,240,NULL,NULL,NULL,NULL,NULL),(230,13,NULL,241,NULL,NULL,NULL,NULL,NULL),(231,13,NULL,242,NULL,NULL,NULL,NULL,NULL),(232,13,NULL,243,NULL,NULL,NULL,NULL,NULL),(233,13,NULL,244,NULL,NULL,NULL,NULL,NULL),(234,13,NULL,245,NULL,NULL,NULL,NULL,NULL),(235,13,NULL,246,NULL,NULL,NULL,NULL,NULL),(236,13,NULL,247,NULL,NULL,NULL,NULL,NULL),(237,13,NULL,248,NULL,NULL,NULL,NULL,NULL),(238,13,NULL,249,NULL,NULL,NULL,NULL,NULL),(239,13,NULL,250,NULL,NULL,NULL,NULL,NULL),(240,13,NULL,251,NULL,NULL,NULL,NULL,NULL),(241,13,NULL,252,NULL,NULL,NULL,NULL,NULL),(242,13,NULL,253,NULL,NULL,NULL,NULL,NULL),(243,13,NULL,254,NULL,NULL,NULL,NULL,NULL),(244,13,NULL,255,NULL,NULL,NULL,NULL,NULL),(245,13,NULL,256,NULL,NULL,NULL,NULL,NULL),(246,13,NULL,257,NULL,NULL,NULL,NULL,NULL),(247,13,NULL,258,NULL,NULL,NULL,NULL,NULL),(248,13,NULL,259,NULL,NULL,NULL,NULL,NULL),(249,13,NULL,260,NULL,NULL,NULL,NULL,NULL),(250,13,NULL,261,NULL,NULL,NULL,NULL,NULL),(251,13,NULL,262,NULL,NULL,NULL,NULL,NULL),(252,13,NULL,263,NULL,NULL,NULL,NULL,NULL),(253,13,NULL,264,NULL,NULL,NULL,NULL,NULL),(254,13,NULL,265,NULL,NULL,NULL,NULL,NULL),(255,13,NULL,266,NULL,NULL,NULL,NULL,NULL),(256,13,NULL,267,NULL,NULL,NULL,NULL,NULL),(257,13,NULL,268,NULL,NULL,NULL,NULL,NULL),(258,13,NULL,269,NULL,NULL,NULL,NULL,NULL),(259,13,NULL,270,NULL,NULL,NULL,NULL,NULL),(260,13,NULL,271,NULL,NULL,NULL,NULL,NULL),(261,13,NULL,272,NULL,NULL,NULL,NULL,NULL),(262,13,NULL,273,NULL,NULL,NULL,NULL,NULL),(263,13,NULL,274,NULL,NULL,NULL,NULL,NULL),(264,13,NULL,275,NULL,NULL,NULL,NULL,NULL),(265,13,NULL,276,NULL,NULL,NULL,NULL,NULL),(266,13,NULL,277,NULL,NULL,NULL,NULL,NULL),(267,13,NULL,278,NULL,NULL,NULL,NULL,NULL),(268,13,NULL,279,NULL,NULL,NULL,NULL,NULL),(269,13,NULL,280,NULL,NULL,NULL,NULL,NULL),(270,14,NULL,281,NULL,NULL,NULL,NULL,NULL),(271,14,NULL,282,NULL,NULL,NULL,NULL,NULL),(272,14,NULL,283,NULL,NULL,NULL,NULL,NULL),(273,14,NULL,284,NULL,NULL,NULL,NULL,NULL),(274,14,NULL,285,NULL,NULL,NULL,NULL,NULL),(275,14,NULL,286,NULL,NULL,NULL,NULL,NULL),(276,14,NULL,287,NULL,NULL,NULL,NULL,NULL),(277,14,NULL,288,NULL,NULL,NULL,NULL,NULL),(278,14,NULL,289,NULL,NULL,NULL,NULL,NULL),(279,14,NULL,290,NULL,NULL,NULL,NULL,NULL),(280,14,NULL,291,NULL,NULL,NULL,NULL,NULL),(281,14,NULL,292,NULL,NULL,NULL,NULL,NULL),(282,14,NULL,293,NULL,NULL,NULL,NULL,NULL),(283,14,NULL,294,NULL,NULL,NULL,NULL,NULL),(284,14,NULL,295,NULL,NULL,NULL,NULL,NULL),(285,14,NULL,296,NULL,NULL,NULL,NULL,NULL),(286,14,NULL,297,NULL,NULL,NULL,NULL,NULL),(287,14,NULL,298,NULL,NULL,NULL,NULL,NULL),(288,14,NULL,299,NULL,NULL,NULL,NULL,NULL),(289,14,NULL,300,NULL,NULL,NULL,NULL,NULL),(290,14,NULL,301,NULL,NULL,NULL,NULL,NULL),(291,14,NULL,302,NULL,NULL,NULL,NULL,NULL),(292,14,NULL,303,NULL,NULL,NULL,NULL,NULL),(293,14,NULL,304,NULL,NULL,NULL,NULL,NULL),(294,14,NULL,305,NULL,NULL,NULL,NULL,NULL),(295,14,NULL,306,NULL,NULL,NULL,NULL,NULL),(296,14,NULL,307,NULL,NULL,NULL,NULL,NULL),(297,14,NULL,308,NULL,NULL,NULL,NULL,NULL),(298,14,NULL,309,NULL,NULL,NULL,NULL,NULL),(299,14,NULL,310,NULL,NULL,NULL,NULL,NULL),(300,14,NULL,311,NULL,NULL,NULL,NULL,NULL),(301,14,NULL,312,NULL,NULL,NULL,NULL,NULL),(302,14,NULL,313,NULL,NULL,NULL,NULL,NULL),(303,14,NULL,314,NULL,NULL,NULL,NULL,NULL),(304,14,NULL,315,NULL,NULL,NULL,NULL,NULL),(305,14,NULL,316,NULL,NULL,NULL,NULL,NULL),(306,14,NULL,317,NULL,NULL,NULL,NULL,NULL),(307,14,NULL,318,NULL,NULL,NULL,NULL,NULL),(308,14,NULL,319,NULL,NULL,NULL,NULL,NULL),(309,14,NULL,320,NULL,NULL,NULL,NULL,NULL),(310,15,NULL,321,NULL,NULL,NULL,NULL,NULL),(311,15,NULL,322,NULL,NULL,NULL,NULL,NULL),(312,15,NULL,323,NULL,NULL,NULL,NULL,NULL),(313,15,NULL,324,NULL,NULL,NULL,NULL,NULL),(314,15,NULL,325,NULL,NULL,NULL,NULL,NULL),(315,15,NULL,326,NULL,NULL,NULL,NULL,NULL),(316,15,NULL,327,NULL,NULL,NULL,NULL,NULL),(317,15,NULL,328,NULL,NULL,NULL,NULL,NULL),(318,15,NULL,329,NULL,NULL,NULL,NULL,NULL),(319,15,NULL,330,NULL,NULL,NULL,NULL,NULL),(320,16,NULL,331,NULL,NULL,NULL,NULL,NULL),(321,16,NULL,332,NULL,NULL,NULL,NULL,NULL),(322,16,NULL,333,NULL,NULL,NULL,NULL,NULL),(323,16,NULL,334,NULL,NULL,NULL,NULL,NULL),(324,16,NULL,335,NULL,NULL,NULL,NULL,NULL),(325,16,NULL,336,NULL,NULL,NULL,NULL,NULL),(326,16,NULL,337,NULL,NULL,NULL,NULL,NULL),(327,16,NULL,338,NULL,NULL,NULL,NULL,NULL),(328,16,NULL,339,NULL,NULL,NULL,NULL,NULL),(329,16,NULL,340,NULL,NULL,NULL,NULL,NULL),(330,16,NULL,341,NULL,NULL,NULL,NULL,NULL),(331,16,NULL,342,NULL,NULL,NULL,NULL,NULL),(332,16,NULL,343,NULL,NULL,NULL,NULL,NULL),(333,16,NULL,344,NULL,NULL,NULL,NULL,NULL),(334,16,NULL,345,NULL,NULL,NULL,NULL,NULL),(335,16,NULL,346,NULL,NULL,NULL,NULL,NULL),(336,16,NULL,347,NULL,NULL,NULL,NULL,NULL),(337,16,NULL,348,NULL,NULL,NULL,NULL,NULL),(338,16,NULL,349,NULL,NULL,NULL,NULL,NULL),(339,16,NULL,350,NULL,NULL,NULL,NULL,NULL),(340,16,NULL,351,NULL,NULL,NULL,NULL,NULL),(341,16,NULL,352,NULL,NULL,NULL,NULL,NULL),(342,16,NULL,353,NULL,NULL,NULL,NULL,NULL),(343,16,NULL,354,NULL,NULL,NULL,NULL,NULL),(344,16,NULL,355,NULL,NULL,NULL,NULL,NULL),(345,16,NULL,356,NULL,NULL,NULL,NULL,NULL),(346,16,NULL,357,NULL,NULL,NULL,NULL,NULL),(347,16,NULL,358,NULL,NULL,NULL,NULL,NULL),(348,16,NULL,359,NULL,NULL,NULL,NULL,NULL),(349,16,NULL,360,NULL,NULL,NULL,NULL,NULL),(350,16,NULL,361,NULL,NULL,NULL,NULL,NULL),(351,17,NULL,362,NULL,NULL,NULL,NULL,NULL),(352,17,NULL,363,NULL,NULL,NULL,NULL,NULL),(353,17,NULL,364,NULL,NULL,NULL,NULL,NULL),(354,17,NULL,365,NULL,NULL,NULL,NULL,NULL),(355,17,NULL,366,NULL,NULL,NULL,NULL,NULL),(356,17,NULL,367,NULL,NULL,NULL,NULL,NULL),(357,17,NULL,368,NULL,NULL,NULL,NULL,NULL),(358,19,NULL,369,NULL,NULL,NULL,NULL,NULL),(359,19,NULL,370,NULL,NULL,NULL,NULL,NULL),(360,19,NULL,371,NULL,NULL,NULL,NULL,NULL),(361,19,NULL,372,NULL,NULL,NULL,NULL,NULL),(362,19,NULL,373,NULL,NULL,NULL,NULL,NULL),(363,19,NULL,374,NULL,NULL,NULL,NULL,NULL),(364,19,NULL,375,NULL,NULL,NULL,NULL,NULL),(365,19,NULL,376,NULL,NULL,NULL,NULL,NULL),(366,19,NULL,377,NULL,NULL,NULL,NULL,NULL),(367,19,NULL,378,NULL,NULL,NULL,NULL,NULL),(368,19,NULL,379,NULL,NULL,NULL,NULL,NULL),(369,19,NULL,380,NULL,NULL,NULL,NULL,NULL),(370,19,NULL,381,NULL,NULL,NULL,NULL,NULL),(371,19,NULL,382,NULL,NULL,NULL,NULL,NULL),(372,19,NULL,383,NULL,NULL,NULL,NULL,NULL),(373,19,NULL,384,NULL,NULL,NULL,NULL,NULL),(374,19,NULL,385,NULL,NULL,NULL,NULL,NULL),(375,19,NULL,386,NULL,NULL,NULL,NULL,NULL),(376,19,NULL,387,NULL,NULL,NULL,NULL,NULL),(377,20,NULL,388,NULL,NULL,NULL,NULL,NULL),(378,20,NULL,389,NULL,NULL,NULL,NULL,NULL),(379,20,NULL,390,NULL,NULL,NULL,NULL,NULL),(380,20,NULL,391,NULL,NULL,NULL,NULL,NULL),(381,20,NULL,392,NULL,NULL,NULL,NULL,NULL),(382,20,NULL,393,NULL,NULL,NULL,NULL,NULL),(383,20,NULL,394,NULL,NULL,NULL,NULL,NULL),(384,20,NULL,395,NULL,NULL,NULL,NULL,NULL),(385,20,NULL,396,NULL,NULL,NULL,NULL,NULL),(386,20,NULL,397,NULL,NULL,NULL,NULL,NULL),(387,20,NULL,398,NULL,NULL,NULL,NULL,NULL),(388,20,NULL,399,NULL,NULL,NULL,NULL,NULL),(389,21,NULL,400,NULL,NULL,NULL,NULL,NULL),(390,21,NULL,401,NULL,NULL,NULL,NULL,NULL),(391,21,NULL,402,NULL,NULL,NULL,NULL,NULL),(392,21,NULL,403,NULL,NULL,NULL,NULL,NULL),(393,21,NULL,404,NULL,NULL,NULL,NULL,NULL),(394,21,NULL,405,NULL,NULL,NULL,NULL,NULL),(395,21,NULL,406,NULL,NULL,NULL,NULL,NULL),(396,21,NULL,407,NULL,NULL,NULL,NULL,NULL),(397,21,NULL,408,NULL,NULL,NULL,NULL,NULL),(398,21,NULL,409,NULL,NULL,NULL,NULL,NULL),(399,21,NULL,410,NULL,NULL,NULL,NULL,NULL),(400,21,NULL,411,NULL,NULL,NULL,NULL,NULL),(401,21,NULL,412,NULL,NULL,NULL,NULL,NULL),(402,21,NULL,413,NULL,NULL,NULL,NULL,NULL),(403,21,NULL,414,NULL,NULL,NULL,NULL,NULL),(404,21,NULL,415,NULL,NULL,NULL,NULL,NULL),(405,21,NULL,416,NULL,NULL,NULL,NULL,NULL),(406,21,NULL,417,NULL,NULL,NULL,NULL,NULL),(407,21,NULL,418,NULL,NULL,NULL,NULL,NULL),(408,21,NULL,419,NULL,NULL,NULL,NULL,NULL),(409,21,NULL,420,NULL,NULL,NULL,NULL,NULL),(410,21,NULL,421,NULL,NULL,NULL,NULL,NULL),(411,21,NULL,422,NULL,NULL,NULL,NULL,NULL),(412,21,NULL,423,NULL,NULL,NULL,NULL,NULL),(413,21,NULL,424,NULL,NULL,NULL,NULL,NULL),(414,21,NULL,425,NULL,NULL,NULL,NULL,NULL),(415,21,NULL,426,NULL,NULL,NULL,NULL,NULL),(416,21,NULL,427,NULL,NULL,NULL,NULL,NULL),(417,21,NULL,428,NULL,NULL,NULL,NULL,NULL),(418,21,NULL,429,NULL,NULL,NULL,NULL,NULL),(419,21,NULL,430,NULL,NULL,NULL,NULL,NULL),(420,21,NULL,431,NULL,NULL,NULL,NULL,NULL),(421,21,NULL,432,NULL,NULL,NULL,NULL,NULL),(422,21,NULL,433,NULL,NULL,NULL,NULL,NULL),(423,21,NULL,434,NULL,NULL,NULL,NULL,NULL),(424,21,NULL,435,NULL,NULL,NULL,NULL,NULL),(425,22,NULL,436,NULL,NULL,NULL,NULL,NULL),(426,22,NULL,437,NULL,NULL,NULL,NULL,NULL),(427,22,NULL,438,NULL,NULL,NULL,NULL,NULL),(428,22,NULL,439,NULL,NULL,NULL,NULL,NULL),(429,22,NULL,440,NULL,NULL,NULL,NULL,NULL),(430,22,NULL,441,NULL,NULL,NULL,NULL,NULL),(431,22,NULL,442,NULL,NULL,NULL,NULL,NULL),(432,23,NULL,443,NULL,NULL,NULL,NULL,NULL),(433,23,NULL,444,NULL,NULL,NULL,NULL,NULL),(434,23,NULL,445,NULL,NULL,NULL,NULL,NULL),(435,23,NULL,446,NULL,NULL,NULL,NULL,NULL),(436,23,NULL,447,NULL,NULL,NULL,NULL,NULL),(437,23,NULL,448,NULL,NULL,NULL,NULL,NULL),(438,23,NULL,449,NULL,NULL,NULL,NULL,NULL),(439,23,NULL,450,NULL,NULL,NULL,NULL,NULL),(440,23,NULL,451,NULL,NULL,NULL,NULL,NULL),(441,23,NULL,452,NULL,NULL,NULL,NULL,NULL),(442,23,NULL,453,NULL,NULL,NULL,NULL,NULL),(443,23,NULL,454,NULL,NULL,NULL,NULL,NULL),(444,23,NULL,455,NULL,NULL,NULL,NULL,NULL),(445,23,NULL,456,NULL,NULL,NULL,NULL,NULL),(446,23,NULL,457,NULL,NULL,NULL,NULL,NULL),(447,23,NULL,458,NULL,NULL,NULL,NULL,NULL),(448,23,NULL,459,NULL,NULL,NULL,NULL,NULL),(449,23,NULL,460,NULL,NULL,NULL,NULL,NULL),(450,23,NULL,461,NULL,NULL,NULL,NULL,NULL),(451,23,NULL,462,NULL,NULL,NULL,NULL,NULL),(452,23,NULL,463,NULL,NULL,NULL,NULL,NULL),(453,23,NULL,464,NULL,NULL,NULL,NULL,NULL),(454,23,NULL,465,NULL,NULL,NULL,NULL,NULL),(455,23,NULL,466,NULL,NULL,NULL,NULL,NULL),(456,23,NULL,467,NULL,NULL,NULL,NULL,NULL),(457,23,NULL,468,NULL,NULL,NULL,NULL,NULL),(458,23,NULL,469,NULL,NULL,NULL,NULL,NULL),(459,23,NULL,470,NULL,NULL,NULL,NULL,NULL),(460,23,NULL,471,NULL,NULL,NULL,NULL,NULL),(461,23,NULL,472,NULL,NULL,NULL,NULL,NULL),(462,23,NULL,473,NULL,NULL,NULL,NULL,NULL),(463,23,NULL,474,NULL,NULL,NULL,NULL,NULL),(464,23,NULL,475,NULL,NULL,NULL,NULL,NULL),(465,23,NULL,476,NULL,NULL,NULL,NULL,NULL),(466,23,NULL,477,NULL,NULL,NULL,NULL,NULL),(467,23,NULL,478,NULL,NULL,NULL,NULL,NULL),(468,23,NULL,479,NULL,NULL,NULL,NULL,NULL),(469,23,NULL,480,NULL,NULL,NULL,NULL,NULL),(470,23,NULL,481,NULL,NULL,NULL,NULL,NULL),(471,23,NULL,482,NULL,NULL,NULL,NULL,NULL),(472,23,NULL,483,NULL,NULL,NULL,NULL,NULL),(473,23,NULL,484,NULL,NULL,NULL,NULL,NULL),(474,23,NULL,485,NULL,NULL,NULL,NULL,NULL),(475,23,NULL,486,NULL,NULL,NULL,NULL,NULL),(476,24,NULL,487,NULL,NULL,NULL,NULL,NULL),(477,24,NULL,488,NULL,NULL,NULL,NULL,NULL),(478,24,NULL,489,NULL,NULL,NULL,NULL,NULL),(479,24,NULL,490,NULL,NULL,NULL,NULL,NULL),(480,24,NULL,491,NULL,NULL,NULL,NULL,NULL),(481,25,NULL,492,NULL,NULL,NULL,NULL,NULL),(482,25,NULL,493,NULL,NULL,NULL,NULL,NULL),(483,25,NULL,494,NULL,NULL,NULL,NULL,NULL),(484,25,NULL,495,NULL,NULL,NULL,NULL,NULL),(485,25,NULL,496,NULL,NULL,NULL,NULL,NULL),(486,25,NULL,497,NULL,NULL,NULL,NULL,NULL),(487,25,NULL,498,NULL,NULL,NULL,NULL,NULL),(488,25,NULL,499,NULL,NULL,NULL,NULL,NULL),(489,25,NULL,500,NULL,NULL,NULL,NULL,NULL),(490,25,NULL,501,NULL,NULL,NULL,NULL,NULL),(491,25,NULL,502,NULL,NULL,NULL,NULL,NULL),(492,25,NULL,503,NULL,NULL,NULL,NULL,NULL),(493,25,NULL,504,NULL,NULL,NULL,NULL,NULL),(494,25,NULL,505,NULL,NULL,NULL,NULL,NULL),(495,25,NULL,506,NULL,NULL,NULL,NULL,NULL),(496,25,NULL,507,NULL,NULL,NULL,NULL,NULL),(497,25,NULL,508,NULL,NULL,NULL,NULL,NULL),(498,26,NULL,509,NULL,NULL,NULL,NULL,NULL),(499,26,NULL,510,NULL,NULL,NULL,NULL,NULL),(500,26,NULL,511,NULL,NULL,NULL,NULL,NULL),(501,26,NULL,512,NULL,NULL,NULL,NULL,NULL),(502,26,NULL,513,NULL,NULL,NULL,NULL,NULL),(503,26,NULL,514,NULL,NULL,NULL,NULL,NULL),(504,26,NULL,515,NULL,NULL,NULL,NULL,NULL),(505,26,NULL,516,NULL,NULL,NULL,NULL,NULL),(506,26,NULL,517,NULL,NULL,NULL,NULL,NULL),(507,26,NULL,518,NULL,NULL,NULL,NULL,NULL),(508,26,NULL,519,NULL,NULL,NULL,NULL,NULL),(509,26,NULL,520,NULL,NULL,NULL,NULL,NULL),(510,26,NULL,521,NULL,NULL,NULL,NULL,NULL),(511,26,NULL,522,NULL,NULL,NULL,NULL,NULL),(512,26,NULL,523,NULL,NULL,NULL,NULL,NULL),(513,26,NULL,524,NULL,NULL,NULL,NULL,NULL),(514,26,NULL,525,NULL,NULL,NULL,NULL,NULL),(515,26,NULL,526,NULL,NULL,NULL,NULL,NULL),(516,26,NULL,527,NULL,NULL,NULL,NULL,NULL),(517,26,NULL,528,NULL,NULL,NULL,NULL,NULL),(518,26,NULL,529,NULL,NULL,NULL,NULL,NULL),(519,26,NULL,530,NULL,NULL,NULL,NULL,NULL),(520,26,NULL,531,NULL,NULL,NULL,NULL,NULL),(521,26,NULL,532,NULL,NULL,NULL,NULL,NULL),(522,26,NULL,533,NULL,NULL,NULL,NULL,NULL),(523,26,NULL,534,NULL,NULL,NULL,NULL,NULL),(524,26,NULL,535,NULL,NULL,NULL,NULL,NULL),(525,26,NULL,536,NULL,NULL,NULL,NULL,NULL),(526,26,NULL,537,NULL,NULL,NULL,NULL,NULL),(527,26,NULL,538,NULL,NULL,NULL,NULL,NULL),(528,26,NULL,539,NULL,NULL,NULL,NULL,NULL),(529,26,NULL,540,NULL,NULL,NULL,NULL,NULL),(530,26,NULL,541,NULL,NULL,NULL,NULL,NULL),(531,26,NULL,542,NULL,NULL,NULL,NULL,NULL),(532,26,NULL,543,NULL,NULL,NULL,NULL,NULL),(533,26,NULL,544,NULL,NULL,NULL,NULL,NULL),(534,26,NULL,545,NULL,NULL,NULL,NULL,NULL),(535,26,NULL,546,NULL,NULL,NULL,NULL,NULL),(536,26,NULL,547,NULL,NULL,NULL,NULL,NULL),(537,26,NULL,548,NULL,NULL,NULL,NULL,NULL),(538,26,NULL,549,NULL,NULL,NULL,NULL,NULL),(539,26,NULL,550,NULL,NULL,NULL,NULL,NULL),(540,26,NULL,551,NULL,NULL,NULL,NULL,NULL),(541,26,NULL,552,NULL,NULL,NULL,NULL,NULL),(542,26,NULL,553,NULL,NULL,NULL,NULL,NULL),(543,26,NULL,554,NULL,NULL,NULL,NULL,NULL),(544,26,NULL,555,NULL,NULL,NULL,NULL,NULL),(545,26,NULL,558,NULL,NULL,NULL,NULL,NULL),(546,26,NULL,559,NULL,NULL,NULL,NULL,NULL),(547,26,NULL,560,NULL,NULL,NULL,NULL,NULL),(548,26,NULL,561,NULL,NULL,NULL,NULL,NULL),(549,26,NULL,562,NULL,NULL,NULL,NULL,NULL),(550,26,NULL,563,NULL,NULL,NULL,NULL,NULL),(551,26,NULL,564,NULL,NULL,NULL,NULL,NULL),(552,26,NULL,565,NULL,NULL,NULL,NULL,NULL),(553,26,NULL,566,NULL,NULL,NULL,NULL,NULL),(554,27,NULL,567,NULL,NULL,NULL,NULL,NULL),(555,27,NULL,568,NULL,NULL,NULL,NULL,NULL),(556,27,NULL,569,NULL,NULL,NULL,NULL,NULL),(557,27,NULL,570,NULL,NULL,NULL,NULL,NULL),(558,27,NULL,571,NULL,NULL,NULL,NULL,NULL),(559,27,NULL,572,NULL,NULL,NULL,NULL,NULL),(560,27,NULL,573,NULL,NULL,NULL,NULL,NULL),(561,27,NULL,574,NULL,NULL,NULL,NULL,NULL),(562,27,NULL,575,NULL,NULL,NULL,NULL,NULL),(563,27,NULL,576,NULL,NULL,NULL,NULL,NULL),(564,27,NULL,577,NULL,NULL,NULL,NULL,NULL),(565,27,NULL,578,NULL,NULL,NULL,NULL,NULL),(566,27,NULL,579,NULL,NULL,NULL,NULL,NULL),(567,27,NULL,580,NULL,NULL,NULL,NULL,NULL),(568,27,NULL,581,NULL,NULL,NULL,NULL,NULL),(569,27,NULL,582,NULL,NULL,NULL,NULL,NULL),(570,27,NULL,583,NULL,NULL,NULL,NULL,NULL),(571,27,NULL,584,NULL,NULL,NULL,NULL,NULL),(572,27,NULL,585,NULL,NULL,NULL,NULL,NULL),(573,27,NULL,586,NULL,NULL,NULL,NULL,NULL),(574,27,NULL,587,NULL,NULL,NULL,NULL,NULL),(575,27,NULL,588,NULL,NULL,NULL,NULL,NULL),(576,27,NULL,589,NULL,NULL,NULL,NULL,NULL),(577,28,NULL,590,NULL,NULL,NULL,NULL,NULL),(578,28,NULL,591,NULL,NULL,NULL,NULL,NULL),(579,28,NULL,592,NULL,NULL,NULL,NULL,NULL),(580,28,NULL,593,NULL,NULL,NULL,NULL,NULL),(581,29,NULL,594,NULL,NULL,NULL,NULL,NULL),(582,29,NULL,595,NULL,NULL,NULL,NULL,NULL),(583,29,NULL,596,NULL,NULL,NULL,NULL,NULL),(584,29,NULL,597,NULL,NULL,NULL,NULL,NULL),(585,29,NULL,598,NULL,NULL,NULL,NULL,NULL),(586,29,NULL,599,NULL,NULL,NULL,NULL,NULL),(587,29,NULL,600,NULL,NULL,NULL,NULL,NULL),(588,29,NULL,601,NULL,NULL,NULL,NULL,NULL),(589,29,NULL,602,NULL,NULL,NULL,NULL,NULL),(590,29,NULL,603,NULL,NULL,NULL,NULL,NULL),(591,29,NULL,604,NULL,NULL,NULL,NULL,NULL),(592,29,NULL,605,NULL,NULL,NULL,NULL,NULL),(593,29,NULL,606,NULL,NULL,NULL,NULL,NULL),(594,29,NULL,607,NULL,NULL,NULL,NULL,NULL),(595,29,NULL,608,NULL,NULL,NULL,NULL,NULL),(596,29,NULL,609,NULL,NULL,NULL,NULL,NULL),(597,29,NULL,610,NULL,NULL,NULL,NULL,NULL),(598,29,NULL,611,NULL,NULL,NULL,NULL,NULL),(599,29,NULL,612,NULL,NULL,NULL,NULL,NULL),(600,29,NULL,613,NULL,NULL,NULL,NULL,NULL),(601,29,NULL,614,NULL,NULL,NULL,NULL,NULL),(602,29,NULL,615,NULL,NULL,NULL,NULL,NULL),(603,29,NULL,616,NULL,NULL,NULL,NULL,NULL),(604,29,NULL,617,NULL,NULL,NULL,NULL,NULL),(605,29,NULL,618,NULL,NULL,NULL,NULL,NULL),(606,29,NULL,619,NULL,NULL,NULL,NULL,NULL),(607,29,NULL,620,NULL,NULL,NULL,NULL,NULL),(608,29,NULL,621,NULL,NULL,NULL,NULL,NULL),(609,29,NULL,622,NULL,NULL,NULL,NULL,NULL),(610,29,NULL,623,NULL,NULL,NULL,NULL,NULL),(611,29,NULL,624,NULL,NULL,NULL,NULL,NULL),(612,29,NULL,625,NULL,NULL,NULL,NULL,NULL),(613,29,NULL,626,NULL,NULL,NULL,NULL,NULL),(614,29,NULL,627,NULL,NULL,NULL,NULL,NULL),(615,29,NULL,628,NULL,NULL,NULL,NULL,NULL),(616,29,NULL,629,NULL,NULL,NULL,NULL,NULL),(617,29,NULL,630,NULL,NULL,NULL,NULL,NULL),(618,29,NULL,631,NULL,NULL,NULL,NULL,NULL),(619,30,NULL,632,NULL,NULL,NULL,NULL,NULL),(620,30,NULL,633,NULL,NULL,NULL,NULL,NULL),(621,30,NULL,634,NULL,NULL,NULL,NULL,NULL),(622,30,NULL,635,NULL,NULL,NULL,NULL,NULL),(623,30,NULL,636,NULL,NULL,NULL,NULL,NULL),(624,31,NULL,637,NULL,NULL,NULL,NULL,NULL),(625,31,NULL,638,NULL,NULL,NULL,NULL,NULL),(626,31,NULL,639,NULL,NULL,NULL,NULL,NULL),(627,31,NULL,640,NULL,NULL,NULL,NULL,NULL),(628,31,NULL,641,NULL,NULL,NULL,NULL,NULL),(629,31,NULL,642,NULL,NULL,NULL,NULL,NULL),(630,31,NULL,643,NULL,NULL,NULL,NULL,NULL),(631,31,NULL,644,NULL,NULL,NULL,NULL,NULL),(632,31,NULL,645,NULL,NULL,NULL,NULL,NULL),(633,31,NULL,646,NULL,NULL,NULL,NULL,NULL),(634,31,NULL,647,NULL,NULL,NULL,NULL,NULL),(635,31,NULL,648,NULL,NULL,NULL,NULL,NULL),(636,31,NULL,649,NULL,NULL,NULL,NULL,NULL),(637,31,NULL,650,NULL,NULL,NULL,NULL,NULL),(638,31,NULL,651,NULL,NULL,NULL,NULL,NULL),(639,31,NULL,652,NULL,NULL,NULL,NULL,NULL),(640,31,NULL,653,NULL,NULL,NULL,NULL,NULL),(641,31,NULL,654,NULL,NULL,NULL,NULL,NULL),(642,31,NULL,655,NULL,NULL,NULL,NULL,NULL),(643,31,NULL,656,NULL,NULL,NULL,NULL,NULL),(644,31,NULL,657,NULL,NULL,NULL,NULL,NULL),(645,31,NULL,658,NULL,NULL,NULL,NULL,NULL),(646,31,NULL,659,NULL,NULL,NULL,NULL,NULL),(647,31,NULL,660,NULL,NULL,NULL,NULL,NULL),(648,31,NULL,661,NULL,NULL,NULL,NULL,NULL),(649,31,NULL,662,NULL,NULL,NULL,NULL,NULL),(650,31,NULL,663,NULL,NULL,NULL,NULL,NULL),(651,31,NULL,664,NULL,NULL,NULL,NULL,NULL),(652,31,NULL,665,NULL,NULL,NULL,NULL,NULL),(653,32,NULL,666,NULL,NULL,NULL,NULL,NULL),(654,32,NULL,667,NULL,NULL,NULL,NULL,NULL),(655,33,NULL,668,NULL,NULL,NULL,NULL,NULL),(656,33,NULL,669,NULL,NULL,NULL,NULL,NULL),(657,33,NULL,670,NULL,NULL,NULL,NULL,NULL),(658,33,NULL,671,NULL,NULL,NULL,NULL,NULL),(659,33,NULL,672,NULL,NULL,NULL,NULL,NULL),(660,33,NULL,673,NULL,NULL,NULL,NULL,NULL),(661,33,NULL,674,NULL,NULL,NULL,NULL,NULL),(662,33,NULL,675,NULL,NULL,NULL,NULL,NULL),(663,33,NULL,676,NULL,NULL,NULL,NULL,NULL),(664,33,NULL,677,NULL,NULL,NULL,NULL,NULL),(665,33,NULL,678,NULL,NULL,NULL,NULL,NULL),(666,33,NULL,679,NULL,NULL,NULL,NULL,NULL),(667,33,NULL,680,NULL,NULL,NULL,NULL,NULL),(668,33,NULL,681,NULL,NULL,NULL,NULL,NULL),(669,33,NULL,682,NULL,NULL,NULL,NULL,NULL),(670,33,NULL,683,NULL,NULL,NULL,NULL,NULL),(671,33,NULL,684,NULL,NULL,NULL,NULL,NULL),(672,33,NULL,685,NULL,NULL,NULL,NULL,NULL),(673,33,NULL,686,NULL,NULL,NULL,NULL,NULL),(674,33,NULL,687,NULL,NULL,NULL,NULL,NULL),(675,33,NULL,688,NULL,NULL,NULL,NULL,NULL),(676,33,NULL,689,NULL,NULL,NULL,NULL,NULL),(677,33,NULL,690,NULL,NULL,NULL,NULL,NULL),(678,33,NULL,691,NULL,NULL,NULL,NULL,NULL),(679,33,NULL,692,NULL,NULL,NULL,NULL,NULL),(680,33,NULL,693,NULL,NULL,NULL,NULL,NULL),(681,34,NULL,694,NULL,NULL,NULL,NULL,NULL),(682,34,NULL,695,NULL,NULL,NULL,NULL,NULL),(683,34,NULL,696,NULL,NULL,NULL,NULL,NULL),(684,34,NULL,697,NULL,NULL,NULL,NULL,NULL),(685,34,NULL,698,NULL,NULL,NULL,NULL,NULL),(686,35,NULL,699,NULL,NULL,NULL,NULL,NULL),(687,35,NULL,700,NULL,NULL,NULL,NULL,NULL),(688,35,NULL,701,NULL,NULL,NULL,NULL,NULL),(689,35,NULL,702,NULL,NULL,NULL,NULL,NULL),(690,35,NULL,703,NULL,NULL,NULL,NULL,NULL),(691,35,NULL,704,NULL,NULL,NULL,NULL,NULL),(692,35,NULL,705,NULL,NULL,NULL,NULL,NULL),(693,35,NULL,706,NULL,NULL,NULL,NULL,NULL),(694,35,NULL,707,NULL,NULL,NULL,NULL,NULL),(695,35,NULL,708,NULL,NULL,NULL,NULL,NULL),(696,35,NULL,709,NULL,NULL,NULL,NULL,NULL),(697,35,NULL,710,NULL,NULL,NULL,NULL,NULL),(698,35,NULL,711,NULL,NULL,NULL,NULL,NULL),(699,35,NULL,712,NULL,NULL,NULL,NULL,NULL),(700,35,NULL,713,NULL,NULL,NULL,NULL,NULL),(701,35,NULL,714,NULL,NULL,NULL,NULL,NULL),(702,35,NULL,715,NULL,NULL,NULL,NULL,NULL),(703,35,NULL,716,NULL,NULL,NULL,NULL,NULL),(704,35,NULL,717,NULL,NULL,NULL,NULL,NULL),(705,35,NULL,718,NULL,NULL,NULL,NULL,NULL),(706,35,NULL,719,NULL,NULL,NULL,NULL,NULL),(707,35,NULL,720,NULL,NULL,NULL,NULL,NULL),(708,35,NULL,721,NULL,NULL,NULL,NULL,NULL),(709,35,NULL,722,NULL,NULL,NULL,NULL,NULL),(710,35,NULL,723,NULL,NULL,NULL,NULL,NULL),(711,35,NULL,724,NULL,NULL,NULL,NULL,NULL),(712,35,NULL,725,NULL,NULL,NULL,NULL,NULL),(713,35,NULL,726,NULL,NULL,NULL,NULL,NULL),(714,35,NULL,727,NULL,NULL,NULL,NULL,NULL),(715,35,NULL,728,NULL,NULL,NULL,NULL,NULL),(716,35,NULL,729,NULL,NULL,NULL,NULL,NULL),(717,35,NULL,730,NULL,NULL,NULL,NULL,NULL),(718,36,NULL,731,NULL,NULL,NULL,NULL,NULL),(719,36,NULL,732,NULL,NULL,NULL,NULL,NULL),(720,36,NULL,733,NULL,NULL,NULL,NULL,NULL),(721,36,NULL,734,NULL,NULL,NULL,NULL,NULL),(722,36,NULL,735,NULL,NULL,NULL,NULL,NULL),(723,36,NULL,736,NULL,NULL,NULL,NULL,NULL),(724,36,NULL,737,NULL,NULL,NULL,NULL,NULL),(725,37,NULL,738,NULL,NULL,NULL,NULL,NULL),(726,37,NULL,739,NULL,NULL,NULL,NULL,NULL),(727,37,NULL,740,NULL,NULL,NULL,NULL,NULL),(728,37,NULL,741,NULL,NULL,NULL,NULL,NULL),(729,37,NULL,742,NULL,NULL,NULL,NULL,NULL),(730,37,NULL,743,NULL,NULL,NULL,NULL,NULL),(731,37,NULL,744,NULL,NULL,NULL,NULL,NULL),(732,37,NULL,745,NULL,NULL,NULL,NULL,NULL),(733,37,NULL,746,NULL,NULL,NULL,NULL,NULL),(734,37,NULL,747,NULL,NULL,NULL,NULL,NULL),(735,37,NULL,748,NULL,NULL,NULL,NULL,NULL),(736,37,NULL,749,NULL,NULL,NULL,NULL,NULL),(737,37,NULL,750,NULL,NULL,NULL,NULL,NULL),(738,37,NULL,751,NULL,NULL,NULL,NULL,NULL),(739,37,NULL,752,NULL,NULL,NULL,NULL,NULL),(740,37,NULL,753,NULL,NULL,NULL,NULL,NULL),(741,37,NULL,754,NULL,NULL,NULL,NULL,NULL),(742,37,NULL,755,NULL,NULL,NULL,NULL,NULL),(743,37,NULL,756,NULL,NULL,NULL,NULL,NULL),(744,37,NULL,757,NULL,NULL,NULL,NULL,NULL),(745,37,NULL,758,NULL,NULL,NULL,NULL,NULL),(746,37,NULL,759,NULL,NULL,NULL,NULL,NULL),(747,37,NULL,760,NULL,NULL,NULL,NULL,NULL),(748,37,NULL,761,NULL,NULL,NULL,NULL,NULL),(749,37,NULL,762,NULL,NULL,NULL,NULL,NULL),(750,37,NULL,763,NULL,NULL,NULL,NULL,NULL),(751,37,NULL,764,NULL,NULL,NULL,NULL,NULL),(752,37,NULL,765,NULL,NULL,NULL,NULL,NULL),(753,37,NULL,766,NULL,NULL,NULL,NULL,NULL),(754,37,NULL,767,NULL,NULL,NULL,NULL,NULL),(755,37,NULL,768,NULL,NULL,NULL,NULL,NULL),(756,38,NULL,769,NULL,NULL,NULL,NULL,NULL),(757,38,NULL,770,NULL,NULL,NULL,NULL,NULL),(758,38,NULL,771,NULL,NULL,NULL,NULL,NULL),(759,38,NULL,772,NULL,NULL,NULL,NULL,NULL),(760,38,NULL,773,NULL,NULL,NULL,NULL,NULL),(761,38,NULL,774,NULL,NULL,NULL,NULL,NULL),(762,38,NULL,775,NULL,NULL,NULL,NULL,NULL),(763,38,NULL,776,NULL,NULL,NULL,NULL,NULL),(764,38,NULL,777,NULL,NULL,NULL,NULL,NULL),(765,38,NULL,778,NULL,NULL,NULL,NULL,NULL),(766,38,NULL,779,NULL,NULL,NULL,NULL,NULL),(767,38,NULL,780,NULL,NULL,NULL,NULL,NULL),(768,38,NULL,781,NULL,NULL,NULL,NULL,NULL),(769,38,NULL,782,NULL,NULL,NULL,NULL,NULL),(770,38,NULL,783,NULL,NULL,NULL,NULL,NULL),(771,38,NULL,784,NULL,NULL,NULL,NULL,NULL),(772,38,NULL,785,NULL,NULL,NULL,NULL,NULL),(773,38,NULL,786,NULL,NULL,NULL,NULL,NULL),(774,38,NULL,787,NULL,NULL,NULL,NULL,NULL),(775,38,NULL,788,NULL,NULL,NULL,NULL,NULL),(776,38,NULL,789,NULL,NULL,NULL,NULL,NULL),(777,38,NULL,790,NULL,NULL,NULL,NULL,NULL),(778,38,NULL,791,NULL,NULL,NULL,NULL,NULL),(779,38,NULL,792,NULL,NULL,NULL,NULL,NULL),(780,38,NULL,793,NULL,NULL,NULL,NULL,NULL),(781,38,NULL,794,NULL,NULL,NULL,NULL,NULL),(782,38,NULL,795,NULL,NULL,NULL,NULL,NULL),(783,38,NULL,796,NULL,NULL,NULL,NULL,NULL),(784,38,NULL,797,NULL,NULL,NULL,NULL,NULL),(785,38,NULL,798,NULL,NULL,NULL,NULL,NULL),(786,38,NULL,799,NULL,NULL,NULL,NULL,NULL),(787,38,NULL,800,NULL,NULL,NULL,NULL,NULL),(788,38,NULL,801,NULL,NULL,NULL,NULL,NULL),(789,38,NULL,802,NULL,NULL,NULL,NULL,NULL),(790,38,NULL,803,NULL,NULL,NULL,NULL,NULL),(791,38,NULL,804,NULL,NULL,NULL,NULL,NULL),(792,38,NULL,805,NULL,NULL,NULL,NULL,NULL),(793,38,NULL,806,NULL,NULL,NULL,NULL,NULL),(794,38,NULL,807,NULL,NULL,NULL,NULL,NULL),(795,38,NULL,808,NULL,NULL,NULL,NULL,NULL),(796,38,NULL,809,NULL,NULL,NULL,NULL,NULL),(797,38,NULL,810,NULL,NULL,NULL,NULL,NULL),(798,38,NULL,811,NULL,NULL,NULL,NULL,NULL),(799,38,NULL,812,NULL,NULL,NULL,NULL,NULL),(800,38,NULL,813,NULL,NULL,NULL,NULL,NULL),(801,38,NULL,814,NULL,NULL,NULL,NULL,NULL),(802,38,NULL,815,NULL,NULL,NULL,NULL,NULL),(803,38,NULL,816,NULL,NULL,NULL,NULL,NULL),(804,38,NULL,817,NULL,NULL,NULL,NULL,NULL),(805,38,NULL,818,NULL,NULL,NULL,NULL,NULL),(806,38,NULL,819,NULL,NULL,NULL,NULL,NULL),(807,38,NULL,820,NULL,NULL,NULL,NULL,NULL),(808,39,NULL,821,NULL,NULL,NULL,NULL,NULL),(809,39,NULL,822,NULL,NULL,NULL,NULL,NULL),(810,39,NULL,823,NULL,NULL,NULL,NULL,NULL),(811,39,NULL,824,NULL,NULL,NULL,NULL,NULL),(812,39,NULL,825,NULL,NULL,NULL,NULL,NULL),(813,39,NULL,826,NULL,NULL,NULL,NULL,NULL),(814,39,NULL,827,NULL,NULL,NULL,NULL,NULL),(815,39,NULL,828,NULL,NULL,NULL,NULL,NULL),(816,39,NULL,829,NULL,NULL,NULL,NULL,NULL),(817,39,NULL,830,NULL,NULL,NULL,NULL,NULL),(818,39,NULL,831,NULL,NULL,NULL,NULL,NULL),(819,39,NULL,832,NULL,NULL,NULL,NULL,NULL),(820,39,NULL,833,NULL,NULL,NULL,NULL,NULL),(821,39,NULL,834,NULL,NULL,NULL,NULL,NULL),(822,39,NULL,835,NULL,NULL,NULL,NULL,NULL),(823,39,NULL,836,NULL,NULL,NULL,NULL,NULL),(824,39,NULL,837,NULL,NULL,NULL,NULL,NULL),(825,39,NULL,838,NULL,NULL,NULL,NULL,NULL),(826,39,NULL,839,NULL,NULL,NULL,NULL,NULL),(827,39,NULL,840,NULL,NULL,NULL,NULL,NULL),(828,39,NULL,841,NULL,NULL,NULL,NULL,NULL),(829,39,NULL,842,NULL,NULL,NULL,NULL,NULL),(830,40,NULL,843,NULL,NULL,NULL,NULL,NULL),(831,40,NULL,844,NULL,NULL,NULL,NULL,NULL),(832,40,NULL,845,NULL,NULL,NULL,NULL,NULL),(833,40,NULL,846,NULL,NULL,NULL,NULL,NULL),(834,40,NULL,847,NULL,NULL,NULL,NULL,NULL),(835,40,NULL,848,NULL,NULL,NULL,NULL,NULL),(836,40,NULL,849,NULL,NULL,NULL,NULL,NULL),(837,41,NULL,850,NULL,NULL,NULL,NULL,NULL),(838,41,NULL,851,NULL,NULL,NULL,NULL,NULL),(839,41,NULL,852,NULL,NULL,NULL,NULL,NULL),(840,41,NULL,853,NULL,NULL,NULL,NULL,NULL),(841,41,NULL,854,NULL,NULL,NULL,NULL,NULL),(842,41,NULL,855,NULL,NULL,NULL,NULL,NULL),(843,41,NULL,856,NULL,NULL,NULL,NULL,NULL),(844,41,NULL,857,NULL,NULL,NULL,NULL,NULL),(845,41,NULL,858,NULL,NULL,NULL,NULL,NULL),(846,41,NULL,859,NULL,NULL,NULL,NULL,NULL),(847,41,NULL,860,NULL,NULL,NULL,NULL,NULL),(848,41,NULL,861,NULL,NULL,NULL,NULL,NULL),(849,41,NULL,862,NULL,NULL,NULL,NULL,NULL),(850,41,NULL,863,NULL,NULL,NULL,NULL,NULL),(851,41,NULL,864,NULL,NULL,NULL,NULL,NULL),(852,41,NULL,865,NULL,NULL,NULL,NULL,NULL),(853,41,NULL,866,NULL,NULL,NULL,NULL,NULL),(854,41,NULL,867,NULL,NULL,NULL,NULL,NULL),(855,41,NULL,868,NULL,NULL,NULL,NULL,NULL),(856,41,NULL,869,NULL,NULL,NULL,NULL,NULL),(857,41,NULL,870,NULL,NULL,NULL,NULL,NULL),(858,41,NULL,871,NULL,NULL,NULL,NULL,NULL),(859,41,NULL,872,NULL,NULL,NULL,NULL,NULL),(860,41,NULL,873,NULL,NULL,NULL,NULL,NULL),(861,41,NULL,874,NULL,NULL,NULL,NULL,NULL),(862,41,NULL,875,NULL,NULL,NULL,NULL,NULL),(863,41,NULL,876,NULL,NULL,NULL,NULL,NULL),(864,41,NULL,877,NULL,NULL,NULL,NULL,NULL),(865,41,NULL,878,NULL,NULL,NULL,NULL,NULL),(866,41,NULL,879,NULL,NULL,NULL,NULL,NULL),(867,41,NULL,880,NULL,NULL,NULL,NULL,NULL),(868,43,NULL,881,NULL,NULL,NULL,NULL,NULL),(869,43,NULL,882,NULL,NULL,NULL,NULL,NULL),(870,43,NULL,883,NULL,NULL,NULL,NULL,NULL),(871,43,NULL,884,NULL,NULL,NULL,NULL,NULL),(872,43,NULL,885,NULL,NULL,NULL,NULL,NULL),(873,43,NULL,886,NULL,NULL,NULL,NULL,NULL),(874,43,NULL,887,NULL,NULL,NULL,NULL,NULL),(875,43,NULL,888,NULL,NULL,NULL,NULL,NULL),(876,43,NULL,889,NULL,NULL,NULL,NULL,NULL),(877,43,NULL,890,NULL,NULL,NULL,NULL,NULL),(878,43,NULL,891,NULL,NULL,NULL,NULL,NULL),(879,43,NULL,892,NULL,NULL,NULL,NULL,NULL),(880,43,NULL,893,NULL,NULL,NULL,NULL,NULL),(881,43,NULL,894,NULL,NULL,NULL,NULL,NULL),(882,43,NULL,895,NULL,NULL,NULL,NULL,NULL),(883,43,NULL,896,NULL,NULL,NULL,NULL,NULL),(884,43,NULL,897,NULL,NULL,NULL,NULL,NULL),(885,43,NULL,898,NULL,NULL,NULL,NULL,NULL),(886,43,NULL,899,NULL,NULL,NULL,NULL,NULL),(887,43,NULL,900,NULL,NULL,NULL,NULL,NULL),(888,43,NULL,901,NULL,NULL,NULL,NULL,NULL),(889,42,NULL,902,NULL,NULL,NULL,NULL,NULL),(890,42,NULL,903,NULL,NULL,NULL,NULL,NULL),(891,42,NULL,904,NULL,NULL,NULL,NULL,NULL),(892,42,NULL,905,NULL,NULL,NULL,NULL,NULL),(893,42,NULL,906,NULL,NULL,NULL,NULL,NULL),(894,42,NULL,907,NULL,NULL,NULL,NULL,NULL),(895,42,NULL,908,NULL,NULL,NULL,NULL,NULL),(896,42,NULL,909,NULL,NULL,NULL,NULL,NULL),(897,42,NULL,910,NULL,NULL,NULL,NULL,NULL),(898,42,NULL,911,NULL,NULL,NULL,NULL,NULL),(899,42,NULL,912,NULL,NULL,NULL,NULL,NULL),(900,42,NULL,913,NULL,NULL,NULL,NULL,NULL),(901,42,NULL,914,NULL,NULL,NULL,NULL,NULL),(902,42,NULL,915,NULL,NULL,NULL,NULL,NULL),(903,42,NULL,916,NULL,NULL,NULL,NULL,NULL),(904,42,NULL,917,NULL,NULL,NULL,NULL,NULL),(905,42,NULL,918,NULL,NULL,NULL,NULL,NULL),(906,42,NULL,919,NULL,NULL,NULL,NULL,NULL),(907,42,NULL,920,NULL,NULL,NULL,NULL,NULL),(908,42,NULL,921,NULL,NULL,NULL,NULL,NULL),(909,42,NULL,922,NULL,NULL,NULL,NULL,NULL),(910,42,NULL,923,NULL,NULL,NULL,NULL,NULL),(911,42,NULL,924,NULL,NULL,NULL,NULL,NULL),(912,42,NULL,925,NULL,NULL,NULL,NULL,NULL),(913,42,NULL,926,NULL,NULL,NULL,NULL,NULL),(914,42,NULL,927,NULL,NULL,NULL,NULL,NULL),(915,42,NULL,928,NULL,NULL,NULL,NULL,NULL),(916,42,NULL,929,NULL,NULL,NULL,NULL,NULL),(917,42,NULL,930,NULL,NULL,NULL,NULL,NULL),(918,42,NULL,931,NULL,NULL,NULL,NULL,NULL),(919,42,NULL,932,NULL,NULL,NULL,NULL,NULL),(920,42,NULL,933,NULL,NULL,NULL,NULL,NULL),(921,44,NULL,934,NULL,NULL,NULL,NULL,NULL),(922,44,NULL,935,NULL,NULL,NULL,NULL,NULL),(923,44,NULL,936,NULL,NULL,NULL,NULL,NULL),(924,44,NULL,937,NULL,NULL,NULL,NULL,NULL),(925,44,NULL,938,NULL,NULL,NULL,NULL,NULL),(926,44,NULL,939,NULL,NULL,NULL,NULL,NULL),(927,45,NULL,940,NULL,NULL,NULL,NULL,NULL),(928,45,NULL,941,NULL,NULL,NULL,NULL,NULL),(929,45,NULL,942,NULL,NULL,NULL,NULL,NULL),(930,45,NULL,943,NULL,NULL,NULL,NULL,NULL),(931,45,NULL,944,NULL,NULL,NULL,NULL,NULL),(932,45,NULL,945,NULL,NULL,NULL,NULL,NULL),(933,45,NULL,946,NULL,NULL,NULL,NULL,NULL),(934,45,NULL,947,NULL,NULL,NULL,NULL,NULL),(935,45,NULL,948,NULL,NULL,NULL,NULL,NULL),(936,45,NULL,949,NULL,NULL,NULL,NULL,NULL),(937,45,NULL,950,NULL,NULL,NULL,NULL,NULL),(938,45,NULL,951,NULL,NULL,NULL,NULL,NULL),(939,45,NULL,952,NULL,NULL,NULL,NULL,NULL),(940,45,NULL,953,NULL,NULL,NULL,NULL,NULL),(941,45,NULL,954,NULL,NULL,NULL,NULL,NULL),(942,45,NULL,955,NULL,NULL,NULL,NULL,NULL),(943,45,NULL,956,NULL,NULL,NULL,NULL,NULL),(944,45,NULL,957,NULL,NULL,NULL,NULL,NULL),(945,45,NULL,958,NULL,NULL,NULL,NULL,NULL),(946,46,NULL,959,NULL,NULL,NULL,NULL,NULL),(947,46,NULL,960,NULL,NULL,NULL,NULL,NULL),(948,46,NULL,961,NULL,NULL,NULL,NULL,NULL),(949,46,NULL,962,NULL,NULL,NULL,NULL,NULL),(950,46,NULL,963,NULL,NULL,NULL,NULL,NULL),(951,46,NULL,964,NULL,NULL,NULL,NULL,NULL),(952,46,NULL,965,NULL,NULL,NULL,NULL,NULL),(953,46,NULL,966,NULL,NULL,NULL,NULL,NULL),(954,46,NULL,967,NULL,NULL,NULL,NULL,NULL),(955,46,NULL,968,NULL,NULL,NULL,NULL,NULL),(956,46,NULL,969,NULL,NULL,NULL,NULL,NULL),(957,46,NULL,970,NULL,NULL,NULL,NULL,NULL),(958,46,NULL,971,NULL,NULL,NULL,NULL,NULL),(959,46,NULL,972,NULL,NULL,NULL,NULL,NULL),(960,46,NULL,973,NULL,NULL,NULL,NULL,NULL),(961,46,NULL,974,NULL,NULL,NULL,NULL,NULL),(962,46,NULL,975,NULL,NULL,NULL,NULL,NULL),(963,46,NULL,976,NULL,NULL,NULL,NULL,NULL),(964,46,NULL,977,NULL,NULL,NULL,NULL,NULL),(965,46,NULL,978,NULL,NULL,NULL,NULL,NULL),(966,46,NULL,979,NULL,NULL,NULL,NULL,NULL),(967,46,NULL,980,NULL,NULL,NULL,NULL,NULL),(968,46,NULL,981,NULL,NULL,NULL,NULL,NULL),(969,46,NULL,982,NULL,NULL,NULL,NULL,NULL),(970,46,NULL,983,NULL,NULL,NULL,NULL,NULL),(971,47,NULL,984,NULL,NULL,NULL,NULL,NULL),(973,49,NULL,986,NULL,NULL,NULL,NULL,NULL),(974,49,NULL,987,NULL,NULL,NULL,NULL,NULL),(975,49,NULL,988,NULL,NULL,NULL,NULL,NULL),(976,50,NULL,989,NULL,NULL,NULL,NULL,NULL),(977,50,NULL,990,NULL,NULL,NULL,NULL,NULL),(978,50,NULL,991,NULL,NULL,NULL,NULL,NULL),(979,50,NULL,992,NULL,NULL,NULL,NULL,NULL),(980,50,NULL,993,NULL,NULL,NULL,NULL,NULL),(981,50,NULL,994,NULL,NULL,NULL,NULL,NULL),(982,50,NULL,995,NULL,NULL,NULL,NULL,NULL),(983,50,NULL,996,NULL,NULL,NULL,NULL,NULL),(984,50,NULL,997,NULL,NULL,NULL,NULL,NULL),(985,50,NULL,998,NULL,NULL,NULL,NULL,NULL),(986,50,NULL,999,NULL,NULL,NULL,NULL,NULL),(987,50,NULL,1000,NULL,NULL,NULL,NULL,NULL),(988,50,NULL,1001,NULL,NULL,NULL,NULL,NULL),(989,50,NULL,1002,NULL,NULL,NULL,NULL,NULL),(990,50,NULL,1003,NULL,NULL,NULL,NULL,NULL),(991,50,NULL,1004,NULL,NULL,NULL,NULL,NULL),(992,50,NULL,1005,NULL,NULL,NULL,NULL,NULL),(993,50,NULL,1006,NULL,NULL,NULL,NULL,NULL),(994,50,NULL,1007,NULL,NULL,NULL,NULL,NULL),(995,50,NULL,1008,NULL,NULL,NULL,NULL,NULL),(996,51,NULL,1009,NULL,NULL,NULL,NULL,NULL),(997,51,NULL,1010,NULL,NULL,NULL,NULL,NULL),(998,51,NULL,1011,NULL,NULL,NULL,NULL,NULL),(999,51,NULL,1012,NULL,NULL,NULL,NULL,NULL),(1000,51,NULL,1013,NULL,NULL,NULL,NULL,NULL),(1001,51,NULL,1014,NULL,NULL,NULL,NULL,NULL),(1002,51,NULL,1015,NULL,NULL,NULL,NULL,NULL),(1003,51,NULL,1016,NULL,NULL,NULL,NULL,NULL),(1004,51,NULL,1017,NULL,NULL,NULL,NULL,NULL),(1005,51,NULL,1018,NULL,NULL,NULL,NULL,NULL),(1006,51,NULL,1019,NULL,NULL,NULL,NULL,NULL),(1007,51,NULL,1020,NULL,NULL,NULL,NULL,NULL),(1008,51,NULL,1021,NULL,NULL,NULL,NULL,NULL),(1009,51,NULL,1022,NULL,NULL,NULL,NULL,NULL),(1010,51,NULL,1023,NULL,NULL,NULL,NULL,NULL),(1011,51,NULL,1024,NULL,NULL,NULL,NULL,NULL),(1012,51,NULL,1025,NULL,NULL,NULL,NULL,NULL),(1013,51,NULL,1026,NULL,NULL,NULL,NULL,NULL),(1014,51,NULL,1027,NULL,NULL,NULL,NULL,NULL),(1015,51,NULL,1028,NULL,NULL,NULL,NULL,NULL),(1016,51,NULL,1029,NULL,NULL,NULL,NULL,NULL),(1017,51,NULL,1030,NULL,NULL,NULL,NULL,NULL),(1018,51,NULL,1031,NULL,NULL,NULL,NULL,NULL),(1019,51,NULL,1032,NULL,NULL,NULL,NULL,NULL),(1020,51,NULL,1033,NULL,NULL,NULL,NULL,NULL),(1021,51,NULL,1034,NULL,NULL,NULL,NULL,NULL),(1022,51,NULL,1035,NULL,NULL,NULL,NULL,NULL),(1023,51,NULL,1036,NULL,NULL,NULL,NULL,NULL),(1024,51,NULL,1037,NULL,NULL,NULL,NULL,NULL),(1025,51,NULL,1038,NULL,NULL,NULL,NULL,NULL),(1026,51,NULL,1039,NULL,NULL,NULL,NULL,NULL),(1027,51,NULL,1040,NULL,NULL,NULL,NULL,NULL),(1028,51,NULL,1041,NULL,NULL,NULL,NULL,NULL),(1029,51,NULL,1042,NULL,NULL,NULL,NULL,NULL),(1030,51,NULL,1043,NULL,NULL,NULL,NULL,NULL),(1031,51,NULL,1044,NULL,NULL,NULL,NULL,NULL),(1032,51,NULL,1045,NULL,NULL,NULL,NULL,NULL),(1033,51,NULL,1046,NULL,NULL,NULL,NULL,NULL),(1034,51,NULL,1047,NULL,NULL,NULL,NULL,NULL),(1035,51,NULL,1048,NULL,NULL,NULL,NULL,NULL),(1036,51,NULL,1049,NULL,NULL,NULL,NULL,NULL),(1037,52,NULL,1050,NULL,NULL,NULL,NULL,NULL),(1038,52,NULL,1051,NULL,NULL,NULL,NULL,NULL),(1039,52,NULL,1052,NULL,NULL,NULL,NULL,NULL),(1040,52,NULL,1053,NULL,NULL,NULL,NULL,NULL),(1041,52,NULL,1054,NULL,NULL,NULL,NULL,NULL),(1042,52,NULL,1055,NULL,NULL,NULL,NULL,NULL),(1043,52,NULL,1056,NULL,NULL,NULL,NULL,NULL),(1044,52,NULL,1057,NULL,NULL,NULL,NULL,NULL),(1045,52,NULL,1058,NULL,NULL,NULL,NULL,NULL),(1046,52,NULL,1059,NULL,NULL,NULL,NULL,NULL),(1047,52,NULL,1060,NULL,NULL,NULL,NULL,NULL),(1048,52,NULL,1061,NULL,NULL,NULL,NULL,NULL),(1049,52,NULL,1062,NULL,NULL,NULL,NULL,NULL),(1050,52,NULL,1063,NULL,NULL,NULL,NULL,NULL),(1051,52,NULL,1064,NULL,NULL,NULL,NULL,NULL),(1052,52,NULL,1065,NULL,NULL,NULL,NULL,NULL),(1053,52,NULL,1066,NULL,NULL,NULL,NULL,NULL),(1054,53,NULL,1067,NULL,NULL,NULL,NULL,NULL),(1055,53,NULL,1068,NULL,NULL,NULL,NULL,NULL),(1056,53,NULL,1069,NULL,NULL,NULL,NULL,NULL),(1057,53,NULL,1070,NULL,NULL,NULL,NULL,NULL),(1058,53,NULL,1071,NULL,NULL,NULL,NULL,NULL),(1059,54,NULL,1072,NULL,NULL,NULL,NULL,NULL),(1060,54,NULL,1073,NULL,NULL,NULL,NULL,NULL),(1061,54,NULL,1074,NULL,NULL,NULL,NULL,NULL),(1062,54,NULL,1075,NULL,NULL,NULL,NULL,NULL),(1063,54,NULL,1076,NULL,NULL,NULL,NULL,NULL),(1064,54,NULL,1077,NULL,NULL,NULL,NULL,NULL),(1065,54,NULL,1078,NULL,NULL,NULL,NULL,NULL),(1066,54,NULL,1079,NULL,NULL,NULL,NULL,NULL),(1067,54,NULL,1080,NULL,NULL,NULL,NULL,NULL),(1068,54,NULL,1081,NULL,NULL,NULL,NULL,NULL),(1069,54,NULL,1082,NULL,NULL,NULL,NULL,NULL),(1070,54,NULL,1083,NULL,NULL,NULL,NULL,NULL),(1071,54,NULL,1084,NULL,NULL,NULL,NULL,NULL),(1072,54,NULL,1085,NULL,NULL,NULL,NULL,NULL),(1073,54,NULL,1086,NULL,NULL,NULL,NULL,NULL),(1074,54,NULL,1087,NULL,NULL,NULL,NULL,NULL),(1075,55,NULL,1088,NULL,NULL,NULL,NULL,NULL),(1076,55,NULL,1089,NULL,NULL,NULL,NULL,NULL),(1077,55,NULL,1090,NULL,NULL,NULL,NULL,NULL),(1078,55,NULL,1091,NULL,NULL,NULL,NULL,NULL),(1079,55,NULL,1092,NULL,NULL,NULL,NULL,NULL),(1080,55,NULL,1093,NULL,NULL,NULL,NULL,NULL),(1081,55,NULL,1094,NULL,NULL,NULL,NULL,NULL),(1082,55,NULL,1095,NULL,NULL,NULL,NULL,NULL),(1083,55,NULL,1096,NULL,NULL,NULL,NULL,NULL),(1084,55,NULL,1097,NULL,NULL,NULL,NULL,NULL),(1085,55,NULL,1098,NULL,NULL,NULL,NULL,NULL),(1086,55,NULL,1099,NULL,NULL,NULL,NULL,NULL),(1087,56,NULL,1100,NULL,NULL,NULL,NULL,NULL),(1088,56,NULL,1101,NULL,NULL,NULL,NULL,NULL),(1089,56,NULL,1102,NULL,NULL,NULL,NULL,NULL),(1090,56,NULL,1103,NULL,NULL,NULL,NULL,NULL),(1091,56,NULL,1104,NULL,NULL,NULL,NULL,NULL),(1092,56,NULL,1105,NULL,NULL,NULL,NULL,NULL),(1093,56,NULL,1106,NULL,NULL,NULL,NULL,NULL),(1094,56,NULL,1107,NULL,NULL,NULL,NULL,NULL),(1095,56,NULL,1108,NULL,NULL,NULL,NULL,NULL),(1096,56,NULL,1109,NULL,NULL,NULL,NULL,NULL),(1097,56,NULL,1110,NULL,NULL,NULL,NULL,NULL),(1098,56,NULL,1111,NULL,NULL,NULL,NULL,NULL),(1099,56,NULL,1112,NULL,NULL,NULL,NULL,NULL),(1100,56,NULL,1113,NULL,NULL,NULL,NULL,NULL),(1101,56,NULL,1114,NULL,NULL,NULL,NULL,NULL),(1102,56,NULL,1115,NULL,NULL,NULL,NULL,NULL),(1103,56,NULL,1116,NULL,NULL,NULL,NULL,NULL),(1104,56,NULL,1117,NULL,NULL,NULL,NULL,NULL),(1105,56,NULL,1118,NULL,NULL,NULL,NULL,NULL),(1106,56,NULL,1119,NULL,NULL,NULL,NULL,NULL),(1107,56,NULL,1120,NULL,NULL,NULL,NULL,NULL),(1108,56,NULL,1121,NULL,NULL,NULL,NULL,NULL),(1109,57,NULL,1122,NULL,NULL,NULL,NULL,NULL),(1110,57,NULL,1123,NULL,NULL,NULL,NULL,NULL),(1111,57,NULL,1124,NULL,NULL,NULL,NULL,NULL),(1112,57,NULL,1125,NULL,NULL,NULL,NULL,NULL),(1113,58,NULL,1126,NULL,NULL,NULL,NULL,NULL),(1114,58,NULL,1127,NULL,NULL,NULL,NULL,NULL),(1115,58,NULL,1128,NULL,NULL,NULL,NULL,NULL),(1116,58,NULL,1129,NULL,NULL,NULL,NULL,NULL),(1117,58,NULL,1130,NULL,NULL,NULL,NULL,NULL),(1118,58,NULL,1131,NULL,NULL,NULL,NULL,NULL),(1119,58,NULL,1133,NULL,NULL,NULL,NULL,NULL),(1120,58,NULL,1134,NULL,NULL,NULL,NULL,NULL),(1121,58,NULL,1135,NULL,NULL,NULL,NULL,NULL),(1122,58,NULL,1136,NULL,NULL,NULL,NULL,NULL),(1123,58,NULL,1137,NULL,NULL,NULL,NULL,NULL),(1124,58,NULL,1138,NULL,NULL,NULL,NULL,NULL),(1125,58,NULL,1139,NULL,NULL,NULL,NULL,NULL),(1126,58,NULL,1140,NULL,NULL,NULL,NULL,NULL),(1127,58,NULL,1141,NULL,NULL,NULL,NULL,NULL),(1128,58,NULL,1142,NULL,NULL,NULL,NULL,NULL),(1129,58,NULL,1143,NULL,NULL,NULL,NULL,NULL),(1130,58,NULL,1144,NULL,NULL,NULL,NULL,NULL),(1131,58,NULL,1145,NULL,NULL,NULL,NULL,NULL),(1132,58,NULL,1146,NULL,NULL,NULL,NULL,NULL),(1133,59,NULL,1147,NULL,NULL,NULL,NULL,NULL),(1134,59,NULL,1148,NULL,NULL,NULL,NULL,NULL),(1135,59,NULL,1149,NULL,NULL,NULL,NULL,NULL),(1136,60,NULL,1150,NULL,NULL,NULL,NULL,NULL),(1137,60,NULL,1151,NULL,NULL,NULL,NULL,NULL),(1138,60,NULL,1152,NULL,NULL,NULL,NULL,NULL),(1139,60,NULL,1153,NULL,NULL,NULL,NULL,NULL),(1140,60,NULL,1154,NULL,NULL,NULL,NULL,NULL),(1141,60,NULL,1155,NULL,NULL,NULL,NULL,NULL),(1142,60,NULL,1156,NULL,NULL,NULL,NULL,NULL),(1143,60,NULL,1157,NULL,NULL,NULL,NULL,NULL),(1144,60,NULL,1158,NULL,NULL,NULL,NULL,NULL),(1145,60,NULL,1159,NULL,NULL,NULL,NULL,NULL),(1146,60,NULL,1160,NULL,NULL,NULL,NULL,NULL),(1147,60,NULL,1161,NULL,NULL,NULL,NULL,NULL),(1148,60,NULL,1162,NULL,NULL,NULL,NULL,NULL),(1149,60,NULL,1163,NULL,NULL,NULL,NULL,NULL),(1150,60,NULL,1164,NULL,NULL,NULL,NULL,NULL),(1151,60,NULL,1165,NULL,NULL,NULL,NULL,NULL),(1152,60,NULL,1166,NULL,NULL,NULL,NULL,NULL),(1153,60,NULL,1167,NULL,NULL,NULL,NULL,NULL),(1154,60,NULL,1168,NULL,NULL,NULL,NULL,NULL),(1155,60,NULL,1169,NULL,NULL,NULL,NULL,NULL),(1156,60,NULL,1170,NULL,NULL,NULL,NULL,NULL),(1157,60,NULL,1171,NULL,NULL,NULL,NULL,NULL),(1158,60,NULL,1172,NULL,NULL,NULL,NULL,NULL),(1159,60,NULL,1173,NULL,NULL,NULL,NULL,NULL),(1160,60,NULL,1174,NULL,NULL,NULL,NULL,NULL),(1161,60,NULL,1175,NULL,NULL,NULL,NULL,NULL),(1162,60,NULL,1176,NULL,NULL,NULL,NULL,NULL),(1163,60,NULL,1177,NULL,NULL,NULL,NULL,NULL),(1164,60,NULL,1178,NULL,NULL,NULL,NULL,NULL),(1165,60,NULL,1179,NULL,NULL,NULL,NULL,NULL),(1166,60,NULL,1180,NULL,NULL,NULL,NULL,NULL),(1167,60,NULL,1181,NULL,NULL,NULL,NULL,NULL),(1168,60,NULL,1182,NULL,NULL,NULL,NULL,NULL),(1169,61,NULL,1183,NULL,NULL,NULL,NULL,NULL),(1170,61,NULL,1184,NULL,NULL,NULL,NULL,NULL),(1171,61,NULL,1185,NULL,NULL,NULL,NULL,NULL),(1172,61,NULL,1186,NULL,NULL,NULL,NULL,NULL),(1173,61,NULL,1187,NULL,NULL,NULL,NULL,NULL),(1174,61,NULL,1188,NULL,NULL,NULL,NULL,NULL),(1175,61,NULL,1189,NULL,NULL,NULL,NULL,NULL),(1176,61,NULL,1190,NULL,NULL,NULL,NULL,NULL),(1177,61,NULL,1191,NULL,NULL,NULL,NULL,NULL),(1178,61,NULL,1192,NULL,NULL,NULL,NULL,NULL),(1179,61,NULL,1193,NULL,NULL,NULL,NULL,NULL),(1180,61,NULL,1194,NULL,NULL,NULL,NULL,NULL),(1181,61,NULL,1195,NULL,NULL,NULL,NULL,NULL),(1182,61,NULL,1196,NULL,NULL,NULL,NULL,NULL),(1183,61,NULL,1197,NULL,NULL,NULL,NULL,NULL),(1184,62,NULL,1198,NULL,NULL,NULL,NULL,NULL),(1185,62,NULL,1199,NULL,NULL,NULL,NULL,NULL),(1186,62,NULL,1200,NULL,NULL,NULL,NULL,NULL),(1187,62,NULL,1201,NULL,NULL,NULL,NULL,NULL),(1188,62,NULL,1202,NULL,NULL,NULL,NULL,NULL),(1189,62,NULL,1203,NULL,NULL,NULL,NULL,NULL),(1190,62,NULL,1204,NULL,NULL,NULL,NULL,NULL),(1191,62,NULL,1205,NULL,NULL,NULL,NULL,NULL),(1192,62,NULL,1206,NULL,NULL,NULL,NULL,NULL),(1193,62,NULL,1207,NULL,NULL,NULL,NULL,NULL),(1194,62,NULL,1208,NULL,NULL,NULL,NULL,NULL),(1195,62,NULL,1209,NULL,NULL,NULL,NULL,NULL),(1196,62,NULL,1210,NULL,NULL,NULL,NULL,NULL),(1197,62,NULL,1211,NULL,NULL,NULL,NULL,NULL),(1198,62,NULL,1212,NULL,NULL,NULL,NULL,NULL),(1199,62,NULL,1213,NULL,NULL,NULL,NULL,NULL),(1200,62,NULL,1214,NULL,NULL,NULL,NULL,NULL),(1201,62,NULL,1215,NULL,NULL,NULL,NULL,NULL),(1202,62,NULL,1216,NULL,NULL,NULL,NULL,NULL),(1203,62,NULL,1217,NULL,NULL,NULL,NULL,NULL),(1204,62,NULL,1218,NULL,NULL,NULL,NULL,NULL),(1205,62,NULL,1219,NULL,NULL,NULL,NULL,NULL),(1206,62,NULL,1220,NULL,NULL,NULL,NULL,NULL),(1207,62,NULL,1221,NULL,NULL,NULL,NULL,NULL),(1208,62,NULL,1222,NULL,NULL,NULL,NULL,NULL),(1209,62,NULL,1223,NULL,NULL,NULL,NULL,NULL),(1210,62,NULL,1224,NULL,NULL,NULL,NULL,NULL),(1211,62,NULL,1225,NULL,NULL,NULL,NULL,NULL),(1212,62,NULL,1226,NULL,NULL,NULL,NULL,NULL),(1213,62,NULL,1227,NULL,NULL,NULL,NULL,NULL),(1214,62,NULL,1228,NULL,NULL,NULL,NULL,NULL),(1215,62,NULL,1229,NULL,NULL,NULL,NULL,NULL),(1216,62,NULL,1230,NULL,NULL,NULL,NULL,NULL),(1217,62,NULL,1231,NULL,NULL,NULL,NULL,NULL),(1218,62,NULL,1232,NULL,NULL,NULL,NULL,NULL),(1219,62,NULL,1233,NULL,NULL,NULL,NULL,NULL),(1220,62,NULL,1234,NULL,NULL,NULL,NULL,NULL),(1221,62,NULL,1235,NULL,NULL,NULL,NULL,NULL),(1222,62,NULL,1236,NULL,NULL,NULL,NULL,NULL),(1223,62,NULL,1237,NULL,NULL,NULL,NULL,NULL),(1224,62,NULL,1238,NULL,NULL,NULL,NULL,NULL),(1225,62,NULL,1239,NULL,NULL,NULL,NULL,NULL),(1226,62,NULL,1240,NULL,NULL,NULL,NULL,NULL),(1227,62,NULL,1241,NULL,NULL,NULL,NULL,NULL),(1228,62,NULL,1242,NULL,NULL,NULL,NULL,NULL),(1229,62,NULL,1243,NULL,NULL,NULL,NULL,NULL),(1230,62,NULL,1244,NULL,NULL,NULL,NULL,NULL),(1231,62,NULL,1245,NULL,NULL,NULL,NULL,NULL),(1232,62,NULL,1246,NULL,NULL,NULL,NULL,NULL),(1233,62,NULL,1247,NULL,NULL,NULL,NULL,NULL),(1234,62,NULL,1248,NULL,NULL,NULL,NULL,NULL),(1235,62,NULL,1249,NULL,NULL,NULL,NULL,NULL),(1236,62,NULL,1250,NULL,NULL,NULL,NULL,NULL),(1237,62,NULL,1251,NULL,NULL,NULL,NULL,NULL),(1238,62,NULL,1252,NULL,NULL,NULL,NULL,NULL),(1239,62,NULL,1253,NULL,NULL,NULL,NULL,NULL),(1240,62,NULL,1254,NULL,NULL,NULL,NULL,NULL),(1241,62,NULL,1255,NULL,NULL,NULL,NULL,NULL),(1242,62,NULL,1256,NULL,NULL,NULL,NULL,NULL),(1243,62,NULL,1257,NULL,NULL,NULL,NULL,NULL),(1244,62,NULL,1258,NULL,NULL,NULL,NULL,NULL),(1245,62,NULL,1259,NULL,NULL,NULL,NULL,NULL),(1246,62,NULL,1260,NULL,NULL,NULL,NULL,NULL),(1247,62,NULL,1261,NULL,NULL,NULL,NULL,NULL),(1248,62,NULL,1262,NULL,NULL,NULL,NULL,NULL),(1249,62,NULL,1263,NULL,NULL,NULL,NULL,NULL),(1250,62,NULL,1264,NULL,NULL,NULL,NULL,NULL),(1251,62,NULL,1265,NULL,NULL,NULL,NULL,NULL),(1252,62,NULL,1266,NULL,NULL,NULL,NULL,NULL),(1253,62,NULL,1267,NULL,NULL,NULL,NULL,NULL),(1254,62,NULL,1268,NULL,NULL,NULL,NULL,NULL),(1255,62,NULL,1269,NULL,NULL,NULL,NULL,NULL),(1256,62,NULL,1270,NULL,NULL,NULL,NULL,NULL),(1257,63,NULL,1271,NULL,NULL,NULL,NULL,NULL),(1258,63,NULL,1272,NULL,NULL,NULL,NULL,NULL),(1259,63,NULL,1273,NULL,NULL,NULL,NULL,NULL),(1260,63,NULL,1274,NULL,NULL,NULL,NULL,NULL),(1261,63,NULL,1275,NULL,NULL,NULL,NULL,NULL),(1262,63,NULL,1276,NULL,NULL,NULL,NULL,NULL),(1263,63,NULL,1277,NULL,NULL,NULL,NULL,NULL),(1264,63,NULL,1278,NULL,NULL,NULL,NULL,NULL),(1265,63,NULL,1279,NULL,NULL,NULL,NULL,NULL),(1266,63,NULL,1280,NULL,NULL,NULL,NULL,NULL),(1267,63,NULL,1281,NULL,NULL,NULL,NULL,NULL),(1268,63,NULL,1282,NULL,NULL,NULL,NULL,NULL),(1269,63,NULL,1283,NULL,NULL,NULL,NULL,NULL),(1270,63,NULL,1284,NULL,NULL,NULL,NULL,NULL),(1271,63,NULL,1285,NULL,NULL,NULL,NULL,NULL),(1272,63,NULL,1286,NULL,NULL,NULL,NULL,NULL),(1273,63,NULL,1287,NULL,NULL,NULL,NULL,NULL),(1274,63,NULL,1288,NULL,NULL,NULL,NULL,NULL),(1275,63,NULL,1289,NULL,NULL,NULL,NULL,NULL),(1276,63,NULL,1290,NULL,NULL,NULL,NULL,NULL),(1277,63,NULL,1291,NULL,NULL,NULL,NULL,NULL),(1278,63,NULL,1292,NULL,NULL,NULL,NULL,NULL),(1279,63,NULL,1293,NULL,NULL,NULL,NULL,NULL),(1280,64,NULL,1294,NULL,NULL,NULL,NULL,NULL),(1281,64,NULL,1295,NULL,NULL,NULL,NULL,NULL),(1282,64,NULL,1296,NULL,NULL,NULL,NULL,NULL),(1283,64,NULL,1297,NULL,NULL,NULL,NULL,NULL),(1284,64,NULL,1298,NULL,NULL,NULL,NULL,NULL),(1285,64,NULL,1299,NULL,NULL,NULL,NULL,NULL),(1286,64,NULL,1300,NULL,NULL,NULL,NULL,NULL),(1287,64,NULL,1301,NULL,NULL,NULL,NULL,NULL),(1288,64,NULL,1302,NULL,NULL,NULL,NULL,NULL),(1289,64,NULL,1303,NULL,NULL,NULL,NULL,NULL),(1290,64,NULL,1304,NULL,NULL,NULL,NULL,NULL),(1291,64,NULL,1305,NULL,NULL,NULL,NULL,NULL),(1292,64,NULL,1306,NULL,NULL,NULL,NULL,NULL),(1293,65,NULL,1307,NULL,NULL,NULL,NULL,NULL),(1294,65,NULL,1308,NULL,NULL,NULL,NULL,NULL),(1295,65,NULL,1309,NULL,NULL,NULL,NULL,NULL),(1296,65,NULL,1310,NULL,NULL,NULL,NULL,NULL),(1297,65,NULL,1311,NULL,NULL,NULL,NULL,NULL),(1298,65,NULL,1312,NULL,NULL,NULL,NULL,NULL),(1299,65,NULL,1313,NULL,NULL,NULL,NULL,NULL),(1300,65,NULL,1314,NULL,NULL,NULL,NULL,NULL),(1301,65,NULL,1315,NULL,NULL,NULL,NULL,NULL),(1302,65,NULL,1316,NULL,NULL,NULL,NULL,NULL),(1303,65,NULL,1317,NULL,NULL,NULL,NULL,NULL),(1304,65,NULL,1318,NULL,NULL,NULL,NULL,NULL),(1305,65,NULL,1319,NULL,NULL,NULL,NULL,NULL),(1306,65,NULL,1320,NULL,NULL,NULL,NULL,NULL),(1307,65,NULL,1321,NULL,NULL,NULL,NULL,NULL),(1308,65,NULL,1322,NULL,NULL,NULL,NULL,NULL),(1309,65,NULL,1323,NULL,NULL,NULL,NULL,NULL),(1310,65,NULL,1324,NULL,NULL,NULL,NULL,NULL),(1311,66,NULL,1325,NULL,NULL,NULL,NULL,NULL),(1312,66,NULL,1326,NULL,NULL,NULL,NULL,NULL),(1313,66,NULL,1327,NULL,NULL,NULL,NULL,NULL),(1314,66,NULL,1328,NULL,NULL,NULL,NULL,NULL),(1315,66,NULL,1329,NULL,NULL,NULL,NULL,NULL),(1316,66,NULL,1330,NULL,NULL,NULL,NULL,NULL),(1317,66,NULL,1331,NULL,NULL,NULL,NULL,NULL),(1318,66,NULL,1332,NULL,NULL,NULL,NULL,NULL),(1319,66,NULL,1333,NULL,NULL,NULL,NULL,NULL),(1320,66,NULL,1334,NULL,NULL,NULL,NULL,NULL),(1321,66,NULL,1335,NULL,NULL,NULL,NULL,NULL),(1322,66,NULL,1336,NULL,NULL,NULL,NULL,NULL),(1323,67,NULL,1337,NULL,NULL,NULL,NULL,NULL),(1324,67,NULL,1338,NULL,NULL,NULL,NULL,NULL),(1325,67,NULL,1339,NULL,NULL,NULL,NULL,NULL),(1326,67,NULL,1340,NULL,NULL,NULL,NULL,NULL),(1327,67,NULL,1341,NULL,NULL,NULL,NULL,NULL),(1328,67,NULL,1342,NULL,NULL,NULL,NULL,NULL),(1329,67,NULL,1343,NULL,NULL,NULL,NULL,NULL),(1330,67,NULL,1344,NULL,NULL,NULL,NULL,NULL),(1331,67,NULL,1345,NULL,NULL,NULL,NULL,NULL),(1332,67,NULL,1346,NULL,NULL,NULL,NULL,NULL),(1333,67,NULL,1347,NULL,NULL,NULL,NULL,NULL),(1334,67,NULL,1348,NULL,NULL,NULL,NULL,NULL);
/*!40000 ALTER TABLE `cash_documents` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cash_documents` with 1333 row(s)
--

--
-- Table structure for table `cash_document_credits`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_document_credits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_id` int(10) unsigned NOT NULL,
  `cash_id_processed` int(10) unsigned DEFAULT NULL,
  `document_id` int(10) unsigned DEFAULT NULL,
  `sale_note_id` int(10) unsigned DEFAULT NULL,
  `status` varchar(15) NOT NULL DEFAULT 'PENDING',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_document_credits_document_id_foreign` (`document_id`),
  KEY `cash_document_credits_sale_note_id_foreign` (`sale_note_id`),
  KEY `cash_document_credits_cash_id_foreign` (`cash_id`),
  CONSTRAINT `cash_document_credits_cash_id_foreign` FOREIGN KEY (`cash_id`) REFERENCES `cash` (`id`),
  CONSTRAINT `cash_document_credits_document_id_foreign` FOREIGN KEY (`document_id`) REFERENCES `documents` (`id`),
  CONSTRAINT `cash_document_credits_sale_note_id_foreign` FOREIGN KEY (`sale_note_id`) REFERENCES `sale_notes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cash_document_credits`
--

LOCK TABLES `cash_document_credits` WRITE;
/*!40000 ALTER TABLE `cash_document_credits` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `cash_document_credits` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cash_document_credits` with 0 row(s)
--

--
-- Table structure for table `cash_transactions`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cash_transactions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `cash_id` int(10) unsigned NOT NULL,
  `payment_method_type_id` char(2) NOT NULL,
  `date` date NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `payment` decimal(14,4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `cash_transactions_cash_id_foreign` (`cash_id`),
  KEY `cash_transactions_payment_method_type_id_foreign` (`payment_method_type_id`),
  CONSTRAINT `cash_transactions_cash_id_foreign` FOREIGN KEY (`cash_id`) REFERENCES `cash` (`id`) ON DELETE CASCADE,
  CONSTRAINT `cash_transactions_payment_method_type_id_foreign` FOREIGN KEY (`payment_method_type_id`) REFERENCES `payment_method_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=71 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cash_transactions`
--

LOCK TABLES `cash_transactions` WRITE;
/*!40000 ALTER TABLE `cash_transactions` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cash_transactions` VALUES (1,1,'01','2025-01-10','Saldo inicial',861.1000),(4,2,'01','2025-01-13','Saldo inicial',1062.2200),(5,3,'01','2025-01-14','Saldo inicial',571.1200),(7,4,'01','2025-01-14','Saldo inicial',1616.2200),(8,5,'01','2025-01-14','Saldo inicial',1616.2200),(9,6,'01','2025-01-14','Saldo inicial',1667.2200),(10,7,'01','2025-01-15','Saldo inicial',286.4000),(11,8,'01','2025-01-15','Saldo inicial',0.0000),(12,9,'01','2025-01-16','Saldo inicial',0.0000),(13,10,'01','2025-01-16','Saldo inicial',0.0000),(14,11,'01','2025-01-17','Saldo inicial',0.0000),(15,12,'01','2025-01-17','Saldo inicial',0.0000),(16,13,'01','2025-01-18','Saldo inicial',0.0000),(17,14,'01','2025-01-19','Saldo inicial',0.0000),(18,15,'01','2025-01-20','Saldo inicial',0.0000),(19,16,'01','2025-01-20','Saldo inicial',0.0000),(20,17,'01','2025-01-21','Saldo inicial',0.0000),(21,18,'01','2025-01-21','Saldo inicial',0.0000),(22,19,'01','2025-01-21','Saldo inicial',0.0000),(23,20,'01','2025-01-22','Saldo inicial',0.0000),(24,21,'01','2025-01-22','Saldo inicial',0.0000),(25,22,'01','2025-01-23','Saldo inicial',0.0000),(26,23,'01','2025-01-23','Saldo inicial',0.0000),(27,24,'01','2025-01-24','Saldo inicial',0.0000),(28,25,'01','2025-01-24','Saldo inicial',0.0000),(29,26,'01','2025-01-25','Saldo inicial',0.0000),(30,27,'01','2025-01-26','Saldo inicial',0.0000),(31,28,'01','2025-01-27','Saldo inicial',0.0000),(32,29,'01','2025-01-27','Saldo inicial',0.0000),(33,30,'01','2025-01-28','Saldo inicial',0.0000),(34,31,'01','2025-01-28','Saldo inicial',0.0000),(35,32,'01','2025-01-29','Saldo inicial',0.0000),(36,33,'01','2025-01-29','Saldo inicial',0.0000),(37,34,'01','2025-01-30','Saldo inicial',0.0000),(38,35,'01','2025-01-30','Saldo inicial',0.0000),(39,36,'01','2025-01-31','Saldo inicial',0.0000),(40,37,'01','2025-01-31','Saldo inicial',0.0000),(41,38,'01','2025-02-01','Saldo inicial',0.0000),(42,39,'01','2025-02-02','Saldo inicial',0.0000),(43,40,'01','2025-02-03','Saldo inicial',0.0000),(44,41,'01','2025-02-03','Saldo inicial',0.0000),(45,42,'01','2025-02-04','Saldo inicial',0.0000),(46,43,'01','2025-02-04','Saldo inicial',0.0000),(47,44,'01','2025-02-05','Saldo inicial',0.0000),(48,45,'01','2025-02-05','Saldo inicial',0.0000),(49,46,'01','2025-02-06','Saldo inicial',0.0000),(50,47,'01','2025-02-06','Saldo inicial',0.0000),(52,49,'01','2025-02-07','Saldo inicial',0.0000),(53,50,'01','2025-02-07','Saldo inicial',0.0000),(54,51,'01','2025-02-08','Saldo inicial',0.0000),(55,52,'01','2025-02-09','Saldo inicial',0.0000),(56,53,'01','2025-02-10','Saldo inicial',158.0000),(57,54,'01','2025-02-10','Saldo inicial',222.0000),(58,55,'01','2025-02-11','Saldo inicial',281.0000),(59,56,'01','2025-02-11','Saldo inicial',337.0000),(60,57,'01','2025-02-12','Saldo inicial',405.2000),(61,58,'01','2025-02-12','Saldo inicial',426.7000),(62,59,'01','2025-02-13','Saldo inicial',510.7000),(63,60,'01','2025-02-13','Saldo inicial',572.9500),(64,61,'01','2025-02-14','Saldo inicial',653.8500),(65,62,'01','2025-02-15','Saldo inicial',0.0000),(66,63,'01','2025-02-16','Saldo inicial',0.0000),(67,64,'01','2025-02-17','Saldo inicial',219.6500),(68,65,'01','2025-02-17','Saldo inicial',253.6500),(69,66,'01','2025-02-18','Saldo inicial',297.6500),(70,67,'01','2025-02-18','Saldo inicial',323.5500);
/*!40000 ALTER TABLE `cash_transactions` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cash_transactions` with 66 row(s)
--

--
-- Table structure for table `categories`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `categories_name_index` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `categories`
--

LOCK TABLES `categories` WRITE;
/*!40000 ALTER TABLE `categories` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `categories` VALUES (1,'Varios','2024-11-10 18:48:20','2024-11-10 18:48:20'),(3,'Helados','2024-11-17 00:13:35','2024-11-17 00:13:50'),(4,'Cosmeticos','2024-11-18 15:29:39','2024-11-18 15:29:39'),(5,'Galenicos','2024-11-18 16:05:34','2024-11-18 16:05:34');
/*!40000 ALTER TABLE `categories` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `categories` with 4 row(s)
--

--
-- Table structure for table `cat_accounting_ledger_code_account`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_accounting_ledger_code_account` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `code_account` varchar(255) NOT NULL COMMENT 'Codigo de plan de cuenta',
  `name` longtext NOT NULL COMMENT 'Nombre de cuenta',
  `disabled` tinyint(3) unsigned DEFAULT 0 COMMENT 'Permite realizar modificaciones',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=41 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_accounting_ledger_code_account`
--

LOCK TABLES `cat_accounting_ledger_code_account` WRITE;
/*!40000 ALTER TABLE `cat_accounting_ledger_code_account` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_accounting_ledger_code_account` VALUES (1,'1','Activos',1,NULL,NULL),(2,'1.1','Activos corrientes',1,NULL,NULL),(3,'1.1.1','Efectivo y equivalentes de efectivo',1,NULL,NULL),(4,'1.1.1.1','Caja',1,NULL,NULL),(5,'1.1.1.2','Bancos',1,NULL,NULL),(6,'1.1.2','Deudores comerciales y otras cuentas por cobrar',1,NULL,NULL),(7,'1.1.2.0','Activos por impuestos corrientes',1,NULL,NULL),(8,'1.1.2.1','Otras cuentas por cobrar',1,NULL,NULL),(9,'1.1.3','Inventarios',1,NULL,NULL),(10,'1.1.4','Inversiones a corto plazo',1,NULL,NULL),(11,'1.1.5','Otros activos corrientes',1,NULL,NULL),(12,'1.2','Activos no corrientes',1,NULL,NULL),(13,'1.2.1','Propiedad, planta y equipo (Activos fijos)',1,NULL,NULL),(14,'1.2.2','Otros Activos no corrientes',1,NULL,NULL),(15,'2','Pasivos',1,NULL,NULL),(16,'2.1','Pasivos corrientes',1,NULL,NULL),(17,'2.1.1','Cuentas por pagar',1,NULL,NULL),(18,'2.1.1.1','Otras cuentas por pagar',1,NULL,NULL),(19,'2.1.2','Provisiones',1,NULL,NULL),(20,'2.1.3','Obligaciones laborales y de seguridad social',1,NULL,NULL),(21,'2.1.4','Pasivos por impuestos corrientes',1,NULL,NULL),(22,'2.1.4.1','Impuestos por pagar',1,NULL,NULL),(23,'2.1.4.2','Retenciones por pagar',1,NULL,NULL),(24,'2.1.5','Cuentas por pagar con costo financiero',1,NULL,NULL),(25,'2.1.6','Obligaciones financieras',1,NULL,NULL),(26,'2.1.6.1','Tarjetas de crédito',1,NULL,NULL),(27,'2.1.7','Otros pasivos corrientes',1,NULL,NULL),(28,'2.2','Pasivos no corrientes',1,NULL,NULL),(29,'2.2.1','Préstamos a largo plazo',1,NULL,NULL),(30,'2.2.2','Otros pasivos no corrientes',1,NULL,NULL),(31,'3','Patrimonio',1,NULL,NULL),(32,'3.1','Capital social',1,NULL,NULL),(33,'3.2','Ganancias acumuladas',1,NULL,NULL),(34,'3.3','Ajustes por saldos iniciales',1,NULL,NULL),(35,'3.3.1','Ajustes iniciales en bancos',1,NULL,NULL),(36,'3.3.2','Ajustes iniciales en inventario',1,NULL,NULL),(37,'4','Ingresos',1,NULL,NULL),(38,'4.1','Ingresos de actividades ordinarias',1,NULL,NULL),(39,'4.2','Otros Ingresos',1,NULL,NULL),(40,'4.2.1','Otros ingresos diversos',1,NULL,NULL);
/*!40000 ALTER TABLE `cat_accounting_ledger_code_account` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_accounting_ledger_code_account` with 40 row(s)
--

--
-- Table structure for table `cat_address_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_address_types` (
  `id` varchar(255) NOT NULL,
  `description` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_address_types`
--

LOCK TABLES `cat_address_types` WRITE;
/*!40000 ALTER TABLE `cat_address_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_address_types` VALUES ('01','Punto de venta'),('02','Producción'),('03','Extracción'),('04','Explotación'),('05','Otros');
/*!40000 ALTER TABLE `cat_address_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_address_types` with 5 row(s)
--

--
-- Table structure for table `cat_affectation_igv_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_affectation_igv_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `exportation` tinyint(1) DEFAULT NULL,
  `free` tinyint(1) DEFAULT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_affectation_igv_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_affectation_igv_types`
--

LOCK TABLES `cat_affectation_igv_types` WRITE;
/*!40000 ALTER TABLE `cat_affectation_igv_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_affectation_igv_types` VALUES ('10',1,0,0,'Gravado - Operación Onerosa'),('11',1,0,1,'Gravado – Retiro por premio'),('12',1,0,1,'Gravado – Retiro por donación'),('13',1,0,1,'Gravado – Retiro'),('14',1,0,1,'Gravado – Retiro por publicidad'),('15',1,0,1,'Gravado – Bonificaciones'),('16',1,0,1,'Gravado – Retiro por entrega a trabajadores'),('17',0,0,1,'Gravado – IVAP'),('20',1,0,0,'Exonerado - Operación Onerosa'),('21',1,0,1,'Exonerado – Transferencia Gratuita'),('30',1,0,0,'Inafecto - Operación Onerosa'),('31',1,0,1,'Inafecto – Retiro por Bonificación'),('32',1,0,1,'Inafecto – Retiro'),('33',1,0,1,'Inafecto – Retiro por Muestras Médicas'),('34',1,0,1,'Inafecto - Retiro por Convenio Colectivo'),('35',1,0,1,'Inafecto – Retiro por premio'),('36',1,0,1,'Inafecto - Retiro por publicidad'),('37',1,0,1,'Inafecto - Transferencia gratuita'),('40',1,1,0,'Exportación de bienes o servicios');
/*!40000 ALTER TABLE `cat_affectation_igv_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_affectation_igv_types` with 19 row(s)
--

--
-- Table structure for table `cat_attribute_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_attribute_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_attribute_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_attribute_types`
--

LOCK TABLES `cat_attribute_types` WRITE;
/*!40000 ALTER TABLE `cat_attribute_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_attribute_types` VALUES ('3001',1,'Detracciones: Recursos Hidrobiológicos-Matrícula de la embarcación'),('3002',1,'Detracciones: Recursos Hidrobiológicos-Nombre de la embarcación'),('3003',1,'Detracciones: Recursos Hidrobiológicos-Tipo de especie vendida'),('3004',1,'Detracciones: Recursos Hidrobiológicos-Lugar de descarga'),('3005',1,'Detracciones: Recursos Hidrobiológicos-Fecha de descarga'),('3006',1,'Detracciones: Recursos Hidrobiológicos-Cantidad de especie vendida'),('3050',1,'Transportre Terreste - Número de asiento'),('3051',1,'Transporte Terrestre - Información de manifiesto de pasajeros'),('3052',1,'Transporte Terrestre - Número de documento de identidad del pasajero'),('3053',1,'Transporte Terrestre - Tipo de documento de identidad del pasajero'),('3054',1,'Transporte Terrestre - Nombres y apellidos del pasajero'),('3055',1,'Transporte Terrestre - Ciudad o lugar de destino - Ubigeo'),('3056',1,'Transporte Terrestre - Ciudad o lugar de destino - Dirección detallada'),('3057',1,'Transporte Terrestre - Ciudad o lugar de origen - Ubigeo'),('3058',1,'Transporte Terrestre - Ciudad o lugar de origen - Dirección detallada'),('3059',1,'Transporte Terrestre - Fecha de inicio programado'),('3060',1,'Transporte Terrestre - Hora de inicio programado'),('4000',1,'Beneficio Hospedajes-Paquete turístico: Código de país de emisión del pasaporte'),('4001',1,'Beneficio Hospedajes: Código de país de residencia del sujeto no domiciliado'),('4002',1,'Beneficio Hospedajes: Fecha de ingreso al país'),('4003',1,'Beneficio Hospedajes: Fecha de Ingreso al Establecimiento'),('4004',1,'Beneficio Hospedajes: Fecha de Salida del Establecimiento'),('4005',1,'Beneficio Hospedajes: Número de Días de Permanencia'),('4006',1,'Beneficio Hospedajes: Fecha de Consumo'),('4007',1,'Beneficio Hospedajes-Paquete turístico: Nombres y apellidos del huesped'),('4008',1,'Beneficio Hospedajes-Paquete turístico: Tipo de documento de identidad del huesped'),('4009',1,'Beneficio Hospedajes-Paquete turístico: Número de documento de identidad del huesped'),('4030',1,'Carta Porte Aéreo:  Lugar de origen - Código de ubigeo'),('4031',1,'Carta Porte Aéreo:  Lugar de origen - Dirección detallada'),('4032',1,'Carta Porte Aéreo:  Lugar de destino - Código de ubigeo'),('4033',1,'Carta Porte Aéreo:  Lugar de destino - Dirección detallada'),('4040',1,'BVME transporte ferroviario: Pasajero - Apellidos y Nombres'),('4041',1,'BVME transporte ferroviario: Pasajero - Tipo de documento de identidad'),('4042',1,'BVME transporte ferroviario: Servicio transporte: Ciudad o lugar de origen - Código de ubigeo'),('4043',1,'BVME transporte ferroviario: Servicio transporte: Ciudad o lugar de origen - Dirección detallada'),('4044',1,'BVME transporte ferroviario: Servicio transporte: Ciudad o lugar de destino - Código de ubigeo'),('4045',1,'BVME transporte ferroviario: Servicio transporte: Ciudad o lugar de destino - Dirección detallada'),('4046',1,'BVME transporte ferroviario: Servicio transporte:Número de asiento'),('4047',1,'BVME transporte ferroviario: Servicio transporte: Hora programada de inicio de viaje'),('4048',1,'BVME transporte ferroviario: Servicio transporte: Fecha programada de inicio de viaje'),('4049',1,'BVME transporte ferroviario: Pasajero - Número de documento de identidad'),('4060',1,'Regalía Petrolera: Decreto Supremo de aprobación del contrato'),('4061',1,'Regalía Petrolera: Area de contrato (Lote)'),('4062',1,'Regalía Petrolera: Periodo de pago - Fecha de inicio'),('4063',1,'Regalía Petrolera: Periodo de pago - Fecha de fin'),('4064',1,'Regalía Petrolera: Fecha de Pago'),('5000',1,'Proveedores Estado: Número de Expediente'),('5001',1,'Proveedores Estado: Código de Unidad Ejecutora'),('5002',1,'Proveedores Estado: N° de Proceso de Selección'),('5003',1,'Proveedores Estado: N° de Contrato'),('5010',1,'Numero de Placa'),('5011',1,'Categoria'),('5012',1,'Marca'),('5013',1,'Modelo'),('5014',1,'Color'),('5015',1,'Motor'),('5016',1,'Combustible'),('5017',1,'Form. Rodante'),('5018',1,'VIN'),('5019',1,'Serie/Chasis'),('5020',1,'Año fabricacion'),('5021',1,'Año modelo'),('5022',1,'Version'),('5023',1,'Ejes'),('5024',1,'Asientos'),('5025',1,'Pasajeros'),('5026',1,'Ruedas'),('5027',1,'Carroceria'),('5028',1,'Potencia'),('5029',1,'Cilindros'),('5030',1,'Ciliindrada'),('5031',1,'Peso Bruto'),('5032',1,'Peso Neto'),('5033',1,'Carga Util'),('5034',1,'Longitud'),('5035',1,'Altura'),('5036',1,'Ancho'),('6000',1,'Comercialización de Oro:  Código Unico Concesión Minera'),('6001',1,'Comercialización de Oro:  N° declaración compromiso'),('6002',1,'Comercialización de Oro:  N° Reg. Especial .Comerci. Oro'),('6003',1,'Comercialización de Oro:  N° Resolución que autoriza Planta de Beneficio'),('6004',1,'Comercialización de Oro: Ley Mineral (% concent. oro)'),('7000',1,'Gastos Art. 37 Renta:  Número de Placa'),('7001',1,'Créditos Hipotecarios: Tipo de préstamo'),('7002',1,'Créditos Hipotecarios: Indicador de Primera Vivienda'),('7003',1,'Créditos Hipotecarios: Partida Registral'),('7004',1,'Créditos Hipotecarios: Número de contrato'),('7005',1,'Créditos Hipotecarios: Fecha de otorgamiento del crédito'),('7006',1,'Créditos Hipotecarios: Dirección del predio - Código de ubigeo'),('7007',1,'Créditos Hipotecarios: Dirección del predio - Dirección completa'),('7008',1,'Créditos Hipotecarios: Dirección del predio - Urbanización'),('7009',1,'Créditos Hipotecarios: Dirección del predio - Provincia'),('7010',1,'Créditos Hipotecarios: Dirección del predio - Distrito'),('7011',1,'Créditos Hipotecarios: Dirección del predio - Departamento'),('7020',1,'Partida Arancelaria');
/*!40000 ALTER TABLE `cat_attribute_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_attribute_types` with 95 row(s)
--

--
-- Table structure for table `cat_charge_discount_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_charge_discount_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `base` tinyint(1) NOT NULL,
  `level` enum('item','global') NOT NULL,
  `type` enum('discount','charge') NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_charge_discount_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_charge_discount_types`
--

LOCK TABLES `cat_charge_discount_types` WRITE;
/*!40000 ALTER TABLE `cat_charge_discount_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_charge_discount_types` VALUES ('00',1,1,'item','discount','Descuentos que afectan la base imponible del IGV/IVAP'),('01',1,0,'item','discount','Descuentos que no afectan la base imponible del IGV/IVAP'),('02',1,1,'global','discount','Descuentos globales que afectan la base imponible del IGV/IVAP'),('03',1,0,'global','discount','Descuentos globales que no afectan la base imponible del IGV/IVAP'),('04',0,1,'global','discount','Descuentos globales por anticipos gravados que afectan la base imponible del IGV/IVAP'),('05',0,0,'global','discount','Descuentos globales por anticipos exonerados'),('06',0,0,'global','discount','Descuentos globales por anticipos inafectos'),('45',0,1,'global','charge','FISE'),('46',1,0,'global','charge','Recargo al consumo y/o propinas'),('47',1,1,'item','charge','Cargos que afectan la base imponible del IGV/IVAP'),('48',1,0,'item','charge','Cargos que no afectan la base imponible del IGV/IVAP'),('49',1,1,'global','charge','Cargos globales que afectan la base imponible del IGV/IVAP'),('50',1,0,'global','charge','Cargos globales que no afectan la base imponible del IGV/IVAP'),('51',0,1,'global','charge','Percepción venta interna'),('52',0,1,'global','charge','Percepción a la adquisición de combustible'),('53',0,1,'global','charge','Percepción realizada al agente de percepción con tasa especial'),('62',1,0,'global','discount','Retención del IGV');
/*!40000 ALTER TABLE `cat_charge_discount_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_charge_discount_types` with 17 row(s)
--

--
-- Table structure for table `cat_colors_items`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_colors_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL COMMENT 'Nombre del color',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_colors_items`
--

LOCK TABLES `cat_colors_items` WRITE;
/*!40000 ALTER TABLE `cat_colors_items` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `cat_colors_items` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_colors_items` with 0 row(s)
--

--
-- Table structure for table `cat_currency_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_currency_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `symbol` varchar(255) DEFAULT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_currency_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_currency_types`
--

LOCK TABLES `cat_currency_types` WRITE;
/*!40000 ALTER TABLE `cat_currency_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_currency_types` VALUES ('PEN',1,'S/','Soles'),('USD',1,'$','Dólares Americanos');
/*!40000 ALTER TABLE `cat_currency_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_currency_types` with 2 row(s)
--

--
-- Table structure for table `cat_detraction_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_detraction_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(255) NOT NULL,
  `percentage` decimal(6,2) NOT NULL,
  `operation_type_id` varchar(255) NOT NULL,
  KEY `cat_detraction_types_operation_type_id_foreign` (`operation_type_id`),
  KEY `cat_detraction_types_id_index` (`id`),
  CONSTRAINT `cat_detraction_types_operation_type_id_foreign` FOREIGN KEY (`operation_type_id`) REFERENCES `cat_operation_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_detraction_types`
--

LOCK TABLES `cat_detraction_types` WRITE;
/*!40000 ALTER TABLE `cat_detraction_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_detraction_types` VALUES ('001',1,'Azúcar y melaza de caña',10.00,'1001'),('003',1,'Alcohol etílico',10.00,'1001'),('005',1,'Maíz amarillo duro',4.00,'1001'),('008',1,'Madera',4.00,'1001'),('016',1,'Aceite de pescado',10.00,'1001'),('019',1,'Arrendamiento de bienes',10.00,'1001'),('020',1,'Mantenimiento y reparación de bienes muebles',12.00,'1001'),('022',1,'Otros servicios empresariales',12.00,'1001'),('023',1,'Leche',4.00,'1001'),('025',1,'Fabricación de bienes por encargo',10.00,'1001'),('027',1,'Servicio de transporte de carga',4.00,'1004');
/*!40000 ALTER TABLE `cat_detraction_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_detraction_types` with 11 row(s)
--

--
-- Table structure for table `cat_digemid`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_digemid` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(10) unsigned NOT NULL COMMENT 'Id de la tabla de item',
  `cod_digemid` longtext NOT NULL COMMENT 'Codigo digmid',
  `nom_prod` longtext DEFAULT NULL COMMENT 'Nombre segun digemid',
  `concent` longtext DEFAULT NULL COMMENT 'Dosificacion segun digemid',
  `nom_form_farm` longtext DEFAULT NULL,
  `nom_form_farm_simplif` longtext DEFAULT NULL,
  `presentac` longtext DEFAULT NULL,
  `fracciones` longtext DEFAULT NULL,
  `fec_vcto_reg_sanitario` longtext DEFAULT NULL,
  `num_reg_san` longtext DEFAULT NULL,
  `nom_titular` longtext DEFAULT NULL,
  `prices` longtext DEFAULT NULL,
  `max_prices` int(10) unsigned DEFAULT 0,
  `active` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `last_update` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_digemid`
--

LOCK TABLES `cat_digemid` WRITE;
/*!40000 ALTER TABLE `cat_digemid` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `cat_digemid` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_digemid` with 0 row(s)
--

--
-- Table structure for table `cat_document_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_document_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `short` varchar(255) DEFAULT NULL,
  `description` varchar(255) NOT NULL,
  `is_sunat` tinyint(1) NOT NULL DEFAULT 1,
  KEY `cat_document_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_document_types`
--

LOCK TABLES `cat_document_types` WRITE;
/*!40000 ALTER TABLE `cat_document_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_document_types` VALUES ('01',1,'FT','FACTURA ELECTRÓNICA',1),('03',1,'BV','BOLETA DE VENTA ELECTRÓNICA',1),('07',1,'NC','NOTA DE CRÉDITO',1),('08',1,'ND','NOTA DE DÉBITO',1),('09',1,NULL,'GUIA DE REMISIÓN REMITENTE',1),('20',1,NULL,'COMPROBANTE DE RETENCIÓN ELECTRÓNICA',1),('31',1,NULL,'Guía de remisión transportista',1),('40',1,NULL,'COMPROBANTE DE PERCEPCIÓN ELECTRÓNICA',1),('71',0,NULL,'Guia de remisión remitente complementaria',1),('72',0,NULL,'Guia de remisión transportista complementaria',1),('GU75',1,NULL,'GUÍA',0),('NE76',1,NULL,'NOTA DE ENTRADA',0),('80',1,NULL,'NOTA DE VENTA',0),('02',1,NULL,'RECIBO POR HONORARIOS',1),('14',1,NULL,'SERVICIOS PÚBLICOS',1),('04',1,NULL,'LIQUIDACIÓN DE COMPRA',1),('U2',1,NULL,'Guía de Ingreso Almacén',0),('U3',1,NULL,'Guía de Salida Almacén',0),('U4',1,NULL,'Guía de Transferencia Almacén',0),('U5',1,NULL,'COTIZACIÓN',0),('U6',1,NULL,'PEDIDO',0),('U7',1,NULL,'ORDEN DE COMPRA',0);
/*!40000 ALTER TABLE `cat_document_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_document_types` with 22 row(s)
--

--
-- Table structure for table `cat_identity_document_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_identity_document_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_identity_document_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_identity_document_types`
--

LOCK TABLES `cat_identity_document_types` WRITE;
/*!40000 ALTER TABLE `cat_identity_document_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_identity_document_types` VALUES ('0',1,'Doc.trib.no.dom.sin.ruc'),('1',1,'DNI'),('4',1,'CE'),('6',1,'RUC'),('7',1,'Pasaporte'),('A',0,'Ced. Diplomática de identidad'),('B',0,'Documento identidad país residencia-no.d'),('C',0,'Tax Identification Number - TIN – Doc Trib PP.NN'),('D',0,'Identification Number - IN – Doc Trib PP. JJ'),('E',0,'TAM- Tarjeta Andina de Migración');
/*!40000 ALTER TABLE `cat_identity_document_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_identity_document_types` with 10 row(s)
--

--
-- Table structure for table `cat_item_mold_cavities`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_item_mold_cavities` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL COMMENT 'Nombre de cavidades del molde',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_item_mold_cavities`
--

LOCK TABLES `cat_item_mold_cavities` WRITE;
/*!40000 ALTER TABLE `cat_item_mold_cavities` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `cat_item_mold_cavities` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_item_mold_cavities` with 0 row(s)
--

--
-- Table structure for table `cat_item_mold_properties`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_item_mold_properties` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL COMMENT 'Nombre de propiedades por molde',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_item_mold_properties`
--

LOCK TABLES `cat_item_mold_properties` WRITE;
/*!40000 ALTER TABLE `cat_item_mold_properties` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `cat_item_mold_properties` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_item_mold_properties` with 0 row(s)
--

--
-- Table structure for table `cat_item_package_measurements`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_item_package_measurements` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL COMMENT 'Nombre de medidas del paquete',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_item_package_measurements`
--

LOCK TABLES `cat_item_package_measurements` WRITE;
/*!40000 ALTER TABLE `cat_item_package_measurements` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `cat_item_package_measurements` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_item_package_measurements` with 0 row(s)
--

--
-- Table structure for table `cat_item_product_family`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_item_product_family` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL COMMENT 'Nombre de familia d eproductos',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_item_product_family`
--

LOCK TABLES `cat_item_product_family` WRITE;
/*!40000 ALTER TABLE `cat_item_product_family` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `cat_item_product_family` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_item_product_family` with 0 row(s)
--

--
-- Table structure for table `cat_item_size`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_item_size` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL COMMENT 'Nombre de unidad de medida',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_item_size`
--

LOCK TABLES `cat_item_size` WRITE;
/*!40000 ALTER TABLE `cat_item_size` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `cat_item_size` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_item_size` with 0 row(s)
--

--
-- Table structure for table `cat_item_status`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_item_status` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL COMMENT 'Nombre del status',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_item_status`
--

LOCK TABLES `cat_item_status` WRITE;
/*!40000 ALTER TABLE `cat_item_status` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `cat_item_status` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_item_status` with 0 row(s)
--

--
-- Table structure for table `cat_item_units_per_package`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_item_units_per_package` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL COMMENT 'Nombre de unidades por paquete',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_item_units_per_package`
--

LOCK TABLES `cat_item_units_per_package` WRITE;
/*!40000 ALTER TABLE `cat_item_units_per_package` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `cat_item_units_per_package` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_item_units_per_package` with 0 row(s)
--

--
-- Table structure for table `cat_item_unit_business`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_item_unit_business` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` longtext NOT NULL COMMENT 'Nombre de unidad de negocio',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_item_unit_business`
--

LOCK TABLES `cat_item_unit_business` WRITE;
/*!40000 ALTER TABLE `cat_item_unit_business` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `cat_item_unit_business` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_item_unit_business` with 0 row(s)
--

--
-- Table structure for table `cat_legend_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_legend_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_legend_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_legend_types`
--

LOCK TABLES `cat_legend_types` WRITE;
/*!40000 ALTER TABLE `cat_legend_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_legend_types` VALUES ('1000',1,'Monto en Letras'),('1002',1,'TRANSFERENCIA GRATUITA DE UN BIEN Y/O SERVICIO PRESTADO GRATUITAMENTE'),('2000',1,'COMPROBANTE DE PERCEPCIÓN'),('2001',1,'BIENES TRANSFERIDOS EN LA AMAZONÍA REGIÓN SELVA PARA SER CONSUMIDOS EN LA MISMA'),('2002',1,'SERVICIOS PRESTADOS EN LA AMAZONÍA  REGIÓN SELVA PARA SER CONSUMIDOS EN LA MISMA'),('2003',1,'CONTRATOS DE CONSTRUCCIÓN EJECUTADOS  EN LA AMAZONÍA REGIÓN SELVA'),('2004',1,'Agencia de Viaje - Paquete turístico'),('2005',1,'Venta realizada por emisor itinerante'),('2006',1,'Operación sujeta a detracción'),('2007',1,'Operación sujeta al IVAP'),('2008',1,'VENTA EXONERADA DEL IGV-ISC-IPM. PROHIBIDA LA VENTA FUERA DE LA ZONA COMERCIAL DE TACNA'),('2009',1,'PRIMERA VENTA DE MERCANCÍA IDENTIFICABLE ENTRE USUARIOS DE LA ZONA COMERCIAL'),('2010',1,'Restitucion Simplificado de Derechos Arancelarios');
/*!40000 ALTER TABLE `cat_legend_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_legend_types` with 13 row(s)
--

--
-- Table structure for table `cat_note_credit_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_note_credit_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_note_credit_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_note_credit_types`
--

LOCK TABLES `cat_note_credit_types` WRITE;
/*!40000 ALTER TABLE `cat_note_credit_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_note_credit_types` VALUES ('01',1,'Anulación de la operación'),('02',1,'Anulación por error en el RUC'),('03',1,'Corrección por error en la descripción'),('04',1,'Descuento global'),('05',1,'Descuento por ítem'),('06',1,'Devolución total'),('07',1,'Devolución por ítem'),('08',1,'Bonificación'),('09',1,'Disminución en el valor'),('10',1,'Otros Conceptos'),('11',1,'Ajustes de operaciones de exportación'),('12',1,'Ajustes afectos al IVAP'),('13',1,'Ajustes – montos y/o fechas de pago');
/*!40000 ALTER TABLE `cat_note_credit_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_note_credit_types` with 13 row(s)
--

--
-- Table structure for table `cat_note_debit_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_note_debit_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_note_debit_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_note_debit_types`
--

LOCK TABLES `cat_note_debit_types` WRITE;
/*!40000 ALTER TABLE `cat_note_debit_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_note_debit_types` VALUES ('01',1,'Intereses por mora'),('02',1,'Aumento en el valor'),('03',1,'Penalidades/ otros conceptos'),('10',1,'Ajustes de operaciones de exportación'),('11',1,'Ajustes afectos al IVAP');
/*!40000 ALTER TABLE `cat_note_debit_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_note_debit_types` with 5 row(s)
--

--
-- Table structure for table `cat_operation_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_operation_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `exportation` tinyint(1) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_operation_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_operation_types`
--

LOCK TABLES `cat_operation_types` WRITE;
/*!40000 ALTER TABLE `cat_operation_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_operation_types` VALUES ('0101',1,0,'Venta interna'),('0112',0,0,'Venta Interna - Sustenta Gastos Deducibles Persona Natural'),('0113',0,0,'Venta Interna - NRUS'),('0200',1,1,'Exportación de Bienes'),('0201',0,1,'Exportación de Servicios – Prestación servicios realizados íntegramente en el país'),('0202',0,1,'Exportación de Servicios – Prestación de servicios de hospedaje No Domiciliado'),('0203',0,1,'Exportación de Servicios – Transporte de navieras'),('0204',0,1,'Exportación de Servicios – Servicios a naves y aeronaves de bandera extranjera'),('0205',0,1,'Exportación de Servicios - Servicios que conformen un Paquete Turístico'),('0206',0,1,'Exportación de Servicios – Servicios complementarios al transporte de carga'),('0207',0,1,'Exportación de Servicios – Suministro de energía eléctrica a favor de sujetos domiciliados en ZED'),('0208',0,1,'Exportación de Servicios – Prestación servicios realizados parcialmente en el extranjero'),('0301',0,0,'Operaciones con Carta de porte aéreo (emitidas en el ámbito nacional)'),('0302',0,0,'Operaciones de Transporte ferroviario de pasajeros'),('0303',0,0,'Operaciones de Pago de regalía petrolera'),('0401',1,0,'Ventas no domiciliados que no califican como exportación'),('1001',1,0,'Operación Sujeta a Detracción'),('1002',0,0,'Operación Sujeta a Detracción- Recursos Hidrobiológicos'),('1003',0,0,'Operación Sujeta a Detracción- Servicios de Transporte Pasajeros'),('1004',1,0,'Operación Sujeta a Detracción- Servicios de Transporte Carga'),('2001',0,0,'Operación Sujeta a Percepción'),('0501',1,0,'Compra interna');
/*!40000 ALTER TABLE `cat_operation_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_operation_types` with 22 row(s)
--

--
-- Table structure for table `cat_other_tax_concept_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_other_tax_concept_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_other_tax_concept_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_other_tax_concept_types`
--

LOCK TABLES `cat_other_tax_concept_types` WRITE;
/*!40000 ALTER TABLE `cat_other_tax_concept_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_other_tax_concept_types` VALUES ('1000',1,'Total valor de venta - operaciones exportadas'),('1001',1,'Total valor de venta - operaciones gravadas'),('1002',1,'Total valor de venta - operaciones inafectas'),('1003',1,'Total valor de venta - operaciones exoneradas'),('1004',1,'Total valor de venta – Operaciones gratuitas'),('1005',1,'Sub total de venta'),('2001',1,'Percepciones'),('2002',1,'Retenciones'),('2003',1,'Detracciones'),('2004',1,'Bonificaciones'),('2005',1,'Total descuentos'),('3001',1,'FISE (Ley 29852) Fondo Inclusión Social Energético');
/*!40000 ALTER TABLE `cat_other_tax_concept_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_other_tax_concept_types` with 12 row(s)
--

--
-- Table structure for table `cat_payment_method_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_payment_method_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_payment_method_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_payment_method_types`
--

LOCK TABLES `cat_payment_method_types` WRITE;
/*!40000 ALTER TABLE `cat_payment_method_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_payment_method_types` VALUES ('001',1,'Depósito en cuenta'),('002',1,'Giro'),('003',1,'Transferencia de fondos'),('004',1,'Orden de pago'),('005',1,'Tarjeta de débito'),('006',1,'Tarjeta de crédito emitida en el país por una empresa del sistema financiero'),('007',1,'Cheques con la cláusula de \"NO NEGOCIABLE\", \"INTRANSFERIBLES\", \"NO A LA ORDEN\" u otra equivalente, a que se refiere el inciso g) del artículo 5° de la ley'),('008',1,'Efectivo, por operaciones en las que no existe obligación de utilizar medio de pago'),('009',1,'Efectivo, en los demás casos'),('010',1,'Medios de pago usados en comercio exterior'),('011',1,'Documentos emitidos por las EDPYMES y las cooperativas de ahorro y crédito no autorizadas a captar depósitos del público'),('012',1,'Tarjeta de crédito emitida en el país o en el exterior por una empresa no perteneciente al sistema financiero, cuyo objeto principal sea la emisión y administración de tarjetas de crédito'),('013',1,'Tarjetas de crédito emitidas en el exterior por empresas bancarias o financieras no domiciliadas'),('101',1,'Transferencias – Comercio exterior'),('102',1,'Cheques bancarios - Comercio exterior'),('103',1,'Orden de pago simple - Comercio exterior'),('104',1,'Orden de pago documentario - Comercio exterior'),('105',1,'Remesa simple - Comercio exterior'),('106',1,'Remesa documentaria - Comercio exterior'),('107',1,'Carta de crédito simple - Comercio exterior'),('108',1,'Carta de crédito documentario - Comercio exterior'),('999',1,'Otros medios de pago'),('10',1,'Yape');
/*!40000 ALTER TABLE `cat_payment_method_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_payment_method_types` with 23 row(s)
--

--
-- Table structure for table `cat_perception_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_perception_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `percentage` decimal(10,2) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_perception_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_perception_types`
--

LOCK TABLES `cat_perception_types` WRITE;
/*!40000 ALTER TABLE `cat_perception_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_perception_types` VALUES ('01',1,2.00,'Percepción Venta Interna'),('02',1,1.00,'Percepción a la adquisición de combustible'),('03',1,0.50,'Percepción realizada al agente de percepción con tasa especial');
/*!40000 ALTER TABLE `cat_perception_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_perception_types` with 3 row(s)
--

--
-- Table structure for table `cat_periods`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_periods` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `period` char(1) NOT NULL COMMENT 'Define si es dia, mes o año - D/M/Y',
  `name` text NOT NULL COMMENT 'Nombre del periodo',
  `active` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Si esta activo',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_periods`
--

LOCK TABLES `cat_periods` WRITE;
/*!40000 ALTER TABLE `cat_periods` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_periods` VALUES (1,'M','Mensual',1,NULL,NULL),(2,'Y','Anual',1,NULL,NULL);
/*!40000 ALTER TABLE `cat_periods` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_periods` with 2 row(s)
--

--
-- Table structure for table `cat_price_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_price_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_price_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_price_types`
--

LOCK TABLES `cat_price_types` WRITE;
/*!40000 ALTER TABLE `cat_price_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_price_types` VALUES ('01',1,'Precio unitario (incluye el IGV)'),('02',1,'Valor referencial unitario en operaciones no onerosas');
/*!40000 ALTER TABLE `cat_price_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_price_types` with 2 row(s)
--

--
-- Table structure for table `cat_related_documents_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_related_documents_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_related_documents_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_related_documents_types`
--

LOCK TABLES `cat_related_documents_types` WRITE;
/*!40000 ALTER TABLE `cat_related_documents_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_related_documents_types` VALUES ('01',1,'Numeración DAM'),('02',1,'Número de orden de entrega'),('03',1,'Número SCOP'),('04',1,'Número de manifiesto de carga'),('05',1,'Número de constancia de detracción'),('06',1,'Otros');
/*!40000 ALTER TABLE `cat_related_documents_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_related_documents_types` with 6 row(s)
--

--
-- Table structure for table `cat_related_tax_document_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_related_tax_document_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_related_tax_document_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_related_tax_document_types`
--

LOCK TABLES `cat_related_tax_document_types` WRITE;
/*!40000 ALTER TABLE `cat_related_tax_document_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_related_tax_document_types` VALUES ('01',1,'Factura – emitida para corregir error en el RUC'),('02',1,'Factura – emitida por anticipos'),('03',1,'Boleta de Venta – emitida por anticipos'),('04',1,'Ticket de Salida - ENAPU'),('05',1,'Código SCOP'),('99',1,'Otros');
/*!40000 ALTER TABLE `cat_related_tax_document_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_related_tax_document_types` with 6 row(s)
--

--
-- Table structure for table `cat_retention_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_retention_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `percentage` decimal(10,2) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_retention_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_retention_types`
--

LOCK TABLES `cat_retention_types` WRITE;
/*!40000 ALTER TABLE `cat_retention_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_retention_types` VALUES ('01',1,3.00,'Tasa 3%'),('02',1,6.00,'Tasa 6%');
/*!40000 ALTER TABLE `cat_retention_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_retention_types` with 2 row(s)
--

--
-- Table structure for table `cat_summary_status_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_summary_status_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_summary_status_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_summary_status_types`
--

LOCK TABLES `cat_summary_status_types` WRITE;
/*!40000 ALTER TABLE `cat_summary_status_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_summary_status_types` VALUES ('1',1,'Adicionar'),('2',1,'Modificar'),('3',1,'Anulado');
/*!40000 ALTER TABLE `cat_summary_status_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_summary_status_types` with 3 row(s)
--

--
-- Table structure for table `cat_system_isc_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_system_isc_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_system_isc_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_system_isc_types`
--

LOCK TABLES `cat_system_isc_types` WRITE;
/*!40000 ALTER TABLE `cat_system_isc_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_system_isc_types` VALUES ('01',1,'Sistema al valor'),('02',1,'Aplicación del Monto Fijo'),('03',1,'Sistema de Precios de Venta al Público');
/*!40000 ALTER TABLE `cat_system_isc_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_system_isc_types` with 3 row(s)
--

--
-- Table structure for table `cat_transfer_reason_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_transfer_reason_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(255) NOT NULL,
  `discount_stock` tinyint(1) DEFAULT 0,
  KEY `cat_transfer_reason_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_transfer_reason_types`
--

LOCK TABLES `cat_transfer_reason_types` WRITE;
/*!40000 ALTER TABLE `cat_transfer_reason_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_transfer_reason_types` VALUES ('01',1,'Venta',0),('02',1,'Compra',0),('04',1,'Traslado entre establecimientos de la misma empresa',0),('08',1,'Importación',0),('09',1,'Exportación',0),('13',1,'Otros no comprendido en ningún código del presente catálogo',0),('14',1,'Venta sujeta a confirmación del comprador',0),('18',1,'Traslado emisor itinerante de comprobantes de pago Aquí no se está considerando el traslado a zona primaria.',0),('19',0,'Traslado a zona primaria',0),('03',1,'Venta con entrega a terceros',0),('05',1,'Consignación',0),('06',1,'Devolución',0),('07',1,'Recojo de bienes transformados',0),('17',1,'Traslado de bienes para transformación',0);
/*!40000 ALTER TABLE `cat_transfer_reason_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_transfer_reason_types` with 14 row(s)
--

--
-- Table structure for table `cat_transport_mode_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_transport_mode_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_transport_mode_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_transport_mode_types`
--

LOCK TABLES `cat_transport_mode_types` WRITE;
/*!40000 ALTER TABLE `cat_transport_mode_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_transport_mode_types` VALUES ('01',1,'Transporte público'),('02',1,'Transporte privado');
/*!40000 ALTER TABLE `cat_transport_mode_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_transport_mode_types` with 2 row(s)
--

--
-- Table structure for table `cat_unit_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `cat_unit_types` (
  `id` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL,
  `symbol` varchar(255) DEFAULT NULL,
  `description` varchar(255) NOT NULL,
  KEY `cat_unit_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `cat_unit_types`
--

LOCK TABLES `cat_unit_types` WRITE;
/*!40000 ALTER TABLE `cat_unit_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `cat_unit_types` VALUES ('ZZ',1,NULL,'Servicio'),('BX',1,NULL,'Caja'),('GLL',1,NULL,'Galones'),('GRM',1,NULL,'Gramos'),('KGM',1,NULL,'Kilos'),('LTR',1,NULL,'Litros'),('MTR',1,NULL,'Metros'),('FOT',1,NULL,'Pies'),('INH',1,NULL,'Pulgadas'),('NIU',1,NULL,'Unidades'),('YRD',1,NULL,'Yardas'),('HUR',1,NULL,'Hora'),('TM',0,NULL,'Toneladas'),('TNE',1,NULL,'Toneladas');
/*!40000 ALTER TABLE `cat_unit_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `cat_unit_types` with 14 row(s)
--

--
-- Table structure for table `charge_padrones`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `charge_padrones` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `state` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `charge_padrones`
--

LOCK TABLES `charge_padrones` WRITE;
/*!40000 ALTER TABLE `charge_padrones` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `charge_padrones` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `charge_padrones` with 0 row(s)
--

--
-- Table structure for table `client_errors`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `client_errors` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `code` varchar(255) NOT NULL,
  `client_error_type_id` varchar(255) NOT NULL,
  `original_message` varchar(255) NOT NULL,
  `user_message` varchar(255) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `client_errors_client_error_type_id_foreign` (`client_error_type_id`),
  KEY `client_errors_code_index` (`code`),
  CONSTRAINT `client_errors_client_error_type_id_foreign` FOREIGN KEY (`client_error_type_id`) REFERENCES `client_error_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=30 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `client_errors`
--

LOCK TABLES `client_errors` WRITE;
/*!40000 ALTER TABLE `client_errors` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `client_errors` VALUES (1,'205','data_entry','parameter cardNumber can not be null/empty','Ingresa el número de tu tarjeta.'),(2,'208','data_entry','parameter cardExpirationMonth can not be null/empty','Elige un mes.'),(3,'209','data_entry','parameter cardExpirationYear can not be null/empty','Elige un año.'),(4,'212','data_entry','parameter docType can not be null/empty','Ingresa tu tipo de documento.'),(5,'213','data_entry','The parameter cardholder.document.subtype can not be null or empty','Ingresa tu documento.'),(6,'214','data_entry','parameter docNumber can not be null/empty','Ingresa tu documento.'),(7,'220','data_entry','parameter cardIssuerId can not be null/empty','Ingresa tu banco.'),(8,'221','data_entry','parameter cardholderName can not be null/empty','Ingresa el nombre y apellido.'),(9,'224','data_entry','parameter securityCode can not be null/empty','Ingresa el código de seguridad.'),(10,'E301','data_entry','invalid parameter cardNumber','Ingresa un número de tarjeta válido.'),(11,'E302','data_entry','invalid parameter securityCode','Revisa el código de seguridad.'),(12,'316','data_entry','invalid parameter cardholderName','Ingresa un nombre válido.'),(13,'322','data_entry','	invalid parameter docType','El tipo de documento es inválido.'),(14,'323','data_entry','invalid parameter cardholder.document.subtype','Revisa tu documento.'),(15,'324','data_entry','invalid parameter docNumber','El documento es inválido.'),(16,'325','data_entry','invalid parameter cardExpirationMonth','El mes es inválido'),(17,'326','data_entry','invalid parameter cardExpirationYear','El año es inválido'),(18,'default','data_entry','Otro código de error','Revisa los datos.'),(19,'106','token_creation','Cannot operate between users from different countries','No puedes realizar pagos a otros países.'),(20,'109','token_creation','Invalid number of shares for this payment_method_id','El medio de pago no procesa pagos en installments cuotas. Elige otra tarjeta u otro medio de pago.'),(21,'126','token_creation','The action requested is not valid for the current payment state','No pudimos procesar tu pago.'),(22,'129','token_creation','Cannot pay this amount with this paymentMethod','El medio de pago no procesa pagos del monto seleccionado. Elige otra tarjeta u otro medio de pago.'),(23,'145','token_creation','Invalid users involved','Una de las partes con la que intentas hacer el pago es de prueba y la otra es usuario real.'),(24,'150','token_creation','The payer_id cannot do payments currently','No puedes realizar pagos.'),(25,'151','token_creation','The payer_id cannot do payments with this payment_method_id','No puedes realizar pagos.'),(26,'160','token_creation','Collector not allowed to operate','No pudimos procesar tu pago.'),(27,'204','token_creation','Unavailable payment_method','El medio de pago no está disponible en este momento. Elige otra tarjeta u otro medio de pago.'),(28,'801','token_creation','Already posted the same request in the last minute','Realizaste un pago similar hace instantes. Intenta de nuevo en unos minutos.'),(29,'default','token_creation','Otro código de error','No pudimos procesar tu pago.');
/*!40000 ALTER TABLE `client_errors` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `client_errors` with 29 row(s)
--

--
-- Table structure for table `client_error_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `client_error_types` (
  `id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `client_error_types`
--

LOCK TABLES `client_error_types` WRITE;
/*!40000 ALTER TABLE `client_error_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `client_error_types` VALUES ('data_entry','Errores de ingreso de datos'),('token_creation','Errores en la creación del token de tarjeta');
/*!40000 ALTER TABLE `client_error_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `client_error_types` with 2 row(s)
--

--
-- Table structure for table `columns_to_reports`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `columns_to_reports` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `report` varchar(255) DEFAULT NULL,
  `columns` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`columns`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `columns_to_reports_user_id_foreign` (`user_id`),
  CONSTRAINT `columns_to_reports_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `columns_to_reports`
--

LOCK TABLES `columns_to_reports` WRITE;
/*!40000 ALTER TABLE `columns_to_reports` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `columns_to_reports` VALUES (1,1,'sale_notes_index','{\"paid\": {\"title\": \"Estado de Pago\", \"visible\": false}, \"region\": {\"title\": \"Region\", \"visible\": false}, \"due_date\": {\"title\": \"Fecha de Vencimiento\", \"visible\": false}, \"total_igv\": {\"title\": \"T.IGV\", \"visible\": false}, \"recurrence\": {\"title\": \"Recurrencia\", \"visible\": false}, \"total_free\": {\"title\": \"T.Gratuito\", \"visible\": false}, \"total_paid\": {\"title\": \"Pagado\", \"visible\": false}, \"seller_name\": {\"title\": \"Vendedor\", \"visible\": false}, \"total_taxed\": {\"title\": \"T.Gravado\", \"visible\": false}, \"type_period\": {\"title\": \"Tipo Periodo\", \"visible\": true}, \"date_payment\": {\"title\": \"Fecha de pago\", \"visible\": false}, \"license_plate\": {\"title\": \"Placa\", \"visible\": true}, \"dispatch_status\": {\"title\": \"Estado de despacho\", \"visible\": false}, \"quantity_period\": {\"title\": \"Cantidad Periodo\", \"visible\": true}, \"total_exonerated\": {\"title\": \"T.Exonerado\", \"visible\": false}, \"total_unaffected\": {\"title\": \"T.Inafecto\", \"visible\": false}, \"total_exportation\": {\"title\": \"T.Exportación\", \"visible\": false}, \"exchange_rate_sale\": {\"title\": \"Tipo de cambio\", \"visible\": false}, \"total_pending_paid\": {\"title\": \"Por pagar\", \"visible\": false}}','2024-11-10 19:37:57','2024-11-10 19:37:57'),(2,1,'client_index','{\"zone\": {\"title\": \"Zona\", \"visible\": false}, \"email\": {\"title\": \"Correo electrónico\", \"visible\": false}, \"seller\": {\"title\": \"Vendedor asignado\", \"visible\": false}, \"website\": {\"title\": \"Sitio Web\", \"visible\": false}, \"district\": {\"title\": \"Distrito\", \"visible\": false}, \"province\": {\"title\": \"Provincia\", \"visible\": false}, \"telephone\": {\"title\": \"Teléfono\", \"visible\": false}, \"department\": {\"title\": \"Departamento\", \"visible\": false}, \"credit_days\": {\"title\": \"Días de crédito\", \"visible\": false}, \"observation\": {\"title\": \"Observacion\", \"visible\": false}, \"person_type\": {\"title\": \"Tipo de cliente\", \"visible\": false}}','2024-11-12 00:43:50','2024-11-12 00:43:50'),(3,2,'sale_notes_index','{\"paid\": {\"title\": \"Estado de Pago\", \"visible\": false}, \"region\": {\"title\": \"Region\", \"visible\": false}, \"due_date\": {\"title\": \"Fecha de Vencimiento\", \"visible\": false}, \"total_igv\": {\"title\": \"T.IGV\", \"visible\": false}, \"recurrence\": {\"title\": \"Recurrencia\", \"visible\": false}, \"total_free\": {\"title\": \"T.Gratuito\", \"visible\": false}, \"total_paid\": {\"title\": \"Pagado\", \"visible\": false}, \"seller_name\": {\"title\": \"Vendedor\", \"visible\": false}, \"total_taxed\": {\"title\": \"T.Gravado\", \"visible\": false}, \"type_period\": {\"title\": \"Tipo Periodo\", \"visible\": true}, \"date_payment\": {\"title\": \"Fecha de pago\", \"visible\": false}, \"license_plate\": {\"title\": \"Placa\", \"visible\": true}, \"dispatch_status\": {\"title\": \"Estado de despacho\", \"visible\": false}, \"quantity_period\": {\"title\": \"Cantidad Periodo\", \"visible\": true}, \"total_exonerated\": {\"title\": \"T.Exonerado\", \"visible\": false}, \"total_unaffected\": {\"title\": \"T.Inafecto\", \"visible\": false}, \"total_exportation\": {\"title\": \"T.Exportación\", \"visible\": false}, \"exchange_rate_sale\": {\"title\": \"Tipo de cambio\", \"visible\": false}, \"total_pending_paid\": {\"title\": \"Por pagar\", \"visible\": false}}','2024-11-12 19:55:24','2024-11-12 19:55:24'),(4,2,'client_index','{\"zone\": {\"title\": \"Zona\", \"visible\": false}, \"email\": {\"title\": \"Correo electrónico\", \"visible\": false}, \"seller\": {\"title\": \"Vendedor asignado\", \"visible\": false}, \"website\": {\"title\": \"Sitio Web\", \"visible\": false}, \"district\": {\"title\": \"Distrito\", \"visible\": false}, \"province\": {\"title\": \"Provincia\", \"visible\": false}, \"telephone\": {\"title\": \"Teléfono\", \"visible\": false}, \"department\": {\"title\": \"Departamento\", \"visible\": false}, \"credit_days\": {\"title\": \"Días de crédito\", \"visible\": false}, \"observation\": {\"title\": \"Observacion\", \"visible\": false}, \"person_type\": {\"title\": \"Tipo de cliente\", \"visible\": false}}','2024-11-12 20:14:37','2024-11-12 20:14:37'),(5,2,'sale_notes_reports_index','{\"region\": {\"title\": \"Region\", \"visible\": false}, \"web_platforms\": {\"title\": \"Plataformas web\", \"visible\": false}}','2024-11-12 20:40:51','2024-11-12 20:40:51'),(6,1,'sale_notes_reports_index','{\"region\": {\"title\": \"Region\", \"visible\": false}, \"web_platforms\": {\"title\": \"Plataformas web\", \"visible\": false}}','2024-11-14 18:52:37','2024-11-14 18:52:37'),(7,1,'document_index','{\"notes\": {\"title\": \"Notas C/D\", \"visible\": false}, \"total\": {\"title\": \"Total\", \"visible\": false}, \"guides\": {\"title\": \"Guias\", \"visible\": false}, \"balance\": {\"title\": \"Saldo\", \"visible\": true}, \"send_it\": {\"title\": \"Correo enviado al destinatario\", \"visible\": false}, \"dispatch\": {\"title\": \"Guía de Remisión\", \"visible\": false}, \"soap_type\": {\"title\": \"Soap\", \"visible\": false}, \"user_name\": {\"title\": \"Usuario\", \"visible\": false}, \"order_note\": {\"title\": \"Pedidos\", \"visible\": false}, \"sales_note\": {\"title\": \"Nota de ventas\", \"visible\": false}, \"total_free\": {\"title\": \"T.Gratuito\", \"visible\": false}, \"date_of_due\": {\"title\": \"F. Vencimiento\", \"visible\": false}, \"date_payment\": {\"title\": \"Fecha de pago\", \"visible\": false}, \"total_charge\": {\"title\": \"T.Cargos\", \"visible\": false}, \"plate_numbers\": {\"title\": \"Placa\", \"visible\": false}, \"purchase_order\": {\"title\": \"Orden de Compra\", \"visible\": false}, \"currency_type_id\": {\"title\": \"Moneda\", \"visible\": false}, \"total_exonerated\": {\"title\": \"T.Exonerado\", \"visible\": false}, \"total_unaffected\": {\"title\": \"T.Inafecto\", \"visible\": false}, \"total_exportation\": {\"title\": \"T.Exportación\", \"visible\": false}, \"exchange_rate_sale\": {\"title\": \"Tipo de cambio\", \"visible\": false}}','2024-11-15 18:10:32','2024-11-15 18:10:32'),(8,3,'document_index','{\"notes\":{\"title\":\"Notas C\\/D\",\"visible\":false},\"total\":{\"title\":\"Total\",\"visible\":false},\"guides\":{\"title\":\"Guias\",\"visible\":false},\"balance\":{\"title\":\"Saldo\",\"visible\":true},\"send_it\":{\"title\":\"Correo enviado al destinatario\",\"visible\":false},\"dispatch\":{\"title\":\"Gu\\u00eda de Remisi\\u00f3n\",\"visible\":false},\"soap_type\":{\"title\":\"Soap\",\"visible\":false},\"user_name\":{\"title\":\"Usuario\",\"visible\":false},\"order_note\":{\"title\":\"Pedidos\",\"visible\":false},\"sales_note\":{\"title\":\"Nota de ventas\",\"visible\":false},\"total_free\":{\"title\":\"T.Gratuito\",\"visible\":false},\"date_of_due\":{\"title\":\"F. Vencimiento\",\"visible\":false},\"date_payment\":{\"title\":\"Fecha de pago\",\"visible\":false},\"total_charge\":{\"title\":\"T.Cargos\",\"visible\":false},\"plate_numbers\":{\"title\":\"Placa\",\"visible\":false},\"purchase_order\":{\"title\":\"Orden de Compra\",\"visible\":false},\"currency_type_id\":{\"title\":\"Moneda\",\"visible\":false},\"total_exonerated\":{\"title\":\"T.Exonerado\",\"visible\":false},\"total_unaffected\":{\"title\":\"T.Inafecto\",\"visible\":false},\"total_exportation\":{\"title\":\"T.Exportaci\\u00f3n\",\"visible\":false},\"exchange_rate_sale\":{\"title\":\"Tipo de cambio\",\"visible\":false}}','2024-11-18 13:24:21','2025-01-14 07:17:01'),(9,2,'document_index','{\"notes\":{\"title\":\"Notas C\\/D\",\"visible\":false},\"total\":{\"title\":\"Total\",\"visible\":false},\"guides\":{\"title\":\"Guias\",\"visible\":false},\"balance\":{\"title\":\"Saldo\",\"visible\":true},\"send_it\":{\"title\":\"Correo enviado al destinatario\",\"visible\":false},\"dispatch\":{\"title\":\"Gu\\u00eda de Remisi\\u00f3n\",\"visible\":false},\"soap_type\":{\"title\":\"Soap\",\"visible\":false},\"user_name\":{\"title\":\"Usuario\",\"visible\":false},\"order_note\":{\"title\":\"Pedidos\",\"visible\":false},\"sales_note\":{\"title\":\"Nota de ventas\",\"visible\":false},\"total_free\":{\"title\":\"T.Gratuito\",\"visible\":false},\"date_of_due\":{\"title\":\"F. Vencimiento\",\"visible\":false},\"date_payment\":{\"title\":\"Fecha de pago\",\"visible\":false},\"total_charge\":{\"title\":\"T.Cargos\",\"visible\":false},\"plate_numbers\":{\"title\":\"Placa\",\"visible\":false},\"purchase_order\":{\"title\":\"Orden de Compra\",\"visible\":false},\"currency_type_id\":{\"title\":\"Moneda\",\"visible\":false},\"total_exonerated\":{\"title\":\"T.Exonerado\",\"visible\":false},\"total_unaffected\":{\"title\":\"T.Inafecto\",\"visible\":false},\"total_exportation\":{\"title\":\"T.Exportaci\\u00f3n\",\"visible\":false},\"exchange_rate_sale\":{\"title\":\"Tipo de cambio\",\"visible\":false}}','2024-11-18 15:01:04','2025-01-20 21:28:30'),(10,3,'client_index','{\"zone\": {\"title\": \"Zona\", \"visible\": false}, \"email\": {\"title\": \"Correo electrónico\", \"visible\": false}, \"seller\": {\"title\": \"Vendedor asignado\", \"visible\": false}, \"website\": {\"title\": \"Sitio Web\", \"visible\": false}, \"district\": {\"title\": \"Distrito\", \"visible\": false}, \"province\": {\"title\": \"Provincia\", \"visible\": false}, \"telephone\": {\"title\": \"Teléfono\", \"visible\": false}, \"department\": {\"title\": \"Departamento\", \"visible\": false}, \"credit_days\": {\"title\": \"Días de crédito\", \"visible\": false}, \"observation\": {\"title\": \"Observacion\", \"visible\": false}, \"person_type\": {\"title\": \"Tipo de cliente\", \"visible\": false}}','2024-11-18 16:10:18','2024-11-18 16:10:18'),(11,3,'documents_report_index','{\"guides\":{\"title\":\"Guias\",\"visible\":false},\"options\":{\"title\":\"Opciones\",\"visible\":false},\"web_platforms\":{\"title\":\"Plataformas web\",\"visible\":false},\"total_isc\":{\"title\":\"Total ISC\",\"visible\":false},\"total_charge\":{\"title\":\"Total Cargos\",\"visible\":false},\"district\":{\"title\":\"Distrito\",\"visible\":false},\"department\":{\"title\":\"Departamento\",\"visible\":false},\"province\":{\"title\":\"Provincia\",\"visible\":false},\"client_direction\":{\"title\":\"Direccion del cliente\",\"visible\":false},\"ruc\":{\"title\":\"Ruc\",\"visible\":false},\"note_sale\":{\"title\":\"Nota de venta\",\"visible\":false},\"date_note\":{\"title\":\"Fecha de N.Venta\",\"visible\":false},\"payment_form\":{\"title\":\"Forma de pago\",\"visible\":false},\"payment_method\":{\"title\":\"Metodo de pago\",\"visible\":false},\"purchase_order\":{\"title\":\"Orden de compra\",\"visible\":true},\"total_exonerated\":{\"title\":\"Total Exonerado\",\"visible\":true},\"total_unaffected\":{\"title\":\"Total Inafecto\",\"visible\":true},\"total_free\":{\"title\":\"Total Gratuito\",\"visible\":true},\"total_taxed\":{\"title\":\"Total Gravado\",\"visible\":true},\"total_igv\":{\"title\":\"Total IGV\",\"visible\":true},\"total\":{\"title\":\"Total\",\"visible\":true},\"user_seller\":{\"title\":\"Usuario\\/Vendedor\",\"visible\":true},\"doc_affect\":{\"title\":\"Doc. Afectado\",\"visible\":true},\"quote\":{\"title\":\"Cotizacion\",\"visible\":true},\"case\":{\"title\":\"Caso\",\"visible\":true},\"items\":{\"title\":\"Productos\",\"visible\":true},\"currency_type_id\":{\"title\":\"Moneda\",\"visible\":true}}','2025-01-10 12:20:47','2025-01-10 12:20:47'),(12,3,'sale_notes_index','{\"due_date\":{\"title\":\"Fecha de Vencimiento\",\"visible\":false},\"exchange_rate_sale\":{\"title\":\"Tipo de cambio\",\"visible\":false},\"total_free\":{\"title\":\"T.Gratuito\",\"visible\":false},\"total_exportation\":{\"title\":\"T.Exportaci\\u00f3n\",\"visible\":false},\"total_unaffected\":{\"title\":\"T.Inafecto\",\"visible\":false},\"total_exonerated\":{\"title\":\"T.Exonerado\",\"visible\":false},\"total_taxed\":{\"title\":\"T.Gravado\",\"visible\":false},\"total_igv\":{\"title\":\"T.IGV\",\"visible\":false},\"paid\":{\"title\":\"Estado de Pago\",\"visible\":false},\"type_period\":{\"title\":\"Tipo Periodo\",\"visible\":true},\"quantity_period\":{\"title\":\"Cantidad Periodo\",\"visible\":true},\"license_plate\":{\"title\":\"Placa\",\"visible\":true},\"total_paid\":{\"title\":\"Pagado\",\"visible\":false},\"total_pending_paid\":{\"title\":\"Por pagar\",\"visible\":false},\"seller_name\":{\"title\":\"Vendedor\",\"visible\":false},\"recurrence\":{\"title\":\"Recurrencia\",\"visible\":false},\"region\":{\"title\":\"Region\",\"visible\":false},\"date_payment\":{\"title\":\"Fecha de pago\",\"visible\":false},\"dispatch_status\":{\"title\":\"Estado de despacho\",\"visible\":false}}','2025-01-10 12:25:10','2025-01-10 12:25:10'),(13,4,'client_index','{\"observation\":{\"title\":\"Observacion\",\"visible\":false},\"zone\":{\"title\":\"Zona\",\"visible\":false},\"website\":{\"title\":\"Sitio Web\",\"visible\":false},\"person_type\":{\"title\":\"Tipo de cliente\",\"visible\":false},\"credit_days\":{\"title\":\"D\\u00edas de cr\\u00e9dito\",\"visible\":false},\"seller\":{\"title\":\"Vendedor asignado\",\"visible\":false},\"email\":{\"title\":\"Correo electr\\u00f3nico\",\"visible\":false},\"telephone\":{\"title\":\"Tel\\u00e9fono\",\"visible\":false},\"department\":{\"title\":\"Departamento\",\"visible\":false},\"province\":{\"title\":\"Provincia\",\"visible\":false},\"district\":{\"title\":\"Distrito\",\"visible\":false}}','2025-01-13 09:55:36','2025-01-13 09:55:36'),(14,4,'document_index','{\"notes\":{\"title\":\"Notas C\\/D\",\"visible\":false},\"dispatch\":{\"title\":\"Gu\\u00eda de Remisi\\u00f3n\",\"visible\":false},\"plate_numbers\":{\"title\":\"Placa\",\"visible\":false},\"user_name\":{\"title\":\"Usuario\",\"visible\":false},\"exchange_rate_sale\":{\"title\":\"Tipo de cambio\",\"visible\":false},\"total_exportation\":{\"title\":\"T.Exportaci\\u00f3n\",\"visible\":false},\"total_free\":{\"title\":\"T.Gratuito\",\"visible\":false},\"total_unaffected\":{\"title\":\"T.Inafecto\",\"visible\":false},\"total_exonerated\":{\"title\":\"T.Exonerado\",\"visible\":false},\"date_of_due\":{\"title\":\"F. Vencimiento\",\"visible\":false},\"guides\":{\"title\":\"Guias\",\"visible\":false},\"sales_note\":{\"title\":\"Nota de ventas\",\"visible\":false},\"order_note\":{\"title\":\"Pedidos\",\"visible\":false},\"send_it\":{\"title\":\"Correo enviado al destinatario\",\"visible\":false},\"total\":{\"title\":\"Total\",\"visible\":false},\"currency_type_id\":{\"title\":\"Moneda\",\"visible\":false},\"purchase_order\":{\"title\":\"Orden de Compra\",\"visible\":false},\"soap_type\":{\"title\":\"Soap\",\"visible\":false},\"balance\":{\"title\":\"Saldo\",\"visible\":true},\"total_charge\":{\"title\":\"T.Cargos\",\"visible\":false},\"date_payment\":{\"title\":\"Fecha de pago\",\"visible\":false}}','2025-01-13 09:55:40','2025-01-13 09:55:40'),(15,4,'sale_notes_index','{\"due_date\":{\"title\":\"Fecha de Vencimiento\",\"visible\":false},\"exchange_rate_sale\":{\"title\":\"Tipo de cambio\",\"visible\":false},\"total_free\":{\"title\":\"T.Gratuito\",\"visible\":false},\"total_exportation\":{\"title\":\"T.Exportaci\\u00f3n\",\"visible\":false},\"total_unaffected\":{\"title\":\"T.Inafecto\",\"visible\":false},\"total_exonerated\":{\"title\":\"T.Exonerado\",\"visible\":false},\"total_taxed\":{\"title\":\"T.Gravado\",\"visible\":false},\"total_igv\":{\"title\":\"T.IGV\",\"visible\":false},\"paid\":{\"title\":\"Estado de Pago\",\"visible\":false},\"type_period\":{\"title\":\"Tipo Periodo\",\"visible\":true},\"quantity_period\":{\"title\":\"Cantidad Periodo\",\"visible\":true},\"license_plate\":{\"title\":\"Placa\",\"visible\":true},\"total_paid\":{\"title\":\"Pagado\",\"visible\":false},\"total_pending_paid\":{\"title\":\"Por pagar\",\"visible\":false},\"seller_name\":{\"title\":\"Vendedor\",\"visible\":false},\"recurrence\":{\"title\":\"Recurrencia\",\"visible\":false},\"region\":{\"title\":\"Region\",\"visible\":false},\"date_payment\":{\"title\":\"Fecha de pago\",\"visible\":false},\"dispatch_status\":{\"title\":\"Estado de despacho\",\"visible\":false}}','2025-01-13 09:55:45','2025-01-13 09:55:45');
/*!40000 ALTER TABLE `columns_to_reports` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `columns_to_reports` with 15 row(s)
--

--
-- Table structure for table `companies`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `companies` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `identity_document_type_id` varchar(255) NOT NULL,
  `number` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `trade_name` varchar(255) DEFAULT NULL,
  `soap_send_id` char(2) NOT NULL DEFAULT '01',
  `soap_type_id` char(2) NOT NULL,
  `soap_username` varchar(255) DEFAULT NULL,
  `soap_password` varchar(255) DEFAULT NULL,
  `soap_url` varchar(255) DEFAULT NULL,
  `certificate` varchar(255) DEFAULT NULL,
  `certificate_due` date DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `detraction_account` varchar(255) DEFAULT NULL,
  `app_logo` varchar(255) DEFAULT NULL,
  `logo_store` varchar(255) DEFAULT NULL,
  `favicon` varchar(150) DEFAULT NULL,
  `img_firm` varchar(255) DEFAULT NULL,
  `operation_amazonia` tinyint(1) NOT NULL DEFAULT 0,
  `integrated_query_client_id` varchar(255) DEFAULT NULL,
  `integrated_query_client_secret` varchar(255) DEFAULT NULL,
  `url_login_pse` varchar(255) DEFAULT NULL,
  `user_pse` varchar(255) DEFAULT NULL,
  `password_pse` varchar(255) DEFAULT NULL,
  `client_id_pse` varchar(255) NOT NULL DEFAULT '8',
  `send_document_to_pse` tinyint(1) NOT NULL DEFAULT 0,
  `url_send_cdr_pse` varchar(255) DEFAULT NULL,
  `url_signature_pse` varchar(255) DEFAULT NULL,
  `ws_api_phone_number_id` varchar(255) DEFAULT NULL,
  `ws_api_token` text DEFAULT NULL,
  `soap_sunat_username` varchar(20) DEFAULT NULL,
  `soap_sunat_password` varchar(20) DEFAULT NULL,
  `api_sunat_id` varchar(36) DEFAULT NULL,
  `api_sunat_secret` varchar(50) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `cod_digemid` text DEFAULT NULL COMMENT 'Codigo de establecimiento DIGEMID',
  PRIMARY KEY (`id`),
  KEY `companies_identity_document_type_id_foreign` (`identity_document_type_id`),
  KEY `companies_soap_type_id_foreign` (`soap_type_id`),
  CONSTRAINT `companies_identity_document_type_id_foreign` FOREIGN KEY (`identity_document_type_id`) REFERENCES `cat_identity_document_types` (`id`),
  CONSTRAINT `companies_soap_type_id_foreign` FOREIGN KEY (`soap_type_id`) REFERENCES `soap_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `companies`
--

LOCK TABLES `companies` WRITE;
/*!40000 ALTER TABLE `companies` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `companies` VALUES (1,'6','10469845511','Botica Multifarma','Botica Multifarma','01','01',NULL,NULL,NULL,NULL,NULL,'logo_10469845511.png',NULL,'app_logo_10469845511.jpg',NULL,NULL,'img_firm_10469845511.jpg',0,NULL,NULL,NULL,NULL,NULL,'8',0,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-18 12:29:19',NULL);
/*!40000 ALTER TABLE `companies` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `companies` with 1 row(s)
--

--
-- Table structure for table `company_accounts`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `company_accounts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `subtotal_pen` varchar(255) NOT NULL,
  `total_pen` varchar(255) NOT NULL,
  `igv_pen` varchar(255) NOT NULL,
  `subtotal_usd` varchar(255) NOT NULL,
  `total_usd` varchar(255) NOT NULL,
  `igv_usd` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `company_accounts`
--

LOCK TABLES `company_accounts` WRITE;
/*!40000 ALTER TABLE `company_accounts` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `company_accounts` VALUES (1,'70111','12121','40111','70111','12122','40111');
/*!40000 ALTER TABLE `company_accounts` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `company_accounts` with 1 row(s)
--

--
-- Table structure for table `configurations`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `configurations` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `send_auto` tinyint(1) NOT NULL,
  `formats` varchar(255) NOT NULL DEFAULT 'default',
  `cron` tinyint(1) NOT NULL DEFAULT 1,
  `stock` tinyint(1) NOT NULL DEFAULT 1,
  `sunat_alternate_server` tinyint(1) NOT NULL DEFAULT 0,
  `limit_documents` bigint(20) NOT NULL DEFAULT 0,
  `limit_users` bigint(20) NOT NULL DEFAULT 10,
  `locked_emission` tinyint(1) NOT NULL DEFAULT 0,
  `restrict_sales_limit` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'habilitar restricción de límite de ventas mensual',
  `locked_create_establishments` tinyint(1) NOT NULL DEFAULT 0,
  `permission_to_edit_cpe` tinyint(1) NOT NULL DEFAULT 0,
  `customer_filter_by_seller` tinyint(1) NOT NULL DEFAULT 0,
  `detraction_amount_rounded_int` tinyint(1) NOT NULL DEFAULT 0,
  `set_address_by_establishment` tinyint(1) NOT NULL DEFAULT 0,
  `plan` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`plan`)),
  `enable_whatsapp` tinyint(1) NOT NULL DEFAULT 1,
  `phone_whatsapp` varchar(255) DEFAULT NULL,
  `apk_url` text DEFAULT NULL,
  `visual` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`visual`)),
  `decimal_quantity` tinyint(4) NOT NULL DEFAULT 2,
  `locked_users` tinyint(1) NOT NULL DEFAULT 0,
  `date_time_start` datetime DEFAULT NULL,
  `quantity_documents` int(11) NOT NULL,
  `quantity_sales_notes` int(11) NOT NULL,
  `locked_tenant` tinyint(1) NOT NULL DEFAULT 0,
  `compact_sidebar` tinyint(1) NOT NULL DEFAULT 0,
  `amount_plastic_bag_taxes` decimal(6,2) NOT NULL DEFAULT 0.10,
  `config_system_env` tinyint(1) NOT NULL DEFAULT 1,
  `colums_grid_item` tinyint(4) DEFAULT 4,
  `options_pos` tinyint(1) NOT NULL DEFAULT 1,
  `edit_name_product` tinyint(1) NOT NULL DEFAULT 1,
  `restrict_receipt_date` tinyint(1) NOT NULL DEFAULT 1,
  `shipping_time_days` int(11) NOT NULL DEFAULT 4,
  `affectation_igv_type_id` varchar(255) NOT NULL DEFAULT '10',
  `global_discount_type_id` varchar(255) NOT NULL DEFAULT '03',
  `include_igv` tinyint(1) DEFAULT NULL,
  `percentage_allowance_charge` decimal(12,2) DEFAULT 0.00,
  `igv_retention_percentage` decimal(8,5) NOT NULL DEFAULT 3.00000,
  `active_allowance_charge` tinyint(1) DEFAULT 0,
  `active_warehouse_prices` tinyint(1) DEFAULT 0,
  `product_only_location` tinyint(1) DEFAULT NULL,
  `terms_condition` text DEFAULT NULL,
  `terms_condition_sale` text DEFAULT NULL,
  `cotizaction_finance` tinyint(1) NOT NULL DEFAULT 1,
  `quotation_allow_seller_generate_sale` tinyint(1) NOT NULL DEFAULT 0,
  `allow_edit_unit_price_to_seller` tinyint(1) NOT NULL DEFAULT 0,
  `legend_footer` tinyint(1) NOT NULL DEFAULT 0,
  `header_image` varchar(255) DEFAULT NULL,
  `destination_sale` tinyint(1) NOT NULL DEFAULT 1,
  `default_document_type_03` tinyint(1) NOT NULL DEFAULT 1,
  `default_document_type_80` tinyint(1) NOT NULL DEFAULT 0,
  `search_item_by_barcode` tinyint(1) NOT NULL DEFAULT 0,
  `login` text DEFAULT NULL,
  `navbar` varchar(15) NOT NULL DEFAULT 'fixed',
  `finances` text DEFAULT NULL,
  `smtp_encryption` text DEFAULT NULL COMMENT 'Tipo de cifrado de correo',
  `smtp_password` text DEFAULT NULL COMMENT 'contraseña de usuario para el envio de correo',
  `smtp_user` text DEFAULT NULL COMMENT 'Nombre de usuario para el envio de correo',
  `smtp_port` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Puerto de correo del cliente',
  `smtp_host` text DEFAULT NULL COMMENT 'Host de correo del cliente',
  `ticket_58` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `url_apiruc` text DEFAULT NULL,
  `token_apiruc` text DEFAULT NULL,
  `seller_can_create_product` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Define si los vendedores pueden crear productos',
  `seller_can_view_balance` tinyint(1) NOT NULL DEFAULT 1 COMMENT 'Define si los vendedores pueden ver el balance en finanzas',
  `seller_can_generate_sale_opportunities` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Define si los vendedores pueden crear productos',
  `update_document_on_dispaches` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Si esta activo, al momento de crear una guia, se actualiza el pdf de documentos.',
  `is_pharmacy` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Establece si se activa el modulo de farmacia',
  `auto_send_dispatchs_to_sunat` tinyint(4) DEFAULT 1 COMMENT 'define si se mandan las guias automaticamente a sunat',
  `send_data_to_other_server` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Habilita la posibilidad de enviar datos a otro servidor',
  `search_item_by_series` tinyint(1) NOT NULL DEFAULT 0,
  `mi_tienda_pe` tinyint(1) NOT NULL DEFAULT 0,
  `group_items_generate_document` tinyint(1) NOT NULL DEFAULT 1,
  `change_free_affectation_igv` tinyint(1) NOT NULL DEFAULT 0,
  `currency_type_id` varchar(255) DEFAULT 'PEN' COMMENT 'Id de cat_currency_types_id',
  `select_available_price_list` tinyint(1) NOT NULL DEFAULT 0,
  `show_extra_info_to_item` tinyint(3) unsigned DEFAULT 0 COMMENT 'Habilita datos extra para item',
  `enabled_global_igv_to_purchase` tinyint(3) unsigned DEFAULT 0 COMMENT 'Habilita el igv global en la compra. Sobreescribe has_igv del item',
  `show_pdf_name` tinyint(3) unsigned DEFAULT 0 COMMENT 'Muestra el nombre de pdf en vez del producto',
  `dispatches_address_text` tinyint(3) unsigned DEFAULT 0 COMMENT 'En guias, habilita colocar la direccion de destino como texto',
  `show_items_only_user_stablishment` int(10) unsigned DEFAULT 1 COMMENT 'permite mostrar stock del alamcen de usuario',
  `name_product_pdf_to_xml` tinyint(1) NOT NULL DEFAULT 0,
  `item_name_pdf_description` tinyint(4) NOT NULL DEFAULT 0 COMMENT 'Si esta activado, el nombre de pdf será por defecto la descripcion del item',
  `auto_print` tinyint(1) NOT NULL DEFAULT 0,
  `show_service_on_pos` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'Permite listar al inicio, los servicios en pos',
  `pos_cost_price` tinyint(1) NOT NULL DEFAULT 1,
  `pos_history` tinyint(1) NOT NULL DEFAULT 1,
  `show_totals_on_cpe_list` tinyint(1) NOT NULL DEFAULT 0,
  `show_terms_condition_pos` tinyint(1) NOT NULL DEFAULT 0,
  `show_ticket_80` tinyint(1) NOT NULL DEFAULT 1,
  `show_ticket_58` tinyint(1) NOT NULL DEFAULT 0,
  `show_ticket_50` tinyint(1) NOT NULL DEFAULT 0,
  `show_complete_name_pos` tinyint(1) NOT NULL DEFAULT 0,
  `show_last_price_sale` tinyint(1) NOT NULL DEFAULT 0,
  `show_logo_by_establishment` tinyint(1) NOT NULL DEFAULT 0,
  `print_new_line_to_observation` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Añade la posiblidad de colocar salto de linea en observación de pdf',
  `new_validator_pagination` mediumint(8) unsigned DEFAULT 0,
  `validate_purchase_sale_unit_price` tinyint(1) NOT NULL DEFAULT 0,
  `checked_global_igv_to_purchase` tinyint(1) NOT NULL DEFAULT 0,
  `checked_update_purchase_price` tinyint(1) NOT NULL DEFAULT 0,
  `set_global_purchase_currency_items` tinyint(1) NOT NULL DEFAULT 0,
  `set_unit_price_dispatch_related_record` tinyint(1) NOT NULL DEFAULT 0,
  `restrict_voided_send` tinyint(1) NOT NULL DEFAULT 1,
  `shipping_time_days_voided` int(11) NOT NULL DEFAULT 7,
  `enabled_tips_pos` tinyint(1) NOT NULL DEFAULT 0,
  `top_menu_a_id` int(10) unsigned DEFAULT NULL,
  `top_menu_b_id` int(10) unsigned DEFAULT NULL,
  `top_menu_c_id` int(10) unsigned DEFAULT NULL,
  `top_menu_d_id` int(10) unsigned DEFAULT NULL,
  `skin_id` int(10) unsigned NOT NULL DEFAULT 1,
  `legend_forest_to_xml` tinyint(1) NOT NULL DEFAULT 0,
  `change_currency_item` tinyint(1) NOT NULL DEFAULT 0,
  `enabled_advanced_records_search` tinyint(1) NOT NULL DEFAULT 0,
  `change_decimal_quantity_unit_price_pdf` tinyint(1) NOT NULL DEFAULT 0,
  `decimal_quantity_unit_price_pdf` int(11) NOT NULL DEFAULT 2,
  `separate_cash_transactions` tinyint(1) NOT NULL DEFAULT 0,
  `order_cash_income` tinyint(1) NOT NULL DEFAULT 0,
  `generate_order_note_from_quotation` tinyint(1) NOT NULL DEFAULT 0,
  `list_items_by_warehouse` tinyint(1) NOT NULL DEFAULT 0,
  `hide_pdf_view_documents` tinyint(1) NOT NULL DEFAULT 0,
  `ticket_single_shipment` tinyint(1) NOT NULL DEFAULT 0,
  `affect_all_documents` tinyint(1) NOT NULL DEFAULT 0,
  `dashboard_sales` tinyint(1) NOT NULL DEFAULT 1,
  `dashboard_general` tinyint(1) NOT NULL DEFAULT 1,
  `dashboard_clients` tinyint(1) NOT NULL DEFAULT 1,
  `dashboard_products` tinyint(1) NOT NULL DEFAULT 0,
  `restrict_series_selection_seller` tinyint(1) NOT NULL DEFAULT 0,
  `regex_password_user` tinyint(1) NOT NULL DEFAULT 0,
  `enabled_remember_change_password` tinyint(1) NOT NULL DEFAULT 0,
  `quantity_month_remember_change_password` int(11) NOT NULL DEFAULT 1,
  `enabled_point_system` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'sistema por puntos',
  `point_system_sale_amount` decimal(12,2) NOT NULL DEFAULT 1.00 COMMENT 'sistema por puntos',
  `quantity_of_points` decimal(12,2) NOT NULL DEFAULT 1.00 COMMENT 'sistema por puntos',
  `round_points_of_sale` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'sistema por puntos',
  `enable_categories_products_view` tinyint(1) NOT NULL DEFAULT 0,
  `restrict_seller_discount` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'limitar descuento a los vendedores',
  `sellers_discount_limit` decimal(12,2) NOT NULL DEFAULT 0.00 COMMENT 'limitar descuento a los vendedores',
  `enabled_sales_agents` tinyint(1) NOT NULL DEFAULT 0,
  `change_affectation_exonerated_igv` tinyint(1) NOT NULL DEFAULT 0,
  `search_factory_code_items` tinyint(1) NOT NULL DEFAULT 0,
  `show_load_voucher` tinyint(1) NOT NULL DEFAULT 0,
  `register_series_invoice_xml` tinyint(1) NOT NULL DEFAULT 0,
  `enable_discount_by_customer` tinyint(1) NOT NULL DEFAULT 0,
  `enabled_dispatch_ticket_pdf` tinyint(1) NOT NULL DEFAULT 0,
  `show_price_barcode_ticket` tinyint(1) DEFAULT NULL,
  `price_selected_add_product` tinyint(1) NOT NULL DEFAULT 0,
  `pdf_footer_images` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`pdf_footer_images`)),
  `restrict_sale_items_cpe` tinyint(1) NOT NULL DEFAULT 0,
  `show_convert_cpe_pos` tinyint(1) NOT NULL DEFAULT 0,
  `order_node_advanced` tinyint(1) NOT NULL DEFAULT 0,
  `remove_validation_email_establishments` tinyint(1) NOT NULL DEFAULT 0,
  `select_establishment_bank_account` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configurations`
--

LOCK TABLES `configurations` WRITE;
/*!40000 ALTER TABLE `configurations` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `configurations` VALUES (1,0,'default',1,1,0,0,0,0,0,0,1,0,0,0,'{\"id\": 1, \"name\": \"Ilimitado\", \"locked\": 1, \"pricing\": 99, \"created_at\": \"2024-11-09T23:43:33.000000Z\", \"updated_at\": \"2024-11-09T23:43:33.000000Z\", \"limit_users\": 0, \"sales_limit\": 0, \"plan_documents\": {\"0\": 1, \"1\": 2, \"2\": 3, \"3\": 4}, \"limit_documents\": 0, \"sales_unlimited\": true, \"establishments_limit\": 0, \"establishments_unlimited\": true, \"include_sale_notes_sales_limit\": false, \"include_sale_notes_limit_documents\": false}',1,'1',NULL,'{\"bg\":\"white\",\"header\":\"light\",\"navbar\":\"fixed\",\"sidebars\":\"light\",\"sidebar_theme\":\"white\"}',2,0,'2024-11-10 15:18:50',4,7,0,0,0.20,1,4,0,1,1,4,'10','03',0,0.00,3.00000,0,0,1,NULL,NULL,1,0,0,0,NULL,1,0,1,0,'{\"type\":\"image\",\"image\":\"https:\\/\\/farma.sys.apps.org.pe\\/images\\/fondo-5.svg\",\"position_form\":\"right\",\"show_logo_in_form\":false,\"position_logo\":\"top-left\",\"show_socials\":false,\"facebook\":null,\"twitter\":null,\"instagram\":null,\"linkedin\":null}','fixed','{\"apply_arrears\":false,\"arrears_amount\":0}','',NULL,'',0,NULL,0,NULL,'2025-02-07 09:28:41',NULL,NULL,0,0,0,0,1,0,0,0,0,1,0,'PEN',0,1,1,0,0,0,1,0,1,0,0,0,0,0,1,0,0,1,0,0,0,20,1,0,0,0,0,1,7,0,1,15,76,NULL,2,0,0,0,0,2,1,1,0,1,0,0,0,1,1,1,1,0,0,0,1,1,1.00,0.50,0,1,1,15.00,0,0,0,1,0,1,0,NULL,0,NULL,1,0,0,0,0);
/*!40000 ALTER TABLE `configurations` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `configurations` with 1 row(s)
--

--
-- Table structure for table `configuration_ecommerce`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `configuration_ecommerce` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `information_contact_name` varchar(255) NOT NULL,
  `information_contact_email` varchar(255) NOT NULL,
  `information_contact_phone` varchar(255) NOT NULL,
  `information_contact_address` varchar(255) DEFAULT NULL,
  `phone_whatsapp` text DEFAULT NULL,
  `script_paypal` text DEFAULT NULL,
  `logo` varchar(255) DEFAULT NULL,
  `link_youtube` text DEFAULT NULL,
  `link_twitter` text DEFAULT NULL,
  `link_facebook` text DEFAULT NULL,
  `tag_support` text DEFAULT NULL,
  `tag_dollar` text DEFAULT NULL,
  `tag_shipping` text DEFAULT NULL,
  `token_public_culqui` text DEFAULT NULL,
  `token_private_culqui` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configuration_ecommerce`
--

LOCK TABLES `configuration_ecommerce` WRITE;
/*!40000 ALTER TABLE `configuration_ecommerce` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `configuration_ecommerce` VALUES (1,'Admin','admin@mail.com','01 505-5555',NULL,NULL,NULL,'logo_store_10469845511.png',NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-16 23:51:02');
/*!40000 ALTER TABLE `configuration_ecommerce` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `configuration_ecommerce` with 1 row(s)
--

--
-- Table structure for table `configuration_mi_tienda_pe`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `configuration_mi_tienda_pe` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `establishment_id` int(10) unsigned DEFAULT 1,
  `series_order_note_id` int(10) unsigned DEFAULT 0,
  `series_document_ft_id` int(10) unsigned DEFAULT 0,
  `series_document_bt_id` int(10) unsigned DEFAULT 0,
  `user_id` int(10) unsigned DEFAULT 0,
  `payment_destination_id` int(10) unsigned DEFAULT 0,
  `currency_type_id` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `autogenerate` tinyint(3) unsigned DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `configuration_mi_tienda_pe`
--

LOCK TABLES `configuration_mi_tienda_pe` WRITE;
/*!40000 ALTER TABLE `configuration_mi_tienda_pe` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `configuration_mi_tienda_pe` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `configuration_mi_tienda_pe` with 0 row(s)
--

--
-- Table structure for table `contracts`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contracts` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `seller_id` int(10) unsigned DEFAULT NULL,
  `external_id` char(36) NOT NULL,
  `establishment_id` int(10) unsigned NOT NULL,
  `establishment` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`establishment`)),
  `soap_type_id` char(2) NOT NULL,
  `state_type_id` char(2) NOT NULL,
  `prefix` varchar(255) NOT NULL,
  `date_of_issue` date NOT NULL,
  `time_of_issue` time NOT NULL,
  `date_of_due` date DEFAULT NULL,
  `delivery_date` date DEFAULT NULL,
  `customer_id` int(10) unsigned NOT NULL,
  `customer` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`customer`)),
  `shipping_address` text DEFAULT NULL,
  `payment_method_type_id` char(2) DEFAULT NULL,
  `currency_type_id` varchar(255) NOT NULL,
  `exchange_rate_sale` decimal(13,3) NOT NULL,
  `total_prepayment` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_charge` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_discount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_exportation` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_free` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_taxed` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_unaffected` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_exonerated` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_igv` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_base_isc` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_isc` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_base_other_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_other_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_value` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total` decimal(12,2) NOT NULL,
  `charges` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`charges`)),
  `discounts` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`discounts`)),
  `prepayments` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`prepayments`)),
  `guides` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`guides`)),
  `related` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`related`)),
  `perception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`perception`)),
  `detraction` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`detraction`)),
  `legends` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`legends`)),
  `filename` varchar(255) DEFAULT NULL,
  `terms_condition` text DEFAULT NULL,
  `account_number` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `changed` varchar(255) NOT NULL DEFAULT '0',
  `quotation_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contracts_user_id_foreign` (`user_id`),
  KEY `contracts_establishment_id_foreign` (`establishment_id`),
  KEY `contracts_customer_id_foreign` (`customer_id`),
  KEY `contracts_soap_type_id_foreign` (`soap_type_id`),
  KEY `contracts_currency_type_id_foreign` (`currency_type_id`),
  KEY `contracts_payment_method_type_id_foreign` (`payment_method_type_id`),
  KEY `contracts_quotation_id_foreign` (`quotation_id`),
  KEY `contracts_state_type_id_foreign` (`state_type_id`),
  CONSTRAINT `contracts_currency_type_id_foreign` FOREIGN KEY (`currency_type_id`) REFERENCES `cat_currency_types` (`id`),
  CONSTRAINT `contracts_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `contracts_establishment_id_foreign` FOREIGN KEY (`establishment_id`) REFERENCES `establishments` (`id`),
  CONSTRAINT `contracts_payment_method_type_id_foreign` FOREIGN KEY (`payment_method_type_id`) REFERENCES `payment_method_types` (`id`),
  CONSTRAINT `contracts_quotation_id_foreign` FOREIGN KEY (`quotation_id`) REFERENCES `quotations` (`id`),
  CONSTRAINT `contracts_soap_type_id_foreign` FOREIGN KEY (`soap_type_id`) REFERENCES `soap_types` (`id`),
  CONSTRAINT `contracts_state_type_id_foreign` FOREIGN KEY (`state_type_id`) REFERENCES `contract_state_types` (`id`),
  CONSTRAINT `contracts_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contracts`
--

LOCK TABLES `contracts` WRITE;
/*!40000 ALTER TABLE `contracts` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `contracts` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `contracts` with 0 row(s)
--

--
-- Table structure for table `contract_items`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contract_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contract_id` int(10) unsigned NOT NULL,
  `item_id` int(10) unsigned NOT NULL,
  `item` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`item`)),
  `quantity` decimal(12,4) NOT NULL,
  `unit_value` decimal(16,6) NOT NULL,
  `affectation_igv_type_id` varchar(255) NOT NULL,
  `total_base_igv` decimal(12,2) NOT NULL,
  `percentage_igv` decimal(12,2) NOT NULL,
  `total_igv` decimal(12,2) NOT NULL,
  `system_isc_type_id` varchar(255) DEFAULT NULL,
  `total_base_isc` decimal(12,2) NOT NULL DEFAULT 0.00,
  `percentage_isc` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_isc` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_base_other_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `percentage_other_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_other_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_taxes` decimal(12,2) NOT NULL,
  `price_type_id` varchar(255) NOT NULL,
  `unit_price` decimal(16,6) NOT NULL,
  `total_value` decimal(12,2) NOT NULL,
  `total_charge` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_discount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total` decimal(12,2) NOT NULL,
  `attributes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`attributes`)),
  `discounts` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`discounts`)),
  `charges` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`charges`)),
  `name_product_pdf` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_items_contract_id_foreign` (`contract_id`),
  KEY `contract_items_item_id_foreign` (`item_id`),
  KEY `contract_items_affectation_igv_type_id_foreign` (`affectation_igv_type_id`),
  KEY `contract_items_system_isc_type_id_foreign` (`system_isc_type_id`),
  KEY `contract_items_price_type_id_foreign` (`price_type_id`),
  CONSTRAINT `contract_items_affectation_igv_type_id_foreign` FOREIGN KEY (`affectation_igv_type_id`) REFERENCES `cat_affectation_igv_types` (`id`),
  CONSTRAINT `contract_items_contract_id_foreign` FOREIGN KEY (`contract_id`) REFERENCES `contracts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contract_items_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `items` (`id`),
  CONSTRAINT `contract_items_price_type_id_foreign` FOREIGN KEY (`price_type_id`) REFERENCES `cat_price_types` (`id`),
  CONSTRAINT `contract_items_system_isc_type_id_foreign` FOREIGN KEY (`system_isc_type_id`) REFERENCES `cat_system_isc_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contract_items`
--

LOCK TABLES `contract_items` WRITE;
/*!40000 ALTER TABLE `contract_items` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `contract_items` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `contract_items` with 0 row(s)
--

--
-- Table structure for table `contract_payments`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contract_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `contract_id` int(10) unsigned NOT NULL,
  `date_of_payment` date NOT NULL,
  `payment_method_type_id` char(2) NOT NULL,
  `has_card` tinyint(1) NOT NULL DEFAULT 0,
  `card_brand_id` char(2) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `change` decimal(12,2) DEFAULT NULL,
  `payment` decimal(12,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `contract_payments_contract_id_foreign` (`contract_id`),
  KEY `contract_payments_card_brand_id_foreign` (`card_brand_id`),
  KEY `contract_payments_payment_method_type_id_foreign` (`payment_method_type_id`),
  CONSTRAINT `contract_payments_card_brand_id_foreign` FOREIGN KEY (`card_brand_id`) REFERENCES `card_brands` (`id`),
  CONSTRAINT `contract_payments_contract_id_foreign` FOREIGN KEY (`contract_id`) REFERENCES `contracts` (`id`) ON DELETE CASCADE,
  CONSTRAINT `contract_payments_payment_method_type_id_foreign` FOREIGN KEY (`payment_method_type_id`) REFERENCES `payment_method_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contract_payments`
--

LOCK TABLES `contract_payments` WRITE;
/*!40000 ALTER TABLE `contract_payments` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `contract_payments` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `contract_payments` with 0 row(s)
--

--
-- Table structure for table `contract_state_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `contract_state_types` (
  `id` char(2) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `contract_state_types_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `contract_state_types`
--

LOCK TABLES `contract_state_types` WRITE;
/*!40000 ALTER TABLE `contract_state_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `contract_state_types` VALUES ('01','Registrado'),('05','Entregado'),('09','Rechazado');
/*!40000 ALTER TABLE `contract_state_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `contract_state_types` with 3 row(s)
--

--
-- Table structure for table `countries`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `countries` (
  `id` char(2) NOT NULL,
  `description` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  KEY `countries_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `countries`
--

LOCK TABLES `countries` WRITE;
/*!40000 ALTER TABLE `countries` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `countries` VALUES ('AX','AALAND ISLANDS',1),('AF','AFGHANISTAN',1),('AL','ALBANIA',1),('DZ','ALGERIA',1),('AS','AMERICAN SAMOA',1),('AD','ANDORRA',1),('AO','ANGOLA',1),('AI','ANGUILLA',1),('AQ','ANTARCTICA',1),('AG','ANTIGUA AND BARBUDA',1),('AR','ARGENTINA',1),('AM','ARMENIA',1),('AW','ARUBA',1),('AU','AUSTRALIA',1),('AT','AUSTRIA',1),('AZ','AZERBAIJAN',1),('BS','BAHAMAS',1),('BH','BAHRAIN',1),('BD','BANGLADESH',1),('BB','BARBADOS',1),('BY','BELARUS',1),('BE','BELGIUM',1),('BZ','BELIZE',1),('BJ','BENIN',1),('BM','BERMUDA',1),('BT','BHUTAN',1),('BO','BOLIVIA',1),('BA','BOSNIA AND HERZEGOWINA',1),('BW','BOTSWANA',1),('BV','BOUVET ISLAND',1),('BR','BRAZIL',1),('IO','BRITISH INDIAN OCEAN TERRITORY',1),('BN','BRUNEI DARUSSALAM',1),('BG','BULGARIA',1),('BF','BURKINA FASO',1),('BI','BURUNDI',1),('KH','CAMBODIA',1),('CM','CAMEROON',1),('CA','CANADA',1),('CV','CAPE VERDE',1),('KY','CAYMAN ISLANDS',1),('CF','CENTRAL AFRICAN REPUBLIC',1),('TD','CHAD',1),('CL','CHILE',1),('CN','CHINA',1),('CX','CHRISTMAS ISLAND',1),('CC','COCOS (KEELING) ISLANDS',1),('CO','COLOMBIA',1),('KM','COMOROS',1),('CD','CONGO, Democratic Republic of (was Zaire)',1),('CG','CONGO, Republic of',1),('CK','COOK ISLANDS',1),('CR','COSTA RICA',1),('CI','COTE D`IVOIRE',1),('HR','CROATIA (local name: Hrvatska)',1),('CU','CUBA',1),('CY','CYPRUS',1),('CZ','CZECH REPUBLIC',1),('DK','DENMARK',1),('DJ','DJIBOUTI',1),('DM','DOMINICA',1),('DO','DOMINICAN REPUBLIC',1),('EC','ECUADOR',1),('EG','EGYPT',1),('SV','EL SALVADOR',1),('GQ','EQUATORIAL GUINEA',1),('ER','ERITREA',1),('EE','ESTONIA',1),('ET','ETHIOPIA',1),('FK','FALKLAND ISLANDS (MALVINAS)',1),('FO','FAROE ISLANDS',1),('FJ','FIJI',1),('FI','FINLAND',1),('FR','FRANCE',1),('GF','FRENCH GUIANA',1),('PF','FRENCH POLYNESIA',1),('TF','FRENCH SOUTHERN TERRITORIES',1),('GA','GABON',1),('GM','GAMBIA',1),('GE','GEORGIA',1),('DE','GERMANY',1),('GH','GHANA',1),('GI','GIBRALTAR',1),('GR','GREECE',1),('GL','GREENLAND',1),('GD','GRENADA',1),('GP','GUADELOUPE',1),('GU','GUAM',1),('GT','GUATEMALA',1),('GN','GUINEA',1),('GW','GUINEA-BISSAU',1),('GY','GUYANA',1),('HT','HAITI',1),('HM','HEARD AND MC DONALD ISLANDS',1),('HN','HONDURAS',1),('HK','HONG KONG',1),('HU','HUNGARY',1),('IS','ICELAND',1),('IN','INDIA',1),('ID','INDONESIA',1),('IR','IRAN (ISLAMIC REPUBLIC OF)',1),('IQ','IRAQ',1),('IE','IRELAND',1),('IL','ISRAEL',1),('IT','ITALY',1),('JM','JAMAICA',1),('JP','JAPAN',1),('JO','JORDAN',1),('KZ','KAZAKHSTAN',1),('KE','KENYA',1),('KI','KIRIBATI',1),('KP','KOREA, DEMOCRATIC PEOPLE`S REPUBLIC OF',1),('KR','KOREA, REPUBLIC OF',1),('KW','KUWAIT',1),('KG','KYRGYZSTAN',1),('LA','LAO PEOPLE`S DEMOCRATIC REPUBLIC',1),('LV','LATVIA',1),('LB','LEBANON',1),('LS','LESOTHO',1),('LR','LIBERIA',1),('LY','LIBYAN ARAB JAMAHIRIYA',1),('LI','LIECHTENSTEIN',1),('LT','LITHUANIA',1),('LU','LUXEMBOURG',1),('MO','MACAU',1),('MK','MACEDONIA, THE FORMER YUGOSLAV REPUBLIC OF',1),('MG','MADAGASCAR',1),('MW','MALAWI',1),('MY','MALAYSIA',1),('MV','MALDIVES',1),('ML','MALI',1),('MT','MALTA',1),('MH','MARSHALL ISLANDS',1),('MQ','MARTINIQUE',1),('MR','MAURITANIA',1),('MU','MAURITIUS',1),('YT','MAYOTTE',1),('MX','MEXICO',1),('FM','MICRONESIA, FEDERATED STATES OF',1),('MD','MOLDOVA, REPUBLIC OF',1),('MC','MONACO',1),('MN','MONGOLIA',1),('MS','MONTSERRAT',1),('MA','MOROCCO',1),('MZ','MOZAMBIQUE',1),('MM','MYANMAR',1),('NA','NAMIBIA',1),('NR','NAURU',1),('NP','NEPAL',1),('NL','NETHERLANDS',1),('AN','NETHERLANDS ANTILLES',1),('NC','NEW CALEDONIA',1),('NZ','NEW ZEALAND',1),('NI','NICARAGUA',1),('NE','NIGER',1),('NG','NIGERIA',1),('NU','NIUE',1),('NF','NORFOLK ISLAND',1),('MP','NORTHERN MARIANA ISLANDS',1),('NO','NORWAY',1),('OM','OMAN',1),('PK','PAKISTAN',1),('PW','PALAU',1),('PS','PALESTINIAN TERRITORY, Occupied',1),('PA','PANAMA',1),('PG','PAPUA NEW GUINEA',1),('PY','PARAGUAY',1),('PE','PERU',1),('PH','PHILIPPINES',1),('PN','PITCAIRN',1),('PL','POLAND',1),('PT','PORTUGAL',1),('PR','PUERTO RICO',1),('QA','QATAR',1),('RE','REUNION',1),('RO','ROMANIA',1),('RU','RUSSIAN FEDERATION',1),('RW','RWANDA',1),('SH','SAINT HELENA',1),('KN','SAINT KITTS AND NEVIS',1),('LC','SAINT LUCIA',1),('PM','SAINT PIERRE AND MIQUELON',1),('VC','SAINT VINCENT AND THE GRENADINES',1),('WS','SAMOA',1),('SM','SAN MARINO',1),('ST','SAO TOME AND PRINCIPE',1),('SA','SAUDI ARABIA',1),('SN','SENEGAL',1),('CS','SERBIA AND MONTENEGRO',1),('SC','SEYCHELLES',1),('SL','SIERRA LEONE',1),('SG','SINGAPORE',1),('SK','SLOVAKIA',1),('SI','SLOVENIA',1),('SB','SOLOMON ISLANDS',1),('SO','SOMALIA',1),('ZA','SOUTH AFRICA',1),('GS','SOUTH GEORGIA AND THE SOUTH SANDWICH ISLANDS',1),('ES','SPAIN',1),('LK','SRI LANKA',1),('SD','SUDAN',1),('SR','SURINAME',1),('SJ','SVALBARD AND JAN MAYEN ISLANDS',1),('SZ','SWAZILAND',1),('SE','SWEDEN',1),('CH','SWITZERLAND',1),('SY','SYRIAN ARAB REPUBLIC',1),('TW','TAIWAN',1),('TJ','TAJIKISTAN',1),('TZ','TANZANIA, UNITED REPUBLIC OF',1),('TH','THAILAND',1),('TL','TIMOR-LESTE',1),('TG','TOGO',1),('TK','TOKELAU',1),('TO','TONGA',1),('TT','TRINIDAD AND TOBAGO',1),('TN','TUNISIA',1),('TR','TURKEY',1),('TM','TURKMENISTAN',1),('TC','TURKS AND CAICOS ISLANDS',1),('TV','TUVALU',1),('UG','UGANDA',1),('UA','UKRAINE',1),('AE','UNITED ARAB EMIRATES',1),('GB','UNITED KINGDOM',1),('US','UNITED STATES',1),('UM','UNITED STATES MINOR OUTLYING ISLANDS',1),('UY','URUGUAY',1),('UZ','UZBEKISTAN',1),('VU','VANUATU',1),('VA','VATICAN CITY STATE (HOLY SEE)',1),('VE','VENEZUELA',1),('VN','VIET NAM',1),('VG','VIRGIN ISLANDS (BRITISH)',1),('VI','VIRGIN ISLANDS (U.S.)',1),('WF','WALLIS AND FUTUNA ISLANDS',1),('EH','WESTERN SAHARA',1),('YE','YEMEN',1),('ZM','ZAMBIA',1),('ZW','ZIMBABWE',1);
/*!40000 ALTER TABLE `countries` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `countries` with 240 row(s)
--

--
-- Table structure for table `departments`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `departments` (
  `id` char(2) NOT NULL,
  `description` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  KEY `departments_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `departments`
--

LOCK TABLES `departments` WRITE;
/*!40000 ALTER TABLE `departments` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `departments` VALUES ('01','AMAZONAS',1),('02','ANCASH',1),('03','APURIMAC',1),('04','AREQUIPA',1),('05','AYACUCHO',1),('06','CAJAMARCA',1),('07','CALLAO',1),('08','CUSCO',1),('09','HUANCAVELICA',1),('10','HUÁNUCO',1),('11','ICA',1),('12','JUNÍN',1),('13','LA LIBERTAD',1),('14','LAMBAYEQUE',1),('15','LIMA',1),('16','LORETO',1),('17','MADRE DE DIOS',1),('18','MOQUEGUA',1),('19','PASCO',1),('20','PIURA',1),('21','PUNO',1),('22','SAN MARTIN',1),('23','TACNA',1),('24','TUMBES',1),('25','UCAYALI',1);
/*!40000 ALTER TABLE `departments` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `departments` with 25 row(s)
--

--
-- Table structure for table `devolutions`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `devolutions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `external_id` char(36) NOT NULL,
  `establishment_id` int(10) unsigned NOT NULL,
  `soap_type_id` char(2) NOT NULL,
  `state_type_id` char(2) NOT NULL,
  `prefix` char(2) NOT NULL,
  `date_of_issue` date NOT NULL,
  `time_of_issue` time NOT NULL,
  `devolution_reason_id` int(10) unsigned NOT NULL,
  `observation` varchar(500) NOT NULL,
  `filename` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `devolutions_user_id_foreign` (`user_id`),
  KEY `devolutions_establishment_id_foreign` (`establishment_id`),
  KEY `devolutions_devolution_reason_id_foreign` (`devolution_reason_id`),
  KEY `devolutions_soap_type_id_foreign` (`soap_type_id`),
  KEY `devolutions_state_type_id_foreign` (`state_type_id`),
  CONSTRAINT `devolutions_devolution_reason_id_foreign` FOREIGN KEY (`devolution_reason_id`) REFERENCES `devolution_reasons` (`id`),
  CONSTRAINT `devolutions_establishment_id_foreign` FOREIGN KEY (`establishment_id`) REFERENCES `establishments` (`id`),
  CONSTRAINT `devolutions_soap_type_id_foreign` FOREIGN KEY (`soap_type_id`) REFERENCES `soap_types` (`id`),
  CONSTRAINT `devolutions_state_type_id_foreign` FOREIGN KEY (`state_type_id`) REFERENCES `state_types` (`id`),
  CONSTRAINT `devolutions_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `devolutions`
--

LOCK TABLES `devolutions` WRITE;
/*!40000 ALTER TABLE `devolutions` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `devolutions` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `devolutions` with 0 row(s)
--

--
-- Table structure for table `devolution_items`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `devolution_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `devolution_id` int(10) unsigned NOT NULL,
  `item_id` int(10) unsigned NOT NULL,
  `item` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`item`)),
  `quantity` decimal(12,4) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `devolution_items_devolution_id_foreign` (`devolution_id`),
  KEY `devolution_items_item_id_foreign` (`item_id`),
  CONSTRAINT `devolution_items_devolution_id_foreign` FOREIGN KEY (`devolution_id`) REFERENCES `devolutions` (`id`) ON DELETE CASCADE,
  CONSTRAINT `devolution_items_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `items` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `devolution_items`
--

LOCK TABLES `devolution_items` WRITE;
/*!40000 ALTER TABLE `devolution_items` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `devolution_items` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `devolution_items` with 0 row(s)
--

--
-- Table structure for table `devolution_reasons`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `devolution_reasons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `devolution_reasons`
--

LOCK TABLES `devolution_reasons` WRITE;
/*!40000 ALTER TABLE `devolution_reasons` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `devolution_reasons` VALUES (1,'Productos vencidos',NULL,NULL),(2,'Productos dañados',NULL,NULL),(3,'Productos con errores de Fábrica',NULL,NULL);
/*!40000 ALTER TABLE `devolution_reasons` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `devolution_reasons` with 3 row(s)
--

--
-- Table structure for table `dispatchers`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dispatchers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `identity_document_type_id` varchar(255) NOT NULL,
  `number` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `address` varchar(255) NOT NULL,
  `number_mtc` varchar(12) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dispatchers_identity_document_type_id_foreign` (`identity_document_type_id`),
  KEY `dispatchers_number_index` (`number`),
  KEY `dispatchers_name_index` (`name`),
  CONSTRAINT `dispatchers_identity_document_type_id_foreign` FOREIGN KEY (`identity_document_type_id`) REFERENCES `cat_identity_document_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dispatchers`
--

LOCK TABLES `dispatchers` WRITE;
/*!40000 ALTER TABLE `dispatchers` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `dispatchers` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `dispatchers` with 0 row(s)
--

--
-- Table structure for table `dispatches`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dispatches` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `external_id` char(36) NOT NULL,
  `establishment_id` int(10) unsigned NOT NULL,
  `establishment` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`establishment`)),
  `soap_type_id` char(2) NOT NULL,
  `state_type_id` char(2) NOT NULL,
  `ubl_version` varchar(255) NOT NULL,
  `document_type_id` varchar(255) NOT NULL,
  `reference_sale_note_id` int(10) unsigned DEFAULT NULL,
  `reference_document_id` int(10) unsigned DEFAULT NULL,
  `reference_quotation_id` int(10) unsigned DEFAULT NULL,
  `reference_order_form_id` int(10) unsigned DEFAULT NULL,
  `reference_order_note_id` int(10) unsigned DEFAULT NULL,
  `series` char(4) NOT NULL,
  `number` int(11) NOT NULL,
  `date_of_issue` date NOT NULL,
  `time_of_issue` time NOT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `customer` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`customer`)),
  `observations` text DEFAULT NULL,
  `transport_mode_type_id` varchar(255) DEFAULT NULL,
  `transfer_reason_type_id` varchar(255) DEFAULT NULL,
  `transfer_reason_description` varchar(255) DEFAULT NULL,
  `date_of_shipping` date NOT NULL,
  `transshipment_indicator` tinyint(1) NOT NULL,
  `port_code` varchar(255) DEFAULT NULL,
  `unit_type_id` varchar(255) NOT NULL,
  `total_weight` decimal(10,2) NOT NULL,
  `packages_number` int(11) DEFAULT NULL,
  `container_number` int(11) DEFAULT NULL,
  `related` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'Numero de DAM' CHECK (json_valid(`related`)),
  `origin` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`origin`)),
  `delivery` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`delivery`)),
  `dispatcher_id` int(10) unsigned DEFAULT NULL,
  `dispatcher` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`dispatcher`)),
  `driver_id` int(10) unsigned DEFAULT NULL,
  `driver` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`driver`)),
  `order_form_external` varchar(255) DEFAULT NULL,
  `license_plate` varchar(255) DEFAULT NULL,
  `sender_id` int(10) unsigned DEFAULT NULL,
  `sender_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`sender_data`)),
  `sender_address_id` int(10) unsigned DEFAULT NULL,
  `sender_address_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`sender_address_data`)),
  `receiver_id` int(10) unsigned DEFAULT NULL,
  `receiver_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`receiver_data`)),
  `receiver_address_id` int(10) unsigned DEFAULT NULL,
  `receiver_address_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`receiver_address_data`)),
  `transport_id` int(10) unsigned DEFAULT NULL,
  `transport_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`transport_data`)),
  `secondary_license_plates` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`secondary_license_plates`)),
  `legends` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`legends`)),
  `optional` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`optional`)),
  `filename` varchar(255) DEFAULT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `soap_shipping_response` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`soap_shipping_response`)),
  `send_to_pse` tinyint(1) NOT NULL DEFAULT 0,
  `response_signature_pse` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`response_signature_pse`)),
  `response_send_cdr_pse` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`response_send_cdr_pse`)),
  `has_xml` tinyint(1) NOT NULL DEFAULT 0,
  `has_pdf` tinyint(1) NOT NULL DEFAULT 0,
  `has_cdr` tinyint(1) NOT NULL DEFAULT 0,
  `document_id` int(10) unsigned DEFAULT NULL,
  `ticket` varchar(50) DEFAULT NULL,
  `reception_date` varchar(255) DEFAULT NULL,
  `qr_url` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `data_affected_document` longtext DEFAULT NULL,
  `terms_condition` text DEFAULT NULL,
  `additional_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`additional_data`)),
  `origin_address_id` int(10) unsigned DEFAULT NULL,
  `delivery_address_id` int(10) unsigned DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dispatches_user_id_foreign` (`user_id`),
  KEY `dispatches_establishment_id_foreign` (`establishment_id`),
  KEY `dispatches_soap_type_id_foreign` (`soap_type_id`),
  KEY `dispatches_state_type_id_foreign` (`state_type_id`),
  KEY `dispatches_document_type_id_foreign` (`document_type_id`),
  KEY `dispatches_customer_id_foreign` (`customer_id`),
  KEY `dispatches_unit_type_id_foreign` (`unit_type_id`),
  KEY `dispatches_transport_mode_type_id_foreign` (`transport_mode_type_id`),
  KEY `dispatches_transfer_reason_type_id_foreign` (`transfer_reason_type_id`),
  KEY `dispatches_document_id_foreign` (`document_id`),
  KEY `dispatches_dispatcher_id_foreign` (`dispatcher_id`),
  KEY `dispatches_driver_id_foreign` (`driver_id`),
  KEY `dispatches_transport_id_foreign` (`transport_id`),
  KEY `dispatches_sender_id_foreign` (`sender_id`),
  KEY `dispatches_sender_address_id_foreign` (`sender_address_id`),
  KEY `dispatches_receiver_id_foreign` (`receiver_id`),
  KEY `dispatches_receiver_address_id_foreign` (`receiver_address_id`),
  CONSTRAINT `dispatches_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dispatches_dispatcher_id_foreign` FOREIGN KEY (`dispatcher_id`) REFERENCES `dispatchers` (`id`),
  CONSTRAINT `dispatches_document_id_foreign` FOREIGN KEY (`document_id`) REFERENCES `documents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `dispatches_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `cat_document_types` (`id`),
  CONSTRAINT `dispatches_driver_id_foreign` FOREIGN KEY (`driver_id`) REFERENCES `drivers` (`id`),
  CONSTRAINT `dispatches_establishment_id_foreign` FOREIGN KEY (`establishment_id`) REFERENCES `establishments` (`id`),
  CONSTRAINT `dispatches_receiver_address_id_foreign` FOREIGN KEY (`receiver_address_id`) REFERENCES `dispatch_addresses` (`id`),
  CONSTRAINT `dispatches_receiver_id_foreign` FOREIGN KEY (`receiver_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dispatches_sender_address_id_foreign` FOREIGN KEY (`sender_address_id`) REFERENCES `dispatch_addresses` (`id`),
  CONSTRAINT `dispatches_sender_id_foreign` FOREIGN KEY (`sender_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `dispatches_soap_type_id_foreign` FOREIGN KEY (`soap_type_id`) REFERENCES `soap_types` (`id`),
  CONSTRAINT `dispatches_state_type_id_foreign` FOREIGN KEY (`state_type_id`) REFERENCES `state_types` (`id`),
  CONSTRAINT `dispatches_transfer_reason_type_id_foreign` FOREIGN KEY (`transfer_reason_type_id`) REFERENCES `cat_transfer_reason_types` (`id`),
  CONSTRAINT `dispatches_transport_id_foreign` FOREIGN KEY (`transport_id`) REFERENCES `transports` (`id`),
  CONSTRAINT `dispatches_transport_mode_type_id_foreign` FOREIGN KEY (`transport_mode_type_id`) REFERENCES `cat_transport_mode_types` (`id`),
  CONSTRAINT `dispatches_unit_type_id_foreign` FOREIGN KEY (`unit_type_id`) REFERENCES `cat_unit_types` (`id`),
  CONSTRAINT `dispatches_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dispatches`
--

LOCK TABLES `dispatches` WRITE;
/*!40000 ALTER TABLE `dispatches` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `dispatches` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `dispatches` with 0 row(s)
--

--
-- Table structure for table `dispatch_addresses`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dispatch_addresses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(10) unsigned NOT NULL,
  `address` varchar(255) NOT NULL,
  `location_id` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`location_id`)),
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`),
  UNIQUE KEY `dispatch_address_unique` (`person_id`,`address`),
  CONSTRAINT `dispatch_addresses_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dispatch_addresses`
--

LOCK TABLES `dispatch_addresses` WRITE;
/*!40000 ALTER TABLE `dispatch_addresses` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `dispatch_addresses` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `dispatch_addresses` with 0 row(s)
--

--
-- Table structure for table `dispatch_items`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dispatch_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `dispatch_id` int(10) unsigned NOT NULL,
  `item_id` int(10) unsigned NOT NULL,
  `item` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`item`)),
  `quantity` decimal(12,4) NOT NULL,
  `name_product_pdf` longtext DEFAULT NULL,
  `additional_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`additional_data`)),
  PRIMARY KEY (`id`),
  KEY `dispatch_items_dispatch_id_foreign` (`dispatch_id`),
  KEY `dispatch_items_item_id_foreign` (`item_id`),
  CONSTRAINT `dispatch_items_dispatch_id_foreign` FOREIGN KEY (`dispatch_id`) REFERENCES `dispatches` (`id`) ON DELETE CASCADE,
  CONSTRAINT `dispatch_items_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `items` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dispatch_items`
--

LOCK TABLES `dispatch_items` WRITE;
/*!40000 ALTER TABLE `dispatch_items` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `dispatch_items` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `dispatch_items` with 0 row(s)
--

--
-- Table structure for table `dispatch_sale_notes`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `dispatch_sale_notes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `sale_note_id` int(10) unsigned NOT NULL,
  `date_dispatch` date DEFAULT NULL,
  `time_dispatch` time DEFAULT NULL,
  `person_pick` varchar(255) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `person_dispatch` varchar(255) DEFAULT NULL,
  `status` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `dispatch_sale_notes_sale_note_id_foreign` (`sale_note_id`),
  CONSTRAINT `dispatch_sale_notes_sale_note_id_foreign` FOREIGN KEY (`sale_note_id`) REFERENCES `sale_notes` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `dispatch_sale_notes`
--

LOCK TABLES `dispatch_sale_notes` WRITE;
/*!40000 ALTER TABLE `dispatch_sale_notes` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `dispatch_sale_notes` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `dispatch_sale_notes` with 0 row(s)
--

--
-- Table structure for table `districts`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `districts` (
  `id` char(6) NOT NULL,
  `province_id` char(4) NOT NULL,
  `description` varchar(255) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  KEY `districts_province_id_foreign` (`province_id`),
  KEY `districts_id_index` (`id`),
  CONSTRAINT `districts_province_id_foreign` FOREIGN KEY (`province_id`) REFERENCES `provinces` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `districts`
--

LOCK TABLES `districts` WRITE;
/*!40000 ALTER TABLE `districts` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `districts` VALUES ('010101','0101','Chachapoyas',1),('010102','0101','Asunción',1),('010103','0101','Balsas',1),('010104','0101','Cheto',1),('010105','0101','Chiliquin',1),('010106','0101','Chuquibamba',1),('010107','0101','Granada',1),('010108','0101','Huancas',1),('010109','0101','La Jalca',1),('010110','0101','Leimebamba',1),('010111','0101','Levanto',1),('010112','0101','Magdalena',1),('010113','0101','Mariscal Castilla',1),('010114','0101','Molinopampa',1),('010115','0101','Montevideo',1),('010116','0101','Olleros',1),('010117','0101','Quinjalca',1),('010118','0101','San Francisco de Daguas',1),('010119','0101','San Isidro de Maino',1),('010120','0101','Soloco',1),('010121','0101','Sonche',1),('010201','0102','Bagua',1),('010202','0102','Aramango',1),('010203','0102','Copallin',1),('010204','0102','El Parco',1),('010205','0102','Imaza',1),('010206','0102','La Peca',1),('010301','0103','Jumbilla',1),('010302','0103','Chisquilla',1),('010303','0103','Churuja',1),('010304','0103','Corosha',1),('010305','0103','Cuispes',1),('010306','0103','Florida',1),('010307','0103','Jazan',1),('010308','0103','Recta',1),('010309','0103','San Carlos',1),('010310','0103','Shipasbamba',1),('010311','0103','Valera',1),('010312','0103','Yambrasbamba',1),('010401','0104','Nieva',1),('010402','0104','El Cenepa',1),('010403','0104','Río Santiago',1),('010501','0105','Lamud',1),('010502','0105','Camporredondo',1),('010503','0105','Cocabamba',1),('010504','0105','Colcamar',1),('010505','0105','Conila',1),('010506','0105','Inguilpata',1),('010507','0105','Longuita',1),('010508','0105','Lonya Chico',1),('010509','0105','Luya',1),('010510','0105','Luya Viejo',1),('010511','0105','María',1),('010512','0105','Ocalli',1),('010513','0105','Ocumal',1),('010514','0105','Pisuquia',1),('010515','0105','Providencia',1),('010516','0105','San Cristóbal',1),('010517','0105','San Francisco de Yeso',1),('010518','0105','San Jerónimo',1),('010519','0105','San Juan de Lopecancha',1),('010520','0105','Santa Catalina',1),('010521','0105','Santo Tomas',1),('010522','0105','Tingo',1),('010523','0105','Trita',1),('010601','0106','San Nicolás',1),('010602','0106','Chirimoto',1),('010603','0106','Cochamal',1),('010604','0106','Huambo',1),('010605','0106','Limabamba',1),('010606','0106','Longar',1),('010607','0106','Mariscal Benavides',1),('010608','0106','Milpuc',1),('010609','0106','Omia',1),('010610','0106','Santa Rosa',1),('010611','0106','Totora',1),('010612','0106','Vista Alegre',1),('010701','0107','Bagua Grande',1),('010702','0107','Cajaruro',1),('010703','0107','Cumba',1),('010704','0107','El Milagro',1),('010705','0107','Jamalca',1),('010706','0107','Lonya Grande',1),('010707','0107','Yamon',1),('020101','0201','Huaraz',1),('020102','0201','Cochabamba',1),('020103','0201','Colcabamba',1),('020104','0201','Huanchay',1),('020105','0201','Independencia',1),('020106','0201','Jangas',1),('020107','0201','La Libertad',1),('020108','0201','Olleros',1),('020109','0201','Pampas Grande',1),('020110','0201','Pariacoto',1),('020111','0201','Pira',1),('020112','0201','Tarica',1),('020201','0202','Aija',1),('020202','0202','Coris',1),('020203','0202','Huacllan',1),('020204','0202','La Merced',1),('020205','0202','Succha',1),('020301','0203','Llamellin',1),('020302','0203','Aczo',1),('020303','0203','Chaccho',1),('020304','0203','Chingas',1),('020305','0203','Mirgas',1),('020306','0203','San Juan de Rontoy',1),('020401','0204','Chacas',1),('020402','0204','Acochaca',1),('020501','0205','Chiquian',1),('020502','0205','Abelardo Pardo Lezameta',1),('020503','0205','Antonio Raymondi',1),('020504','0205','Aquia',1),('020505','0205','Cajacay',1),('020506','0205','Canis',1),('020507','0205','Colquioc',1),('020508','0205','Huallanca',1),('020509','0205','Huasta',1),('020510','0205','Huayllacayan',1),('020511','0205','La Primavera',1),('020512','0205','Mangas',1),('020513','0205','Pacllon',1),('020514','0205','San Miguel de Corpanqui',1),('020515','0205','Ticllos',1),('020601','0206','Carhuaz',1),('020602','0206','Acopampa',1),('020603','0206','Amashca',1),('020604','0206','Anta',1),('020605','0206','Ataquero',1),('020606','0206','Marcara',1),('020607','0206','Pariahuanca',1),('020608','0206','San Miguel de Aco',1),('020609','0206','Shilla',1),('020610','0206','Tinco',1),('020611','0206','Yungar',1),('020701','0207','San Luis',1),('020702','0207','San Nicolás',1),('020703','0207','Yauya',1),('020801','0208','Casma',1),('020802','0208','Buena Vista Alta',1),('020803','0208','Comandante Noel',1),('020804','0208','Yautan',1),('020901','0209','Corongo',1),('020902','0209','Aco',1),('020903','0209','Bambas',1),('020904','0209','Cusca',1),('020905','0209','La Pampa',1),('020906','0209','Yanac',1),('020907','0209','Yupan',1),('021001','0210','Huari',1),('021002','0210','Anra',1),('021003','0210','Cajay',1),('021004','0210','Chavin de Huantar',1),('021005','0210','Huacachi',1),('021006','0210','Huacchis',1),('021007','0210','Huachis',1),('021008','0210','Huantar',1),('021009','0210','Masin',1),('021010','0210','Paucas',1),('021011','0210','Ponto',1),('021012','0210','Rahuapampa',1),('021013','0210','Rapayan',1),('021014','0210','San Marcos',1),('021015','0210','San Pedro de Chana',1),('021016','0210','Uco',1),('021101','0211','Huarmey',1),('021102','0211','Cochapeti',1),('021103','0211','Culebras',1),('021104','0211','Huayan',1),('021105','0211','Malvas',1),('021201','0212','Caraz',1),('021202','0212','Huallanca',1),('021203','0212','Huata',1),('021204','0212','Huaylas',1),('021205','0212','Mato',1),('021206','0212','Pamparomas',1),('021207','0212','Pueblo Libre',1),('021208','0212','Santa Cruz',1),('021209','0212','Santo Toribio',1),('021210','0212','Yuracmarca',1),('021301','0213','Piscobamba',1),('021302','0213','Casca',1),('021303','0213','Eleazar Guzmán Barron',1),('021304','0213','Fidel Olivas Escudero',1),('021305','0213','Llama',1),('021306','0213','Llumpa',1),('021307','0213','Lucma',1),('021308','0213','Musga',1),('021401','0214','Ocros',1),('021402','0214','Acas',1),('021403','0214','Cajamarquilla',1),('021404','0214','Carhuapampa',1),('021405','0214','Cochas',1),('021406','0214','Congas',1),('021407','0214','Llipa',1),('021408','0214','San Cristóbal de Rajan',1),('021409','0214','San Pedro',1),('021410','0214','Santiago de Chilcas',1),('021501','0215','Cabana',1),('021502','0215','Bolognesi',1),('021503','0215','Conchucos',1),('021504','0215','Huacaschuque',1),('021505','0215','Huandoval',1),('021506','0215','Lacabamba',1),('021507','0215','Llapo',1),('021508','0215','Pallasca',1),('021509','0215','Pampas',1),('021510','0215','Santa Rosa',1),('021511','0215','Tauca',1),('021601','0216','Pomabamba',1),('021602','0216','Huayllan',1),('021603','0216','Parobamba',1),('021604','0216','Quinuabamba',1),('021701','0217','Recuay',1),('021702','0217','Catac',1),('021703','0217','Cotaparaco',1),('021704','0217','Huayllapampa',1),('021705','0217','Llacllin',1),('021706','0217','Marca',1),('021707','0217','Pampas Chico',1),('021708','0217','Pararin',1),('021709','0217','Tapacocha',1),('021710','0217','Ticapampa',1),('021801','0218','Chimbote',1),('021802','0218','Cáceres del Perú',1),('021803','0218','Coishco',1),('021804','0218','Macate',1),('021805','0218','Moro',1),('021806','0218','Nepeña',1),('021807','0218','Samanco',1),('021808','0218','Santa',1),('021809','0218','NUEVO CHIMBOTE',1),('021901','0219','Sihuas',1),('021902','0219','Acobamba',1),('021903','0219','Alfonso Ugarte',1),('021904','0219','Cashapampa',1),('021905','0219','Chingalpo',1),('021906','0219','Huayllabamba',1),('021907','0219','Quiches',1),('021908','0219','Ragash',1),('021909','0219','San Juan',1),('021910','0219','Sicsibamba',1),('022001','0220','Yungay',1),('022002','0220','Cascapara',1),('022003','0220','Mancos',1),('022004','0220','Matacoto',1),('022005','0220','Quillo',1),('022006','0220','Ranrahirca',1),('022007','0220','Shupluy',1),('022008','0220','Yanama',1),('030101','0301','Abancay',1),('030102','0301','Chacoche',1),('030103','0301','Circa',1),('030104','0301','Curahuasi',1),('030105','0301','Huanipaca',1),('030106','0301','Lambrama',1),('030107','0301','Pichirhua',1),('030108','0301','San Pedro de Cachora',1),('030109','0301','Tamburco',1),('030201','0302','Andahuaylas',1),('030202','0302','Andarapa',1),('030203','0302','Chiara',1),('030204','0302','Huancarama',1),('030205','0302','Huancaray',1),('030206','0302','Huayana',1),('030207','0302','Kishuara',1),('030208','0302','Pacobamba',1),('030209','0302','Pacucha',1),('030210','0302','Pampachiri',1),('030211','0302','Pomacocha',1),('030212','0302','San Antonio de Cachi',1),('030213','0302','San Jerónimo',1),('030214','0302','San Miguel de Chaccrampa',1),('030215','0302','Santa María de Chicmo',1),('030216','0302','Talavera',1),('030217','0302','Tumay Huaraca',1),('030218','0302','Turpo',1),('030219','0302','Kaquiabamba',1),('030220','0302','José María Arguedas',1),('030301','0303','Antabamba',1),('030302','0303','El Oro',1),('030303','0303','Huaquirca',1),('030304','0303','Juan Espinoza Medrano',1),('030305','0303','Oropesa',1),('030306','0303','Pachaconas',1),('030307','0303','Sabaino',1),('030401','0304','Chalhuanca',1),('030402','0304','Capaya',1),('030403','0304','Caraybamba',1),('030404','0304','Chapimarca',1),('030405','0304','Colcabamba',1),('030406','0304','Cotaruse',1),('030407','0304','Ihuayllo',1),('030408','0304','Justo Apu Sahuaraura',1),('030409','0304','Lucre',1),('030410','0304','Pocohuanca',1),('030411','0304','San Juan de Chacña',1),('030412','0304','Sañayca',1),('030413','0304','Soraya',1),('030414','0304','Tapairihua',1),('030415','0304','Tintay',1),('030416','0304','Toraya',1),('030417','0304','Yanaca',1),('030501','0305','Tambobamba',1),('030502','0305','Cotabambas',1),('030503','0305','Coyllurqui',1),('030504','0305','Haquira',1),('030505','0305','Mara',1),('030506','0305','Challhuahuacho',1),('030601','0306','Chincheros',1),('030602','0306','Anco_Huallo',1),('030603','0306','Cocharcas',1),('030604','0306','Huaccana',1),('030605','0306','Ocobamba',1),('030606','0306','Ongoy',1),('030607','0306','Uranmarca',1),('030608','0306','Ranracancha',1),('030609','0306','Rocchacc',1),('030610','0306','El Porvenir',1),('030701','0307','Chuquibambilla',1),('030702','0307','Curpahuasi',1),('030703','0307','Gamarra',1),('030704','0307','Huayllati',1),('030705','0307','Mamara',1),('030706','0307','Micaela Bastidas',1),('030707','0307','Pataypampa',1),('030708','0307','Progreso',1),('030709','0307','San Antonio',1),('030710','0307','Santa Rosa',1),('030711','0307','Turpay',1),('030712','0307','Vilcabamba',1),('030713','0307','Virundo',1),('030714','0307','Curasco',1),('040101','0401','Arequipa',1),('040102','0401','Alto Selva Alegre',1),('040103','0401','Cayma',1),('040104','0401','Cerro Colorado',1),('040105','0401','Characato',1),('040106','0401','Chiguata',1),('040107','0401','Jacobo Hunter',1),('040108','0401','La Joya',1),('040109','0401','Mariano Melgar',1),('040110','0401','Miraflores',1),('040111','0401','Mollebaya',1),('040112','0401','Paucarpata',1),('040113','0401','Pocsi',1),('040114','0401','Polobaya',1),('040115','0401','Quequeña',1),('040116','0401','Sabandia',1),('040117','0401','Sachaca',1),('040118','0401','San Juan de Siguas',1),('040119','0401','San Juan de Tarucani',1),('040120','0401','Santa Isabel de Siguas',1),('040121','0401','Santa Rita de Siguas',1),('040122','0401','Socabaya',1),('040123','0401','Tiabaya',1),('040124','0401','Uchumayo',1),('040125','0401','Vitor',1),('040126','0401','Yanahuara',1),('040127','0401','Yarabamba',1),('040128','0401','Yura',1),('040129','0401','José Luis Bustamante Y Rivero',1),('040201','0402','Camaná',1),('040202','0402','José María Quimper',1),('040203','0402','Mariano Nicolás Valcárcel',1),('040204','0402','Mariscal Cáceres',1),('040205','0402','Nicolás de Pierola',1),('040206','0402','Ocoña',1),('040207','0402','Quilca',1),('040208','0402','Samuel Pastor',1),('040301','0403','Caravelí',1),('040302','0403','Acarí',1),('040303','0403','Atico',1),('040304','0403','Atiquipa',1),('040305','0403','Bella Unión',1),('040306','0403','Cahuacho',1),('040307','0403','Chala',1),('040308','0403','Chaparra',1),('040309','0403','Huanuhuanu',1),('040310','0403','Jaqui',1),('040311','0403','Lomas',1),('040312','0403','Quicacha',1),('040313','0403','Yauca',1),('040401','0404','Aplao',1),('040402','0404','Andagua',1),('040403','0404','Ayo',1),('040404','0404','Chachas',1),('040405','0404','Chilcaymarca',1),('040406','0404','Choco',1),('040407','0404','Huancarqui',1),('040408','0404','Machaguay',1),('040409','0404','Orcopampa',1),('040410','0404','Pampacolca',1),('040411','0404','Tipan',1),('040412','0404','Uñon',1),('040413','0404','Uraca',1),('040414','0404','Viraco',1),('040501','0405','Chivay',1),('040502','0405','Achoma',1),('040503','0405','Cabanaconde',1),('040504','0405','Callalli',1),('040505','0405','Caylloma',1),('040506','0405','Coporaque',1),('040507','0405','Huambo',1),('040508','0405','Huanca',1),('040509','0405','Ichupampa',1),('040510','0405','Lari',1),('040511','0405','Lluta',1),('040512','0405','Maca',1),('040513','0405','Madrigal',1),('040514','0405','San Antonio de Chuca',1),('040515','0405','Sibayo',1),('040516','0405','Tapay',1),('040517','0405','Tisco',1),('040518','0405','Tuti',1),('040519','0405','Yanque',1),('040520','0405','Majes',1),('040601','0406','Chuquibamba',1),('040602','0406','Andaray',1),('040603','0406','Cayarani',1),('040604','0406','Chichas',1),('040605','0406','Iray',1),('040606','0406','Río Grande',1),('040607','0406','Salamanca',1),('040608','0406','Yanaquihua',1),('040701','0407','Mollendo',1),('040702','0407','Cocachacra',1),('040703','0407','Dean Valdivia',1),('040704','0407','Islay',1),('040705','0407','Mejia',1),('040706','0407','Punta de Bombón',1),('040801','0408','Cotahuasi',1),('040802','0408','Alca',1),('040803','0408','Charcana',1),('040804','0408','Huaynacotas',1),('040805','0408','Pampamarca',1),('040806','0408','Puyca',1),('040807','0408','Quechualla',1),('040808','0408','Sayla',1),('040809','0408','Tauria',1),('040810','0408','Tomepampa',1),('040811','0408','Toro',1),('050101','0501','Ayacucho',1),('050102','0501','Acocro',1),('050103','0501','Acos Vinchos',1),('050104','0501','Carmen Alto',1),('050105','0501','Chiara',1),('050106','0501','Ocros',1),('050107','0501','Pacaycasa',1),('050108','0501','Quinua',1),('050109','0501','San José de Ticllas',1),('050110','0501','San Juan Bautista',1),('050111','0501','Santiago de Pischa',1),('050112','0501','Socos',1),('050113','0501','Tambillo',1),('050114','0501','Vinchos',1),('050115','0501','Jesús Nazareno',1),('050116','0501','Andrés Avelino Cáceres Dorregaray',1),('050201','0502','Cangallo',1),('050202','0502','Chuschi',1),('050203','0502','Los Morochucos',1),('050204','0502','María Parado de Bellido',1),('050205','0502','Paras',1),('050206','0502','Totos',1),('050301','0503','Sancos',1),('050302','0503','Carapo',1),('050303','0503','Sacsamarca',1),('050304','0503','Santiago de Lucanamarca',1),('050401','0504','Huanta',1),('050402','0504','Ayahuanco',1),('050403','0504','Huamanguilla',1),('050404','0504','Iguain',1),('050405','0504','Luricocha',1),('050406','0504','Santillana',1),('050407','0504','Sivia',1),('050408','0504','Llochegua',1),('050409','0504','Canayre',1),('050410','0504','Uchuraccay',1),('050411','0504','Pucacolpa',1),('050412','0504','Chaca',1),('050501','0505','San Miguel',1),('050502','0505','Anco',1),('050503','0505','Ayna',1),('050504','0505','Chilcas',1),('050505','0505','Chungui',1),('050506','0505','Luis Carranza',1),('050507','0505','Santa Rosa',1),('050508','0505','Tambo',1),('050509','0505','Samugari',1),('050510','0505','Anchihuay',1),('050601','0506','Puquio',1),('050602','0506','Aucara',1),('050603','0506','Cabana',1),('050604','0506','Carmen Salcedo',1),('050605','0506','Chaviña',1),('050606','0506','Chipao',1),('050607','0506','Huac-Huas',1),('050608','0506','Laramate',1),('050609','0506','Leoncio Prado',1),('050610','0506','Llauta',1),('050611','0506','Lucanas',1),('050612','0506','Ocaña',1),('050613','0506','Otoca',1),('050614','0506','Saisa',1),('050615','0506','San Cristóbal',1),('050616','0506','San Juan',1),('050617','0506','San Pedro',1),('050618','0506','San Pedro de Palco',1),('050619','0506','Sancos',1),('050620','0506','Santa Ana de Huaycahuacho',1),('050621','0506','Santa Lucia',1),('050701','0507','Coracora',1),('050702','0507','Chumpi',1),('050703','0507','Coronel Castañeda',1),('050704','0507','Pacapausa',1),('050705','0507','Pullo',1),('050706','0507','Puyusca',1),('050707','0507','San Francisco de Ravacayco',1),('050708','0507','Upahuacho',1),('050801','0508','Pausa',1),('050802','0508','Colta',1),('050803','0508','Corculla',1),('050804','0508','Lampa',1),('050805','0508','Marcabamba',1),('050806','0508','Oyolo',1),('050807','0508','Pararca',1),('050808','0508','San Javier de Alpabamba',1),('050809','0508','San José de Ushua',1),('050810','0508','Sara Sara',1),('050901','0509','Querobamba',1),('050902','0509','Belén',1),('050903','0509','Chalcos',1),('050904','0509','Chilcayoc',1),('050905','0509','Huacaña',1),('050906','0509','Morcolla',1),('050907','0509','Paico',1),('050908','0509','San Pedro de Larcay',1),('050909','0509','San Salvador de Quije',1),('050910','0509','Santiago de Paucaray',1),('050911','0509','Soras',1),('051001','0510','Huancapi',1),('051002','0510','Alcamenca',1),('051003','0510','Apongo',1),('051004','0510','Asquipata',1),('051005','0510','Canaria',1),('051006','0510','Cayara',1),('051007','0510','Colca',1),('051008','0510','Huamanquiquia',1),('051009','0510','Huancaraylla',1),('051010','0510','Huaya',1),('051011','0510','Sarhua',1),('051012','0510','Vilcanchos',1),('051101','0511','Vilcas Huaman',1),('051102','0511','Accomarca',1),('051103','0511','Carhuanca',1),('051104','0511','Concepción',1),('051105','0511','Huambalpa',1),('051106','0511','Independencia',1),('051107','0511','Saurama',1),('051108','0511','Vischongo',1),('060101','0601','Cajamarca',1),('060102','0601','Asunción',1),('060103','0601','Chetilla',1),('060104','0601','Cospan',1),('060105','0601','Encañada',1),('060106','0601','Jesús',1),('060107','0601','Llacanora',1),('060108','0601','Los Baños del Inca',1),('060109','0601','Magdalena',1),('060110','0601','Matara',1),('060111','0601','Namora',1),('060112','0601','San Juan',1),('060201','0602','Cajabamba',1),('060202','0602','Cachachi',1),('060203','0602','Condebamba',1),('060204','0602','Sitacocha',1),('060301','0603','Celendín',1),('060302','0603','Chumuch',1),('060303','0603','Cortegana',1),('060304','0603','Huasmin',1),('060305','0603','Jorge Chávez',1),('060306','0603','José Gálvez',1),('060307','0603','Miguel Iglesias',1),('060308','0603','Oxamarca',1),('060309','0603','Sorochuco',1),('060310','0603','Sucre',1),('060311','0603','Utco',1),('060312','0603','La Libertad de Pallan',1),('060401','0604','Chota',1),('060402','0604','Anguia',1),('060403','0604','Chadin',1),('060404','0604','Chiguirip',1),('060405','0604','Chimban',1),('060406','0604','Choropampa',1),('060407','0604','Cochabamba',1),('060408','0604','Conchan',1),('060409','0604','Huambos',1),('060410','0604','Lajas',1),('060411','0604','Llama',1),('060412','0604','Miracosta',1),('060413','0604','Paccha',1),('060414','0604','Pion',1),('060415','0604','Querocoto',1),('060416','0604','San Juan de Licupis',1),('060417','0604','Tacabamba',1),('060418','0604','Tocmoche',1),('060419','0604','Chalamarca',1),('060501','0605','Contumaza',1),('060502','0605','Chilete',1),('060503','0605','Cupisnique',1),('060504','0605','Guzmango',1),('060505','0605','San Benito',1),('060506','0605','Santa Cruz de Toledo',1),('060507','0605','Tantarica',1),('060508','0605','Yonan',1),('060601','0606','Cutervo',1),('060602','0606','Callayuc',1),('060603','0606','Choros',1),('060604','0606','Cujillo',1),('060605','0606','La Ramada',1),('060606','0606','Pimpingos',1),('060607','0606','Querocotillo',1),('060608','0606','San Andrés de Cutervo',1),('060609','0606','San Juan de Cutervo',1),('060610','0606','San Luis de Lucma',1),('060611','0606','Santa Cruz',1),('060612','0606','Santo Domingo de la Capilla',1),('060613','0606','Santo Tomas',1),('060614','0606','Socota',1),('060615','0606','Toribio Casanova',1),('060701','0607','Bambamarca',1),('060702','0607','Chugur',1),('060703','0607','Hualgayoc',1),('060801','0608','Jaén',1),('060802','0608','Bellavista',1),('060803','0608','Chontali',1),('060804','0608','Colasay',1),('060805','0608','Huabal',1),('060806','0608','Las Pirias',1),('060807','0608','Pomahuaca',1),('060808','0608','Pucara',1),('060809','0608','Sallique',1),('060810','0608','San Felipe',1),('060811','0608','San José del Alto',1),('060812','0608','Santa Rosa',1),('060901','0609','San Ignacio',1),('060902','0609','Chirinos',1),('060903','0609','Huarango',1),('060904','0609','La Coipa',1),('060905','0609','Namballe',1),('060906','0609','San José de Lourdes',1),('060907','0609','Tabaconas',1),('061001','0610','Pedro Gálvez',1),('061002','0610','Chancay',1),('061003','0610','Eduardo Villanueva',1),('061004','0610','Gregorio Pita',1),('061005','0610','Ichocan',1),('061006','0610','José Manuel Quiroz',1),('061007','0610','José Sabogal',1),('061101','0611','San Miguel',1),('061102','0611','Bolívar',1),('061103','0611','Calquis',1),('061104','0611','Catilluc',1),('061105','0611','El Prado',1),('061106','0611','La Florida',1),('061107','0611','Llapa',1),('061108','0611','Nanchoc',1),('061109','0611','Niepos',1),('061110','0611','San Gregorio',1),('061111','0611','San Silvestre de Cochan',1),('061112','0611','Tongod',1),('061113','0611','Unión Agua Blanca',1),('061201','0612','San Pablo',1),('061202','0612','San Bernardino',1),('061203','0612','San Luis',1),('061204','0612','Tumbaden',1),('061301','0613','Santa Cruz',1),('061302','0613','Andabamba',1),('061303','0613','Catache',1),('061304','0613','Chancaybaños',1),('061305','0613','La Esperanza',1),('061306','0613','Ninabamba',1),('061307','0613','Pulan',1),('061308','0613','Saucepampa',1),('061309','0613','Sexi',1),('061310','0613','Uticyacu',1),('061311','0613','Yauyucan',1),('070101','0701','Callao',1),('070102','0701','Bellavista',1),('070103','0701','Carmen de la Legua Reynoso',1),('070104','0701','La Perla',1),('070105','0701','La Punta',1),('070106','0701','Ventanilla',1),('070107','0701','Mi Perú',1),('080101','0801','Cusco',1),('080102','0801','Ccorca',1),('080103','0801','Poroy',1),('080104','0801','San Jerónimo',1),('080105','0801','San Sebastian',1),('080106','0801','Santiago',1),('080107','0801','Saylla',1),('080108','0801','Wanchaq',1),('080201','0802','Acomayo',1),('080202','0802','Acopia',1),('080203','0802','Acos',1),('080204','0802','Mosoc Llacta',1),('080205','0802','Pomacanchi',1),('080206','0802','Rondocan',1),('080207','0802','Sangarara',1),('080301','0803','Anta',1),('080302','0803','Ancahuasi',1),('080303','0803','Cachimayo',1),('080304','0803','Chinchaypujio',1),('080305','0803','Huarocondo',1),('080306','0803','Limatambo',1),('080307','0803','Mollepata',1),('080308','0803','Pucyura',1),('080309','0803','Zurite',1),('080401','0804','Calca',1),('080402','0804','Coya',1),('080403','0804','Lamay',1),('080404','0804','Lares',1),('080405','0804','Pisac',1),('080406','0804','San Salvador',1),('080407','0804','Taray',1),('080408','0804','Yanatile',1),('080501','0805','Yanaoca',1),('080502','0805','Checca',1),('080503','0805','Kunturkanki',1),('080504','0805','Langui',1),('080505','0805','Layo',1),('080506','0805','Pampamarca',1),('080507','0805','Quehue',1),('080508','0805','Tupac Amaru',1),('080601','0806','Sicuani',1),('080602','0806','Checacupe',1),('080603','0806','Combapata',1),('080604','0806','Marangani',1),('080605','0806','Pitumarca',1),('080606','0806','San Pablo',1),('080607','0806','San Pedro',1),('080608','0806','Tinta',1),('080701','0807','Santo Tomas',1),('080702','0807','Capacmarca',1),('080703','0807','Chamaca',1),('080704','0807','Colquemarca',1),('080705','0807','Livitaca',1),('080706','0807','Llusco',1),('080707','0807','Quiñota',1),('080708','0807','Velille',1),('080801','0808','Espinar',1),('080802','0808','Condoroma',1),('080803','0808','Coporaque',1),('080804','0808','Ocoruro',1),('080805','0808','Pallpata',1),('080806','0808','Pichigua',1),('080807','0808','Suyckutambo',1),('080808','0808','Alto Pichigua',1),('080901','0809','Santa Ana',1),('080902','0809','Echarate',1),('080903','0809','Huayopata',1),('080904','0809','Maranura',1),('080905','0809','Ocobamba',1),('080906','0809','Quellouno',1),('080907','0809','Kimbiri',1),('080908','0809','Santa Teresa',1),('080909','0809','Vilcabamba',1),('080910','0809','Pichari',1),('080911','0809','Inkawasi',1),('080912','0809','Villa Virgen',1),('080913','0809','Villa Kintiarina',1),('081001','0810','Paruro',1),('081002','0810','Accha',1),('081003','0810','Ccapi',1),('081004','0810','Colcha',1),('081005','0810','Huanoquite',1),('081006','0810','Omacha',1),('081007','0810','Paccaritambo',1),('081008','0810','Pillpinto',1),('081009','0810','Yaurisque',1),('081101','0811','Paucartambo',1),('081102','0811','Caicay',1),('081103','0811','Challabamba',1),('081104','0811','Colquepata',1),('081105','0811','Huancarani',1),('081106','0811','Kosñipata',1),('081201','0812','Urcos',1),('081202','0812','Andahuaylillas',1),('081203','0812','Camanti',1),('081204','0812','Ccarhuayo',1),('081205','0812','Ccatca',1),('081206','0812','Cusipata',1),('081207','0812','Huaro',1),('081208','0812','Lucre',1),('081209','0812','Marcapata',1),('081210','0812','Ocongate',1),('081211','0812','Oropesa',1),('081212','0812','Quiquijana',1),('081301','0813','Urubamba',1),('081302','0813','Chinchero',1),('081303','0813','Huayllabamba',1),('081304','0813','Machupicchu',1),('081305','0813','Maras',1),('081306','0813','Ollantaytambo',1),('081307','0813','Yucay',1),('090101','0901','Huancavelica',1),('090102','0901','Acobambilla',1),('090103','0901','Acoria',1),('090104','0901','Conayca',1),('090105','0901','Cuenca',1),('090106','0901','Huachocolpa',1),('090107','0901','Huayllahuara',1),('090108','0901','Izcuchaca',1),('090109','0901','Laria',1),('090110','0901','Manta',1),('090111','0901','Mariscal Cáceres',1),('090112','0901','Moya',1),('090113','0901','Nuevo Occoro',1),('090114','0901','Palca',1),('090115','0901','Pilchaca',1),('090116','0901','Vilca',1),('090117','0901','Yauli',1),('090118','0901','Ascensión',1),('090119','0901','Huando',1),('090201','0902','Acobamba',1),('090202','0902','Andabamba',1),('090203','0902','Anta',1),('090204','0902','Caja',1),('090205','0902','Marcas',1),('090206','0902','Paucara',1),('090207','0902','Pomacocha',1),('090208','0902','Rosario',1),('090301','0903','Lircay',1),('090302','0903','Anchonga',1),('090303','0903','Callanmarca',1),('090304','0903','Ccochaccasa',1),('090305','0903','Chincho',1),('090306','0903','Congalla',1),('090307','0903','Huanca-Huanca',1),('090308','0903','Huayllay Grande',1),('090309','0903','Julcamarca',1),('090310','0903','San Antonio de Antaparco',1),('090311','0903','Santo Tomas de Pata',1),('090312','0903','Secclla',1),('090401','0904','Castrovirreyna',1),('090402','0904','Arma',1),('090403','0904','Aurahua',1),('090404','0904','Capillas',1),('090405','0904','Chupamarca',1),('090406','0904','Cocas',1),('090407','0904','Huachos',1),('090408','0904','Huamatambo',1),('090409','0904','Mollepampa',1),('090410','0904','San Juan',1),('090411','0904','Santa Ana',1),('090412','0904','Tantara',1),('090413','0904','Ticrapo',1),('090501','0905','Churcampa',1),('090502','0905','Anco',1),('090503','0905','Chinchihuasi',1),('090504','0905','El Carmen',1),('090505','0905','La Merced',1),('090506','0905','Locroja',1),('090507','0905','Paucarbamba',1),('090508','0905','San Miguel de Mayocc',1),('090509','0905','San Pedro de Coris',1),('090510','0905','Pachamarca',1),('090511','0905','Cosme',1),('090601','0906','Huaytara',1),('090602','0906','Ayavi',1),('090603','0906','Córdova',1),('090604','0906','Huayacundo Arma',1),('090605','0906','Laramarca',1),('090606','0906','Ocoyo',1),('090607','0906','Pilpichaca',1),('090608','0906','Querco',1),('090609','0906','Quito-Arma',1),('090610','0906','San Antonio de Cusicancha',1),('090611','0906','San Francisco de Sangayaico',1),('090612','0906','San Isidro',1),('090613','0906','Santiago de Chocorvos',1),('090614','0906','Santiago de Quirahuara',1),('090615','0906','Santo Domingo de Capillas',1),('090616','0906','Tambo',1),('090701','0907','Pampas',1),('090702','0907','Acostambo',1),('090703','0907','Acraquia',1),('090704','0907','Ahuaycha',1),('090705','0907','Colcabamba',1),('090706','0907','Daniel Hernández',1),('090707','0907','Huachocolpa',1),('090709','0907','Huaribamba',1),('090710','0907','Ñahuimpuquio',1),('090711','0907','Pazos',1),('090713','0907','Quishuar',1),('090714','0907','Salcabamba',1),('090715','0907','Salcahuasi',1),('090716','0907','San Marcos de Rocchac',1),('090717','0907','Surcubamba',1),('090718','0907','Tintay Puncu',1),('090719','0907','Quichuas',1),('090720','0907','Andaymarca',1),('090721','0907','Roble',1),('090722','0907','Pichos',1),('100101','1001','Huanuco',1),('100102','1001','Amarilis',1),('100103','1001','Chinchao',1),('100104','1001','Churubamba',1),('100105','1001','Margos',1),('100106','1001','Quisqui (Kichki)',1),('100107','1001','San Francisco de Cayran',1),('100108','1001','San Pedro de Chaulan',1),('100109','1001','Santa María del Valle',1),('100110','1001','Yarumayo',1),('100111','1001','Pillco Marca',1),('100112','1001','Yacus',1),('100113','1001','San Pablo de Pillao',1),('100201','1002','Ambo',1),('100202','1002','Cayna',1),('100203','1002','Colpas',1),('100204','1002','Conchamarca',1),('100205','1002','Huacar',1),('100206','1002','San Francisco',1),('100207','1002','San Rafael',1),('100208','1002','Tomay Kichwa',1),('100301','1003','La Unión',1),('100307','1003','Chuquis',1),('100311','1003','Marías',1),('100313','1003','Pachas',1),('100316','1003','Quivilla',1),('100317','1003','Ripan',1),('100321','1003','Shunqui',1),('100322','1003','Sillapata',1),('100323','1003','Yanas',1),('100401','1004','Huacaybamba',1),('100402','1004','Canchabamba',1),('100403','1004','Cochabamba',1),('100404','1004','Pinra',1),('100501','1005','Llata',1),('100502','1005','Arancay',1),('100503','1005','Chavín de Pariarca',1),('100504','1005','Jacas Grande',1),('100505','1005','Jircan',1),('100506','1005','Miraflores',1),('100507','1005','Monzón',1),('100508','1005','Punchao',1),('100509','1005','Puños',1),('100510','1005','Singa',1),('100511','1005','Tantamayo',1),('100601','1006','Rupa-Rupa',1),('100602','1006','Daniel Alomía Robles',1),('100603','1006','Hermílio Valdizan',1),('100604','1006','José Crespo y Castillo',1),('100605','1006','Luyando',1),('100606','1006','Mariano Damaso Beraun',1),('100607','1006','Pucayacu',1),('100608','1006','Castillo Grande',1),('100701','1007','Huacrachuco',1),('100702','1007','Cholon',1),('100703','1007','San Buenaventura',1),('100704','1007','La Morada',1),('100705','1007','Santa Rosa de Alto Yanajanca',1),('100801','1008','Panao',1),('100802','1008','Chaglla',1),('100803','1008','Molino',1),('100804','1008','Umari',1),('100901','1009','Puerto Inca',1),('100902','1009','Codo del Pozuzo',1),('100903','1009','Honoria',1),('100904','1009','Tournavista',1),('100905','1009','Yuyapichis',1),('101001','1010','Jesús',1),('101002','1010','Baños',1),('101003','1010','Jivia',1),('101004','1010','Queropalca',1),('101005','1010','Rondos',1),('101006','1010','San Francisco de Asís',1),('101007','1010','San Miguel de Cauri',1),('101101','1011','Chavinillo',1),('101102','1011','Cahuac',1),('101103','1011','Chacabamba',1),('101104','1011','Aparicio Pomares',1),('101105','1011','Jacas Chico',1),('101106','1011','Obas',1),('101107','1011','Pampamarca',1),('101108','1011','Choras',1),('110101','1101','Ica',1),('110102','1101','La Tinguiña',1),('110103','1101','Los Aquijes',1),('110104','1101','Ocucaje',1),('110105','1101','Pachacutec',1),('110106','1101','Parcona',1),('110107','1101','Pueblo Nuevo',1),('110108','1101','Salas',1),('110109','1101','San José de Los Molinos',1),('110110','1101','San Juan Bautista',1),('110111','1101','Santiago',1),('110112','1101','Subtanjalla',1),('110113','1101','Tate',1),('110114','1101','Yauca del Rosario',1),('110201','1102','Chincha Alta',1),('110202','1102','Alto Laran',1),('110203','1102','Chavin',1),('110204','1102','Chincha Baja',1),('110205','1102','El Carmen',1),('110206','1102','Grocio Prado',1),('110207','1102','Pueblo Nuevo',1),('110208','1102','San Juan de Yanac',1),('110209','1102','San Pedro de Huacarpana',1),('110210','1102','Sunampe',1),('110211','1102','Tambo de Mora',1),('110301','1103','Nasca',1),('110302','1103','Changuillo',1),('110303','1103','El Ingenio',1),('110304','1103','Marcona',1),('110305','1103','Vista Alegre',1),('110401','1104','Palpa',1),('110402','1104','Llipata',1),('110403','1104','Río Grande',1),('110404','1104','Santa Cruz',1),('110405','1104','Tibillo',1),('110501','1105','Pisco',1),('110502','1105','Huancano',1),('110503','1105','Humay',1),('110504','1105','Independencia',1),('110505','1105','Paracas',1),('110506','1105','San Andrés',1),('110507','1105','San Clemente',1),('110508','1105','Tupac Amaru Inca',1),('120101','1201','Huancayo',1),('120104','1201','Carhuacallanga',1),('120105','1201','Chacapampa',1),('120106','1201','Chicche',1),('120107','1201','Chilca',1),('120108','1201','Chongos Alto',1),('120111','1201','Chupuro',1),('120112','1201','Colca',1),('120113','1201','Cullhuas',1),('120114','1201','El Tambo',1),('120116','1201','Huacrapuquio',1),('120117','1201','Hualhuas',1),('120119','1201','Huancan',1),('120120','1201','Huasicancha',1),('120121','1201','Huayucachi',1),('120122','1201','Ingenio',1),('120124','1201','Pariahuanca',1),('120125','1201','Pilcomayo',1),('120126','1201','Pucara',1),('120127','1201','Quichuay',1),('120128','1201','Quilcas',1),('120129','1201','San Agustín',1),('120130','1201','San Jerónimo de Tunan',1),('120132','1201','Saño',1),('120133','1201','Sapallanga',1),('120134','1201','Sicaya',1),('120135','1201','Santo Domingo de Acobamba',1),('120136','1201','Viques',1),('120201','1202','Concepción',1),('120202','1202','Aco',1),('120203','1202','Andamarca',1),('120204','1202','Chambara',1),('120205','1202','Cochas',1),('120206','1202','Comas',1),('120207','1202','Heroínas Toledo',1),('120208','1202','Manzanares',1),('120209','1202','Mariscal Castilla',1),('120210','1202','Matahuasi',1),('120211','1202','Mito',1),('120212','1202','Nueve de Julio',1),('120213','1202','Orcotuna',1),('120214','1202','San José de Quero',1),('120215','1202','Santa Rosa de Ocopa',1),('120301','1203','Chanchamayo',1),('120302','1203','Perene',1),('120303','1203','Pichanaqui',1),('120304','1203','San Luis de Shuaro',1),('120305','1203','San Ramón',1),('120306','1203','Vitoc',1),('120401','1204','Jauja',1),('120402','1204','Acolla',1),('120403','1204','Apata',1),('120404','1204','Ataura',1),('120405','1204','Canchayllo',1),('120406','1204','Curicaca',1),('120407','1204','El Mantaro',1),('120408','1204','Huamali',1),('120409','1204','Huaripampa',1),('120410','1204','Huertas',1),('120411','1204','Janjaillo',1),('120412','1204','Julcán',1),('120413','1204','Leonor Ordóñez',1),('120414','1204','Llocllapampa',1),('120415','1204','Marco',1),('120416','1204','Masma',1),('120417','1204','Masma Chicche',1),('120418','1204','Molinos',1),('120419','1204','Monobamba',1),('120420','1204','Muqui',1),('120421','1204','Muquiyauyo',1),('120422','1204','Paca',1),('120423','1204','Paccha',1),('120424','1204','Pancan',1),('120425','1204','Parco',1),('120426','1204','Pomacancha',1),('120427','1204','Ricran',1),('120428','1204','San Lorenzo',1),('120429','1204','San Pedro de Chunan',1),('120430','1204','Sausa',1),('120431','1204','Sincos',1),('120432','1204','Tunan Marca',1),('120433','1204','Yauli',1),('120434','1204','Yauyos',1),('120501','1205','Junin',1),('120502','1205','Carhuamayo',1),('120503','1205','Ondores',1),('120504','1205','Ulcumayo',1),('120601','1206','Satipo',1),('120602','1206','Coviriali',1),('120603','1206','Llaylla',1),('120604','1206','Mazamari',1),('120605','1206','Pampa Hermosa',1),('120606','1206','Pangoa',1),('120607','1206','Río Negro',1),('120608','1206','Río Tambo',1),('120609','1206','Vizcatan del Ene',1),('120701','1207','Tarma',1),('120702','1207','Acobamba',1),('120703','1207','Huaricolca',1),('120704','1207','Huasahuasi',1),('120705','1207','La Unión',1),('120706','1207','Palca',1),('120707','1207','Palcamayo',1),('120708','1207','San Pedro de Cajas',1),('120709','1207','Tapo',1),('120801','1208','La Oroya',1),('120802','1208','Chacapalpa',1),('120803','1208','Huay-Huay',1),('120804','1208','Marcapomacocha',1),('120805','1208','Morococha',1),('120806','1208','Paccha',1),('120807','1208','Santa Bárbara de Carhuacayan',1),('120808','1208','Santa Rosa de Sacco',1),('120809','1208','Suitucancha',1),('120810','1208','Yauli',1),('120901','1209','Chupaca',1),('120902','1209','Ahuac',1),('120903','1209','Chongos Bajo',1),('120904','1209','Huachac',1),('120905','1209','Huamancaca Chico',1),('120906','1209','San Juan de Iscos',1),('120907','1209','San Juan de Jarpa',1),('120908','1209','Tres de Diciembre',1),('120909','1209','Yanacancha',1),('130101','1301','Trujillo',1),('130102','1301','El Porvenir',1),('130103','1301','Florencia de Mora',1),('130104','1301','Huanchaco',1),('130105','1301','La Esperanza',1),('130106','1301','Laredo',1),('130107','1301','Moche',1),('130108','1301','Poroto',1),('130109','1301','Salaverry',1),('130110','1301','Simbal',1),('130111','1301','Victor Larco Herrera',1),('130201','1302','Ascope',1),('130202','1302','Chicama',1),('130203','1302','Chocope',1),('130204','1302','Magdalena de Cao',1),('130205','1302','Paijan',1),('130206','1302','Rázuri',1),('130207','1302','Santiago de Cao',1),('130208','1302','Casa Grande',1),('130301','1303','Bolívar',1),('130302','1303','Bambamarca',1),('130303','1303','Condormarca',1),('130304','1303','Longotea',1),('130305','1303','Uchumarca',1),('130306','1303','Ucuncha',1),('130401','1304','Chepen',1),('130402','1304','Pacanga',1),('130403','1304','Pueblo Nuevo',1),('130501','1305','Julcan',1),('130502','1305','Calamarca',1),('130503','1305','Carabamba',1),('130504','1305','Huaso',1),('130601','1306','Otuzco',1),('130602','1306','Agallpampa',1),('130604','1306','Charat',1),('130605','1306','Huaranchal',1),('130606','1306','La Cuesta',1),('130608','1306','Mache',1),('130610','1306','Paranday',1),('130611','1306','Salpo',1),('130613','1306','Sinsicap',1),('130614','1306','Usquil',1),('130701','1307','San Pedro de Lloc',1),('130702','1307','Guadalupe',1),('130703','1307','Jequetepeque',1),('130704','1307','Pacasmayo',1),('130705','1307','San José',1),('130801','1308','Tayabamba',1),('130802','1308','Buldibuyo',1),('130803','1308','Chillia',1),('130804','1308','Huancaspata',1),('130805','1308','Huaylillas',1),('130806','1308','Huayo',1),('130807','1308','Ongon',1),('130808','1308','Parcoy',1),('130809','1308','Pataz',1),('130810','1308','Pias',1),('130811','1308','Santiago de Challas',1),('130812','1308','Taurija',1),('130813','1308','Urpay',1),('130901','1309','Huamachuco',1),('130902','1309','Chugay',1),('130903','1309','Cochorco',1),('130904','1309','Curgos',1),('130905','1309','Marcabal',1),('130906','1309','Sanagoran',1),('130907','1309','Sarin',1),('130908','1309','Sartimbamba',1),('131001','1310','Santiago de Chuco',1),('131002','1310','Angasmarca',1),('131003','1310','Cachicadan',1),('131004','1310','Mollebamba',1),('131005','1310','Mollepata',1),('131006','1310','Quiruvilca',1),('131007','1310','Santa Cruz de Chuca',1),('131008','1310','Sitabamba',1),('131101','1311','Cascas',1),('131102','1311','Lucma',1),('131103','1311','Marmot',1),('131104','1311','Sayapullo',1),('131201','1312','Viru',1),('131202','1312','Chao',1),('131203','1312','Guadalupito',1),('140101','1401','Chiclayo',1),('140102','1401','Chongoyape',1),('140103','1401','Eten',1),('140104','1401','Eten Puerto',1),('140105','1401','José Leonardo Ortiz',1),('140106','1401','La Victoria',1),('140107','1401','Lagunas',1),('140108','1401','Monsefu',1),('140109','1401','Nueva Arica',1),('140110','1401','Oyotun',1),('140111','1401','Picsi',1),('140112','1401','Pimentel',1),('140113','1401','Reque',1),('140114','1401','Santa Rosa',1),('140115','1401','Saña',1),('140116','1401','Cayalti',1),('140117','1401','Patapo',1),('140118','1401','Pomalca',1),('140119','1401','Pucala',1),('140120','1401','Tuman',1),('140201','1402','Ferreñafe',1),('140202','1402','Cañaris',1),('140203','1402','Incahuasi',1),('140204','1402','Manuel Antonio Mesones Muro',1),('140205','1402','Pitipo',1),('140206','1402','Pueblo Nuevo',1),('140301','1403','Lambayeque',1),('140302','1403','Chochope',1),('140303','1403','Illimo',1),('140304','1403','Jayanca',1),('140305','1403','Mochumi',1),('140306','1403','Morrope',1),('140307','1403','Motupe',1),('140308','1403','Olmos',1),('140309','1403','Pacora',1),('140310','1403','Salas',1),('140311','1403','San José',1),('140312','1403','Tucume',1),('150101','1501','Lima',1),('150102','1501','Ancón',1),('150103','1501','Ate',1),('150104','1501','Barranco',1),('150105','1501','Breña',1),('150106','1501','Carabayllo',1),('150107','1501','Chaclacayo',1),('150108','1501','Chorrillos',1),('150109','1501','Cieneguilla',1),('150110','1501','Comas',1),('150111','1501','El Agustino',1),('150112','1501','Independencia',1),('150113','1501','Jesús María',1),('150114','1501','La Molina',1),('150115','1501','La Victoria',1),('150116','1501','Lince',1),('150117','1501','Los Olivos',1),('150118','1501','Lurigancho',1),('150119','1501','Lurin',1),('150120','1501','Magdalena del Mar',1),('150121','1501','Pueblo Libre',1),('150122','1501','Miraflores',1),('150123','1501','Pachacamac',1),('150124','1501','Pucusana',1),('150125','1501','Puente Piedra',1),('150126','1501','Punta Hermosa',1),('150127','1501','Punta Negra',1),('150128','1501','Rímac',1),('150129','1501','San Bartolo',1),('150130','1501','SAN BORJA',1),('150131','1501','San Isidro',1),('150132','1501','San Juan de Lurigancho',1),('150133','1501','San Juan de Miraflores',1),('150134','1501','San Luis',1),('150135','1501','San Martín de Porres',1),('150136','1501','San Miguel',1),('150137','1501','Santa Anita',1),('150138','1501','Santa María del Mar',1),('150139','1501','Santa Rosa',1),('150140','1501','Santiago de Surco',1),('150141','1501','Surquillo',1),('150142','1501','Villa El Salvador',1),('150143','1501','Villa María del Triunfo',1),('150201','1502','Barranca',1),('150202','1502','Paramonga',1),('150203','1502','Pativilca',1),('150204','1502','Supe',1),('150205','1502','Supe Puerto',1),('150301','1503','Cajatambo',1),('150302','1503','Copa',1),('150303','1503','Gorgor',1),('150304','1503','Huancapon',1),('150305','1503','Manas',1),('150401','1504','Canta',1),('150402','1504','Arahuay',1),('150403','1504','Huamantanga',1),('150404','1504','Huaros',1),('150405','1504','Lachaqui',1),('150406','1504','San Buenaventura',1),('150407','1504','Santa Rosa de Quives',1),('150501','1505','San Vicente de Cañete',1),('150502','1505','Asia',1),('150503','1505','Calango',1),('150504','1505','Cerro Azul',1),('150505','1505','Chilca',1),('150506','1505','Coayllo',1),('150507','1505','Imperial',1),('150508','1505','Lunahuana',1),('150509','1505','Mala',1),('150510','1505','Nuevo Imperial',1),('150511','1505','Pacaran',1),('150512','1505','Quilmana',1),('150513','1505','San Antonio',1),('150514','1505','San Luis',1),('150515','1505','Santa Cruz de Flores',1),('150516','1505','Zúñiga',1),('150601','1506','Huaral',1),('150602','1506','Atavillos Alto',1),('150603','1506','Atavillos Bajo',1),('150604','1506','Aucallama',1),('150605','1506','Chancay',1),('150606','1506','Ihuari',1),('150607','1506','Lampian',1),('150608','1506','Pacaraos',1),('150609','1506','San Miguel de Acos',1),('150610','1506','Santa Cruz de Andamarca',1),('150611','1506','Sumbilca',1),('150612','1506','Veintisiete de Noviembre',1),('150701','1507','Matucana',1),('150702','1507','Antioquia',1),('150703','1507','Callahuanca',1),('150704','1507','Carampoma',1),('150705','1507','Chicla',1),('150706','1507','Cuenca',1),('150707','1507','Huachupampa',1),('150708','1507','Huanza',1),('150709','1507','Huarochiri',1),('150710','1507','Lahuaytambo',1),('150711','1507','Langa',1),('150712','1507','Laraos',1),('150713','1507','Mariatana',1),('150714','1507','Ricardo Palma',1),('150715','1507','San Andrés de Tupicocha',1),('150716','1507','San Antonio',1),('150717','1507','San Bartolomé',1),('150718','1507','San Damian',1),('150719','1507','San Juan de Iris',1),('150720','1507','San Juan de Tantaranche',1),('150721','1507','San Lorenzo de Quinti',1),('150722','1507','San Mateo',1),('150723','1507','San Mateo de Otao',1),('150724','1507','San Pedro de Casta',1),('150725','1507','San Pedro de Huancayre',1),('150726','1507','Sangallaya',1),('150727','1507','Santa Cruz de Cocachacra',1),('150728','1507','Santa Eulalia',1),('150729','1507','Santiago de Anchucaya',1),('150730','1507','Santiago de Tuna',1),('150731','1507','Santo Domingo de Los Olleros',1),('150732','1507','Surco',1),('150801','1508','Huacho',1),('150802','1508','Ambar',1),('150803','1508','Caleta de Carquin',1),('150804','1508','Checras',1),('150805','1508','Hualmay',1),('150806','1508','Huaura',1),('150807','1508','Leoncio Prado',1),('150808','1508','Paccho',1),('150809','1508','Santa Leonor',1),('150810','1508','Santa María',1),('150811','1508','Sayan',1),('150812','1508','Vegueta',1),('150901','1509','Oyon',1),('150902','1509','Andajes',1),('150903','1509','Caujul',1),('150904','1509','Cochamarca',1),('150905','1509','Navan',1),('150906','1509','Pachangara',1),('151001','1510','Yauyos',1),('151002','1510','Alis',1),('151003','1510','Allauca',1),('151004','1510','Ayaviri',1),('151005','1510','Azángaro',1),('151006','1510','Cacra',1),('151007','1510','Carania',1),('151008','1510','Catahuasi',1),('151009','1510','Chocos',1),('151010','1510','Cochas',1),('151011','1510','Colonia',1),('151012','1510','Hongos',1),('151013','1510','Huampara',1),('151014','1510','Huancaya',1),('151015','1510','Huangascar',1),('151016','1510','Huantan',1),('151017','1510','Huañec',1),('151018','1510','Laraos',1),('151019','1510','Lincha',1),('151020','1510','Madean',1),('151021','1510','Miraflores',1),('151022','1510','Omas',1),('151023','1510','Putinza',1),('151024','1510','Quinches',1),('151025','1510','Quinocay',1),('151026','1510','San Joaquín',1),('151027','1510','San Pedro de Pilas',1),('151028','1510','Tanta',1),('151029','1510','Tauripampa',1),('151030','1510','Tomas',1),('151031','1510','Tupe',1),('151032','1510','Viñac',1),('151033','1510','Vitis',1),('160101','1601','Iquitos',1),('160102','1601','Alto Nanay',1),('160103','1601','Fernando Lores',1),('160104','1601','Indiana',1),('160105','1601','Las Amazonas',1),('160106','1601','Mazan',1),('160107','1601','Napo',1),('160108','1601','Punchana',1),('160110','1601','Torres Causana',1),('160112','1601','Belén',1),('160113','1601','San Juan Bautista',1),('160201','1602','Yurimaguas',1),('160202','1602','Balsapuerto',1),('160205','1602','Jeberos',1),('160206','1602','Lagunas',1),('160210','1602','Santa Cruz',1),('160211','1602','Teniente Cesar López Rojas',1),('160301','1603','Nauta',1),('160302','1603','Parinari',1),('160303','1603','Tigre',1),('160304','1603','Trompeteros',1),('160305','1603','Urarinas',1),('160401','1604','Ramón Castilla',1),('160402','1604','Pebas',1),('160403','1604','Yavari',1),('160404','1604','San Pablo',1),('160501','1605','Requena',1),('160502','1605','Alto Tapiche',1),('160503','1605','Capelo',1),('160504','1605','Emilio San Martín',1),('160505','1605','Maquia',1),('160506','1605','Puinahua',1),('160507','1605','Saquena',1),('160508','1605','Soplin',1),('160509','1605','Tapiche',1),('160510','1605','Jenaro Herrera',1),('160511','1605','Yaquerana',1),('160601','1606','Contamana',1),('160602','1606','Inahuaya',1),('160603','1606','Padre Márquez',1),('160604','1606','Pampa Hermosa',1),('160605','1606','Sarayacu',1),('160606','1606','Vargas Guerra',1),('160701','1607','Barranca',1),('160702','1607','Cahuapanas',1),('160703','1607','Manseriche',1),('160704','1607','Morona',1),('160705','1607','Pastaza',1),('160706','1607','Andoas',1),('160801','1608','Putumayo',1),('160802','1608','Rosa Panduro',1),('160803','1608','Teniente Manuel Clavero',1),('160804','1608','Yaguas',1),('170101','1701','Tambopata',1),('170102','1701','Inambari',1),('170103','1701','Las Piedras',1),('170104','1701','Laberinto',1),('170201','1702','Manu',1),('170202','1702','Fitzcarrald',1),('170203','1702','Madre de Dios',1),('170204','1702','Huepetuhe',1),('170301','1703','Iñapari',1),('170302','1703','Iberia',1),('170303','1703','Tahuamanu',1),('180101','1801','Moquegua',1),('180102','1801','Carumas',1),('180103','1801','Cuchumbaya',1),('180104','1801','Samegua',1),('180105','1801','San Cristóbal',1),('180106','1801','Torata',1),('180201','1802','Omate',1),('180202','1802','Chojata',1),('180203','1802','Coalaque',1),('180204','1802','Ichuña',1),('180205','1802','La Capilla',1),('180206','1802','Lloque',1),('180207','1802','Matalaque',1),('180208','1802','Puquina',1),('180209','1802','Quinistaquillas',1),('180210','1802','Ubinas',1),('180211','1802','Yunga',1),('180301','1803','Ilo',1),('180302','1803','El Algarrobal',1),('180303','1803','Pacocha',1),('190101','1901','Chaupimarca',1),('190102','1901','Huachon',1),('190103','1901','Huariaca',1),('190104','1901','Huayllay',1),('190105','1901','Ninacaca',1),('190106','1901','Pallanchacra',1),('190107','1901','Paucartambo',1),('190108','1901','San Francisco de Asís de Yarusyacan',1),('190109','1901','Simon Bolívar',1),('190110','1901','Ticlacayan',1),('190111','1901','Tinyahuarco',1),('190112','1901','Vicco',1),('190113','1901','Yanacancha',1),('190201','1902','Yanahuanca',1),('190202','1902','Chacayan',1),('190203','1902','Goyllarisquizga',1),('190204','1902','Paucar',1),('190205','1902','San Pedro de Pillao',1),('190206','1902','Santa Ana de Tusi',1),('190207','1902','Tapuc',1),('190208','1902','Vilcabamba',1),('190301','1903','Oxapampa',1),('190302','1903','Chontabamba',1),('190303','1903','Huancabamba',1),('190304','1903','Palcazu',1),('190305','1903','Pozuzo',1),('190306','1903','Puerto Bermúdez',1),('190307','1903','Villa Rica',1),('190308','1903','Constitución',1),('200101','2001','Piura',1),('200104','2001','Castilla',1),('200105','2001','Catacaos',1),('200107','2001','Cura Mori',1),('200108','2001','El Tallan',1),('200109','2001','La Arena',1),('200110','2001','La Unión',1),('200111','2001','Las Lomas',1),('200114','2001','Tambo Grande',1),('200115','2001','Veintiseis de Octubre',1),('200201','2002','Ayabaca',1),('200202','2002','Frias',1),('200203','2002','Jilili',1),('200204','2002','Lagunas',1),('200205','2002','Montero',1),('200206','2002','Pacaipampa',1),('200207','2002','Paimas',1),('200208','2002','Sapillica',1),('200209','2002','Sicchez',1),('200210','2002','Suyo',1),('200301','2003','Huancabamba',1),('200302','2003','Canchaque',1),('200303','2003','El Carmen de la Frontera',1),('200304','2003','Huarmaca',1),('200305','2003','Lalaquiz',1),('200306','2003','San Miguel de El Faique',1),('200307','2003','Sondor',1),('200308','2003','Sondorillo',1),('200401','2004','Chulucanas',1),('200402','2004','Buenos Aires',1),('200403','2004','Chalaco',1),('200404','2004','La Matanza',1),('200405','2004','Morropon',1),('200406','2004','Salitral',1),('200407','2004','San Juan de Bigote',1),('200408','2004','Santa Catalina de Mossa',1),('200409','2004','Santo Domingo',1),('200410','2004','YAMANGO',1),('200501','2005','PAITA',1),('200502','2005','AMOTAPE',1),('200503','2005','ARENAL',1),('200504','2005','COLAN',1),('200505','2005','LA HUACA',1),('200506','2005','Tamarindo',1),('200507','2005','Vichayal',1),('200601','2006','SULLANA',1),('200602','2006','Bellavista',1),('200603','2006','Ignacio Escudero',1),('200604','2006','Lancones',1),('200605','2006','Marcavelica',1),('200606','2006','Miguel Checa',1),('200607','2006','Querecotillo',1),('200608','2006','Salitral',1),('200701','2007','PARIÑAS',1),('200702','2007','EL ALTO',1),('200703','2007','LA BREA',1),('200704','2007','LOBITOS',1),('200705','2007','Los Organos',1),('200706','2007','MANCORA',1),('200801','2008','SECHURA',1),('200802','2008','Bellavista de la Unión',1),('200803','2008','BERNAL',1),('200804','2008','Cristo Nos Valga',1),('200805','2008','Vice',1),('200806','2008','Rinconada Llicuar',1),('210101','2101','Puno',1),('210102','2101','Acora',1),('210103','2101','Amantani',1),('210104','2101','Atuncolla',1),('210105','2101','Capachica',1),('210106','2101','Chucuito',1),('210107','2101','Coata',1),('210108','2101','Huata',1),('210109','2101','Mañazo',1),('210110','2101','Paucarcolla',1),('210111','2101','Pichacani',1),('210112','2101','Plateria',1),('210113','2101','San Antonio',1),('210114','2101','Tiquillaca',1),('210115','2101','Vilque',1),('210201','2102','Azángaro',1),('210202','2102','Achaya',1),('210203','2102','Arapa',1),('210204','2102','Asillo',1),('210205','2102','Caminaca',1),('210206','2102','Chupa',1),('210207','2102','José Domingo Choquehuanca',1),('210208','2102','Muñani',1),('210209','2102','Potoni',1),('210210','2102','Saman',1),('210211','2102','San Anton',1),('210212','2102','San José',1),('210213','2102','San Juan de Salinas',1),('210214','2102','Santiago de Pupuja',1),('210215','2102','Tirapata',1),('210301','2103','Macusani',1),('210302','2103','Ajoyani',1),('210303','2103','Ayapata',1),('210304','2103','Coasa',1),('210305','2103','Corani',1),('210306','2103','Crucero',1),('210307','2103','Ituata',1),('210308','2103','Ollachea',1),('210309','2103','San Gaban',1),('210310','2103','Usicayos',1),('210401','2104','Juli',1),('210402','2104','Desaguadero',1),('210403','2104','Huacullani',1),('210404','2104','Kelluyo',1),('210405','2104','Pisacoma',1),('210406','2104','Pomata',1),('210407','2104','Zepita',1),('210501','2105','Ilave',1),('210502','2105','Capazo',1),('210503','2105','Pilcuyo',1),('210504','2105','Santa Rosa',1),('210505','2105','Conduriri',1),('210601','2106','Huancane',1),('210602','2106','Cojata',1),('210603','2106','Huatasani',1),('210604','2106','Inchupalla',1),('210605','2106','Pusi',1),('210606','2106','Rosaspata',1),('210607','2106','Taraco',1),('210608','2106','Vilque Chico',1),('210701','2107','Lampa',1),('210702','2107','Cabanilla',1),('210703','2107','Calapuja',1),('210704','2107','Nicasio',1),('210705','2107','Ocuviri',1),('210706','2107','Palca',1),('210707','2107','Paratia',1),('210708','2107','Pucara',1),('210709','2107','Santa Lucia',1),('210710','2107','Vilavila',1),('210801','2108','Ayaviri',1),('210802','2108','Antauta',1),('210803','2108','Cupi',1),('210804','2108','Llalli',1),('210805','2108','Macari',1),('210806','2108','Nuñoa',1),('210807','2108','Orurillo',1),('210808','2108','Santa Rosa',1),('210809','2108','Umachiri',1),('210901','2109','Moho',1),('210902','2109','Conima',1),('210903','2109','Huayrapata',1),('210904','2109','Tilali',1),('211001','2110','Putina',1),('211002','2110','Ananea',1),('211003','2110','Pedro Vilca Apaza',1),('211004','2110','Quilcapuncu',1),('211005','2110','Sina',1),('211101','2111','Juliaca',1),('211102','2111','Cabana',1),('211103','2111','Cabanillas',1),('211104','2111','Caracoto',1),('211105','2111','San Miguel',1),('211201','2112','Sandia',1),('211202','2112','Cuyocuyo',1),('211203','2112','Limbani',1),('211204','2112','Patambuco',1),('211205','2112','Phara',1),('211206','2112','Quiaca',1),('211207','2112','San Juan del Oro',1),('211208','2112','Yanahuaya',1),('211209','2112','Alto Inambari',1),('211210','2112','San Pedro de Putina Punco',1),('211301','2113','Yunguyo',1),('211302','2113','Anapia',1),('211303','2113','Copani',1),('211304','2113','Cuturapi',1),('211305','2113','Ollaraya',1),('211306','2113','Tinicachi',1),('211307','2113','Unicachi',1),('220101','2201','Moyobamba',1),('220102','2201','Calzada',1),('220103','2201','Habana',1),('220104','2201','Jepelacio',1),('220105','2201','Soritor',1),('220106','2201','Yantalo',1),('220201','2202','Bellavista',1),('220202','2202','Alto Biavo',1),('220203','2202','Bajo Biavo',1),('220204','2202','Huallaga',1),('220205','2202','San Pablo',1),('220206','2202','San Rafael',1),('220301','2203','San José de Sisa',1),('220302','2203','Agua Blanca',1),('220303','2203','San Martín',1),('220304','2203','Santa Rosa',1),('220305','2203','Shatoja',1),('220401','2204','Saposoa',1),('220402','2204','Alto Saposoa',1),('220403','2204','El Eslabón',1),('220404','2204','Piscoyacu',1),('220405','2204','Sacanche',1),('220406','2204','Tingo de Saposoa',1),('220501','2205','Lamas',1),('220502','2205','Alonso de Alvarado',1),('220503','2205','Barranquita',1),('220504','2205','Caynarachi',1),('220505','2205','Cuñumbuqui',1),('220506','2205','Pinto Recodo',1),('220507','2205','Rumisapa',1),('220508','2205','San Roque de Cumbaza',1),('220509','2205','Shanao',1),('220510','2205','Tabalosos',1),('220511','2205','Zapatero',1),('220601','2206','Juanjuí',1),('220602','2206','Campanilla',1),('220603','2206','Huicungo',1),('220604','2206','Pachiza',1),('220605','2206','Pajarillo',1),('220701','2207','Picota',1),('220702','2207','Buenos Aires',1),('220703','2207','Caspisapa',1),('220704','2207','Pilluana',1),('220705','2207','Pucacaca',1),('220706','2207','San Cristóbal',1),('220707','2207','San Hilarión',1),('220708','2207','Shamboyacu',1),('220709','2207','Tingo de Ponasa',1),('220710','2207','Tres Unidos',1),('220801','2208','Rioja',1),('220802','2208','Awajun',1),('220803','2208','Elías Soplin Vargas',1),('220804','2208','Nueva Cajamarca',1),('220805','2208','Pardo Miguel',1),('220806','2208','Posic',1),('220807','2208','San Fernando',1),('220808','2208','Yorongos',1),('220809','2208','Yuracyacu',1),('220901','2209','Tarapoto',1),('220902','2209','Alberto Leveau',1),('220903','2209','Cacatachi',1),('220904','2209','Chazuta',1),('220905','2209','Chipurana',1),('220906','2209','El Porvenir',1),('220907','2209','Huimbayoc',1),('220908','2209','Juan Guerra',1),('220909','2209','La Banda de Shilcayo',1),('220910','2209','Morales',1),('220911','2209','Papaplaya',1),('220912','2209','San Antonio',1),('220913','2209','Sauce',1),('220914','2209','Shapaja',1),('221001','2210','Tocache',1),('221002','2210','Nuevo Progreso',1),('221003','2210','Polvora',1),('221004','2210','Shunte',1),('221005','2210','Uchiza',1),('230101','2301','Tacna',1),('230102','2301','Alto de la Alianza',1),('230103','2301','Calana',1),('230104','2301','Ciudad Nueva',1),('230105','2301','Inclan',1),('230106','2301','Pachia',1),('230107','2301','Palca',1),('230108','2301','Pocollay',1),('230109','2301','Sama',1),('230110','2301','Coronel Gregorio Albarracín Lanchipa',1),('230111','2301','La Yarada los Palos',1),('230201','2302','Candarave',1),('230202','2302','Cairani',1),('230203','2302','Camilaca',1),('230204','2302','Curibaya',1),('230205','2302','Huanuara',1),('230206','2302','Quilahuani',1),('230301','2303','Locumba',1),('230302','2303','Ilabaya',1),('230303','2303','Ite',1),('230401','2304','Tarata',1),('230402','2304','Héroes Albarracín',1),('230403','2304','Estique',1),('230404','2304','Estique-Pampa',1),('230405','2304','Sitajara',1),('230406','2304','Susapaya',1),('230407','2304','Tarucachi',1),('230408','2304','Ticaco',1),('240101','2401','Tumbes',1),('240102','2401','Corrales',1),('240103','2401','La Cruz',1),('240104','2401','Pampas de Hospital',1),('240105','2401','San Jacinto',1),('240106','2401','San Juan de la Virgen',1),('240201','2402','Zorritos',1),('240202','2402','Casitas',1),('240203','2402','Canoas de Punta Sal',1),('240301','2403','Zarumilla',1),('240302','2403','Aguas Verdes',1),('240303','2403','Matapalo',1),('240304','2403','Papayal',1),('250101','2501','Calleria',1),('250102','2501','Campoverde',1),('250103','2501','Iparia',1),('250104','2501','Masisea',1),('250105','2501','Yarinacocha',1),('250106','2501','Nueva Requena',1),('250107','2501','Manantay',1),('250201','2502','Raymondi',1),('250202','2502','Sepahua',1),('250203','2502','Tahuania',1),('250204','2502','Yurua',1),('250301','2503','Padre Abad',1),('250302','2503','Irazola',1),('250303','2503','Curimana',1),('250304','2503','Neshuya',1),('250305','2503','Alexander Von Humboldt',1),('250401','2504','Purus',1),('250307','2503','Boqueron',1),('080915','0809','Kumpirushiato',1),('080916','0809','Cielo Punco',1),('080917','0809','Manitea',1),('080918','0809','Megantoni',1),('080919','0809','Union Ashaninka',1),('080914','0809','Megantoni',1),('050511','0505','Oronccoy',1);
/*!40000 ALTER TABLE `districts` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `districts` with 1876 row(s)
--

--
-- Table structure for table `documentary_actions`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documentary_actions` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `description` varchar(250) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documentary_actions`
--

LOCK TABLES `documentary_actions` WRITE;
/*!40000 ALTER TABLE `documentary_actions` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `documentary_actions` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `documentary_actions` with 0 row(s)
--

--
-- Table structure for table `documentary_documents`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documentary_documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `description` varchar(250) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documentary_documents`
--

LOCK TABLES `documentary_documents` WRITE;
/*!40000 ALTER TABLE `documentary_documents` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `documentary_documents` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `documentary_documents` with 0 row(s)
--

--
-- Table structure for table `documentary_files`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documentary_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `documentary_document_id` int(10) unsigned DEFAULT 0,
  `documentary_process_id` int(10) unsigned NOT NULL,
  `number` mediumtext DEFAULT NULL,
  `year` int(10) unsigned NOT NULL,
  `invoice` longtext NOT NULL,
  `date_register` varchar(10) NOT NULL,
  `time_register` varchar(8) NOT NULL,
  `person_id` int(10) unsigned NOT NULL,
  `sender` longtext DEFAULT NULL,
  `subject` longtext DEFAULT NULL,
  `attached_file` longtext DEFAULT NULL,
  `observation` text DEFAULT NULL,
  `status` enum('RECIBIDO','DERIVADO','FINALIZADO','ARCHIVADO') NOT NULL DEFAULT 'RECIBIDO',
  `documentary_office_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Define el ultimo proceso',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `requirements` longtext DEFAULT NULL,
  `is_archive` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'define si el tramite es simplificado',
  `is_simplify` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'define si el tramite es simplificado',
  `documentary_guides_number_status_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Cuando es simplificado, se usará este status',
  `is_completed` tinyint(1) NOT NULL DEFAULT 0,
  `establishment_id` int(10) unsigned NOT NULL DEFAULT 0,
  `date_end` datetime DEFAULT NULL COMMENT 'Fecha de finalización',
  PRIMARY KEY (`id`),
  KEY `documentary_files_documentary_document_id_foreign` (`documentary_document_id`),
  KEY `documentary_files_documentary_process_id_foreign` (`documentary_process_id`),
  KEY `documentary_files_person_id_foreign` (`person_id`),
  KEY `documentary_files_user_id_foreign` (`user_id`),
  CONSTRAINT `documentary_files_documentary_process_id_foreign` FOREIGN KEY (`documentary_process_id`) REFERENCES `documentary_processes` (`id`) ON DELETE CASCADE,
  CONSTRAINT `documentary_files_person_id_foreign` FOREIGN KEY (`person_id`) REFERENCES `persons` (`id`) ON DELETE CASCADE,
  CONSTRAINT `documentary_files_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documentary_files`
--

LOCK TABLES `documentary_files` WRITE;
/*!40000 ALTER TABLE `documentary_files` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `documentary_files` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `documentary_files` with 0 row(s)
--

--
-- Table structure for table `documentary_files_archives`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documentary_files_archives` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'usuario asociado',
  `documentary_file_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Solicitud asociada',
  `documentary_office_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'etapa asociada',
  `observation` longtext DEFAULT NULL COMMENT 'observacion',
  `attached_file` longtext DEFAULT NULL COMMENT 'etapa asociada',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `documentary_guides_number_id` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documentary_files_archives`
--

LOCK TABLES `documentary_files_archives` WRITE;
/*!40000 ALTER TABLE `documentary_files_archives` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `documentary_files_archives` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `documentary_files_archives` with 0 row(s)
--

--
-- Table structure for table `documentary_files_requirements`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documentary_files_requirements` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` longtext DEFAULT NULL COMMENT 'Nombre a mostrar',
  `file` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Define si tiene archivo',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documentary_files_requirements`
--

LOCK TABLES `documentary_files_requirements` WRITE;
/*!40000 ALTER TABLE `documentary_files_requirements` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `documentary_files_requirements` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `documentary_files_requirements` with 0 row(s)
--

--
-- Table structure for table `documentary_file_offices`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documentary_file_offices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `documentary_file_id` int(10) unsigned NOT NULL,
  `documentary_office_id` int(10) unsigned NOT NULL,
  `documentary_action_id` int(10) unsigned NOT NULL DEFAULT 0,
  `status` enum('POR DERIVAR','POR RECIBIR','EN PROCESO','FINALIZADO','ARCHIVADO') NOT NULL DEFAULT 'POR DERIVAR',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `office_name` longtext DEFAULT NULL COMMENT 'Nombre de la etapa',
  `process_name` longtext DEFAULT NULL COMMENT 'Nombre del tramite',
  `documentary_process_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Tramite relacionado',
  `complete` int(11) NOT NULL DEFAULT 0 COMMENT 'Define si la etapa esta completa',
  `start_date` datetime DEFAULT NULL COMMENT 'Fecha de inicio',
  `end_date` datetime DEFAULT NULL COMMENT 'Fecha de finalizacion',
  `days` int(10) unsigned DEFAULT 0 COMMENT 'dias para el tramite',
  `observation` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `documentary_file_offices_documentary_file_id_foreign` (`documentary_file_id`),
  KEY `documentary_file_offices_documentary_office_id_foreign` (`documentary_office_id`),
  KEY `documentary_file_offices_documentary_action_id_foreign` (`documentary_action_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documentary_file_offices`
--

LOCK TABLES `documentary_file_offices` WRITE;
/*!40000 ALTER TABLE `documentary_file_offices` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `documentary_file_offices` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `documentary_file_offices` with 0 row(s)
--

--
-- Table structure for table `documentary_guides_number`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documentary_guides_number` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `doc_file_id` int(10) unsigned DEFAULT 0 COMMENT 'Expediente relacionado',
  `doc_office_id` int(10) unsigned DEFAULT 0 COMMENT 'Etapa observada',
  `guide` longtext DEFAULT NULL COMMENT 'Especifica la guia',
  `origin` longtext DEFAULT NULL COMMENT 'Especifica la instucion',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `date_of_due` datetime DEFAULT NULL,
  `observation` longtext DEFAULT NULL,
  `description` longtext DEFAULT NULL,
  `date_take` datetime DEFAULT NULL COMMENT 'Fecha estimada de finalización',
  `date_end` datetime DEFAULT NULL COMMENT 'Fecha de finalización',
  `documentary_guides_number_status_id` int(10) unsigned DEFAULT 0 COMMENT 'relacionado con documentary_guides_number_status',
  `user_id` int(10) unsigned NOT NULL DEFAULT 0 COMMENT 'Responsable',
  `total_day` int(10) unsigned DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documentary_guides_number`
--

LOCK TABLES `documentary_guides_number` WRITE;
/*!40000 ALTER TABLE `documentary_guides_number` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `documentary_guides_number` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `documentary_guides_number` with 0 row(s)
--

--
-- Table structure for table `documentary_guides_number_status`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documentary_guides_number_status` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `color` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documentary_guides_number_status`
--

LOCK TABLES `documentary_guides_number_status` WRITE;
/*!40000 ALTER TABLE `documentary_guides_number_status` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `documentary_guides_number_status` VALUES (1,'En Calificación',NULL),(2,'Concluidos',NULL),(3,'Observados',NULL),(4,'Archivados',NULL);
/*!40000 ALTER TABLE `documentary_guides_number_status` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `documentary_guides_number_status` with 4 row(s)
--

--
-- Table structure for table `documentary_observation`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documentary_observation` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `doc_file_id` int(10) unsigned DEFAULT 0 COMMENT 'Expediente relacionado',
  `observation` longtext DEFAULT NULL COMMENT 'Conjunto de etapas.',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documentary_observation`
--

LOCK TABLES `documentary_observation` WRITE;
/*!40000 ALTER TABLE `documentary_observation` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `documentary_observation` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `documentary_observation` with 0 row(s)
--

--
-- Table structure for table `documentary_offices`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documentary_offices` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `description` varchar(250) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `days` mediumint(8) unsigned NOT NULL DEFAULT 0,
  `default` tinyint(3) unsigned NOT NULL DEFAULT 0,
  `color` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documentary_offices`
--

LOCK TABLES `documentary_offices` WRITE;
/*!40000 ALTER TABLE `documentary_offices` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `documentary_offices` VALUES (1,'Caja','',1,'2024-11-10 15:18:38','2024-11-10 15:18:38',0,0,NULL),(2,'Procesos','',1,'2024-11-10 15:18:38','2024-11-10 15:18:38',0,0,NULL),(3,'Seguimiento','',1,'2024-11-10 15:18:38','2024-11-10 15:18:38',0,0,NULL),(4,'Validacion','',1,'2024-11-10 15:18:38','2024-11-10 15:18:38',0,0,NULL);
/*!40000 ALTER TABLE `documentary_offices` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `documentary_offices` with 4 row(s)
--

--
-- Table structure for table `documentary_processes`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documentary_processes` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` text NOT NULL,
  `description` text DEFAULT NULL,
  `price` decimal(10,5) NOT NULL DEFAULT 0.00000,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `documentary_offices` longtext DEFAULT NULL COMMENT 'etapas que contiene',
  `documentary_offices_order` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documentary_processes`
--

LOCK TABLES `documentary_processes` WRITE;
/*!40000 ALTER TABLE `documentary_processes` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `documentary_processes` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `documentary_processes` with 0 row(s)
--

--
-- Table structure for table `documentary_processes_rel_file`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documentary_processes_rel_file` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `doc_processes_id` int(10) unsigned DEFAULT 0 COMMENT 'Requerimiento relacionado',
  `doc_file_id` int(10) unsigned DEFAULT 0 COMMENT 'Expediente relacionado',
  `doc_office_id` int(10) unsigned DEFAULT 0 COMMENT 'Etapa actual',
  `stages` longtext DEFAULT NULL COMMENT 'Conjunto de etapas.',
  `complete` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Define si se ha completado',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documentary_processes_rel_file`
--

LOCK TABLES `documentary_processes_rel_file` WRITE;
/*!40000 ALTER TABLE `documentary_processes_rel_file` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `documentary_processes_rel_file` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `documentary_processes_rel_file` with 0 row(s)
--

--
-- Table structure for table `documentary_processes_rel_off`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documentary_processes_rel_off` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `doc_processes_id` int(10) unsigned DEFAULT 0 COMMENT 'Requerimiento relacionado',
  `doc_offices_id` int(10) unsigned DEFAULT 0 COMMENT 'Proceso relacionado',
  `active` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Status de la relacion',
  `order` int(10) unsigned DEFAULT 1 COMMENT 'Establece el orden del proceso',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documentary_processes_rel_off`
--

LOCK TABLES `documentary_processes_rel_off` WRITE;
/*!40000 ALTER TABLE `documentary_processes_rel_off` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `documentary_processes_rel_off` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `documentary_processes_rel_off` with 0 row(s)
--

--
-- Table structure for table `documentary_processes_rel_req`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documentary_processes_rel_req` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `doc_processes_id` int(10) unsigned DEFAULT 0 COMMENT 'Requerimiento relacionado',
  `doc_files_requirements_id` int(10) unsigned DEFAULT 0 COMMENT 'Proceso relacionado',
  `active` tinyint(3) unsigned NOT NULL DEFAULT 0 COMMENT 'Status de la relacion',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documentary_processes_rel_req`
--

LOCK TABLES `documentary_processes_rel_req` WRITE;
/*!40000 ALTER TABLE `documentary_processes_rel_req` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `documentary_processes_rel_req` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `documentary_processes_rel_req` with 0 row(s)
--

--
-- Table structure for table `documents`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `documents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `external_id` char(36) NOT NULL,
  `establishment_id` int(10) unsigned NOT NULL,
  `establishment` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`establishment`)),
  `soap_type_id` char(2) NOT NULL,
  `state_type_id` char(2) NOT NULL,
  `ubl_version` varchar(255) NOT NULL,
  `ticket_single_shipment` tinyint(1) NOT NULL DEFAULT 0,
  `force_send_by_summary` tinyint(1) NOT NULL DEFAULT 0,
  `group_id` char(2) NOT NULL,
  `document_type_id` varchar(255) NOT NULL,
  `series` char(4) NOT NULL,
  `number` int(11) NOT NULL,
  `date_of_issue` date NOT NULL,
  `time_of_issue` time NOT NULL,
  `customer_id` int(10) unsigned NOT NULL,
  `customer` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`customer`)),
  `currency_type_id` varchar(255) NOT NULL,
  `payment_condition_id` varchar(255) DEFAULT NULL,
  `payment_method_type_id` char(2) DEFAULT NULL,
  `purchase_order` varchar(255) DEFAULT NULL,
  `plate_number` varchar(255) DEFAULT NULL,
  `quotation_id` int(10) unsigned DEFAULT NULL,
  `sale_note_id` int(10) unsigned DEFAULT NULL,
  `user_rel_subscription_plan_id` int(10) unsigned DEFAULT 0 COMMENT 'Relacion con suscripciones',
  `technical_service_id` int(10) unsigned DEFAULT NULL,
  `order_note_id` int(10) unsigned DEFAULT NULL,
  `dispatch_id` int(10) unsigned DEFAULT NULL,
  `seller_id` int(10) unsigned DEFAULT NULL,
  `exchange_rate_sale` decimal(13,3) NOT NULL,
  `point_system` tinyint(1) NOT NULL DEFAULT 0 COMMENT 'indica si el documento se uso en sistema por puntos',
  `point_system_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'datos de sistema por puntos' CHECK (json_valid(`point_system_data`)),
  `automatic_date_of_issue` date DEFAULT NULL,
  `type_period` varchar(255) DEFAULT NULL,
  `quantity_period` int(11) DEFAULT NULL,
  `enabled_concurrency` tinyint(3) unsigned DEFAULT 0,
  `apply_concurrency` tinyint(3) unsigned DEFAULT 0,
  `total_prepayment` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_charge` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_discount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_exportation` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_free` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_taxed` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_unaffected` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_exonerated` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_igv` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_igv_free` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_base_isc` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_isc` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_base_other_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_other_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_plastic_bag_taxes` decimal(6,2) NOT NULL DEFAULT 0.00,
  `total_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_value` decimal(12,2) NOT NULL DEFAULT 0.00,
  `subtotal` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total` decimal(12,2) NOT NULL,
  `dispatch_ticket_pdf` tinyint(1) NOT NULL DEFAULT 0,
  `has_prepayment` tinyint(1) NOT NULL DEFAULT 0,
  `affectation_type_prepayment` varchar(255) DEFAULT NULL,
  `was_deducted_prepayment` tinyint(1) NOT NULL DEFAULT 0,
  `pending_amount_prepayment` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_pending_payment` decimal(12,2) NOT NULL DEFAULT 0.00,
  `charges` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`charges`)),
  `discounts` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`discounts`)),
  `prepayments` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`prepayments`)),
  `guides` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`guides`)),
  `related` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`related`)),
  `perception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`perception`)),
  `detraction` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`detraction`)),
  `retention` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`retention`)),
  `legends` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`legends`)),
  `additional_information` text DEFAULT NULL,
  `additional_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`additional_data`)),
  `filename` varchar(255) DEFAULT NULL,
  `unique_filename` varchar(255) DEFAULT NULL,
  `hash` varchar(255) DEFAULT NULL,
  `qr` longtext DEFAULT NULL COMMENT ' ',
  `reference_data` varchar(500) DEFAULT NULL,
  `agent_id` int(10) unsigned DEFAULT NULL,
  `has_xml` tinyint(1) NOT NULL DEFAULT 0,
  `has_pdf` tinyint(1) NOT NULL DEFAULT 0,
  `has_cdr` tinyint(1) NOT NULL DEFAULT 0,
  `data_json` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`data_json`)),
  `send_server` tinyint(1) NOT NULL DEFAULT 1,
  `success_shipping_status` tinyint(1) NOT NULL DEFAULT 0,
  `shipping_status` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`shipping_status`)),
  `success_sunat_shipping_status` tinyint(1) NOT NULL DEFAULT 0,
  `sunat_shipping_status` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`sunat_shipping_status`)),
  `query_status` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`query_status`)),
  `success_query_status` tinyint(1) NOT NULL DEFAULT 0,
  `total_canceled` tinyint(1) NOT NULL DEFAULT 0,
  `soap_shipping_response` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`soap_shipping_response`)),
  `regularize_shipping` tinyint(1) NOT NULL DEFAULT 0,
  `response_regularize_shipping` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`response_regularize_shipping`)),
  `send_to_pse` tinyint(1) NOT NULL DEFAULT 0,
  `response_signature_pse` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`response_signature_pse`)),
  `response_send_cdr_pse` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`response_send_cdr_pse`)),
  `sale_notes_relateds` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL COMMENT 'registros asociados cuando se genera cpe desde multiples notas de venta' CHECK (json_valid(`sale_notes_relateds`)),
  `terms_condition` text DEFAULT NULL,
  `folio` varchar(50) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  `is_editable` tinyint(1) NOT NULL DEFAULT 0,
  `grade` text DEFAULT NULL COMMENT 'Grado designado - utilizado en matricula',
  `section` text DEFAULT NULL COMMENT 'Seccion designado - utilizado en matricula',
  PRIMARY KEY (`id`),
  UNIQUE KEY `documents_series_number_unique` (`soap_type_id`,`document_type_id`,`series`,`number`),
  KEY `documents_user_id_foreign` (`user_id`),
  KEY `documents_establishment_id_foreign` (`establishment_id`),
  KEY `documents_customer_id_foreign` (`customer_id`),
  KEY `documents_state_type_id_foreign` (`state_type_id`),
  KEY `documents_group_id_foreign` (`group_id`),
  KEY `documents_document_type_id_foreign` (`document_type_id`),
  KEY `documents_currency_type_id_foreign` (`currency_type_id`),
  KEY `documents_quotation_id_foreign` (`quotation_id`),
  KEY `documents_external_id_index` (`external_id`),
  KEY `documents_sale_note_id_foreign` (`sale_note_id`),
  KEY `documents_series_index` (`series`),
  KEY `documents_number_index` (`number`),
  KEY `documents_date_of_issue_index` (`date_of_issue`),
  KEY `documents_order_note_id_foreign` (`order_note_id`),
  KEY `documents_payment_method_type_id_foreign` (`payment_method_type_id`),
  KEY `documents_seller_id_foreign` (`seller_id`),
  KEY `documents_payment_condition_id_foreign` (`payment_condition_id`),
  KEY `documents_dispatch_id_foreign` (`dispatch_id`),
  KEY `documents_technical_service_id_foreign` (`technical_service_id`),
  KEY `documents_type_period_index` (`type_period`),
  KEY `documents_regularize_shipping_index` (`regularize_shipping`),
  KEY `documents_ticket_single_shipment_index` (`ticket_single_shipment`),
  KEY `documents_agent_id_foreign` (`agent_id`),
  KEY `documents_force_send_by_summary_index` (`force_send_by_summary`),
  CONSTRAINT `documents_agent_id_foreign` FOREIGN KEY (`agent_id`) REFERENCES `agents` (`id`),
  CONSTRAINT `documents_currency_type_id_foreign` FOREIGN KEY (`currency_type_id`) REFERENCES `cat_currency_types` (`id`),
  CONSTRAINT `documents_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `documents_dispatch_id_foreign` FOREIGN KEY (`dispatch_id`) REFERENCES `dispatches` (`id`),
  CONSTRAINT `documents_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `cat_document_types` (`id`),
  CONSTRAINT `documents_establishment_id_foreign` FOREIGN KEY (`establishment_id`) REFERENCES `establishments` (`id`),
  CONSTRAINT `documents_group_id_foreign` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `documents_order_note_id_foreign` FOREIGN KEY (`order_note_id`) REFERENCES `order_notes` (`id`),
  CONSTRAINT `documents_payment_condition_id_foreign` FOREIGN KEY (`payment_condition_id`) REFERENCES `payment_conditions` (`id`),
  CONSTRAINT `documents_payment_method_type_id_foreign` FOREIGN KEY (`payment_method_type_id`) REFERENCES `payment_method_types` (`id`),
  CONSTRAINT `documents_quotation_id_foreign` FOREIGN KEY (`quotation_id`) REFERENCES `quotations` (`id`),
  CONSTRAINT `documents_sale_note_id_foreign` FOREIGN KEY (`sale_note_id`) REFERENCES `sale_notes` (`id`),
  CONSTRAINT `documents_seller_id_foreign` FOREIGN KEY (`seller_id`) REFERENCES `users` (`id`),
  CONSTRAINT `documents_soap_type_id_foreign` FOREIGN KEY (`soap_type_id`) REFERENCES `soap_types` (`id`),
  CONSTRAINT `documents_state_type_id_foreign` FOREIGN KEY (`state_type_id`) REFERENCES `state_types` (`id`),
  CONSTRAINT `documents_technical_service_id_foreign` FOREIGN KEY (`technical_service_id`) REFERENCES `technical_services` (`id`),
  CONSTRAINT `documents_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `documents`
--

LOCK TABLES `documents` WRITE;
/*!40000 ALTER TABLE `documents` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `documents` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `documents` with 0 row(s)
--

--
-- Table structure for table `document_fee`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `document_fee` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(10) unsigned NOT NULL,
  `date` date NOT NULL,
  `currency_type_id` varchar(255) NOT NULL,
  `amount` decimal(12,2) NOT NULL,
  `payment_method_type_id` char(2) DEFAULT NULL COMMENT 'Relacion con el metodo de pago, Nulo es pago a cuotas',
  PRIMARY KEY (`id`),
  KEY `document_fee_document_id_foreign` (`document_id`),
  KEY `document_fee_currency_type_id_foreign` (`currency_type_id`),
  CONSTRAINT `document_fee_currency_type_id_foreign` FOREIGN KEY (`currency_type_id`) REFERENCES `cat_currency_types` (`id`),
  CONSTRAINT `document_fee_document_id_foreign` FOREIGN KEY (`document_id`) REFERENCES `documents` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `document_fee`
--

LOCK TABLES `document_fee` WRITE;
/*!40000 ALTER TABLE `document_fee` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `document_fee` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `document_fee` with 0 row(s)
--

--
-- Table structure for table `document_hotels`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `document_hotels` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(10) unsigned NOT NULL,
  `number` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `identity_document_type_id` varchar(255) NOT NULL,
  `sex` enum('M','F') NOT NULL,
  `age` int(11) NOT NULL,
  `civil_status` enum('S','C','V','D') NOT NULL,
  `nacionality` varchar(255) NOT NULL,
  `origin` varchar(255) NOT NULL,
  `room_number` int(11) NOT NULL,
  `date_entry` date NOT NULL,
  `time_entry` time NOT NULL,
  `date_exit` date NOT NULL,
  `time_exit` time NOT NULL,
  `ocupation` varchar(255) DEFAULT NULL,
  `room_type` varchar(255) DEFAULT NULL,
  `guests` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`guests`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_hotels_document_id_foreign` (`document_id`),
  KEY `document_hotels_identity_document_type_id_foreign` (`identity_document_type_id`),
  CONSTRAINT `document_hotels_document_id_foreign` FOREIGN KEY (`document_id`) REFERENCES `documents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `document_hotels_identity_document_type_id_foreign` FOREIGN KEY (`identity_document_type_id`) REFERENCES `cat_identity_document_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `document_hotels`
--

LOCK TABLES `document_hotels` WRITE;
/*!40000 ALTER TABLE `document_hotels` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `document_hotels` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `document_hotels` with 0 row(s)
--

--
-- Table structure for table `document_items`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `document_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(10) unsigned NOT NULL,
  `item_id` int(10) unsigned NOT NULL,
  `item` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`item`)),
  `quantity` decimal(12,4) NOT NULL,
  `quantity_factor` decimal(12,4) NOT NULL DEFAULT 1.0000,
  `unit_value` decimal(16,6) NOT NULL,
  `affectation_igv_type_id` varchar(255) NOT NULL,
  `total_base_igv` decimal(12,2) NOT NULL,
  `percentage_igv` decimal(12,2) NOT NULL,
  `total_igv` decimal(12,2) NOT NULL,
  `system_isc_type_id` varchar(255) DEFAULT NULL,
  `total_base_isc` decimal(12,2) NOT NULL DEFAULT 0.00,
  `percentage_isc` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_isc` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_base_other_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `percentage_other_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_other_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_plastic_bag_taxes` decimal(6,2) NOT NULL DEFAULT 0.00,
  `total_taxes` decimal(12,2) NOT NULL,
  `price_type_id` varchar(255) NOT NULL,
  `unit_price` decimal(16,6) NOT NULL,
  `total_value` decimal(12,2) NOT NULL,
  `total_charge` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_discount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total` decimal(12,2) NOT NULL,
  `attributes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`attributes`)),
  `discounts` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`discounts`)),
  `charges` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`charges`)),
  `additional_information` text DEFAULT NULL,
  `warehouse_id` int(10) unsigned DEFAULT NULL,
  `name_product_pdf` longtext DEFAULT NULL,
  `additional_data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`additional_data`)),
  `name_product_xml` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_items_document_id_foreign` (`document_id`),
  KEY `document_items_item_id_foreign` (`item_id`),
  KEY `document_items_affectation_igv_type_id_foreign` (`affectation_igv_type_id`),
  KEY `document_items_system_isc_type_id_foreign` (`system_isc_type_id`),
  KEY `document_items_price_type_id_foreign` (`price_type_id`),
  KEY `document_items_warehouse_id_foreign` (`warehouse_id`),
  CONSTRAINT `document_items_affectation_igv_type_id_foreign` FOREIGN KEY (`affectation_igv_type_id`) REFERENCES `cat_affectation_igv_types` (`id`),
  CONSTRAINT `document_items_document_id_foreign` FOREIGN KEY (`document_id`) REFERENCES `documents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `document_items_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `items` (`id`),
  CONSTRAINT `document_items_price_type_id_foreign` FOREIGN KEY (`price_type_id`) REFERENCES `cat_price_types` (`id`),
  CONSTRAINT `document_items_system_isc_type_id_foreign` FOREIGN KEY (`system_isc_type_id`) REFERENCES `cat_system_isc_types` (`id`),
  CONSTRAINT `document_items_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `document_items`
--

LOCK TABLES `document_items` WRITE;
/*!40000 ALTER TABLE `document_items` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `document_items` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `document_items` with 0 row(s)
--

--
-- Table structure for table `document_payments`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `document_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(10) unsigned NOT NULL,
  `date_of_payment` date NOT NULL,
  `payment_method_type_id` char(2) NOT NULL,
  `has_card` tinyint(1) NOT NULL DEFAULT 0,
  `card_brand_id` char(2) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `payment_received` tinyint(1) DEFAULT NULL,
  `change` decimal(12,2) DEFAULT NULL,
  `payment` decimal(12,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `document_payments_document_id_foreign` (`document_id`),
  KEY `document_payments_card_brand_id_foreign` (`card_brand_id`),
  KEY `document_payments_payment_method_type_id_foreign` (`payment_method_type_id`),
  KEY `document_payments_date_of_payment_index` (`date_of_payment`),
  CONSTRAINT `document_payments_card_brand_id_foreign` FOREIGN KEY (`card_brand_id`) REFERENCES `card_brands` (`id`),
  CONSTRAINT `document_payments_document_id_foreign` FOREIGN KEY (`document_id`) REFERENCES `documents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `document_payments_payment_method_type_id_foreign` FOREIGN KEY (`payment_method_type_id`) REFERENCES `payment_method_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `document_payments`
--

LOCK TABLES `document_payments` WRITE;
/*!40000 ALTER TABLE `document_payments` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `document_payments` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `document_payments` with 0 row(s)
--

--
-- Table structure for table `document_transports`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `document_transports` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `document_id` int(10) unsigned NOT NULL,
  `seat_number` varchar(255) NOT NULL,
  `passenger_manifest` varchar(255) NOT NULL,
  `identity_document_type_id` varchar(255) NOT NULL,
  `number_identity_document` varchar(255) NOT NULL,
  `passenger_fullname` varchar(255) NOT NULL,
  `origin_district_id` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`origin_district_id`)),
  `origin_address` varchar(255) DEFAULT NULL,
  `destinatation_district_id` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`destinatation_district_id`)),
  `destinatation_address` varchar(255) DEFAULT NULL,
  `start_date` date DEFAULT NULL,
  `start_time` time DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `document_transports_document_id_foreign` (`document_id`),
  KEY `document_transports_identity_document_type_id_foreign` (`identity_document_type_id`),
  CONSTRAINT `document_transports_document_id_foreign` FOREIGN KEY (`document_id`) REFERENCES `documents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `document_transports_identity_document_type_id_foreign` FOREIGN KEY (`identity_document_type_id`) REFERENCES `cat_identity_document_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `document_transports`
--

LOCK TABLES `document_transports` WRITE;
/*!40000 ALTER TABLE `document_transports` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `document_transports` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `document_transports` with 0 row(s)
--

--
-- Table structure for table `download_tray`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `download_tray` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned DEFAULT NULL,
  `module` varchar(255) NOT NULL,
  `format` varchar(255) NOT NULL,
  `path` varchar(255) DEFAULT NULL,
  `file_name` varchar(255) DEFAULT NULL,
  `type` varchar(255) DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'IN_PROCESS',
  `date_init` datetime DEFAULT NULL,
  `date_end` datetime DEFAULT NULL,
  `payload_request` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `download_tray_user_id_foreign` (`user_id`),
  CONSTRAINT `download_tray_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `download_tray`
--

LOCK TABLES `download_tray` WRITE;
/*!40000 ALTER TABLE `download_tray` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `download_tray` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `download_tray` with 0 row(s)
--

--
-- Table structure for table `drivers`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `drivers` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `identity_document_type_id` varchar(255) NOT NULL,
  `number` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  `license` varchar(255) NOT NULL,
  `telephone` varchar(255) DEFAULT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  `is_active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `drivers_identity_document_type_id_foreign` (`identity_document_type_id`),
  KEY `drivers_number_index` (`number`),
  KEY `drivers_name_index` (`name`),
  CONSTRAINT `drivers_identity_document_type_id_foreign` FOREIGN KEY (`identity_document_type_id`) REFERENCES `cat_identity_document_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `drivers`
--

LOCK TABLES `drivers` WRITE;
/*!40000 ALTER TABLE `drivers` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `drivers` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `drivers` with 0 row(s)
--

--
-- Table structure for table `email_send_log`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `email_send_log` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `relation_id` int(10) unsigned DEFAULT 0 COMMENT 'Id de modelo',
  `type` int(10) unsigned DEFAULT 0 COMMENT 'Tipo de relacion',
  `relation_model` longtext DEFAULT NULL COMMENT 'Modelo a relacion',
  `file_line` longtext DEFAULT NULL COMMENT 'Archivo qu elo llama',
  `sendit` tinyint(3) unsigned DEFAULT 1 COMMENT 'Booleano para envio de correo',
  `email` text DEFAULT NULL COMMENT 'Correo de destino',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `email_send_log`
--

LOCK TABLES `email_send_log` WRITE;
/*!40000 ALTER TABLE `email_send_log` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `email_send_log` VALUES (1,8,0,'App\\Models\\Tenant\\SaleNote',NULL,0,'diegopotosi23@gmail.com','2024-11-11 10:20:13','2024-11-11 10:20:13'),(2,9,0,'App\\Models\\Tenant\\SaleNote',NULL,0,'diegopotosi23@gmail.com','2024-11-12 19:49:43','2024-11-12 19:49:43'),(3,9,0,'App\\Models\\Tenant\\SaleNote',NULL,0,'diegopotosi23@gmail.com','2024-11-12 19:49:51','2024-11-12 19:49:51'),(4,16,0,'App\\Models\\Tenant\\SaleNote',NULL,0,'dreamteamglobalpc105@gmail.com','2024-11-18 16:02:45','2024-11-18 16:02:45');
/*!40000 ALTER TABLE `email_send_log` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `email_send_log` with 4 row(s)
--

--
-- Table structure for table `establishments`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `establishments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `country_id` char(2) NOT NULL,
  `department_id` char(2) NOT NULL,
  `province_id` char(4) NOT NULL,
  `district_id` char(6) NOT NULL,
  `address` varchar(255) NOT NULL,
  `email` varchar(255) DEFAULT NULL,
  `telephone` varchar(255) NOT NULL,
  `code` varchar(255) NOT NULL,
  `aditional_information` varchar(255) DEFAULT NULL,
  `web_address` varchar(255) DEFAULT NULL,
  `trade_address` varchar(255) DEFAULT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `logo` varchar(150) DEFAULT NULL,
  `template_pdf` varchar(255) NOT NULL DEFAULT 'default',
  `has_igv_31556` tinyint(1) NOT NULL DEFAULT 0,
  `template_ticket_pdf` varchar(255) NOT NULL DEFAULT 'default',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `establishments_country_id_foreign` (`country_id`),
  KEY `establishments_department_id_foreign` (`department_id`),
  KEY `establishments_province_id_foreign` (`province_id`),
  KEY `establishments_district_id_foreign` (`district_id`),
  CONSTRAINT `establishments_country_id_foreign` FOREIGN KEY (`country_id`) REFERENCES `countries` (`id`),
  CONSTRAINT `establishments_department_id_foreign` FOREIGN KEY (`department_id`) REFERENCES `departments` (`id`),
  CONSTRAINT `establishments_district_id_foreign` FOREIGN KEY (`district_id`) REFERENCES `districts` (`id`),
  CONSTRAINT `establishments_province_id_foreign` FOREIGN KEY (`province_id`) REFERENCES `provinces` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `establishments`
--

LOCK TABLES `establishments` WRITE;
/*!40000 ALTER TABLE `establishments` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `establishments` VALUES (1,'BOTICA PRINCIPAL','PE','06','0607','060701','7 de junio 155','ventas@boticamultifarma.com','937781962','0000',NULL,'boticamultifarma.com','7 de junio 155',1,'storage/uploads/logos/1732023177.png','default2',0,'default',NULL,'2024-11-19 08:38:09');
/*!40000 ALTER TABLE `establishments` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `establishments` with 1 row(s)
--

--
-- Table structure for table `exchange_rates`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `exchange_rates` (
  `date` date NOT NULL,
  `sale_original` decimal(13,3) NOT NULL,
  `purchase_original` decimal(13,3) NOT NULL,
  `purchase` decimal(13,3) NOT NULL,
  `sale` decimal(13,3) NOT NULL,
  `date_original` date NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`date`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `exchange_rates`
--

LOCK TABLES `exchange_rates` WRITE;
/*!40000 ALTER TABLE `exchange_rates` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `exchange_rates` VALUES ('2024-11-10',3.769,3.764,3.764,3.769,'2024-11-08','2024-11-10 15:24:25','2024-11-10 15:24:25'),('2024-11-11',3.769,3.764,3.764,3.769,'2024-11-08','2024-11-11 10:09:34','2024-11-11 10:09:34'),('2024-11-12',3.781,3.766,3.766,3.781,'2024-11-11','2024-11-12 00:27:27','2024-11-12 00:27:27'),('2024-11-13',3.788,3.781,3.781,3.788,'2024-11-12','2024-11-13 09:00:05','2024-11-13 09:00:05'),('2024-11-14',3.800,3.795,3.795,3.800,'2024-11-13','2024-11-14 13:40:40','2024-11-14 13:40:40'),('2024-11-15',3.805,3.798,3.798,3.805,'2024-11-14','2024-11-15 17:59:35','2024-11-15 17:59:35'),('2024-11-16',3.807,3.799,3.799,3.807,'2024-11-15','2024-11-16 23:48:31','2024-11-16 23:48:31'),('2024-11-17',3.807,3.799,3.799,3.807,'2024-11-15','2024-11-17 00:04:28','2024-11-17 00:04:28'),('2024-11-18',3.807,3.799,3.799,3.807,'2024-11-15','2024-11-18 10:08:33','2024-11-18 10:08:33'),('2024-11-19',3.799,3.789,3.789,3.799,'2024-11-18','2024-11-19 08:07:11','2024-11-19 08:07:11'),('2024-11-20',3.798,3.791,3.791,3.798,'2024-11-19','2024-11-20 22:38:25','2024-11-20 22:38:25'),('2024-11-21',3.798,3.792,3.792,3.798,'2024-11-20','2024-11-21 07:09:28','2024-11-21 07:09:28'),('2024-11-22',3.797,3.791,3.791,3.797,'2024-11-21','2024-11-22 11:41:17','2024-11-22 11:41:17'),('2024-11-24',3.798,3.785,3.785,3.798,'2024-11-22','2024-11-24 21:24:12','2024-11-24 21:24:12'),('2024-12-03',3.766,3.746,3.746,3.766,'2024-12-02','2024-12-03 10:38:31','2024-12-03 10:38:31'),('2024-12-04',3.749,3.737,3.737,3.749,'2024-12-03','2024-12-04 14:47:44','2024-12-04 14:47:44'),('2024-12-07',3.727,3.719,3.719,3.727,'2024-12-06','2024-12-07 13:44:42','2024-12-07 13:44:42'),('2024-12-11',3.718,3.705,3.705,3.718,'2024-12-10','2024-12-11 22:53:04','2024-12-11 22:53:04'),('2024-12-16',3.737,3.732,3.732,3.737,'2024-12-13','2024-12-16 09:49:28','2024-12-16 09:49:28'),('2024-12-20',3.743,3.734,3.734,3.743,'2024-12-19','2024-12-20 12:04:15','2024-12-20 12:04:15'),('2024-12-26',3.731,3.718,3.718,3.731,'2024-12-24','2024-12-26 16:04:26','2024-12-26 16:04:26'),('2024-12-27',3.748,3.738,3.738,3.748,'2024-12-26','2024-12-27 10:47:09','2024-12-27 10:47:09'),('2024-12-31',3.770,3.758,3.758,3.770,'2024-12-30','2024-12-31 18:31:16','2024-12-31 18:31:16'),('2025-01-08',3.772,3.767,3.767,3.772,'2025-01-07','2025-01-08 23:47:19','2025-01-08 23:47:19'),('2025-01-10',3.769,3.765,3.765,3.769,'2025-01-09','2025-01-10 10:02:15','2025-01-10 10:02:15'),('2025-01-12',3.769,3.762,3.762,3.769,'2025-01-10','2025-01-12 09:32:32','2025-01-12 09:32:32'),('2025-01-13',3.769,3.762,3.762,3.769,'2025-01-10','2025-01-13 07:19:37','2025-01-13 07:19:37'),('2025-01-14',3.785,3.774,3.774,3.785,'2025-01-13','2025-01-14 07:07:38','2025-01-14 07:07:38'),('2025-01-15',3.778,3.773,3.773,3.778,'2025-01-14','2025-01-15 07:57:58','2025-01-15 07:57:58'),('2025-01-16',3.768,3.761,3.761,3.768,'2025-01-15','2025-01-16 07:33:20','2025-01-16 07:33:20'),('2025-01-17',3.769,3.764,3.764,3.769,'2025-01-16','2025-01-17 08:14:17','2025-01-17 08:14:17'),('2025-01-18',3.752,3.743,3.743,3.752,'2025-01-17','2025-01-18 07:11:06','2025-01-18 07:11:06'),('2025-01-19',3.752,3.743,3.743,3.752,'2025-01-17','2025-01-19 07:27:08','2025-01-19 07:27:08'),('2025-01-20',3.752,3.743,3.743,3.752,'2025-01-17','2025-01-20 07:31:14','2025-01-20 07:31:14'),('2025-01-21',3.742,3.728,3.728,3.742,'2025-01-20','2025-01-21 08:24:19','2025-01-21 08:24:19'),('2025-01-22',3.735,3.727,3.727,3.735,'2025-01-21','2025-01-22 07:37:10','2025-01-22 07:37:10'),('2025-01-23',3.724,3.718,3.718,3.724,'2025-01-22','2025-01-23 07:17:00','2025-01-23 07:17:00'),('2025-01-24',3.717,3.710,3.710,3.717,'2025-01-23','2025-01-24 07:29:17','2025-01-24 07:29:17'),('2025-01-25',3.716,3.706,3.706,3.716,'2025-01-24','2025-01-25 10:37:16','2025-01-25 10:37:16'),('2025-01-26',3.716,3.706,3.706,3.716,'2025-01-24','2025-01-26 07:40:38','2025-01-26 07:40:38'),('2025-01-27',3.716,3.706,3.706,3.716,'2025-01-24','2025-01-27 08:22:58','2025-01-27 08:22:58'),('2025-01-28',3.742,3.735,3.735,3.742,'2025-01-27','2025-01-28 07:20:58','2025-01-28 07:20:58'),('2025-01-29',3.743,3.737,3.737,3.743,'2025-01-28','2025-01-29 07:40:20','2025-01-29 07:40:20'),('2025-01-30',3.728,3.721,3.721,3.728,'2025-01-29','2025-01-30 07:26:27','2025-01-30 07:26:27'),('2025-01-31',3.720,3.712,3.712,3.720,'2025-01-30','2025-01-31 07:13:59','2025-01-31 07:13:59'),('2025-02-01',3.728,3.715,3.715,3.728,'2025-01-31','2025-02-01 07:11:06','2025-02-01 07:11:06'),('2025-02-02',3.728,3.715,3.715,3.728,'2025-01-31','2025-02-02 07:49:49','2025-02-02 07:49:49'),('2025-02-03',3.728,3.715,3.715,3.728,'2025-01-31','2025-02-03 07:29:04','2025-02-03 07:29:04'),('2025-02-04',3.722,3.713,3.713,3.722,'2025-02-03','2025-02-04 15:42:02','2025-02-04 15:42:02'),('2025-02-05',3.712,3.701,3.701,3.712,'2025-02-04','2025-02-05 07:25:19','2025-02-05 07:25:19'),('2025-02-06',3.720,3.712,3.712,3.720,'2025-02-05','2025-02-06 14:54:07','2025-02-06 14:54:07'),('2025-02-07',3.715,3.708,3.708,3.715,'2025-02-06','2025-02-07 09:01:16','2025-02-07 09:01:16'),('2025-02-08',3.718,3.709,3.709,3.718,'2025-02-07','2025-02-08 07:27:01','2025-02-08 07:27:01'),('2025-02-09',3.718,3.709,3.709,3.718,'2025-02-07','2025-02-09 08:35:47','2025-02-09 08:35:47'),('2025-02-10',3.718,3.709,3.709,3.718,'2025-02-07','2025-02-10 08:06:37','2025-02-10 08:06:37'),('2025-02-11',3.719,3.707,3.707,3.719,'2025-02-10','2025-02-11 10:11:19','2025-02-11 10:11:19'),('2025-02-12',3.714,3.708,3.708,3.714,'2025-02-11','2025-02-12 12:07:37','2025-02-12 12:07:37'),('2025-02-13',3.714,3.709,3.709,3.714,'2025-02-12','2025-02-13 07:34:54','2025-02-13 07:34:54'),('2025-02-14',3.719,3.714,3.714,3.719,'2025-02-13','2025-02-14 07:20:55','2025-02-14 07:20:55'),('2025-02-15',3.712,3.702,3.702,3.712,'2025-02-14','2025-02-15 08:15:09','2025-02-15 08:15:09'),('2025-02-16',3.712,3.702,3.702,3.712,'2025-02-14','2025-02-16 07:30:06','2025-02-16 07:30:06'),('2025-02-17',3.712,3.702,3.702,3.712,'2025-02-14','2025-02-17 07:50:41','2025-02-17 07:50:41'),('2025-02-18',3.708,3.693,3.693,3.708,'2025-02-17','2025-02-18 07:20:31','2025-02-18 07:20:31');
/*!40000 ALTER TABLE `exchange_rates` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `exchange_rates` with 63 row(s)
--

--
-- Table structure for table `expenses`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expenses` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `soap_type_id` char(2) DEFAULT NULL,
  `expense_type_id` int(10) unsigned NOT NULL,
  `establishment_id` int(10) unsigned NOT NULL,
  `supplier_id` int(10) unsigned NOT NULL,
  `expense_reason_id` int(10) unsigned NOT NULL DEFAULT 1,
  `currency_type_id` varchar(255) NOT NULL,
  `external_id` char(36) NOT NULL,
  `state_type_id` char(255) DEFAULT NULL,
  `number` varchar(255) DEFAULT NULL,
  `date_of_issue` date NOT NULL,
  `time_of_issue` time NOT NULL,
  `supplier` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`supplier`)),
  `exchange_rate_sale` decimal(13,3) NOT NULL,
  `total` decimal(12,2) NOT NULL,
  `filename` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `expenses_filename_unique` (`filename`),
  KEY `expenses_user_id_foreign` (`user_id`),
  KEY `expenses_establishment_id_foreign` (`establishment_id`),
  KEY `expenses_supplier_id_foreign` (`supplier_id`),
  KEY `expenses_expense_type_id_foreign` (`expense_type_id`),
  KEY `expenses_currency_type_id_foreign` (`currency_type_id`),
  KEY `expenses_expense_reason_id_foreign` (`expense_reason_id`),
  KEY `expenses_soap_type_id_foreign` (`soap_type_id`),
  KEY `expenses_state_type_id_foreign` (`state_type_id`),
  CONSTRAINT `expenses_currency_type_id_foreign` FOREIGN KEY (`currency_type_id`) REFERENCES `cat_currency_types` (`id`),
  CONSTRAINT `expenses_establishment_id_foreign` FOREIGN KEY (`establishment_id`) REFERENCES `establishments` (`id`),
  CONSTRAINT `expenses_expense_reason_id_foreign` FOREIGN KEY (`expense_reason_id`) REFERENCES `expense_reasons` (`id`),
  CONSTRAINT `expenses_expense_type_id_foreign` FOREIGN KEY (`expense_type_id`) REFERENCES `expense_types` (`id`),
  CONSTRAINT `expenses_soap_type_id_foreign` FOREIGN KEY (`soap_type_id`) REFERENCES `soap_types` (`id`),
  CONSTRAINT `expenses_state_type_id_foreign` FOREIGN KEY (`state_type_id`) REFERENCES `state_types` (`id`),
  CONSTRAINT `expenses_supplier_id_foreign` FOREIGN KEY (`supplier_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `expenses_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expenses`
--

LOCK TABLES `expenses` WRITE;
/*!40000 ALTER TABLE `expenses` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `expenses` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `expenses` with 0 row(s)
--

--
-- Table structure for table `expense_items`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `expense_id` int(10) unsigned NOT NULL,
  `description` varchar(255) NOT NULL,
  `total` decimal(12,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_items_expense_id_foreign` (`expense_id`),
  CONSTRAINT `expense_items_expense_id_foreign` FOREIGN KEY (`expense_id`) REFERENCES `expenses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expense_items`
--

LOCK TABLES `expense_items` WRITE;
/*!40000 ALTER TABLE `expense_items` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `expense_items` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `expense_items` with 0 row(s)
--

--
-- Table structure for table `expense_method_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_method_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `has_card` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expense_method_types`
--

LOCK TABLES `expense_method_types` WRITE;
/*!40000 ALTER TABLE `expense_method_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `expense_method_types` VALUES (1,'CAJA GENERAL',0),(2,'Tarjeta de crédito',1),(3,'Tarjeta de débito',1);
/*!40000 ALTER TABLE `expense_method_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `expense_method_types` with 3 row(s)
--

--
-- Table structure for table `expense_payments`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `expense_id` int(10) unsigned NOT NULL,
  `date_of_payment` date NOT NULL,
  `expense_method_type_id` int(10) unsigned NOT NULL,
  `has_card` tinyint(1) NOT NULL DEFAULT 0,
  `card_brand_id` char(2) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `payment` decimal(12,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `expense_payments_expense_id_foreign` (`expense_id`),
  KEY `expense_payments_card_brand_id_foreign` (`card_brand_id`),
  KEY `expense_payments_expense_method_type_id_foreign` (`expense_method_type_id`),
  KEY `expense_payments_date_of_payment_index` (`date_of_payment`),
  CONSTRAINT `expense_payments_card_brand_id_foreign` FOREIGN KEY (`card_brand_id`) REFERENCES `card_brands` (`id`),
  CONSTRAINT `expense_payments_expense_id_foreign` FOREIGN KEY (`expense_id`) REFERENCES `expenses` (`id`) ON DELETE CASCADE,
  CONSTRAINT `expense_payments_expense_method_type_id_foreign` FOREIGN KEY (`expense_method_type_id`) REFERENCES `expense_method_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expense_payments`
--

LOCK TABLES `expense_payments` WRITE;
/*!40000 ALTER TABLE `expense_payments` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `expense_payments` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `expense_payments` with 0 row(s)
--

--
-- Table structure for table `expense_reasons`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_reasons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expense_reasons`
--

LOCK TABLES `expense_reasons` WRITE;
/*!40000 ALTER TABLE `expense_reasons` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `expense_reasons` VALUES (1,'Varios'),(2,'Representación de la organización'),(3,'Trabajo de campo');
/*!40000 ALTER TABLE `expense_reasons` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `expense_reasons` with 3 row(s)
--

--
-- Table structure for table `expense_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `expense_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=5 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `expense_types`
--

LOCK TABLES `expense_types` WRITE;
/*!40000 ALTER TABLE `expense_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `expense_types` VALUES (1,'PLANILLA','2024-11-10 15:18:25','2024-11-10 15:18:25'),(2,'RECIBO POR HONORARIO','2024-11-10 15:18:25','2024-11-10 15:18:25'),(3,'SERVICIO PÚBLICO','2024-11-10 15:18:25','2024-11-10 15:18:25'),(4,'OTROS','2024-11-10 15:18:25','2024-11-10 15:18:25');
/*!40000 ALTER TABLE `expense_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `expense_types` with 4 row(s)
--

--
-- Table structure for table `fixed_asset_items`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fixed_asset_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `description` varchar(255) DEFAULT NULL,
  `item_type_id` char(2) NOT NULL,
  `internal_id` varchar(255) DEFAULT NULL,
  `unit_type_id` varchar(255) NOT NULL,
  `currency_type_id` varchar(255) NOT NULL,
  `purchase_unit_price` decimal(16,6) NOT NULL,
  `purchase_affectation_igv_type_id` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fixed_asset_items_item_type_id_foreign` (`item_type_id`),
  KEY `fixed_asset_items_unit_type_id_foreign` (`unit_type_id`),
  KEY `fixed_asset_items_currency_type_id_foreign` (`currency_type_id`),
  KEY `fixed_asset_items_purchase_affectation_igv_type_id_foreign` (`purchase_affectation_igv_type_id`),
  CONSTRAINT `fixed_asset_items_currency_type_id_foreign` FOREIGN KEY (`currency_type_id`) REFERENCES `cat_currency_types` (`id`),
  CONSTRAINT `fixed_asset_items_item_type_id_foreign` FOREIGN KEY (`item_type_id`) REFERENCES `item_types` (`id`),
  CONSTRAINT `fixed_asset_items_purchase_affectation_igv_type_id_foreign` FOREIGN KEY (`purchase_affectation_igv_type_id`) REFERENCES `cat_affectation_igv_types` (`id`),
  CONSTRAINT `fixed_asset_items_unit_type_id_foreign` FOREIGN KEY (`unit_type_id`) REFERENCES `cat_unit_types` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fixed_asset_items`
--

LOCK TABLES `fixed_asset_items` WRITE;
/*!40000 ALTER TABLE `fixed_asset_items` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `fixed_asset_items` VALUES (1,'SILLA','SILLA DE MI BOTICA','01','1','NIU','PEN',30.000000,'12','2024-11-12 20:22:46','2024-11-12 20:22:46');
/*!40000 ALTER TABLE `fixed_asset_items` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `fixed_asset_items` with 1 row(s)
--

--
-- Table structure for table `fixed_asset_purchases`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fixed_asset_purchases` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `external_id` char(36) NOT NULL,
  `establishment_id` int(10) unsigned NOT NULL,
  `soap_type_id` char(2) NOT NULL,
  `state_type_id` char(2) NOT NULL,
  `group_id` char(2) NOT NULL,
  `document_type_id` varchar(255) NOT NULL,
  `series` char(4) NOT NULL,
  `number` int(11) NOT NULL,
  `date_of_issue` date NOT NULL,
  `date_of_due` date DEFAULT NULL,
  `time_of_issue` time NOT NULL,
  `supplier_id` int(10) unsigned NOT NULL,
  `supplier` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`supplier`)),
  `currency_type_id` varchar(255) NOT NULL,
  `exchange_rate_sale` decimal(13,3) NOT NULL,
  `total_prepayment` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_charge` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_discount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_exportation` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_free` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_taxed` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_unaffected` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_exonerated` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_igv` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_base_isc` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_isc` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_base_other_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_other_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_value` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total` decimal(12,2) NOT NULL,
  `customer_id` int(10) unsigned DEFAULT NULL,
  `perception_date` date DEFAULT NULL,
  `perception_number` int(11) DEFAULT NULL,
  `total_perception` decimal(12,2) DEFAULT NULL,
  `charges` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`charges`)),
  `discounts` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`discounts`)),
  `prepayments` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`prepayments`)),
  `guides` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`guides`)),
  `related` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`related`)),
  `perception` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`perception`)),
  `detraction` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`detraction`)),
  `legends` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`legends`)),
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `fixed_asset_purchases_user_id_foreign` (`user_id`),
  KEY `fixed_asset_purchases_establishment_id_foreign` (`establishment_id`),
  KEY `fixed_asset_purchases_supplier_id_foreign` (`supplier_id`),
  KEY `fixed_asset_purchases_customer_id_foreign` (`customer_id`),
  KEY `fixed_asset_purchases_soap_type_id_foreign` (`soap_type_id`),
  KEY `fixed_asset_purchases_state_type_id_foreign` (`state_type_id`),
  KEY `fixed_asset_purchases_group_id_foreign` (`group_id`),
  KEY `fixed_asset_purchases_document_type_id_foreign` (`document_type_id`),
  KEY `fixed_asset_purchases_currency_type_id_foreign` (`currency_type_id`),
  CONSTRAINT `fixed_asset_purchases_currency_type_id_foreign` FOREIGN KEY (`currency_type_id`) REFERENCES `cat_currency_types` (`id`),
  CONSTRAINT `fixed_asset_purchases_customer_id_foreign` FOREIGN KEY (`customer_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fixed_asset_purchases_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `cat_document_types` (`id`),
  CONSTRAINT `fixed_asset_purchases_establishment_id_foreign` FOREIGN KEY (`establishment_id`) REFERENCES `establishments` (`id`),
  CONSTRAINT `fixed_asset_purchases_group_id_foreign` FOREIGN KEY (`group_id`) REFERENCES `groups` (`id`),
  CONSTRAINT `fixed_asset_purchases_soap_type_id_foreign` FOREIGN KEY (`soap_type_id`) REFERENCES `soap_types` (`id`),
  CONSTRAINT `fixed_asset_purchases_state_type_id_foreign` FOREIGN KEY (`state_type_id`) REFERENCES `state_types` (`id`),
  CONSTRAINT `fixed_asset_purchases_supplier_id_foreign` FOREIGN KEY (`supplier_id`) REFERENCES `persons` (`id`),
  CONSTRAINT `fixed_asset_purchases_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fixed_asset_purchases`
--

LOCK TABLES `fixed_asset_purchases` WRITE;
/*!40000 ALTER TABLE `fixed_asset_purchases` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `fixed_asset_purchases` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `fixed_asset_purchases` with 0 row(s)
--

--
-- Table structure for table `fixed_asset_purchase_items`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `fixed_asset_purchase_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `fixed_asset_purchase_id` int(10) unsigned NOT NULL,
  `fixed_asset_item_id` int(10) unsigned NOT NULL,
  `item` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL CHECK (json_valid(`item`)),
  `quantity` decimal(12,4) NOT NULL,
  `unit_value` decimal(16,6) NOT NULL,
  `affectation_igv_type_id` varchar(255) NOT NULL,
  `total_base_igv` decimal(12,2) NOT NULL,
  `percentage_igv` decimal(12,2) NOT NULL,
  `total_igv` decimal(12,2) NOT NULL,
  `system_isc_type_id` varchar(255) DEFAULT NULL,
  `total_base_isc` decimal(12,2) NOT NULL DEFAULT 0.00,
  `percentage_isc` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_isc` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_base_other_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `percentage_other_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_other_taxes` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_taxes` decimal(12,2) NOT NULL,
  `price_type_id` varchar(255) NOT NULL,
  `unit_price` decimal(16,6) NOT NULL,
  `total_value` decimal(12,2) NOT NULL,
  `total_charge` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total_discount` decimal(12,2) NOT NULL DEFAULT 0.00,
  `total` decimal(12,2) NOT NULL,
  `attributes` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`attributes`)),
  `discounts` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`discounts`)),
  `charges` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`charges`)),
  PRIMARY KEY (`id`),
  KEY `fixed_asset_purchase_items_fixed_asset_purchase_id_foreign` (`fixed_asset_purchase_id`),
  KEY `fixed_asset_purchase_items_fixed_asset_item_id_foreign` (`fixed_asset_item_id`),
  KEY `fixed_asset_purchase_items_affectation_igv_type_id_foreign` (`affectation_igv_type_id`),
  KEY `fixed_asset_purchase_items_system_isc_type_id_foreign` (`system_isc_type_id`),
  KEY `fixed_asset_purchase_items_price_type_id_foreign` (`price_type_id`),
  CONSTRAINT `fixed_asset_purchase_items_affectation_igv_type_id_foreign` FOREIGN KEY (`affectation_igv_type_id`) REFERENCES `cat_affectation_igv_types` (`id`),
  CONSTRAINT `fixed_asset_purchase_items_fixed_asset_item_id_foreign` FOREIGN KEY (`fixed_asset_item_id`) REFERENCES `fixed_asset_items` (`id`),
  CONSTRAINT `fixed_asset_purchase_items_fixed_asset_purchase_id_foreign` FOREIGN KEY (`fixed_asset_purchase_id`) REFERENCES `fixed_asset_purchases` (`id`) ON DELETE CASCADE,
  CONSTRAINT `fixed_asset_purchase_items_price_type_id_foreign` FOREIGN KEY (`price_type_id`) REFERENCES `cat_price_types` (`id`),
  CONSTRAINT `fixed_asset_purchase_items_system_isc_type_id_foreign` FOREIGN KEY (`system_isc_type_id`) REFERENCES `cat_system_isc_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `fixed_asset_purchase_items`
--

LOCK TABLES `fixed_asset_purchase_items` WRITE;
/*!40000 ALTER TABLE `fixed_asset_purchase_items` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `fixed_asset_purchase_items` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `fixed_asset_purchase_items` with 0 row(s)
--

--
-- Table structure for table `format_templates`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `format_templates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `formats` varchar(255) NOT NULL,
  `urls` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_bin DEFAULT NULL CHECK (json_valid(`urls`)),
  `is_custom_ticket` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=81 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `format_templates`
--

LOCK TABLES `format_templates` WRITE;
/*!40000 ALTER TABLE `format_templates` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `format_templates` VALUES (1,'center_note','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/center_note/image.png\"}',0),(2,'umbrella_state','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default/image.png\"}',0),(3,'blank','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/blank/image.png\"}',0),(4,'con_valor_unitario','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/con_valor_unitario/image.png\"}',0),(5,'item_desc','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/item_desc/image.png\"}',0),(6,'unit_price','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/unit_price/image.png\"}',0),(7,'dispatch_place_2','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/dispatch_place_2/image.png\"}',0),(8,'modelw80','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/modelw80/image.png\"}',0),(9,'default3','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default3/image.png\"}',0),(10,'full_height','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/full_height/image.png\"}',0),(11,'font_sm','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/font_sm/image.png\"}',0),(12,'legend_amazonia_2','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/legend_amazonia_2/image.png\"}',0),(13,'image_logo_titles','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/image_logo_titles/image.png\"}',0),(14,'partials','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default/image.png\"}',0),(15,'defaultGreen','{\"guide\": \"templates/pdf/defaultGreen/image_guide.png\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default/image.png\"}',0),(16,'internal_code','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/internal_code/image.png\"}',0),(17,'item_description','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/item_description/image.png\"}',0),(18,'default2','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default2/image.png\"}',0),(19,'customer_contact_with_subtotal','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/customer_contact_with_subtotal/image.png\"}',0),(20,'citec','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/citec/image.png\"}',0),(21,'default','{\"guide\": \"\", \"ticket\": \"templates/pdf/default/ticket.png\", \"invoice\": \"templates/pdf/default/image.png\"}',1),(22,'fr_item_desc','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default/image.png\"}',0),(23,'default4','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default4/image.png\"}',0),(24,'default3_596','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default3_596/image.png\"}',0),(25,'distpatch_pharmacy','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default/image.png\"}',0),(26,'ticket_c','{\"guide\": \"\", \"ticket\": \"templates/pdf/ticket_c/ticket.png\", \"invoice\": \"templates/pdf/default/image.png\"}',1),(27,'internal_code_contact','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/internal_code_contact/image.png\"}',0),(28,'jazmar','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/jazmar/image.png\"}',0),(29,'default3_new_account','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default3_new_account/image.png\"}',0),(30,'model2','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/model2/image.png\"}',0),(31,'customer_contact','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/customer_contact/image.png\"}',0),(32,'dispatch_brand','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default/image.png\"}',0),(33,'default_date_end','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default_date_end/image.png\"}',0),(34,'multiples_logos','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/multiples_logos/image.png\"}',0),(35,'wsc','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/wsc/image.png\"}',0),(36,'ticket_name_tradename','{\"guide\": \"\", \"ticket\": \"templates/pdf/ticket_name_tradename/ticket.png\", \"invoice\": \"templates/pdf/default/image.png\"}',1),(37,'model4','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/model4/image.png\"}',0),(38,'school','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/school/image.png\"}',0),(39,'top_ruc','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/top_ruc/image.png\"}',0),(40,'model3','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/model3/image.png\"}',0),(41,'model1','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/model1/image.png\"}',0),(42,'ticket_58','{\"guide\": \"\", \"ticket\": \"templates/pdf/ticket_58/ticket.png\", \"invoice\": \"templates/pdf/ticket_58/image.png\"}',1),(43,'table_square_edges','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/table_square_edges/image.png\"}',0),(44,'dispatch_place','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/dispatch_place/image.png\"}',0),(45,'top_logo_company','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/top_logo_company/image.png\"}',0),(46,'top_placa','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/top_placa/image.png\"}',0),(47,'ticket_internal_code','{\"guide\": \"\", \"ticket\": \"templates/pdf/ticket_internal_code/ticket.png\", \"invoice\": \"templates/pdf/default/image.png\"}',1),(48,'rich_text','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/rich_text/image.png\"}',0),(49,'default3_new_unit_value','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default3_new_unit_value/image.png\"}',0),(50,'item_watermark','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/item_watermark/image.png\"}',0),(51,'header_image_full_width','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/header_image_full_width/image.png\"}',0),(52,'default_lote_fven_serie','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default_lote_fven_serie/image.png\"}',0),(53,'datetime','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/datetime/image.png\"}',0),(54,'unit_types_desc','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/unit_types_desc/image.png\"}',0),(55,'custom','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/custom/image.png\"}',0),(56,'default_brand_as_lab','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default_brand_as_lab/image.png\"}',0),(57,'technical','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/technical/image.png\"}',0),(58,'legend_amazonia','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/legend_amazonia/image.png\"}',0),(59,'default3_banks','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default3_banks/image.png\"}',0),(60,'internal_code_2','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/internal_code_2/image.png\"}',0),(61,'custom_multisaba','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/custom_multisaba/image.png\"}',0),(62,'full_height_ticket','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/full_height_ticket/image.png\"}',0),(63,'rounded','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/rounded/image.png\"}',0),(64,'ticket_b','{\"guide\": \"\", \"ticket\": \"templates/pdf/ticket_b/ticket.png\", \"invoice\": \"templates/pdf/default/image.png\"}',1),(65,'default5','{\"guide\": \"templates/pdf/default5/image_guide.png\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default/image.png\"}',0),(66,'top_ruc_logo','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/top_ruc_logo/image.png\"}',0),(67,'default3_new','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default3_new/image.png\"}',0),(68,'default_brand','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default_brand/image.png\"}',0),(69,'santiago','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/santiago/image.png\"}',0),(70,'default3_911','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default3_911/image.png\"}',0),(71,'ticket_d','{\"guide\": \"\", \"ticket\": \"templates/pdf/ticket_d/ticket.png\", \"invoice\": \"templates/pdf/default/image.png\"}',1),(72,'brand','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/brand/image.png\"}',0),(73,'jc','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/jc/image.png\"}',0),(74,'static','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default/image.png\"}',0),(75,'default3_929','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default3_929/image.png\"}',0),(76,'doble_print','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/doble_print/image.png\"}',0),(77,'no_igv','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/no_igv/image.png\"}',0),(78,'custom_gasolution','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/custom_gasolution/image.png\"}',0),(79,'doble_print_unilac','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/default/image.png\"}',0),(80,'font_swz','{\"guide\": \"\", \"ticket\": \"\", \"invoice\": \"templates/pdf/font_swz/image.png\"}',0);
/*!40000 ALTER TABLE `format_templates` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `format_templates` with 80 row(s)
--

--
-- Table structure for table `full_subscription_server_data`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `full_subscription_server_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(10) unsigned DEFAULT 0,
  `host` varchar(255) DEFAULT NULL,
  `ip` varchar(45) DEFAULT NULL,
  `user` varchar(255) DEFAULT NULL,
  `password` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `full_subscription_server_data`
--

LOCK TABLES `full_subscription_server_data` WRITE;
/*!40000 ALTER TABLE `full_subscription_server_data` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `full_subscription_server_data` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `full_subscription_server_data` with 0 row(s)
--

--
-- Table structure for table `full_subscription_user_data`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `full_subscription_user_data` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `person_id` int(10) unsigned DEFAULT 0,
  `discord_user` varchar(255) DEFAULT NULL,
  `slack_channel` varchar(255) DEFAULT NULL,
  `discord_channel` varchar(255) DEFAULT NULL,
  `gitlab_user` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `full_subscription_user_data`
--

LOCK TABLES `full_subscription_user_data` WRITE;
/*!40000 ALTER TABLE `full_subscription_user_data` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `full_subscription_user_data` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `full_subscription_user_data` with 0 row(s)
--

--
-- Table structure for table `general_payment_conditions`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `general_payment_conditions` (
  `id` varchar(255) NOT NULL,
  `name` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `general_payment_conditions`
--

LOCK TABLES `general_payment_conditions` WRITE;
/*!40000 ALTER TABLE `general_payment_conditions` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `general_payment_conditions` VALUES ('01','Contado'),('02','Crédito'),('03','Crédito con cuotas');
/*!40000 ALTER TABLE `general_payment_conditions` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `general_payment_conditions` with 3 row(s)
--

--
-- Table structure for table `global_payments`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `global_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `soap_type_id` char(2) NOT NULL,
  `destination_id` int(11) DEFAULT NULL,
  `destination_type` varchar(255) NOT NULL,
  `payment_id` int(11) NOT NULL,
  `payment_type` varchar(255) NOT NULL,
  `user_id` int(10) unsigned DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `destination_index` (`destination_id`,`destination_type`),
  KEY `payment_index` (`payment_id`,`payment_type`),
  KEY `global_payments_soap_type_id_foreign` (`soap_type_id`),
  KEY `global_payments_user_id_foreign` (`user_id`),
  CONSTRAINT `global_payments_soap_type_id_foreign` FOREIGN KEY (`soap_type_id`) REFERENCES `soap_types` (`id`),
  CONSTRAINT `global_payments_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1455 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `global_payments`
--

LOCK TABLES `global_payments` WRITE;
/*!40000 ALTER TABLE `global_payments` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `global_payments` VALUES (1,'03',1,'Modules\\Cash\\Models\\Cash',1,'Modules\\Pos\\Models\\CashTransaction',1,'2024-11-10 15:24:15','2024-11-10 15:24:15'),(3,'03',1,'Modules\\Cash\\Models\\Cash',1,'Modules\\SaleNote\\Models\\SaleNotePayment',1,'2024-11-10 15:24:41','2024-11-10 15:24:41'),(4,'03',1,'Modules\\Cash\\Models\\Cash',2,'Modules\\SaleNote\\Models\\SaleNotePayment',1,'2024-11-10 18:57:25','2024-11-10 18:57:25'),(7,'03',1,'Modules\\Cash\\Models\\Cash',5,'Modules\\SaleNote\\Models\\SaleNotePayment',1,'2024-11-10 19:11:40','2024-11-10 19:11:40'),(8,'03',1,'Modules\\Cash\\Models\\Cash',6,'Modules\\SaleNote\\Models\\SaleNotePayment',1,'2024-11-10 19:37:03','2024-11-10 19:37:03'),(9,'03',1,'Modules\\Cash\\Models\\Cash',7,'Modules\\SaleNote\\Models\\SaleNotePayment',1,'2024-11-11 10:19:12','2024-11-11 10:19:12'),(10,'03',1,'Modules\\Cash\\Models\\Cash',8,'Modules\\SaleNote\\Models\\SaleNotePayment',1,'2024-11-11 10:20:06','2024-11-11 10:20:06'),(13,'03',2,'Modules\\Cash\\Models\\Cash',9,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2024-11-12 19:48:38','2024-11-12 19:48:38'),(14,'03',2,'Modules\\Cash\\Models\\Cash',10,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2024-11-14 14:05:37','2024-11-14 14:05:37'),(15,'03',2,'Modules\\Cash\\Models\\Cash',11,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2024-11-14 14:11:24','2024-11-14 14:11:24'),(16,'03',2,'Modules\\Cash\\Models\\Cash',12,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2024-11-14 14:16:24','2024-11-14 14:16:24'),(19,'03',2,'Modules\\Cash\\Models\\Cash',13,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2024-11-14 14:32:48','2024-11-14 14:32:48'),(20,'01',2,'Modules\\Cash\\Models\\Cash',14,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2024-11-18 10:12:00','2024-11-18 10:12:00'),(22,'01',4,'Modules\\Cash\\Models\\Cash',4,'Modules\\Pos\\Models\\CashTransaction',3,'2024-11-18 15:12:21','2024-11-18 15:12:21'),(23,'01',4,'Modules\\Cash\\Models\\Cash',15,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2024-11-18 16:02:00','2024-11-18 16:02:00'),(24,'01',2,'Modules\\Cash\\Models\\Cash',16,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2024-11-18 16:19:29','2024-11-18 16:19:29'),(26,'01',2,'Modules\\Cash\\Models\\Cash',17,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2024-11-18 16:49:31','2024-11-18 16:49:31'),(28,'01',2,'Modules\\Cash\\Models\\Cash',18,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2024-11-18 17:41:59','2024-11-18 17:41:59'),(29,'01',1,'Modules\\Cash\\Models\\Cash',1,'Modules\\Pos\\Models\\CashTransaction',2,'2024-11-19 08:36:16','2024-11-19 08:36:16'),(32,'01',1,'Modules\\Cash\\Models\\Cash',1,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2024-11-19 08:38:31','2024-11-19 08:38:31'),(33,'01',1,'Modules\\Cash\\Models\\Cash',9,'Modules\\Document\\Models\\DocumentPayment',2,'2024-11-19 08:43:42','2024-11-19 08:43:42'),(34,'01',1,'Modules\\Cash\\Models\\Cash',10,'Modules\\Document\\Models\\DocumentPayment',2,'2024-11-19 08:44:10','2024-11-19 08:44:10'),(35,'01',1,'Modules\\Cash\\Models\\Cash',11,'Modules\\Document\\Models\\DocumentPayment',2,'2024-11-19 08:46:41','2024-11-19 08:46:41'),(36,'01',1,'Modules\\Cash\\Models\\Cash',2,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2024-11-19 08:47:43','2024-11-19 08:47:43'),(37,'01',1,'Modules\\Cash\\Models\\Cash',12,'Modules\\Document\\Models\\DocumentPayment',2,'2024-11-19 08:48:31','2024-11-19 08:48:31'),(38,'01',1,'Modules\\Cash\\Models\\Cash',3,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2024-11-19 09:01:59','2024-11-19 09:01:59'),(39,'01',1,'Modules\\Cash\\Models\\Cash',4,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2024-11-19 09:08:52','2024-11-19 09:08:52'),(40,'01',1,'Modules\\Cash\\Models\\Cash',5,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2024-11-19 09:10:35','2024-11-19 09:10:35'),(41,'01',1,'Modules\\Cash\\Models\\Cash',6,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2024-11-19 13:27:55','2024-11-19 13:27:55'),(42,'01',1,'Modules\\Cash\\Models\\Cash',7,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2024-11-19 13:33:03','2024-11-19 13:33:03'),(44,'01',1,'Modules\\Cash\\Models\\Cash',1,'Modules\\Pos\\Models\\CashTransaction',1,'2025-01-08 23:53:03','2025-01-08 23:53:03'),(46,'01',2,'Modules\\Cash\\Models\\Cash',1,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2025-01-10 10:05:57','2025-01-10 10:05:57'),(47,'01',2,'Modules\\Cash\\Models\\Cash',2,'Modules\\SaleNote\\Models\\SaleNotePayment',2,'2025-01-10 10:20:30','2025-01-10 10:20:30'),(48,'01',1,'Modules\\Cash\\Models\\Cash',1,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-10 11:31:02','2025-01-10 11:31:02'),(49,'01',1,'Modules\\Cash\\Models\\Cash',3,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-10 12:36:09','2025-01-10 12:36:09'),(50,'01',1,'Modules\\Cash\\Models\\Cash',1,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 09:43:36','2025-01-12 09:43:36'),(51,'01',1,'Modules\\Cash\\Models\\Cash',2,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 09:56:38','2025-01-12 09:56:38'),(52,'01',1,'Modules\\Cash\\Models\\Cash',3,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 10:18:50','2025-01-12 10:18:50'),(53,'01',1,'Modules\\Cash\\Models\\Cash',4,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 10:40:40','2025-01-12 10:40:40'),(54,'01',1,'Modules\\Cash\\Models\\Cash',5,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 11:02:06','2025-01-12 11:02:06'),(55,'01',1,'Modules\\Cash\\Models\\Cash',6,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 11:36:56','2025-01-12 11:36:56'),(56,'01',1,'Modules\\Cash\\Models\\Cash',7,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 11:40:56','2025-01-12 11:40:56'),(57,'01',1,'Modules\\Cash\\Models\\Cash',8,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 12:12:28','2025-01-12 12:12:28'),(58,'01',1,'Modules\\Cash\\Models\\Cash',9,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 12:42:55','2025-01-12 12:42:55'),(59,'01',1,'Modules\\Cash\\Models\\Cash',10,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 13:20:22','2025-01-12 13:20:22'),(60,'01',1,'Modules\\Cash\\Models\\Cash',11,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 13:20:58','2025-01-12 13:20:58'),(61,'01',1,'Modules\\Cash\\Models\\Cash',12,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 13:22:56','2025-01-12 13:22:56'),(62,'01',1,'Modules\\Cash\\Models\\Cash',13,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 13:23:39','2025-01-12 13:23:39'),(63,'01',1,'Modules\\Cash\\Models\\Cash',14,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 13:30:17','2025-01-12 13:30:17'),(64,'01',1,'Modules\\Cash\\Models\\Cash',15,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 13:34:09','2025-01-12 13:34:09'),(65,'01',1,'Modules\\Cash\\Models\\Cash',16,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 14:14:28','2025-01-12 14:14:28'),(66,'01',1,'Modules\\Cash\\Models\\Cash',17,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 14:49:57','2025-01-12 14:49:57'),(67,'01',1,'Modules\\Cash\\Models\\Cash',18,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 15:15:34','2025-01-12 15:15:34'),(68,'01',1,'Modules\\Cash\\Models\\Cash',19,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 15:22:34','2025-01-12 15:22:34'),(69,'01',1,'Modules\\Cash\\Models\\Cash',20,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 17:38:17','2025-01-12 17:38:17'),(70,'01',1,'Modules\\Cash\\Models\\Cash',21,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 18:19:50','2025-01-12 18:19:50'),(71,'01',1,'Modules\\Cash\\Models\\Cash',22,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 18:35:33','2025-01-12 18:35:33'),(72,'01',1,'Modules\\Cash\\Models\\Cash',23,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 18:40:08','2025-01-12 18:40:08'),(73,'01',1,'Modules\\Cash\\Models\\Cash',24,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 18:56:18','2025-01-12 18:56:18'),(74,'01',1,'Modules\\Cash\\Models\\Cash',25,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 19:41:00','2025-01-12 19:41:00'),(75,'01',1,'Modules\\Cash\\Models\\Cash',26,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 20:01:57','2025-01-12 20:01:57'),(76,'01',1,'Modules\\Cash\\Models\\Cash',27,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 20:24:38','2025-01-12 20:24:38'),(77,'01',1,'Modules\\Cash\\Models\\Cash',28,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 20:26:48','2025-01-12 20:26:48'),(78,'01',1,'Modules\\Cash\\Models\\Cash',29,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 20:47:21','2025-01-12 20:47:21'),(79,'01',1,'Modules\\Cash\\Models\\Cash',30,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 20:55:10','2025-01-12 20:55:10'),(80,'01',1,'Modules\\Cash\\Models\\Cash',31,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 21:10:50','2025-01-12 21:10:50'),(81,'01',1,'Modules\\Cash\\Models\\Cash',32,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 21:43:55','2025-01-12 21:43:55'),(82,'01',1,'Modules\\Cash\\Models\\Cash',33,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 21:44:16','2025-01-12 21:44:16'),(83,'01',1,'Modules\\Cash\\Models\\Cash',34,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 21:45:37','2025-01-12 21:45:37'),(84,'01',1,'Modules\\Cash\\Models\\Cash',35,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 21:51:41','2025-01-12 21:51:41'),(85,'01',1,'Modules\\Cash\\Models\\Cash',36,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-12 22:01:01','2025-01-12 22:01:01'),(87,'01',2,'Modules\\Cash\\Models\\Cash',37,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 07:54:40','2025-01-13 07:54:40'),(88,'01',2,'Modules\\Cash\\Models\\Cash',38,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 08:05:58','2025-01-13 08:05:58'),(89,'01',2,'Modules\\Cash\\Models\\Cash',39,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 08:47:15','2025-01-13 08:47:15'),(90,'01',2,'Modules\\Cash\\Models\\Cash',40,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 10:21:50','2025-01-13 10:21:50'),(91,'01',2,'Modules\\Cash\\Models\\Cash',41,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 10:22:13','2025-01-13 10:22:13'),(92,'01',2,'Modules\\Cash\\Models\\Cash',42,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 10:25:14','2025-01-13 10:25:14'),(94,'01',2,'Modules\\Cash\\Models\\Cash',4,'Modules\\Pos\\Models\\CashTransaction',1,'2025-01-13 10:34:40','2025-01-13 10:34:40'),(95,'01',2,'Modules\\Cash\\Models\\Cash',43,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 10:58:38','2025-01-13 10:58:38'),(96,'01',2,'Modules\\Cash\\Models\\Cash',44,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 12:11:49','2025-01-13 12:11:49'),(97,'01',2,'Modules\\Cash\\Models\\Cash',45,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 12:12:19','2025-01-13 12:12:19'),(98,'01',2,'Modules\\Cash\\Models\\Cash',46,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 13:14:35','2025-01-13 13:14:35'),(99,'01',2,'Modules\\Cash\\Models\\Cash',47,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 13:15:05','2025-01-13 13:15:05'),(100,'01',2,'Modules\\Cash\\Models\\Cash',48,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 13:55:32','2025-01-13 13:55:32'),(101,'01',2,'Modules\\Cash\\Models\\Cash',49,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 14:25:39','2025-01-13 14:25:39'),(102,'01',2,'Modules\\Cash\\Models\\Cash',50,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 15:41:30','2025-01-13 15:41:30'),(103,'01',2,'Modules\\Cash\\Models\\Cash',51,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 15:43:05','2025-01-13 15:43:05'),(104,'01',2,'Modules\\Cash\\Models\\Cash',52,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 16:37:10','2025-01-13 16:37:10'),(105,'01',2,'Modules\\Cash\\Models\\Cash',53,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 17:13:17','2025-01-13 17:13:17'),(106,'01',2,'Modules\\Cash\\Models\\Cash',54,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 17:14:30','2025-01-13 17:14:30'),(107,'01',2,'Modules\\Cash\\Models\\Cash',55,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 18:47:16','2025-01-13 18:47:16'),(108,'01',2,'Modules\\Cash\\Models\\Cash',56,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 18:47:57','2025-01-13 18:47:57'),(109,'01',2,'Modules\\Cash\\Models\\Cash',57,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 19:26:09','2025-01-13 19:26:09'),(110,'01',2,'Modules\\Cash\\Models\\Cash',58,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 19:26:34','2025-01-13 19:26:34'),(111,'01',2,'Modules\\Cash\\Models\\Cash',59,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 19:27:07','2025-01-13 19:27:07'),(112,'01',2,'Modules\\Cash\\Models\\Cash',60,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 20:06:35','2025-01-13 20:06:35'),(113,'01',2,'Modules\\Cash\\Models\\Cash',61,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 20:08:30','2025-01-13 20:08:30'),(114,'01',2,'Modules\\Cash\\Models\\Cash',62,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 20:30:14','2025-01-13 20:30:14'),(115,'01',2,'Modules\\Cash\\Models\\Cash',63,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 20:37:13','2025-01-13 20:37:13'),(116,'01',2,'Modules\\Cash\\Models\\Cash',64,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 20:38:07','2025-01-13 20:38:07'),(117,'01',2,'Modules\\Cash\\Models\\Cash',65,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 20:38:49','2025-01-13 20:38:49'),(118,'01',2,'Modules\\Cash\\Models\\Cash',66,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 20:45:50','2025-01-13 20:45:50'),(119,'01',2,'Modules\\Cash\\Models\\Cash',67,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 20:50:51','2025-01-13 20:50:51'),(120,'01',2,'Modules\\Cash\\Models\\Cash',68,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 22:01:00','2025-01-13 22:01:00'),(121,'01',2,'Modules\\Cash\\Models\\Cash',69,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-13 22:25:28','2025-01-13 22:25:28'),(122,'01',3,'Modules\\Cash\\Models\\Cash',5,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-14 07:12:55','2025-01-14 07:12:55'),(124,'01',4,'Modules\\Cash\\Models\\Cash',70,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 07:56:31','2025-01-14 07:56:31'),(125,'01',4,'Modules\\Cash\\Models\\Cash',71,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 08:23:39','2025-01-14 08:23:39'),(126,'01',4,'Modules\\Cash\\Models\\Cash',72,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 08:25:50','2025-01-14 08:25:50'),(127,'01',4,'Modules\\Cash\\Models\\Cash',73,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 08:26:27','2025-01-14 08:26:27'),(128,'01',4,'Modules\\Cash\\Models\\Cash',74,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 08:27:44','2025-01-14 08:27:44'),(129,'01',4,'Modules\\Cash\\Models\\Cash',75,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 08:48:13','2025-01-14 08:48:13'),(130,'01',4,'Modules\\Cash\\Models\\Cash',76,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 09:57:17','2025-01-14 09:57:17'),(131,'01',4,'Modules\\Cash\\Models\\Cash',77,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 10:17:10','2025-01-14 10:17:10'),(132,'01',4,'Modules\\Cash\\Models\\Cash',78,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 10:39:59','2025-01-14 10:39:59'),(133,'01',4,'Modules\\Cash\\Models\\Cash',79,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 10:51:54','2025-01-14 10:51:54'),(134,'01',4,'Modules\\Cash\\Models\\Cash',80,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 11:03:59','2025-01-14 11:03:59'),(135,'01',4,'Modules\\Cash\\Models\\Cash',81,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 11:30:44','2025-01-14 11:30:44'),(136,'01',4,'Modules\\Cash\\Models\\Cash',7,'Modules\\Pos\\Models\\CashTransaction',2,'2025-01-14 11:35:43','2025-01-14 11:35:43'),(137,'01',5,'Modules\\Cash\\Models\\Cash',8,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-14 11:58:00','2025-01-14 11:58:00'),(138,'01',5,'Modules\\Cash\\Models\\Cash',93,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 12:05:36','2025-01-14 12:05:36'),(139,'01',5,'Modules\\Cash\\Models\\Cash',94,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 12:18:24','2025-01-14 12:18:24'),(140,'01',5,'Modules\\Cash\\Models\\Cash',95,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 12:30:50','2025-01-14 12:30:50'),(141,'01',5,'Modules\\Cash\\Models\\Cash',96,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 12:38:23','2025-01-14 12:38:23'),(142,'01',5,'Modules\\Cash\\Models\\Cash',97,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 12:39:11','2025-01-14 12:39:11'),(143,'01',5,'Modules\\Cash\\Models\\Cash',98,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 12:43:43','2025-01-14 12:43:43'),(144,'01',5,'Modules\\Cash\\Models\\Cash',99,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 12:44:08','2025-01-14 12:44:08'),(145,'01',5,'Modules\\Cash\\Models\\Cash',100,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 12:50:35','2025-01-14 12:50:35'),(146,'01',5,'Modules\\Cash\\Models\\Cash',101,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 13:06:20','2025-01-14 13:06:20'),(147,'01',5,'Modules\\Cash\\Models\\Cash',102,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 13:30:06','2025-01-14 13:30:06'),(148,'01',5,'Modules\\Cash\\Models\\Cash',103,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 13:38:34','2025-01-14 13:38:34'),(149,'01',5,'Modules\\Cash\\Models\\Cash',104,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 14:04:10','2025-01-14 14:04:10'),(150,'01',5,'Modules\\Cash\\Models\\Cash',105,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 14:14:01','2025-01-14 14:14:01'),(151,'01',5,'Modules\\Cash\\Models\\Cash',106,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 14:17:44','2025-01-14 14:17:44'),(152,'01',6,'Modules\\Cash\\Models\\Cash',9,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-14 14:40:51','2025-01-14 14:40:51'),(153,'01',6,'Modules\\Cash\\Models\\Cash',107,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 15:25:09','2025-01-14 15:25:09'),(154,'01',6,'Modules\\Cash\\Models\\Cash',108,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 15:36:32','2025-01-14 15:36:32'),(155,'01',6,'Modules\\Cash\\Models\\Cash',109,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 15:57:29','2025-01-14 15:57:29'),(156,'01',6,'Modules\\Cash\\Models\\Cash',110,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 16:23:20','2025-01-14 16:23:20'),(157,'01',6,'Modules\\Cash\\Models\\Cash',111,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 17:08:22','2025-01-14 17:08:22'),(158,'01',6,'Modules\\Cash\\Models\\Cash',112,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 17:09:56','2025-01-14 17:09:56'),(159,'01',6,'Modules\\Cash\\Models\\Cash',113,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 17:16:28','2025-01-14 17:16:28'),(160,'01',6,'Modules\\Cash\\Models\\Cash',114,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 18:26:58','2025-01-14 18:26:58'),(161,'01',6,'Modules\\Cash\\Models\\Cash',115,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 18:27:24','2025-01-14 18:27:24'),(162,'01',6,'Modules\\Cash\\Models\\Cash',116,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 18:42:33','2025-01-14 18:42:33'),(163,'01',6,'Modules\\Cash\\Models\\Cash',117,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 18:54:56','2025-01-14 18:54:56'),(164,'01',6,'Modules\\Cash\\Models\\Cash',118,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 19:07:18','2025-01-14 19:07:18'),(165,'01',6,'Modules\\Cash\\Models\\Cash',119,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 19:22:31','2025-01-14 19:22:31'),(166,'01',6,'Modules\\Cash\\Models\\Cash',120,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 19:26:40','2025-01-14 19:26:40'),(167,'01',6,'Modules\\Cash\\Models\\Cash',121,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 19:50:25','2025-01-14 19:50:25'),(168,'01',6,'Modules\\Cash\\Models\\Cash',122,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 20:07:30','2025-01-14 20:07:30'),(169,'01',6,'Modules\\Cash\\Models\\Cash',123,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 20:17:38','2025-01-14 20:17:38'),(170,'01',6,'Modules\\Cash\\Models\\Cash',124,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 20:18:02','2025-01-14 20:18:02'),(171,'01',6,'Modules\\Cash\\Models\\Cash',125,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 20:23:12','2025-01-14 20:23:12'),(172,'01',6,'Modules\\Cash\\Models\\Cash',126,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 20:36:08','2025-01-14 20:36:08'),(173,'01',6,'Modules\\Cash\\Models\\Cash',127,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 20:36:33','2025-01-14 20:36:33'),(174,'01',6,'Modules\\Cash\\Models\\Cash',128,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 20:36:58','2025-01-14 20:36:58'),(175,'01',6,'Modules\\Cash\\Models\\Cash',129,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 21:15:28','2025-01-14 21:15:28'),(176,'01',6,'Modules\\Cash\\Models\\Cash',130,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 21:21:52','2025-01-14 21:21:52'),(177,'01',6,'Modules\\Cash\\Models\\Cash',131,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-14 22:21:51','2025-01-14 22:21:51'),(178,'01',7,'Modules\\Cash\\Models\\Cash',10,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-15 07:57:40','2025-01-15 07:57:40'),(179,'01',7,'Modules\\Cash\\Models\\Cash',132,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 07:59:15','2025-01-15 07:59:15'),(180,'01',7,'Modules\\Cash\\Models\\Cash',133,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 08:41:34','2025-01-15 08:41:34'),(181,'01',7,'Modules\\Cash\\Models\\Cash',134,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 09:47:39','2025-01-15 09:47:39'),(182,'01',7,'Modules\\Cash\\Models\\Cash',135,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 12:27:15','2025-01-15 12:27:15'),(183,'01',7,'Modules\\Cash\\Models\\Cash',136,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 13:08:29','2025-01-15 13:08:29'),(184,'01',7,'Modules\\Cash\\Models\\Cash',137,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 14:08:25','2025-01-15 14:08:25'),(185,'01',7,'Modules\\Cash\\Models\\Cash',138,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 14:16:46','2025-01-15 14:16:46'),(186,'01',8,'Modules\\Cash\\Models\\Cash',11,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-15 14:35:08','2025-01-15 14:35:08'),(187,'01',8,'Modules\\Cash\\Models\\Cash',139,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 16:50:22','2025-01-15 16:50:22'),(188,'01',8,'Modules\\Cash\\Models\\Cash',140,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 17:56:08','2025-01-15 17:56:08'),(189,'01',8,'Modules\\Cash\\Models\\Cash',141,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 18:05:48','2025-01-15 18:05:48'),(190,'01',8,'Modules\\Cash\\Models\\Cash',142,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 19:22:03','2025-01-15 19:22:03'),(191,'01',8,'Modules\\Cash\\Models\\Cash',143,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 19:45:45','2025-01-15 19:45:45'),(192,'01',8,'Modules\\Cash\\Models\\Cash',144,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 19:52:10','2025-01-15 19:52:10'),(193,'01',8,'Modules\\Cash\\Models\\Cash',145,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 20:01:55','2025-01-15 20:01:55'),(194,'01',8,'Modules\\Cash\\Models\\Cash',146,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 20:08:46','2025-01-15 20:08:46'),(195,'01',8,'Modules\\Cash\\Models\\Cash',147,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 21:04:04','2025-01-15 21:04:04'),(196,'01',8,'Modules\\Cash\\Models\\Cash',148,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 21:09:18','2025-01-15 21:09:18'),(197,'01',8,'Modules\\Cash\\Models\\Cash',149,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 21:09:50','2025-01-15 21:09:50'),(198,'01',8,'Modules\\Cash\\Models\\Cash',150,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 21:15:09','2025-01-15 21:15:09'),(199,'01',8,'Modules\\Cash\\Models\\Cash',151,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 21:16:58','2025-01-15 21:16:58'),(200,'01',8,'Modules\\Cash\\Models\\Cash',152,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 21:28:11','2025-01-15 21:28:11'),(201,'01',8,'Modules\\Cash\\Models\\Cash',153,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 21:49:47','2025-01-15 21:49:47'),(202,'01',8,'Modules\\Cash\\Models\\Cash',154,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 21:50:16','2025-01-15 21:50:16'),(203,'01',8,'Modules\\Cash\\Models\\Cash',155,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 21:52:01','2025-01-15 21:52:01'),(204,'01',8,'Modules\\Cash\\Models\\Cash',156,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 21:57:52','2025-01-15 21:57:52'),(205,'01',8,'Modules\\Cash\\Models\\Cash',157,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-15 22:09:47','2025-01-15 22:09:47'),(206,'01',9,'Modules\\Cash\\Models\\Cash',12,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-16 07:26:27','2025-01-16 07:26:27'),(207,'01',9,'Modules\\Cash\\Models\\Cash',158,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 09:56:41','2025-01-16 09:56:41'),(208,'01',9,'Modules\\Cash\\Models\\Cash',159,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 13:55:28','2025-01-16 13:55:28'),(209,'01',10,'Modules\\Cash\\Models\\Cash',13,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-16 14:31:35','2025-01-16 14:31:35'),(210,'01',10,'Modules\\Cash\\Models\\Cash',160,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 14:46:53','2025-01-16 14:46:53'),(211,'01',10,'Modules\\Cash\\Models\\Cash',161,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 15:10:56','2025-01-16 15:10:56'),(212,'01',10,'Modules\\Cash\\Models\\Cash',162,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 15:53:23','2025-01-16 15:53:23'),(213,'01',10,'Modules\\Cash\\Models\\Cash',163,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 16:09:13','2025-01-16 16:09:13'),(214,'01',10,'Modules\\Cash\\Models\\Cash',164,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 16:48:45','2025-01-16 16:48:45'),(215,'01',10,'Modules\\Cash\\Models\\Cash',165,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 18:20:05','2025-01-16 18:20:05'),(216,'01',10,'Modules\\Cash\\Models\\Cash',166,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 18:20:22','2025-01-16 18:20:22'),(217,'01',10,'Modules\\Cash\\Models\\Cash',167,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 18:20:42','2025-01-16 18:20:42'),(218,'01',10,'Modules\\Cash\\Models\\Cash',168,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 18:21:57','2025-01-16 18:21:57'),(219,'01',10,'Modules\\Cash\\Models\\Cash',169,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 18:22:19','2025-01-16 18:22:19'),(220,'01',10,'Modules\\Cash\\Models\\Cash',170,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 19:18:32','2025-01-16 19:18:32'),(221,'01',10,'Modules\\Cash\\Models\\Cash',171,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 19:37:53','2025-01-16 19:37:53'),(222,'01',10,'Modules\\Cash\\Models\\Cash',172,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 19:49:18','2025-01-16 19:49:18'),(223,'01',10,'Modules\\Cash\\Models\\Cash',173,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 20:03:09','2025-01-16 20:03:09'),(224,'01',10,'Modules\\Cash\\Models\\Cash',174,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 20:03:50','2025-01-16 20:03:50'),(225,'01',10,'Modules\\Cash\\Models\\Cash',175,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 20:18:04','2025-01-16 20:18:04'),(226,'01',10,'Modules\\Cash\\Models\\Cash',176,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 20:18:19','2025-01-16 20:18:19'),(227,'01',10,'Modules\\Cash\\Models\\Cash',177,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 20:48:42','2025-01-16 20:48:42'),(228,'01',10,'Modules\\Cash\\Models\\Cash',178,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 21:06:40','2025-01-16 21:06:40'),(229,'01',10,'Modules\\Cash\\Models\\Cash',179,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 22:13:47','2025-01-16 22:13:47'),(230,'01',10,'Modules\\Cash\\Models\\Cash',180,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 22:14:40','2025-01-16 22:14:40'),(231,'01',10,'Modules\\Cash\\Models\\Cash',181,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 22:33:30','2025-01-16 22:33:30'),(232,'01',10,'Modules\\Cash\\Models\\Cash',182,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-16 22:34:18','2025-01-16 22:34:18'),(233,'01',11,'Modules\\Cash\\Models\\Cash',14,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-17 08:14:07','2025-01-17 08:14:07'),(234,'01',11,'Modules\\Cash\\Models\\Cash',183,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 08:18:49','2025-01-17 08:18:49'),(235,'01',11,'Modules\\Cash\\Models\\Cash',184,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 09:21:05','2025-01-17 09:21:05'),(236,'01',11,'Modules\\Cash\\Models\\Cash',185,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 10:16:19','2025-01-17 10:16:19'),(237,'01',11,'Modules\\Cash\\Models\\Cash',186,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 11:12:40','2025-01-17 11:12:40'),(238,'01',11,'Modules\\Cash\\Models\\Cash',187,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 11:27:36','2025-01-17 11:27:36'),(239,'01',11,'Modules\\Cash\\Models\\Cash',188,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 13:01:22','2025-01-17 13:01:22'),(240,'01',11,'Modules\\Cash\\Models\\Cash',189,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 13:12:54','2025-01-17 13:12:54'),(241,'01',11,'Modules\\Cash\\Models\\Cash',190,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 13:22:37','2025-01-17 13:22:37'),(242,'01',11,'Modules\\Cash\\Models\\Cash',191,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 14:16:12','2025-01-17 14:16:12'),(243,'01',12,'Modules\\Cash\\Models\\Cash',15,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-17 14:32:01','2025-01-17 14:32:01'),(244,'01',12,'Modules\\Cash\\Models\\Cash',192,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 16:05:42','2025-01-17 16:05:42'),(245,'01',12,'Modules\\Cash\\Models\\Cash',193,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 16:10:04','2025-01-17 16:10:04'),(246,'01',12,'Modules\\Cash\\Models\\Cash',194,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 16:16:50','2025-01-17 16:16:50'),(247,'01',12,'Modules\\Cash\\Models\\Cash',195,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 16:18:36','2025-01-17 16:18:36'),(248,'01',12,'Modules\\Cash\\Models\\Cash',196,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 16:56:11','2025-01-17 16:56:11'),(249,'01',12,'Modules\\Cash\\Models\\Cash',197,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 17:33:16','2025-01-17 17:33:16'),(250,'01',12,'Modules\\Cash\\Models\\Cash',198,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 18:19:17','2025-01-17 18:19:17'),(251,'01',12,'Modules\\Cash\\Models\\Cash',199,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 18:22:33','2025-01-17 18:22:33'),(252,'01',12,'Modules\\Cash\\Models\\Cash',200,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 19:15:18','2025-01-17 19:15:18'),(253,'01',12,'Modules\\Cash\\Models\\Cash',201,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 19:15:42','2025-01-17 19:15:42'),(254,'01',12,'Modules\\Cash\\Models\\Cash',202,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:14:25','2025-01-17 21:14:25'),(255,'01',12,'Modules\\Cash\\Models\\Cash',203,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:15:46','2025-01-17 21:15:46'),(256,'01',12,'Modules\\Cash\\Models\\Cash',204,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:16:42','2025-01-17 21:16:42'),(257,'01',12,'Modules\\Cash\\Models\\Cash',205,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:17:06','2025-01-17 21:17:06'),(258,'01',12,'Modules\\Cash\\Models\\Cash',206,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:17:33','2025-01-17 21:17:33'),(259,'01',12,'Modules\\Cash\\Models\\Cash',207,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:18:12','2025-01-17 21:18:12'),(260,'01',12,'Modules\\Cash\\Models\\Cash',208,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:18:41','2025-01-17 21:18:41'),(261,'01',12,'Modules\\Cash\\Models\\Cash',209,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:20:04','2025-01-17 21:20:04'),(262,'01',12,'Modules\\Cash\\Models\\Cash',210,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:20:20','2025-01-17 21:20:20'),(263,'01',12,'Modules\\Cash\\Models\\Cash',211,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:20:44','2025-01-17 21:20:44'),(264,'01',12,'Modules\\Cash\\Models\\Cash',212,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:22:54','2025-01-17 21:22:54'),(265,'01',12,'Modules\\Cash\\Models\\Cash',213,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:23:22','2025-01-17 21:23:22'),(266,'01',12,'Modules\\Cash\\Models\\Cash',214,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:34:32','2025-01-17 21:34:32'),(267,'01',12,'Modules\\Cash\\Models\\Cash',215,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:35:00','2025-01-17 21:35:00'),(268,'01',12,'Modules\\Cash\\Models\\Cash',216,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:35:54','2025-01-17 21:35:54'),(269,'01',12,'Modules\\Cash\\Models\\Cash',217,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:36:13','2025-01-17 21:36:13'),(270,'01',12,'Modules\\Cash\\Models\\Cash',218,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:46:17','2025-01-17 21:46:17'),(271,'01',12,'Modules\\Cash\\Models\\Cash',219,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 21:52:37','2025-01-17 21:52:37'),(272,'01',12,'Modules\\Cash\\Models\\Cash',220,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 22:04:47','2025-01-17 22:04:47'),(273,'01',12,'Modules\\Cash\\Models\\Cash',221,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 22:08:14','2025-01-17 22:08:14'),(274,'01',12,'Modules\\Cash\\Models\\Cash',222,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 22:08:35','2025-01-17 22:08:35'),(275,'01',12,'Modules\\Cash\\Models\\Cash',223,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-17 22:32:19','2025-01-17 22:32:19'),(276,'01',13,'Modules\\Cash\\Models\\Cash',16,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-18 07:10:00','2025-01-18 07:10:00'),(277,'01',13,'Modules\\Cash\\Models\\Cash',224,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 07:11:19','2025-01-18 07:11:19'),(278,'01',13,'Modules\\Cash\\Models\\Cash',225,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 07:27:49','2025-01-18 07:27:49'),(279,'01',13,'Modules\\Cash\\Models\\Cash',226,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 08:50:55','2025-01-18 08:50:55'),(280,'01',13,'Modules\\Cash\\Models\\Cash',227,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 09:06:23','2025-01-18 09:06:23'),(281,'01',13,'Modules\\Cash\\Models\\Cash',228,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 09:26:29','2025-01-18 09:26:29'),(282,'01',13,'Modules\\Cash\\Models\\Cash',229,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 10:49:28','2025-01-18 10:49:28'),(283,'01',13,'Modules\\Cash\\Models\\Cash',230,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 11:12:13','2025-01-18 11:12:13'),(284,'01',13,'Modules\\Cash\\Models\\Cash',231,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 11:12:43','2025-01-18 11:12:43'),(285,'01',13,'Modules\\Cash\\Models\\Cash',232,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 11:24:37','2025-01-18 11:24:37'),(286,'01',13,'Modules\\Cash\\Models\\Cash',233,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 11:48:55','2025-01-18 11:48:55'),(287,'01',13,'Modules\\Cash\\Models\\Cash',234,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 11:51:37','2025-01-18 11:51:37'),(288,'01',13,'Modules\\Cash\\Models\\Cash',235,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 11:54:15','2025-01-18 11:54:15'),(289,'01',13,'Modules\\Cash\\Models\\Cash',236,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 11:55:37','2025-01-18 11:55:37'),(290,'01',13,'Modules\\Cash\\Models\\Cash',237,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 11:56:29','2025-01-18 11:56:29'),(291,'01',13,'Modules\\Cash\\Models\\Cash',238,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 12:09:34','2025-01-18 12:09:34'),(292,'01',13,'Modules\\Cash\\Models\\Cash',239,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 12:09:50','2025-01-18 12:09:50'),(293,'01',13,'Modules\\Cash\\Models\\Cash',240,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 12:30:34','2025-01-18 12:30:34'),(294,'01',13,'Modules\\Cash\\Models\\Cash',241,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 12:31:17','2025-01-18 12:31:17'),(295,'01',13,'Modules\\Cash\\Models\\Cash',242,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 13:16:05','2025-01-18 13:16:05'),(296,'01',13,'Modules\\Cash\\Models\\Cash',243,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 13:17:43','2025-01-18 13:17:43'),(297,'01',13,'Modules\\Cash\\Models\\Cash',244,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 13:31:12','2025-01-18 13:31:12'),(298,'01',13,'Modules\\Cash\\Models\\Cash',245,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 14:23:51','2025-01-18 14:23:51'),(299,'01',13,'Modules\\Cash\\Models\\Cash',246,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 14:33:38','2025-01-18 14:33:38'),(300,'01',13,'Modules\\Cash\\Models\\Cash',247,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 14:56:44','2025-01-18 14:56:44'),(301,'01',13,'Modules\\Cash\\Models\\Cash',248,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 15:25:05','2025-01-18 15:25:05'),(302,'01',13,'Modules\\Cash\\Models\\Cash',249,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 15:26:45','2025-01-18 15:26:45'),(303,'01',13,'Modules\\Cash\\Models\\Cash',250,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 15:27:03','2025-01-18 15:27:03'),(304,'01',13,'Modules\\Cash\\Models\\Cash',251,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 16:06:14','2025-01-18 16:06:14'),(305,'01',13,'Modules\\Cash\\Models\\Cash',252,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 16:06:41','2025-01-18 16:06:41'),(306,'01',13,'Modules\\Cash\\Models\\Cash',253,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 17:00:38','2025-01-18 17:00:38'),(307,'01',13,'Modules\\Cash\\Models\\Cash',254,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 17:41:15','2025-01-18 17:41:15'),(308,'01',13,'Modules\\Cash\\Models\\Cash',255,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 17:51:33','2025-01-18 17:51:33'),(309,'01',13,'Modules\\Cash\\Models\\Cash',256,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 17:56:24','2025-01-18 17:56:24'),(310,'01',13,'Modules\\Cash\\Models\\Cash',257,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 17:57:01','2025-01-18 17:57:01'),(311,'01',13,'Modules\\Cash\\Models\\Cash',258,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 18:41:15','2025-01-18 18:41:15'),(312,'01',13,'Modules\\Cash\\Models\\Cash',259,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 18:50:29','2025-01-18 18:50:29'),(313,'01',13,'Modules\\Cash\\Models\\Cash',260,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 20:03:33','2025-01-18 20:03:33'),(314,'01',13,'Modules\\Cash\\Models\\Cash',261,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 20:15:47','2025-01-18 20:15:47'),(315,'01',13,'Modules\\Cash\\Models\\Cash',262,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 20:20:57','2025-01-18 20:20:57'),(316,'01',13,'Modules\\Cash\\Models\\Cash',263,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 20:21:15','2025-01-18 20:21:15'),(317,'01',13,'Modules\\Cash\\Models\\Cash',264,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 20:27:06','2025-01-18 20:27:06'),(318,'01',13,'Modules\\Cash\\Models\\Cash',265,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 20:27:33','2025-01-18 20:27:33'),(319,'01',13,'Modules\\Cash\\Models\\Cash',266,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 21:03:44','2025-01-18 21:03:44'),(320,'01',13,'Modules\\Cash\\Models\\Cash',267,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 21:07:09','2025-01-18 21:07:09'),(321,'01',13,'Modules\\Cash\\Models\\Cash',268,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 21:16:35','2025-01-18 21:16:35'),(322,'01',13,'Modules\\Cash\\Models\\Cash',269,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 21:17:04','2025-01-18 21:17:04'),(323,'01',13,'Modules\\Cash\\Models\\Cash',270,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 21:17:30','2025-01-18 21:17:30'),(324,'01',13,'Modules\\Cash\\Models\\Cash',271,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 21:19:23','2025-01-18 21:19:23'),(325,'01',13,'Modules\\Cash\\Models\\Cash',272,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 21:19:42','2025-01-18 21:19:42'),(326,'01',13,'Modules\\Cash\\Models\\Cash',273,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 21:24:37','2025-01-18 21:24:37'),(327,'01',13,'Modules\\Cash\\Models\\Cash',274,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 21:25:38','2025-01-18 21:25:38'),(328,'01',13,'Modules\\Cash\\Models\\Cash',275,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 21:26:14','2025-01-18 21:26:14'),(329,'01',13,'Modules\\Cash\\Models\\Cash',276,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 21:26:35','2025-01-18 21:26:35'),(330,'01',13,'Modules\\Cash\\Models\\Cash',277,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 22:14:04','2025-01-18 22:14:04'),(331,'01',13,'Modules\\Cash\\Models\\Cash',278,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 22:37:15','2025-01-18 22:37:15'),(332,'01',13,'Modules\\Cash\\Models\\Cash',279,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 22:37:42','2025-01-18 22:37:42'),(333,'01',13,'Modules\\Cash\\Models\\Cash',280,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-18 22:38:51','2025-01-18 22:38:51'),(334,'01',14,'Modules\\Cash\\Models\\Cash',17,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-19 07:16:50','2025-01-19 07:16:50'),(335,'01',14,'Modules\\Cash\\Models\\Cash',281,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 10:01:26','2025-01-19 10:01:26'),(336,'01',14,'Modules\\Cash\\Models\\Cash',282,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 10:21:25','2025-01-19 10:21:25'),(337,'01',14,'Modules\\Cash\\Models\\Cash',283,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 10:21:44','2025-01-19 10:21:44'),(338,'01',14,'Modules\\Cash\\Models\\Cash',284,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 11:55:02','2025-01-19 11:55:02'),(339,'01',14,'Modules\\Cash\\Models\\Cash',285,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 11:59:57','2025-01-19 11:59:57'),(340,'01',14,'Modules\\Cash\\Models\\Cash',286,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 12:04:23','2025-01-19 12:04:23'),(341,'01',14,'Modules\\Cash\\Models\\Cash',287,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 12:19:43','2025-01-19 12:19:43'),(342,'01',14,'Modules\\Cash\\Models\\Cash',288,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 12:25:35','2025-01-19 12:25:35'),(343,'01',14,'Modules\\Cash\\Models\\Cash',289,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 12:31:11','2025-01-19 12:31:11'),(344,'01',14,'Modules\\Cash\\Models\\Cash',290,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 12:44:24','2025-01-19 12:44:24'),(345,'01',14,'Modules\\Cash\\Models\\Cash',291,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 13:01:22','2025-01-19 13:01:22'),(346,'01',14,'Modules\\Cash\\Models\\Cash',292,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 13:29:57','2025-01-19 13:29:57'),(347,'01',14,'Modules\\Cash\\Models\\Cash',293,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 13:37:37','2025-01-19 13:37:37'),(348,'01',14,'Modules\\Cash\\Models\\Cash',294,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 13:47:28','2025-01-19 13:47:28'),(349,'01',14,'Modules\\Cash\\Models\\Cash',295,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 14:15:22','2025-01-19 14:15:22'),(350,'01',14,'Modules\\Cash\\Models\\Cash',296,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 14:32:08','2025-01-19 14:32:08'),(351,'01',14,'Modules\\Cash\\Models\\Cash',297,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 14:52:01','2025-01-19 14:52:01'),(352,'01',14,'Modules\\Cash\\Models\\Cash',298,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 15:07:20','2025-01-19 15:07:20'),(353,'01',14,'Modules\\Cash\\Models\\Cash',299,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 15:27:19','2025-01-19 15:27:19'),(354,'01',14,'Modules\\Cash\\Models\\Cash',300,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 15:32:02','2025-01-19 15:32:02'),(355,'01',14,'Modules\\Cash\\Models\\Cash',301,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 16:06:34','2025-01-19 16:06:34'),(356,'01',14,'Modules\\Cash\\Models\\Cash',302,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 16:17:57','2025-01-19 16:17:57'),(357,'01',14,'Modules\\Cash\\Models\\Cash',303,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 16:35:17','2025-01-19 16:35:17'),(358,'01',14,'Modules\\Cash\\Models\\Cash',304,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 17:01:55','2025-01-19 17:01:55'),(359,'01',14,'Modules\\Cash\\Models\\Cash',305,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 17:37:13','2025-01-19 17:37:13'),(360,'01',14,'Modules\\Cash\\Models\\Cash',306,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 18:25:25','2025-01-19 18:25:25'),(361,'01',14,'Modules\\Cash\\Models\\Cash',307,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 18:35:59','2025-01-19 18:35:59'),(362,'01',14,'Modules\\Cash\\Models\\Cash',308,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 18:41:30','2025-01-19 18:41:30'),(363,'01',14,'Modules\\Cash\\Models\\Cash',309,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 18:47:23','2025-01-19 18:47:23'),(364,'01',14,'Modules\\Cash\\Models\\Cash',310,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 19:21:05','2025-01-19 19:21:05'),(365,'01',14,'Modules\\Cash\\Models\\Cash',311,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 19:30:55','2025-01-19 19:30:55'),(366,'01',14,'Modules\\Cash\\Models\\Cash',312,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 19:57:33','2025-01-19 19:57:33'),(367,'01',14,'Modules\\Cash\\Models\\Cash',313,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 20:22:42','2025-01-19 20:22:42'),(368,'01',14,'Modules\\Cash\\Models\\Cash',314,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 20:24:51','2025-01-19 20:24:51'),(369,'01',14,'Modules\\Cash\\Models\\Cash',315,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 20:29:32','2025-01-19 20:29:32'),(370,'01',14,'Modules\\Cash\\Models\\Cash',316,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 20:36:34','2025-01-19 20:36:34'),(371,'01',14,'Modules\\Cash\\Models\\Cash',317,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 21:27:34','2025-01-19 21:27:34'),(372,'01',14,'Modules\\Cash\\Models\\Cash',318,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 21:43:33','2025-01-19 21:43:33'),(373,'01',14,'Modules\\Cash\\Models\\Cash',319,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 21:49:41','2025-01-19 21:49:41'),(374,'01',14,'Modules\\Cash\\Models\\Cash',320,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-19 21:50:50','2025-01-19 21:50:50'),(375,'01',15,'Modules\\Cash\\Models\\Cash',18,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-20 07:31:01','2025-01-20 07:31:01'),(376,'01',15,'Modules\\Cash\\Models\\Cash',321,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 07:55:12','2025-01-20 07:55:12'),(377,'01',15,'Modules\\Cash\\Models\\Cash',322,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 08:01:23','2025-01-20 08:01:23'),(378,'01',15,'Modules\\Cash\\Models\\Cash',323,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 09:46:01','2025-01-20 09:46:01'),(379,'01',15,'Modules\\Cash\\Models\\Cash',324,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 10:37:46','2025-01-20 10:37:46'),(380,'01',15,'Modules\\Cash\\Models\\Cash',325,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 10:55:24','2025-01-20 10:55:24'),(381,'01',15,'Modules\\Cash\\Models\\Cash',326,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 11:24:27','2025-01-20 11:24:27'),(382,'01',15,'Modules\\Cash\\Models\\Cash',327,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 12:17:45','2025-01-20 12:17:45'),(383,'01',15,'Modules\\Cash\\Models\\Cash',328,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 12:58:19','2025-01-20 12:58:19'),(384,'01',15,'Modules\\Cash\\Models\\Cash',329,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 13:02:10','2025-01-20 13:02:10'),(385,'01',15,'Modules\\Cash\\Models\\Cash',330,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 14:04:55','2025-01-20 14:04:55'),(386,'01',16,'Modules\\Cash\\Models\\Cash',19,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-20 14:25:03','2025-01-20 14:25:03'),(387,'01',16,'Modules\\Cash\\Models\\Cash',331,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 15:02:10','2025-01-20 15:02:10'),(388,'01',16,'Modules\\Cash\\Models\\Cash',332,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 15:03:41','2025-01-20 15:03:41'),(389,'01',16,'Modules\\Cash\\Models\\Cash',333,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 15:13:02','2025-01-20 15:13:02'),(390,'01',16,'Modules\\Cash\\Models\\Cash',334,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 16:21:15','2025-01-20 16:21:15'),(391,'01',16,'Modules\\Cash\\Models\\Cash',335,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 16:21:47','2025-01-20 16:21:47'),(392,'01',16,'Modules\\Cash\\Models\\Cash',336,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 16:31:06','2025-01-20 16:31:06'),(393,'01',16,'Modules\\Cash\\Models\\Cash',337,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 16:46:01','2025-01-20 16:46:01'),(394,'01',16,'Modules\\Cash\\Models\\Cash',338,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 16:51:04','2025-01-20 16:51:04'),(395,'01',16,'Modules\\Cash\\Models\\Cash',339,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 16:53:00','2025-01-20 16:53:00'),(396,'01',16,'Modules\\Cash\\Models\\Cash',340,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 16:56:24','2025-01-20 16:56:24'),(397,'01',16,'Modules\\Cash\\Models\\Cash',341,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 17:20:54','2025-01-20 17:20:54'),(398,'01',16,'Modules\\Cash\\Models\\Cash',342,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 17:45:06','2025-01-20 17:45:06'),(399,'01',16,'Modules\\Cash\\Models\\Cash',343,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 18:07:05','2025-01-20 18:07:05'),(400,'01',16,'Modules\\Cash\\Models\\Cash',344,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 18:11:35','2025-01-20 18:11:35'),(401,'01',16,'Modules\\Cash\\Models\\Cash',345,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 18:21:49','2025-01-20 18:21:49'),(402,'01',16,'Modules\\Cash\\Models\\Cash',346,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 19:18:47','2025-01-20 19:18:47'),(403,'01',16,'Modules\\Cash\\Models\\Cash',347,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 19:19:26','2025-01-20 19:19:26'),(404,'01',16,'Modules\\Cash\\Models\\Cash',348,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 19:28:12','2025-01-20 19:28:12'),(405,'01',16,'Modules\\Cash\\Models\\Cash',349,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 19:40:29','2025-01-20 19:40:29'),(406,'01',16,'Modules\\Cash\\Models\\Cash',350,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 19:40:45','2025-01-20 19:40:45'),(407,'01',16,'Modules\\Cash\\Models\\Cash',351,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 19:55:17','2025-01-20 19:55:17'),(408,'01',16,'Modules\\Cash\\Models\\Cash',352,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 20:19:27','2025-01-20 20:19:27'),(409,'01',16,'Modules\\Cash\\Models\\Cash',353,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 20:23:20','2025-01-20 20:23:20'),(410,'01',16,'Modules\\Cash\\Models\\Cash',354,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 20:26:45','2025-01-20 20:26:45'),(411,'01',16,'Modules\\Cash\\Models\\Cash',355,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 20:40:10','2025-01-20 20:40:10'),(412,'01',16,'Modules\\Cash\\Models\\Cash',356,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 20:40:36','2025-01-20 20:40:36'),(413,'01',16,'Modules\\Cash\\Models\\Cash',357,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 20:47:52','2025-01-20 20:47:52'),(414,'01',16,'Modules\\Cash\\Models\\Cash',358,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 20:53:21','2025-01-20 20:53:21'),(415,'01',16,'Modules\\Cash\\Models\\Cash',359,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 20:55:51','2025-01-20 20:55:51'),(416,'01',16,'Modules\\Cash\\Models\\Cash',360,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 21:06:49','2025-01-20 21:06:49'),(417,'01',16,'Modules\\Cash\\Models\\Cash',361,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-20 22:27:47','2025-01-20 22:27:47'),(418,'01',17,'Modules\\Cash\\Models\\Cash',20,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-21 07:16:55','2025-01-21 07:16:55'),(419,'01',17,'Modules\\Cash\\Models\\Cash',362,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-21 08:28:55','2025-01-21 08:28:55'),(420,'01',17,'Modules\\Cash\\Models\\Cash',363,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-21 10:40:27','2025-01-21 10:40:27'),(421,'01',17,'Modules\\Cash\\Models\\Cash',364,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-21 12:28:10','2025-01-21 12:28:10'),(422,'01',17,'Modules\\Cash\\Models\\Cash',365,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-21 13:41:27','2025-01-21 13:41:27'),(423,'01',17,'Modules\\Cash\\Models\\Cash',366,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-21 13:50:29','2025-01-21 13:50:29'),(424,'01',17,'Modules\\Cash\\Models\\Cash',367,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-21 13:55:30','2025-01-21 13:55:30'),(425,'01',17,'Modules\\Cash\\Models\\Cash',368,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-21 14:20:10','2025-01-21 14:20:10'),(426,'01',18,'Modules\\Cash\\Models\\Cash',21,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-21 14:30:23','2025-01-21 14:30:23'),(427,'01',19,'Modules\\Cash\\Models\\Cash',22,'Modules\\Pos\\Models\\CashTransaction',4,'2025-01-21 14:50:41','2025-01-21 14:50:41'),(428,'01',19,'Modules\\Cash\\Models\\Cash',369,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 15:18:47','2025-01-21 15:18:47'),(429,'01',19,'Modules\\Cash\\Models\\Cash',370,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 16:05:04','2025-01-21 16:05:04'),(430,'01',19,'Modules\\Cash\\Models\\Cash',371,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 17:22:11','2025-01-21 17:22:11'),(431,'01',19,'Modules\\Cash\\Models\\Cash',372,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 17:22:24','2025-01-21 17:22:24'),(432,'01',19,'Modules\\Cash\\Models\\Cash',373,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 17:50:48','2025-01-21 17:50:48'),(433,'01',19,'Modules\\Cash\\Models\\Cash',374,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 18:35:35','2025-01-21 18:35:35'),(434,'01',19,'Modules\\Cash\\Models\\Cash',375,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 18:47:42','2025-01-21 18:47:42'),(435,'01',19,'Modules\\Cash\\Models\\Cash',376,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 18:48:08','2025-01-21 18:48:08'),(436,'01',19,'Modules\\Cash\\Models\\Cash',377,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 18:48:27','2025-01-21 18:48:27'),(437,'01',19,'Modules\\Cash\\Models\\Cash',378,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 19:10:19','2025-01-21 19:10:19'),(438,'01',19,'Modules\\Cash\\Models\\Cash',379,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 19:10:33','2025-01-21 19:10:33'),(439,'01',19,'Modules\\Cash\\Models\\Cash',380,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 19:11:13','2025-01-21 19:11:13'),(440,'01',19,'Modules\\Cash\\Models\\Cash',381,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 19:20:32','2025-01-21 19:20:32'),(441,'01',19,'Modules\\Cash\\Models\\Cash',382,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 20:02:02','2025-01-21 20:02:02'),(442,'01',19,'Modules\\Cash\\Models\\Cash',383,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 20:52:26','2025-01-21 20:52:26'),(443,'01',19,'Modules\\Cash\\Models\\Cash',384,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 21:10:56','2025-01-21 21:10:56'),(444,'01',19,'Modules\\Cash\\Models\\Cash',385,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 21:56:42','2025-01-21 21:56:42'),(445,'01',19,'Modules\\Cash\\Models\\Cash',386,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 22:26:11','2025-01-21 22:26:11'),(446,'01',19,'Modules\\Cash\\Models\\Cash',387,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-21 22:26:28','2025-01-21 22:26:28'),(447,'01',20,'Modules\\Cash\\Models\\Cash',23,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-22 07:14:18','2025-01-22 07:14:18'),(448,'01',20,'Modules\\Cash\\Models\\Cash',388,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-22 09:21:49','2025-01-22 09:21:49'),(449,'01',20,'Modules\\Cash\\Models\\Cash',389,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-22 09:37:39','2025-01-22 09:37:39'),(450,'01',20,'Modules\\Cash\\Models\\Cash',390,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-22 09:53:07','2025-01-22 09:53:07'),(451,'01',20,'Modules\\Cash\\Models\\Cash',391,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-22 10:55:51','2025-01-22 10:55:51'),(452,'01',20,'Modules\\Cash\\Models\\Cash',392,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-22 10:59:07','2025-01-22 10:59:07'),(453,'01',20,'Modules\\Cash\\Models\\Cash',393,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-22 11:05:13','2025-01-22 11:05:13'),(454,'01',20,'Modules\\Cash\\Models\\Cash',394,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-22 11:31:31','2025-01-22 11:31:31'),(455,'01',20,'Modules\\Cash\\Models\\Cash',395,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-22 12:37:33','2025-01-22 12:37:33'),(456,'01',20,'Modules\\Cash\\Models\\Cash',396,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-22 12:51:31','2025-01-22 12:51:31'),(457,'01',20,'Modules\\Cash\\Models\\Cash',397,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-22 13:47:26','2025-01-22 13:47:26'),(458,'01',20,'Modules\\Cash\\Models\\Cash',398,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-22 13:54:39','2025-01-22 13:54:39'),(459,'01',20,'Modules\\Cash\\Models\\Cash',399,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-22 14:19:36','2025-01-22 14:19:36'),(460,'01',21,'Modules\\Cash\\Models\\Cash',24,'Modules\\Pos\\Models\\CashTransaction',4,'2025-01-22 14:33:47','2025-01-22 14:33:47'),(461,'01',21,'Modules\\Cash\\Models\\Cash',400,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 14:34:34','2025-01-22 14:34:34'),(462,'01',21,'Modules\\Cash\\Models\\Cash',401,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 14:35:09','2025-01-22 14:35:09'),(463,'01',21,'Modules\\Cash\\Models\\Cash',402,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 15:17:28','2025-01-22 15:17:28'),(464,'01',21,'Modules\\Cash\\Models\\Cash',403,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 15:17:44','2025-01-22 15:17:44'),(465,'01',21,'Modules\\Cash\\Models\\Cash',404,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 15:25:51','2025-01-22 15:25:51'),(466,'01',21,'Modules\\Cash\\Models\\Cash',405,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 15:26:27','2025-01-22 15:26:27'),(467,'01',21,'Modules\\Cash\\Models\\Cash',406,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 17:50:53','2025-01-22 17:50:53'),(468,'01',21,'Modules\\Cash\\Models\\Cash',407,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 17:53:15','2025-01-22 17:53:15'),(469,'01',21,'Modules\\Cash\\Models\\Cash',408,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 17:59:59','2025-01-22 17:59:59'),(470,'01',21,'Modules\\Cash\\Models\\Cash',409,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 18:04:18','2025-01-22 18:04:18'),(471,'01',21,'Modules\\Cash\\Models\\Cash',410,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 18:09:12','2025-01-22 18:09:12'),(472,'01',21,'Modules\\Cash\\Models\\Cash',411,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 18:09:26','2025-01-22 18:09:26'),(473,'01',21,'Modules\\Cash\\Models\\Cash',412,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 18:42:52','2025-01-22 18:42:52'),(474,'01',21,'Modules\\Cash\\Models\\Cash',413,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 18:44:24','2025-01-22 18:44:24'),(475,'01',21,'Modules\\Cash\\Models\\Cash',414,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 19:09:29','2025-01-22 19:09:29'),(476,'01',21,'Modules\\Cash\\Models\\Cash',415,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 19:22:36','2025-01-22 19:22:36'),(477,'01',21,'Modules\\Cash\\Models\\Cash',416,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 19:45:34','2025-01-22 19:45:34'),(478,'01',21,'Modules\\Cash\\Models\\Cash',417,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 19:45:50','2025-01-22 19:45:50'),(479,'01',21,'Modules\\Cash\\Models\\Cash',418,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 19:46:03','2025-01-22 19:46:03'),(480,'01',21,'Modules\\Cash\\Models\\Cash',419,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 19:51:04','2025-01-22 19:51:04'),(481,'01',21,'Modules\\Cash\\Models\\Cash',420,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 19:51:13','2025-01-22 19:51:13'),(482,'01',21,'Modules\\Cash\\Models\\Cash',421,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 20:14:34','2025-01-22 20:14:34'),(483,'01',21,'Modules\\Cash\\Models\\Cash',422,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 20:23:48','2025-01-22 20:23:48'),(484,'01',21,'Modules\\Cash\\Models\\Cash',423,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 20:26:11','2025-01-22 20:26:11'),(485,'01',21,'Modules\\Cash\\Models\\Cash',424,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 20:37:56','2025-01-22 20:37:56'),(486,'01',21,'Modules\\Cash\\Models\\Cash',425,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 20:38:16','2025-01-22 20:38:16'),(487,'01',21,'Modules\\Cash\\Models\\Cash',426,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 20:39:37','2025-01-22 20:39:37'),(488,'01',21,'Modules\\Cash\\Models\\Cash',427,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 20:40:07','2025-01-22 20:40:07'),(489,'01',21,'Modules\\Cash\\Models\\Cash',428,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 20:40:44','2025-01-22 20:40:44'),(490,'01',21,'Modules\\Cash\\Models\\Cash',429,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 20:41:12','2025-01-22 20:41:12'),(491,'01',21,'Modules\\Cash\\Models\\Cash',430,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 21:00:50','2025-01-22 21:00:50'),(492,'01',21,'Modules\\Cash\\Models\\Cash',431,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 21:01:26','2025-01-22 21:01:26'),(493,'01',21,'Modules\\Cash\\Models\\Cash',432,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 21:08:00','2025-01-22 21:08:00'),(494,'01',21,'Modules\\Cash\\Models\\Cash',433,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 21:08:24','2025-01-22 21:08:24'),(495,'01',21,'Modules\\Cash\\Models\\Cash',434,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 22:18:14','2025-01-22 22:18:14'),(496,'01',21,'Modules\\Cash\\Models\\Cash',435,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-22 22:18:33','2025-01-22 22:18:33'),(497,'01',22,'Modules\\Cash\\Models\\Cash',25,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-23 07:16:24','2025-01-23 07:16:24'),(498,'01',22,'Modules\\Cash\\Models\\Cash',436,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-23 07:36:50','2025-01-23 07:36:50'),(499,'01',22,'Modules\\Cash\\Models\\Cash',437,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-23 07:42:34','2025-01-23 07:42:34'),(500,'01',22,'Modules\\Cash\\Models\\Cash',438,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-23 09:26:47','2025-01-23 09:26:47'),(501,'01',22,'Modules\\Cash\\Models\\Cash',439,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-23 10:18:27','2025-01-23 10:18:27'),(502,'01',22,'Modules\\Cash\\Models\\Cash',440,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-23 10:27:47','2025-01-23 10:27:47'),(503,'01',22,'Modules\\Cash\\Models\\Cash',441,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-23 12:56:21','2025-01-23 12:56:21'),(504,'01',22,'Modules\\Cash\\Models\\Cash',442,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-23 13:22:08','2025-01-23 13:22:08'),(505,'01',23,'Modules\\Cash\\Models\\Cash',26,'Modules\\Pos\\Models\\CashTransaction',4,'2025-01-23 14:41:02','2025-01-23 14:41:02'),(506,'01',23,'Modules\\Cash\\Models\\Cash',443,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 14:41:51','2025-01-23 14:41:51'),(507,'01',23,'Modules\\Cash\\Models\\Cash',444,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 14:48:09','2025-01-23 14:48:09'),(508,'01',23,'Modules\\Cash\\Models\\Cash',445,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 14:51:07','2025-01-23 14:51:07'),(509,'01',23,'Modules\\Cash\\Models\\Cash',446,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 14:54:34','2025-01-23 14:54:34'),(510,'01',23,'Modules\\Cash\\Models\\Cash',447,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 15:07:55','2025-01-23 15:07:55'),(511,'01',23,'Modules\\Cash\\Models\\Cash',448,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 15:08:22','2025-01-23 15:08:22'),(512,'01',23,'Modules\\Cash\\Models\\Cash',449,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 15:08:56','2025-01-23 15:08:56'),(513,'01',23,'Modules\\Cash\\Models\\Cash',450,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 16:29:17','2025-01-23 16:29:17'),(514,'01',23,'Modules\\Cash\\Models\\Cash',451,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 16:29:34','2025-01-23 16:29:34'),(515,'01',23,'Modules\\Cash\\Models\\Cash',452,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 16:37:05','2025-01-23 16:37:05'),(516,'01',23,'Modules\\Cash\\Models\\Cash',453,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 17:13:30','2025-01-23 17:13:30'),(517,'01',23,'Modules\\Cash\\Models\\Cash',454,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 17:47:42','2025-01-23 17:47:42'),(518,'01',23,'Modules\\Cash\\Models\\Cash',455,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 17:49:20','2025-01-23 17:49:20'),(519,'01',23,'Modules\\Cash\\Models\\Cash',456,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 17:57:31','2025-01-23 17:57:31'),(520,'01',23,'Modules\\Cash\\Models\\Cash',457,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 17:59:02','2025-01-23 17:59:02'),(521,'01',23,'Modules\\Cash\\Models\\Cash',458,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 17:59:13','2025-01-23 17:59:13'),(522,'01',23,'Modules\\Cash\\Models\\Cash',459,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 18:14:24','2025-01-23 18:14:24'),(523,'01',23,'Modules\\Cash\\Models\\Cash',460,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 18:35:56','2025-01-23 18:35:56'),(524,'01',23,'Modules\\Cash\\Models\\Cash',461,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 18:37:42','2025-01-23 18:37:42'),(525,'01',23,'Modules\\Cash\\Models\\Cash',462,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 18:37:57','2025-01-23 18:37:57'),(526,'01',23,'Modules\\Cash\\Models\\Cash',463,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 18:43:08','2025-01-23 18:43:08'),(527,'01',23,'Modules\\Cash\\Models\\Cash',464,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 18:43:31','2025-01-23 18:43:31'),(528,'01',23,'Modules\\Cash\\Models\\Cash',465,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 18:48:09','2025-01-23 18:48:09'),(529,'01',23,'Modules\\Cash\\Models\\Cash',466,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 19:18:09','2025-01-23 19:18:09'),(530,'01',23,'Modules\\Cash\\Models\\Cash',467,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 19:18:28','2025-01-23 19:18:28'),(531,'01',23,'Modules\\Cash\\Models\\Cash',468,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 19:18:45','2025-01-23 19:18:45'),(532,'01',23,'Modules\\Cash\\Models\\Cash',469,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 19:18:58','2025-01-23 19:18:58'),(533,'01',23,'Modules\\Cash\\Models\\Cash',470,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 19:26:31','2025-01-23 19:26:31'),(534,'01',23,'Modules\\Cash\\Models\\Cash',471,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 19:30:20','2025-01-23 19:30:20'),(535,'01',23,'Modules\\Cash\\Models\\Cash',472,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 19:35:26','2025-01-23 19:35:26'),(536,'01',23,'Modules\\Cash\\Models\\Cash',473,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 19:35:45','2025-01-23 19:35:45'),(537,'01',23,'Modules\\Cash\\Models\\Cash',474,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 19:36:00','2025-01-23 19:36:00'),(538,'01',23,'Modules\\Cash\\Models\\Cash',475,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 19:42:17','2025-01-23 19:42:17'),(539,'01',23,'Modules\\Cash\\Models\\Cash',476,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 19:43:34','2025-01-23 19:43:34'),(540,'01',23,'Modules\\Cash\\Models\\Cash',477,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 19:44:43','2025-01-23 19:44:43'),(541,'01',23,'Modules\\Cash\\Models\\Cash',478,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 19:45:01','2025-01-23 19:45:01'),(542,'01',23,'Modules\\Cash\\Models\\Cash',479,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 19:55:02','2025-01-23 19:55:02'),(543,'01',23,'Modules\\Cash\\Models\\Cash',480,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 20:52:09','2025-01-23 20:52:09'),(544,'01',23,'Modules\\Cash\\Models\\Cash',481,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 21:26:47','2025-01-23 21:26:47'),(545,'01',23,'Modules\\Cash\\Models\\Cash',482,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 21:27:21','2025-01-23 21:27:21'),(546,'01',23,'Modules\\Cash\\Models\\Cash',483,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 21:55:40','2025-01-23 21:55:40'),(547,'01',23,'Modules\\Cash\\Models\\Cash',484,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 22:08:20','2025-01-23 22:08:20'),(548,'01',23,'Modules\\Cash\\Models\\Cash',485,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 22:15:13','2025-01-23 22:15:13'),(549,'01',23,'Modules\\Cash\\Models\\Cash',486,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-23 22:21:09','2025-01-23 22:21:09'),(550,'01',24,'Modules\\Cash\\Models\\Cash',27,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-24 07:29:07','2025-01-24 07:29:07'),(551,'01',24,'Modules\\Cash\\Models\\Cash',487,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-24 07:36:17','2025-01-24 07:36:17'),(552,'01',24,'Modules\\Cash\\Models\\Cash',488,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-24 10:41:06','2025-01-24 10:41:06'),(553,'01',24,'Modules\\Cash\\Models\\Cash',489,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-24 10:55:57','2025-01-24 10:55:57'),(554,'01',24,'Modules\\Cash\\Models\\Cash',490,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-24 12:24:14','2025-01-24 12:24:14'),(555,'01',24,'Modules\\Cash\\Models\\Cash',491,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-24 12:43:14','2025-01-24 12:43:14'),(556,'01',25,'Modules\\Cash\\Models\\Cash',28,'Modules\\Pos\\Models\\CashTransaction',4,'2025-01-24 14:44:36','2025-01-24 14:44:36'),(557,'01',25,'Modules\\Cash\\Models\\Cash',492,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 15:12:40','2025-01-24 15:12:40'),(558,'01',25,'Modules\\Cash\\Models\\Cash',493,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 15:23:18','2025-01-24 15:23:18'),(559,'01',25,'Modules\\Cash\\Models\\Cash',494,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 15:56:13','2025-01-24 15:56:13'),(560,'01',25,'Modules\\Cash\\Models\\Cash',495,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 15:56:32','2025-01-24 15:56:32'),(561,'01',25,'Modules\\Cash\\Models\\Cash',496,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 17:10:41','2025-01-24 17:10:41'),(562,'01',25,'Modules\\Cash\\Models\\Cash',497,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 17:10:54','2025-01-24 17:10:54'),(563,'01',25,'Modules\\Cash\\Models\\Cash',498,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 19:15:15','2025-01-24 19:15:15'),(564,'01',25,'Modules\\Cash\\Models\\Cash',499,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 19:51:27','2025-01-24 19:51:27'),(565,'01',25,'Modules\\Cash\\Models\\Cash',500,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 20:00:50','2025-01-24 20:00:50'),(566,'01',25,'Modules\\Cash\\Models\\Cash',501,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 20:16:01','2025-01-24 20:16:01'),(567,'01',25,'Modules\\Cash\\Models\\Cash',502,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 20:17:06','2025-01-24 20:17:06'),(568,'01',25,'Modules\\Cash\\Models\\Cash',503,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 20:17:19','2025-01-24 20:17:19'),(569,'01',25,'Modules\\Cash\\Models\\Cash',504,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 20:17:53','2025-01-24 20:17:53'),(570,'01',25,'Modules\\Cash\\Models\\Cash',505,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 21:06:36','2025-01-24 21:06:36'),(571,'01',25,'Modules\\Cash\\Models\\Cash',506,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 21:58:36','2025-01-24 21:58:36'),(572,'01',25,'Modules\\Cash\\Models\\Cash',507,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 21:58:58','2025-01-24 21:58:58'),(573,'01',25,'Modules\\Cash\\Models\\Cash',508,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-24 21:59:44','2025-01-24 21:59:44'),(574,'01',26,'Modules\\Cash\\Models\\Cash',29,'Modules\\Pos\\Models\\CashTransaction',4,'2025-01-25 07:05:28','2025-01-25 07:05:28'),(575,'01',26,'Modules\\Cash\\Models\\Cash',509,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 10:37:49','2025-01-25 10:37:49'),(576,'01',26,'Modules\\Cash\\Models\\Cash',510,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 10:38:06','2025-01-25 10:38:06'),(577,'01',26,'Modules\\Cash\\Models\\Cash',511,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 10:56:35','2025-01-25 10:56:35'),(578,'01',26,'Modules\\Cash\\Models\\Cash',512,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 11:29:21','2025-01-25 11:29:21'),(579,'01',26,'Modules\\Cash\\Models\\Cash',513,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 11:55:28','2025-01-25 11:55:28'),(580,'01',26,'Modules\\Cash\\Models\\Cash',514,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 11:55:47','2025-01-25 11:55:47'),(581,'01',26,'Modules\\Cash\\Models\\Cash',515,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 11:56:52','2025-01-25 11:56:52'),(582,'01',26,'Modules\\Cash\\Models\\Cash',516,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 11:57:06','2025-01-25 11:57:06'),(583,'01',26,'Modules\\Cash\\Models\\Cash',517,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 12:35:06','2025-01-25 12:35:06'),(584,'01',26,'Modules\\Cash\\Models\\Cash',518,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 13:01:48','2025-01-25 13:01:48'),(585,'01',26,'Modules\\Cash\\Models\\Cash',519,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 13:29:58','2025-01-25 13:29:58'),(586,'01',26,'Modules\\Cash\\Models\\Cash',520,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 13:30:14','2025-01-25 13:30:14'),(587,'01',26,'Modules\\Cash\\Models\\Cash',521,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 13:30:57','2025-01-25 13:30:57'),(588,'01',26,'Modules\\Cash\\Models\\Cash',522,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 13:31:19','2025-01-25 13:31:19'),(589,'01',26,'Modules\\Cash\\Models\\Cash',523,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 13:31:37','2025-01-25 13:31:37'),(590,'01',26,'Modules\\Cash\\Models\\Cash',524,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 13:51:27','2025-01-25 13:51:27'),(591,'01',26,'Modules\\Cash\\Models\\Cash',525,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 14:39:59','2025-01-25 14:39:59'),(592,'01',26,'Modules\\Cash\\Models\\Cash',526,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 14:41:11','2025-01-25 14:41:11'),(593,'01',26,'Modules\\Cash\\Models\\Cash',527,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 14:41:30','2025-01-25 14:41:30'),(594,'01',26,'Modules\\Cash\\Models\\Cash',528,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 14:42:08','2025-01-25 14:42:08'),(595,'01',26,'Modules\\Cash\\Models\\Cash',529,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 14:43:33','2025-01-25 14:43:33'),(596,'01',26,'Modules\\Cash\\Models\\Cash',530,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 14:44:05','2025-01-25 14:44:05'),(597,'01',26,'Modules\\Cash\\Models\\Cash',531,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 14:44:41','2025-01-25 14:44:41'),(598,'01',26,'Modules\\Cash\\Models\\Cash',532,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 14:44:54','2025-01-25 14:44:54'),(599,'01',26,'Modules\\Cash\\Models\\Cash',533,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 14:46:58','2025-01-25 14:46:58'),(600,'01',26,'Modules\\Cash\\Models\\Cash',534,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 14:47:17','2025-01-25 14:47:17'),(601,'01',26,'Modules\\Cash\\Models\\Cash',535,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 14:47:54','2025-01-25 14:47:54'),(602,'01',26,'Modules\\Cash\\Models\\Cash',536,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 15:14:21','2025-01-25 15:14:21'),(603,'01',26,'Modules\\Cash\\Models\\Cash',537,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 15:18:37','2025-01-25 15:18:37'),(604,'01',26,'Modules\\Cash\\Models\\Cash',538,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 15:32:39','2025-01-25 15:32:39'),(605,'01',26,'Modules\\Cash\\Models\\Cash',539,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 15:33:02','2025-01-25 15:33:02'),(606,'01',26,'Modules\\Cash\\Models\\Cash',540,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 15:38:08','2025-01-25 15:38:08'),(607,'01',26,'Modules\\Cash\\Models\\Cash',541,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 15:58:54','2025-01-25 15:58:54'),(608,'01',26,'Modules\\Cash\\Models\\Cash',542,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 16:11:59','2025-01-25 16:11:59'),(609,'01',26,'Modules\\Cash\\Models\\Cash',543,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 17:48:29','2025-01-25 17:48:29'),(610,'01',26,'Modules\\Cash\\Models\\Cash',544,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 17:49:50','2025-01-25 17:49:50'),(611,'01',26,'Modules\\Cash\\Models\\Cash',545,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 18:32:51','2025-01-25 18:32:51'),(612,'01',26,'Modules\\Cash\\Models\\Cash',546,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 19:27:39','2025-01-25 19:27:39'),(613,'01',26,'Modules\\Cash\\Models\\Cash',547,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 19:28:20','2025-01-25 19:28:20'),(614,'01',26,'Modules\\Cash\\Models\\Cash',548,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 19:28:48','2025-01-25 19:28:48'),(615,'01',26,'Modules\\Cash\\Models\\Cash',549,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 19:29:08','2025-01-25 19:29:08'),(616,'01',26,'Modules\\Cash\\Models\\Cash',550,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 19:31:18','2025-01-25 19:31:18'),(617,'01',26,'Modules\\Cash\\Models\\Cash',551,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 19:31:47','2025-01-25 19:31:47'),(618,'01',26,'Modules\\Cash\\Models\\Cash',552,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 19:32:02','2025-01-25 19:32:02'),(619,'01',26,'Modules\\Cash\\Models\\Cash',553,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 19:48:23','2025-01-25 19:48:23'),(620,'01',26,'Modules\\Cash\\Models\\Cash',554,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 19:50:41','2025-01-25 19:50:41'),(621,'01',26,'Modules\\Cash\\Models\\Cash',555,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 19:52:47','2025-01-25 19:52:47'),(622,'01',26,'Modules\\Cash\\Models\\Cash',556,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 20:38:27','2025-01-25 20:38:27'),(623,'01',26,'Modules\\Cash\\Models\\Cash',557,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 20:47:42','2025-01-25 20:47:42'),(624,'01',26,'Modules\\Cash\\Models\\Cash',558,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 20:48:47','2025-01-25 20:48:47'),(625,'01',26,'Modules\\Cash\\Models\\Cash',559,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 20:49:21','2025-01-25 20:49:21'),(626,'01',26,'Modules\\Cash\\Models\\Cash',560,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 20:49:47','2025-01-25 20:49:47'),(627,'01',26,'Modules\\Cash\\Models\\Cash',561,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 20:50:51','2025-01-25 20:50:51'),(628,'01',26,'Modules\\Cash\\Models\\Cash',562,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 20:52:01','2025-01-25 20:52:01'),(629,'01',26,'Modules\\Cash\\Models\\Cash',563,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 20:56:09','2025-01-25 20:56:09'),(630,'01',26,'Modules\\Cash\\Models\\Cash',564,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 21:13:29','2025-01-25 21:13:29'),(631,'01',26,'Modules\\Cash\\Models\\Cash',565,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 21:13:48','2025-01-25 21:13:48'),(632,'01',26,'Modules\\Cash\\Models\\Cash',566,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-25 22:09:54','2025-01-25 22:09:54'),(633,'01',27,'Modules\\Cash\\Models\\Cash',30,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-26 07:40:20','2025-01-26 07:40:20'),(634,'01',27,'Modules\\Cash\\Models\\Cash',567,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 08:38:36','2025-01-26 08:38:36'),(635,'01',27,'Modules\\Cash\\Models\\Cash',568,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 08:49:25','2025-01-26 08:49:25'),(636,'01',27,'Modules\\Cash\\Models\\Cash',569,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 10:50:23','2025-01-26 10:50:23'),(637,'01',27,'Modules\\Cash\\Models\\Cash',570,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 13:23:06','2025-01-26 13:23:06'),(638,'01',27,'Modules\\Cash\\Models\\Cash',571,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 14:04:16','2025-01-26 14:04:16'),(639,'01',27,'Modules\\Cash\\Models\\Cash',572,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 14:05:20','2025-01-26 14:05:20'),(640,'01',27,'Modules\\Cash\\Models\\Cash',573,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 14:09:38','2025-01-26 14:09:38'),(641,'01',27,'Modules\\Cash\\Models\\Cash',574,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 14:11:26','2025-01-26 14:11:26'),(642,'01',27,'Modules\\Cash\\Models\\Cash',575,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 14:15:14','2025-01-26 14:15:14'),(643,'01',27,'Modules\\Cash\\Models\\Cash',576,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 14:27:32','2025-01-26 14:27:32'),(644,'01',27,'Modules\\Cash\\Models\\Cash',577,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 14:36:02','2025-01-26 14:36:02'),(645,'01',27,'Modules\\Cash\\Models\\Cash',578,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 14:49:31','2025-01-26 14:49:31'),(646,'01',27,'Modules\\Cash\\Models\\Cash',579,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 15:29:34','2025-01-26 15:29:34'),(647,'01',27,'Modules\\Cash\\Models\\Cash',580,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 16:04:00','2025-01-26 16:04:00'),(648,'01',27,'Modules\\Cash\\Models\\Cash',581,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 16:41:06','2025-01-26 16:41:06'),(649,'01',27,'Modules\\Cash\\Models\\Cash',582,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 17:36:09','2025-01-26 17:36:09'),(650,'01',27,'Modules\\Cash\\Models\\Cash',583,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 18:02:03','2025-01-26 18:02:03'),(651,'01',27,'Modules\\Cash\\Models\\Cash',584,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 19:33:53','2025-01-26 19:33:53'),(652,'01',27,'Modules\\Cash\\Models\\Cash',585,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 20:35:45','2025-01-26 20:35:45'),(653,'01',27,'Modules\\Cash\\Models\\Cash',586,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 20:54:11','2025-01-26 20:54:11'),(654,'01',27,'Modules\\Cash\\Models\\Cash',587,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 21:41:18','2025-01-26 21:41:18'),(655,'01',27,'Modules\\Cash\\Models\\Cash',588,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 21:45:59','2025-01-26 21:45:59'),(656,'01',27,'Modules\\Cash\\Models\\Cash',589,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-26 22:00:31','2025-01-26 22:00:31'),(657,'01',28,'Modules\\Cash\\Models\\Cash',31,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-27 08:22:48','2025-01-27 08:22:48'),(658,'01',28,'Modules\\Cash\\Models\\Cash',590,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-27 11:55:23','2025-01-27 11:55:23'),(659,'01',28,'Modules\\Cash\\Models\\Cash',591,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-27 12:39:06','2025-01-27 12:39:06'),(660,'01',28,'Modules\\Cash\\Models\\Cash',592,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-27 13:29:13','2025-01-27 13:29:13'),(661,'01',28,'Modules\\Cash\\Models\\Cash',593,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-27 14:32:34','2025-01-27 14:32:34'),(662,'01',29,'Modules\\Cash\\Models\\Cash',32,'Modules\\Pos\\Models\\CashTransaction',4,'2025-01-27 14:36:44','2025-01-27 14:36:44'),(663,'01',29,'Modules\\Cash\\Models\\Cash',594,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 14:51:37','2025-01-27 14:51:37'),(664,'01',29,'Modules\\Cash\\Models\\Cash',595,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 14:51:49','2025-01-27 14:51:49'),(665,'01',29,'Modules\\Cash\\Models\\Cash',596,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 14:52:13','2025-01-27 14:52:13'),(666,'01',29,'Modules\\Cash\\Models\\Cash',597,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 15:39:38','2025-01-27 15:39:38'),(667,'01',29,'Modules\\Cash\\Models\\Cash',598,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 16:02:04','2025-01-27 16:02:04'),(668,'01',29,'Modules\\Cash\\Models\\Cash',599,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 16:02:20','2025-01-27 16:02:20'),(669,'01',29,'Modules\\Cash\\Models\\Cash',600,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 16:44:59','2025-01-27 16:44:59'),(670,'01',29,'Modules\\Cash\\Models\\Cash',601,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 16:45:23','2025-01-27 16:45:23'),(671,'01',29,'Modules\\Cash\\Models\\Cash',602,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 17:21:24','2025-01-27 17:21:24'),(672,'01',29,'Modules\\Cash\\Models\\Cash',603,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 17:21:40','2025-01-27 17:21:40'),(673,'01',29,'Modules\\Cash\\Models\\Cash',604,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 17:30:59','2025-01-27 17:30:59'),(674,'01',29,'Modules\\Cash\\Models\\Cash',605,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 17:31:33','2025-01-27 17:31:33'),(675,'01',29,'Modules\\Cash\\Models\\Cash',606,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 17:31:47','2025-01-27 17:31:47'),(676,'01',29,'Modules\\Cash\\Models\\Cash',607,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 17:32:08','2025-01-27 17:32:08'),(677,'01',29,'Modules\\Cash\\Models\\Cash',608,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 17:32:29','2025-01-27 17:32:29'),(678,'01',29,'Modules\\Cash\\Models\\Cash',609,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 18:28:37','2025-01-27 18:28:37'),(679,'01',29,'Modules\\Cash\\Models\\Cash',610,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 18:36:41','2025-01-27 18:36:41'),(680,'01',29,'Modules\\Cash\\Models\\Cash',611,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 18:41:29','2025-01-27 18:41:29'),(681,'01',29,'Modules\\Cash\\Models\\Cash',612,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 18:51:15','2025-01-27 18:51:15'),(682,'01',29,'Modules\\Cash\\Models\\Cash',613,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 18:51:43','2025-01-27 18:51:43'),(683,'01',29,'Modules\\Cash\\Models\\Cash',614,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 18:51:56','2025-01-27 18:51:56'),(684,'01',29,'Modules\\Cash\\Models\\Cash',615,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 18:54:57','2025-01-27 18:54:57'),(685,'01',29,'Modules\\Cash\\Models\\Cash',616,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 18:55:13','2025-01-27 18:55:13'),(686,'01',29,'Modules\\Cash\\Models\\Cash',617,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 18:55:29','2025-01-27 18:55:29'),(687,'01',29,'Modules\\Cash\\Models\\Cash',618,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 18:58:45','2025-01-27 18:58:45'),(688,'01',29,'Modules\\Cash\\Models\\Cash',619,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 19:58:03','2025-01-27 19:58:03'),(689,'01',29,'Modules\\Cash\\Models\\Cash',620,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 20:00:49','2025-01-27 20:00:49'),(690,'01',29,'Modules\\Cash\\Models\\Cash',621,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 20:19:31','2025-01-27 20:19:31'),(691,'01',29,'Modules\\Cash\\Models\\Cash',622,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 20:59:36','2025-01-27 20:59:36'),(692,'01',29,'Modules\\Cash\\Models\\Cash',623,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 21:01:25','2025-01-27 21:01:25'),(693,'01',29,'Modules\\Cash\\Models\\Cash',624,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 21:21:18','2025-01-27 21:21:18'),(694,'01',29,'Modules\\Cash\\Models\\Cash',625,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 21:21:32','2025-01-27 21:21:32'),(695,'01',29,'Modules\\Cash\\Models\\Cash',626,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 21:29:24','2025-01-27 21:29:24'),(696,'01',29,'Modules\\Cash\\Models\\Cash',627,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 21:29:39','2025-01-27 21:29:39'),(697,'01',29,'Modules\\Cash\\Models\\Cash',628,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 21:29:59','2025-01-27 21:29:59'),(698,'01',29,'Modules\\Cash\\Models\\Cash',629,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 21:51:44','2025-01-27 21:51:44'),(699,'01',29,'Modules\\Cash\\Models\\Cash',630,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 21:52:25','2025-01-27 21:52:25'),(700,'01',29,'Modules\\Cash\\Models\\Cash',631,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-27 22:04:09','2025-01-27 22:04:09'),(701,'01',30,'Modules\\Cash\\Models\\Cash',33,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-28 07:20:50','2025-01-28 07:20:50'),(702,'01',30,'Modules\\Cash\\Models\\Cash',632,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-28 08:31:35','2025-01-28 08:31:35'),(703,'01',30,'Modules\\Cash\\Models\\Cash',633,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-28 08:55:31','2025-01-28 08:55:31'),(704,'01',30,'Modules\\Cash\\Models\\Cash',634,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-28 09:28:01','2025-01-28 09:28:01'),(705,'01',30,'Modules\\Cash\\Models\\Cash',635,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-28 11:46:34','2025-01-28 11:46:34'),(706,'01',30,'Modules\\Cash\\Models\\Cash',636,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-28 14:01:29','2025-01-28 14:01:29'),(707,'01',31,'Modules\\Cash\\Models\\Cash',34,'Modules\\Pos\\Models\\CashTransaction',4,'2025-01-28 14:50:25','2025-01-28 14:50:25'),(708,'01',31,'Modules\\Cash\\Models\\Cash',637,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 14:53:33','2025-01-28 14:53:33'),(709,'01',31,'Modules\\Cash\\Models\\Cash',638,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 15:16:19','2025-01-28 15:16:19'),(710,'01',31,'Modules\\Cash\\Models\\Cash',639,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 15:16:40','2025-01-28 15:16:40'),(711,'01',31,'Modules\\Cash\\Models\\Cash',640,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 15:48:18','2025-01-28 15:48:18'),(712,'01',31,'Modules\\Cash\\Models\\Cash',641,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 16:06:47','2025-01-28 16:06:47'),(713,'01',31,'Modules\\Cash\\Models\\Cash',642,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 16:07:03','2025-01-28 16:07:03'),(714,'01',31,'Modules\\Cash\\Models\\Cash',643,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 16:10:25','2025-01-28 16:10:25'),(715,'01',31,'Modules\\Cash\\Models\\Cash',644,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 17:44:08','2025-01-28 17:44:08'),(716,'01',31,'Modules\\Cash\\Models\\Cash',645,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 18:35:28','2025-01-28 18:35:28'),(717,'01',31,'Modules\\Cash\\Models\\Cash',646,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 18:35:44','2025-01-28 18:35:44'),(718,'01',31,'Modules\\Cash\\Models\\Cash',647,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 18:37:15','2025-01-28 18:37:15'),(719,'01',31,'Modules\\Cash\\Models\\Cash',648,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 18:46:31','2025-01-28 18:46:31'),(720,'01',31,'Modules\\Cash\\Models\\Cash',649,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 19:25:25','2025-01-28 19:25:25'),(721,'01',31,'Modules\\Cash\\Models\\Cash',650,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 19:46:53','2025-01-28 19:46:53'),(722,'01',31,'Modules\\Cash\\Models\\Cash',651,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 20:02:41','2025-01-28 20:02:41'),(723,'01',31,'Modules\\Cash\\Models\\Cash',652,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 20:03:01','2025-01-28 20:03:01'),(724,'01',31,'Modules\\Cash\\Models\\Cash',653,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 20:03:58','2025-01-28 20:03:58'),(725,'01',31,'Modules\\Cash\\Models\\Cash',654,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 20:05:51','2025-01-28 20:05:51'),(726,'01',31,'Modules\\Cash\\Models\\Cash',655,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 20:06:16','2025-01-28 20:06:16'),(727,'01',31,'Modules\\Cash\\Models\\Cash',656,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 20:06:39','2025-01-28 20:06:39'),(728,'01',31,'Modules\\Cash\\Models\\Cash',657,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 20:07:00','2025-01-28 20:07:00'),(729,'01',31,'Modules\\Cash\\Models\\Cash',658,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 20:39:54','2025-01-28 20:39:54'),(730,'01',31,'Modules\\Cash\\Models\\Cash',659,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 21:08:42','2025-01-28 21:08:42'),(731,'01',31,'Modules\\Cash\\Models\\Cash',660,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 21:09:08','2025-01-28 21:09:08'),(732,'01',31,'Modules\\Cash\\Models\\Cash',661,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 21:10:29','2025-01-28 21:10:29'),(733,'01',31,'Modules\\Cash\\Models\\Cash',662,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 21:10:54','2025-01-28 21:10:54'),(734,'01',31,'Modules\\Cash\\Models\\Cash',663,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 21:11:58','2025-01-28 21:11:58'),(735,'01',31,'Modules\\Cash\\Models\\Cash',664,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 21:35:23','2025-01-28 21:35:23'),(736,'01',31,'Modules\\Cash\\Models\\Cash',665,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-28 22:16:45','2025-01-28 22:16:45'),(737,'01',32,'Modules\\Cash\\Models\\Cash',35,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-29 07:16:44','2025-01-29 07:16:44'),(738,'01',32,'Modules\\Cash\\Models\\Cash',666,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-29 13:19:05','2025-01-29 13:19:05'),(739,'01',32,'Modules\\Cash\\Models\\Cash',667,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-29 14:31:19','2025-01-29 14:31:19'),(740,'01',33,'Modules\\Cash\\Models\\Cash',36,'Modules\\Pos\\Models\\CashTransaction',4,'2025-01-29 14:38:59','2025-01-29 14:38:59'),(741,'01',33,'Modules\\Cash\\Models\\Cash',668,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 15:14:17','2025-01-29 15:14:17'),(742,'01',33,'Modules\\Cash\\Models\\Cash',669,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 15:15:25','2025-01-29 15:15:25'),(743,'01',33,'Modules\\Cash\\Models\\Cash',670,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 15:15:53','2025-01-29 15:15:53'),(744,'01',33,'Modules\\Cash\\Models\\Cash',671,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 17:13:06','2025-01-29 17:13:06'),(745,'01',33,'Modules\\Cash\\Models\\Cash',672,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 17:31:21','2025-01-29 17:31:21'),(746,'01',33,'Modules\\Cash\\Models\\Cash',673,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 17:56:45','2025-01-29 17:56:45'),(747,'01',33,'Modules\\Cash\\Models\\Cash',674,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 19:06:11','2025-01-29 19:06:11'),(748,'01',33,'Modules\\Cash\\Models\\Cash',675,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 19:16:59','2025-01-29 19:16:59'),(749,'01',33,'Modules\\Cash\\Models\\Cash',676,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 19:17:21','2025-01-29 19:17:21'),(750,'01',33,'Modules\\Cash\\Models\\Cash',677,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 19:21:47','2025-01-29 19:21:47'),(751,'01',33,'Modules\\Cash\\Models\\Cash',678,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 19:34:27','2025-01-29 19:34:27'),(752,'01',33,'Modules\\Cash\\Models\\Cash',679,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 19:43:22','2025-01-29 19:43:22'),(753,'01',33,'Modules\\Cash\\Models\\Cash',680,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 19:43:39','2025-01-29 19:43:39'),(754,'01',33,'Modules\\Cash\\Models\\Cash',681,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 19:50:10','2025-01-29 19:50:10'),(755,'01',33,'Modules\\Cash\\Models\\Cash',682,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 19:58:31','2025-01-29 19:58:31'),(756,'01',33,'Modules\\Cash\\Models\\Cash',683,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 20:19:13','2025-01-29 20:19:13'),(757,'01',33,'Modules\\Cash\\Models\\Cash',684,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 20:32:24','2025-01-29 20:32:24'),(758,'01',33,'Modules\\Cash\\Models\\Cash',685,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 20:40:05','2025-01-29 20:40:05'),(759,'01',33,'Modules\\Cash\\Models\\Cash',686,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 20:40:20','2025-01-29 20:40:20'),(760,'01',33,'Modules\\Cash\\Models\\Cash',687,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 21:26:34','2025-01-29 21:26:34'),(761,'01',33,'Modules\\Cash\\Models\\Cash',688,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 21:30:08','2025-01-29 21:30:08'),(762,'01',33,'Modules\\Cash\\Models\\Cash',689,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 21:30:44','2025-01-29 21:30:44'),(763,'01',33,'Modules\\Cash\\Models\\Cash',690,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 21:31:03','2025-01-29 21:31:03'),(764,'01',33,'Modules\\Cash\\Models\\Cash',691,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 22:40:46','2025-01-29 22:40:46'),(765,'01',33,'Modules\\Cash\\Models\\Cash',692,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 22:41:01','2025-01-29 22:41:01'),(766,'01',33,'Modules\\Cash\\Models\\Cash',693,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-29 22:41:20','2025-01-29 22:41:20'),(767,'01',34,'Modules\\Cash\\Models\\Cash',37,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-30 07:25:37','2025-01-30 07:25:37'),(768,'01',34,'Modules\\Cash\\Models\\Cash',694,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-30 08:45:02','2025-01-30 08:45:02'),(769,'01',34,'Modules\\Cash\\Models\\Cash',695,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-30 11:10:01','2025-01-30 11:10:01'),(770,'01',34,'Modules\\Cash\\Models\\Cash',696,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-30 12:05:37','2025-01-30 12:05:37'),(771,'01',34,'Modules\\Cash\\Models\\Cash',697,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-30 12:34:09','2025-01-30 12:34:09'),(772,'01',34,'Modules\\Cash\\Models\\Cash',698,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-30 14:16:14','2025-01-30 14:16:14'),(773,'01',35,'Modules\\Cash\\Models\\Cash',38,'Modules\\Pos\\Models\\CashTransaction',4,'2025-01-30 14:41:21','2025-01-30 14:41:21'),(774,'01',35,'Modules\\Cash\\Models\\Cash',699,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 14:47:36','2025-01-30 14:47:36'),(775,'01',35,'Modules\\Cash\\Models\\Cash',700,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 16:35:28','2025-01-30 16:35:28'),(776,'01',35,'Modules\\Cash\\Models\\Cash',701,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 16:35:47','2025-01-30 16:35:47'),(777,'01',35,'Modules\\Cash\\Models\\Cash',702,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 16:42:32','2025-01-30 16:42:32'),(778,'01',35,'Modules\\Cash\\Models\\Cash',703,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 16:42:46','2025-01-30 16:42:46'),(779,'01',35,'Modules\\Cash\\Models\\Cash',704,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 16:56:40','2025-01-30 16:56:40'),(780,'01',35,'Modules\\Cash\\Models\\Cash',705,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 16:57:15','2025-01-30 16:57:15'),(781,'01',35,'Modules\\Cash\\Models\\Cash',706,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 18:01:29','2025-01-30 18:01:29'),(782,'01',35,'Modules\\Cash\\Models\\Cash',707,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 18:16:43','2025-01-30 18:16:43'),(783,'01',35,'Modules\\Cash\\Models\\Cash',708,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 18:17:02','2025-01-30 18:17:02'),(784,'01',35,'Modules\\Cash\\Models\\Cash',709,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 18:17:31','2025-01-30 18:17:31'),(785,'01',35,'Modules\\Cash\\Models\\Cash',710,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 18:27:51','2025-01-30 18:27:51'),(786,'01',35,'Modules\\Cash\\Models\\Cash',711,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 19:10:14','2025-01-30 19:10:14'),(787,'01',35,'Modules\\Cash\\Models\\Cash',712,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 19:10:26','2025-01-30 19:10:26'),(788,'01',35,'Modules\\Cash\\Models\\Cash',713,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 19:10:40','2025-01-30 19:10:40'),(789,'01',35,'Modules\\Cash\\Models\\Cash',714,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 19:26:58','2025-01-30 19:26:58'),(790,'01',35,'Modules\\Cash\\Models\\Cash',715,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 19:34:18','2025-01-30 19:34:18'),(791,'01',35,'Modules\\Cash\\Models\\Cash',716,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 19:34:38','2025-01-30 19:34:38'),(792,'01',35,'Modules\\Cash\\Models\\Cash',717,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 19:35:02','2025-01-30 19:35:02'),(793,'01',35,'Modules\\Cash\\Models\\Cash',718,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 19:57:23','2025-01-30 19:57:23'),(794,'01',35,'Modules\\Cash\\Models\\Cash',719,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 20:01:29','2025-01-30 20:01:29'),(795,'01',35,'Modules\\Cash\\Models\\Cash',720,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 20:03:46','2025-01-30 20:03:46'),(796,'01',35,'Modules\\Cash\\Models\\Cash',721,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 20:54:23','2025-01-30 20:54:23'),(797,'01',35,'Modules\\Cash\\Models\\Cash',722,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 21:05:52','2025-01-30 21:05:52'),(798,'01',35,'Modules\\Cash\\Models\\Cash',723,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 21:06:09','2025-01-30 21:06:09'),(799,'01',35,'Modules\\Cash\\Models\\Cash',724,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 21:06:29','2025-01-30 21:06:29'),(800,'01',35,'Modules\\Cash\\Models\\Cash',725,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 21:32:16','2025-01-30 21:32:16'),(801,'01',35,'Modules\\Cash\\Models\\Cash',726,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 21:46:24','2025-01-30 21:46:24'),(802,'01',35,'Modules\\Cash\\Models\\Cash',727,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 21:47:41','2025-01-30 21:47:41'),(803,'01',35,'Modules\\Cash\\Models\\Cash',728,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 21:48:08','2025-01-30 21:48:08'),(804,'01',35,'Modules\\Cash\\Models\\Cash',729,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 21:48:35','2025-01-30 21:48:35'),(805,'01',35,'Modules\\Cash\\Models\\Cash',730,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-30 21:49:43','2025-01-30 21:49:43'),(806,'01',36,'Modules\\Cash\\Models\\Cash',39,'Modules\\Pos\\Models\\CashTransaction',3,'2025-01-31 07:13:48','2025-01-31 07:13:48'),(807,'01',36,'Modules\\Cash\\Models\\Cash',731,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-31 10:36:09','2025-01-31 10:36:09'),(808,'01',36,'Modules\\Cash\\Models\\Cash',732,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-31 12:15:02','2025-01-31 12:15:02'),(809,'01',36,'Modules\\Cash\\Models\\Cash',733,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-31 12:30:32','2025-01-31 12:30:32'),(810,'01',36,'Modules\\Cash\\Models\\Cash',734,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-31 12:46:32','2025-01-31 12:46:32'),(811,'01',36,'Modules\\Cash\\Models\\Cash',735,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-31 12:47:47','2025-01-31 12:47:47'),(812,'01',36,'Modules\\Cash\\Models\\Cash',736,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-31 13:56:47','2025-01-31 13:56:47'),(813,'01',36,'Modules\\Cash\\Models\\Cash',737,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-01-31 14:23:05','2025-01-31 14:23:05'),(814,'01',37,'Modules\\Cash\\Models\\Cash',40,'Modules\\Pos\\Models\\CashTransaction',4,'2025-01-31 14:57:12','2025-01-31 14:57:12'),(815,'01',37,'Modules\\Cash\\Models\\Cash',738,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-31 16:20:46','2025-01-31 16:20:46'),(816,'01',37,'Modules\\Cash\\Models\\Cash',739,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-31 16:22:05','2025-01-31 16:22:05'),(817,'01',37,'Modules\\Cash\\Models\\Cash',740,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-31 16:22:25','2025-01-31 16:22:25'),(818,'01',37,'Modules\\Cash\\Models\\Cash',741,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-31 16:22:46','2025-01-31 16:22:46'),(819,'01',37,'Modules\\Cash\\Models\\Cash',742,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-31 16:23:08','2025-01-31 16:23:08'),(820,'01',37,'Modules\\Cash\\Models\\Cash',743,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-31 16:23:27','2025-01-31 16:23:27'),(821,'01',37,'Modules\\Cash\\Models\\Cash',744,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-31 16:23:43','2025-01-31 16:23:43'),(822,'01',37,'Modules\\Cash\\Models\\Cash',745,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-31 16:33:23','2025-01-31 16:33:23'),(823,'01',37,'Modules\\Cash\\Models\\Cash',746,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-31 16:49:34','2025-01-31 16:49:34'),(824,'01',37,'Modules\\Cash\\Models\\Cash',747,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-31 16:55:59','2025-01-31 16:55:59'),(825,'01',37,'Modules\\Cash\\Models\\Cash',748,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-31 18:10:33','2025-01-31 18:10:33'),(826,'01',37,'Modules\\Cash\\Models\\Cash',749,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-31 18:12:42','2025-01-31 18:12:42'),(827,'01',37,'Modules\\Cash\\Models\\Cash',750,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-01-31 18:15:47','2025-01-31 18:15:47'),(828,'01',37,'Modules\\Cash\\Models\\Cash',751,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:40:54','2025-02-01 07:40:54'),(829,'01',37,'Modules\\Cash\\Models\\Cash',752,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:41:25','2025-02-01 07:41:25'),(830,'01',37,'Modules\\Cash\\Models\\Cash',753,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:41:46','2025-02-01 07:41:46'),(831,'01',37,'Modules\\Cash\\Models\\Cash',754,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:42:09','2025-02-01 07:42:09'),(832,'01',37,'Modules\\Cash\\Models\\Cash',755,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:42:41','2025-02-01 07:42:41'),(833,'01',37,'Modules\\Cash\\Models\\Cash',756,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:43:00','2025-02-01 07:43:00'),(834,'01',37,'Modules\\Cash\\Models\\Cash',757,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:43:43','2025-02-01 07:43:43'),(835,'01',37,'Modules\\Cash\\Models\\Cash',758,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:44:21','2025-02-01 07:44:21'),(836,'01',37,'Modules\\Cash\\Models\\Cash',759,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:45:25','2025-02-01 07:45:25'),(837,'01',37,'Modules\\Cash\\Models\\Cash',760,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:45:46','2025-02-01 07:45:46'),(838,'01',37,'Modules\\Cash\\Models\\Cash',761,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:46:11','2025-02-01 07:46:11'),(839,'01',37,'Modules\\Cash\\Models\\Cash',762,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:46:33','2025-02-01 07:46:33'),(840,'01',37,'Modules\\Cash\\Models\\Cash',763,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:46:54','2025-02-01 07:46:54'),(841,'01',37,'Modules\\Cash\\Models\\Cash',764,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:47:33','2025-02-01 07:47:33'),(842,'01',37,'Modules\\Cash\\Models\\Cash',765,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:47:54','2025-02-01 07:47:54'),(843,'01',37,'Modules\\Cash\\Models\\Cash',766,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:48:14','2025-02-01 07:48:14'),(844,'01',37,'Modules\\Cash\\Models\\Cash',767,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:48:37','2025-02-01 07:48:37'),(845,'01',37,'Modules\\Cash\\Models\\Cash',768,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:49:12','2025-02-01 07:49:12'),(846,'01',38,'Modules\\Cash\\Models\\Cash',41,'Modules\\Pos\\Models\\CashTransaction',4,'2025-02-01 07:57:47','2025-02-01 07:57:47'),(847,'01',38,'Modules\\Cash\\Models\\Cash',769,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 07:58:34','2025-02-01 07:58:34'),(848,'01',38,'Modules\\Cash\\Models\\Cash',770,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 09:21:21','2025-02-01 09:21:21'),(849,'01',38,'Modules\\Cash\\Models\\Cash',771,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 09:28:55','2025-02-01 09:28:55'),(850,'01',38,'Modules\\Cash\\Models\\Cash',772,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 11:31:21','2025-02-01 11:31:21'),(851,'01',38,'Modules\\Cash\\Models\\Cash',773,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 11:32:10','2025-02-01 11:32:10'),(852,'01',38,'Modules\\Cash\\Models\\Cash',774,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 11:32:35','2025-02-01 11:32:35'),(853,'01',38,'Modules\\Cash\\Models\\Cash',775,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 11:33:01','2025-02-01 11:33:01'),(854,'01',38,'Modules\\Cash\\Models\\Cash',776,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 11:33:29','2025-02-01 11:33:29'),(855,'01',38,'Modules\\Cash\\Models\\Cash',777,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 11:34:17','2025-02-01 11:34:17'),(856,'01',38,'Modules\\Cash\\Models\\Cash',778,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 11:49:18','2025-02-01 11:49:18'),(857,'01',38,'Modules\\Cash\\Models\\Cash',779,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 12:12:13','2025-02-01 12:12:13'),(858,'01',38,'Modules\\Cash\\Models\\Cash',780,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 12:12:33','2025-02-01 12:12:33'),(859,'01',38,'Modules\\Cash\\Models\\Cash',781,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 12:12:48','2025-02-01 12:12:48'),(860,'01',38,'Modules\\Cash\\Models\\Cash',782,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 15:52:13','2025-02-01 15:52:13'),(861,'01',38,'Modules\\Cash\\Models\\Cash',783,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 15:53:22','2025-02-01 15:53:22'),(862,'01',38,'Modules\\Cash\\Models\\Cash',784,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 15:53:44','2025-02-01 15:53:44'),(863,'01',38,'Modules\\Cash\\Models\\Cash',785,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 15:54:02','2025-02-01 15:54:02'),(864,'01',38,'Modules\\Cash\\Models\\Cash',786,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 15:54:18','2025-02-01 15:54:18'),(865,'01',38,'Modules\\Cash\\Models\\Cash',787,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 15:54:37','2025-02-01 15:54:37'),(866,'01',38,'Modules\\Cash\\Models\\Cash',788,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 15:57:49','2025-02-01 15:57:49'),(867,'01',38,'Modules\\Cash\\Models\\Cash',789,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 15:58:08','2025-02-01 15:58:08'),(868,'01',38,'Modules\\Cash\\Models\\Cash',790,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 15:58:35','2025-02-01 15:58:35'),(869,'01',38,'Modules\\Cash\\Models\\Cash',791,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 15:58:56','2025-02-01 15:58:56'),(870,'01',38,'Modules\\Cash\\Models\\Cash',792,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 15:59:26','2025-02-01 15:59:26'),(871,'01',38,'Modules\\Cash\\Models\\Cash',793,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 15:59:58','2025-02-01 15:59:58'),(872,'01',38,'Modules\\Cash\\Models\\Cash',794,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 16:10:35','2025-02-01 16:10:35'),(873,'01',38,'Modules\\Cash\\Models\\Cash',795,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 16:23:55','2025-02-01 16:23:55'),(874,'01',38,'Modules\\Cash\\Models\\Cash',796,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 16:28:56','2025-02-01 16:28:56'),(875,'01',38,'Modules\\Cash\\Models\\Cash',797,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 16:36:46','2025-02-01 16:36:46'),(876,'01',38,'Modules\\Cash\\Models\\Cash',798,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:14:35','2025-02-01 21:14:35'),(877,'01',38,'Modules\\Cash\\Models\\Cash',799,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:15:40','2025-02-01 21:15:40'),(878,'01',38,'Modules\\Cash\\Models\\Cash',800,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:20:40','2025-02-01 21:20:40'),(879,'01',38,'Modules\\Cash\\Models\\Cash',801,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:33:13','2025-02-01 21:33:13'),(880,'01',38,'Modules\\Cash\\Models\\Cash',802,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:34:27','2025-02-01 21:34:27'),(881,'01',38,'Modules\\Cash\\Models\\Cash',803,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:35:08','2025-02-01 21:35:08'),(882,'01',38,'Modules\\Cash\\Models\\Cash',804,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:37:15','2025-02-01 21:37:15'),(883,'01',38,'Modules\\Cash\\Models\\Cash',805,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:38:31','2025-02-01 21:38:31'),(884,'01',38,'Modules\\Cash\\Models\\Cash',806,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:38:54','2025-02-01 21:38:54'),(885,'01',38,'Modules\\Cash\\Models\\Cash',807,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:39:14','2025-02-01 21:39:14'),(886,'01',38,'Modules\\Cash\\Models\\Cash',808,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:39:53','2025-02-01 21:39:53'),(887,'01',38,'Modules\\Cash\\Models\\Cash',809,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:40:14','2025-02-01 21:40:14'),(888,'01',38,'Modules\\Cash\\Models\\Cash',810,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:42:15','2025-02-01 21:42:15'),(889,'01',38,'Modules\\Cash\\Models\\Cash',811,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:42:40','2025-02-01 21:42:40'),(890,'01',38,'Modules\\Cash\\Models\\Cash',812,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:50:48','2025-02-01 21:50:48'),(891,'01',38,'Modules\\Cash\\Models\\Cash',813,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:51:08','2025-02-01 21:51:08'),(892,'01',38,'Modules\\Cash\\Models\\Cash',814,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:51:28','2025-02-01 21:51:28'),(893,'01',38,'Modules\\Cash\\Models\\Cash',815,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:51:53','2025-02-01 21:51:53'),(894,'01',38,'Modules\\Cash\\Models\\Cash',816,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:52:13','2025-02-01 21:52:13'),(895,'01',38,'Modules\\Cash\\Models\\Cash',817,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:55:02','2025-02-01 21:55:02'),(896,'01',38,'Modules\\Cash\\Models\\Cash',818,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:55:31','2025-02-01 21:55:31'),(897,'01',38,'Modules\\Cash\\Models\\Cash',819,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:55:51','2025-02-01 21:55:51'),(898,'01',38,'Modules\\Cash\\Models\\Cash',820,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-01 21:56:18','2025-02-01 21:56:18'),(899,'01',39,'Modules\\Cash\\Models\\Cash',42,'Modules\\Pos\\Models\\CashTransaction',3,'2025-02-02 07:47:54','2025-02-02 07:47:54'),(900,'01',39,'Modules\\Cash\\Models\\Cash',821,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 07:50:50','2025-02-02 07:50:50'),(901,'01',39,'Modules\\Cash\\Models\\Cash',822,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 07:51:41','2025-02-02 07:51:41'),(902,'01',39,'Modules\\Cash\\Models\\Cash',823,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 11:22:55','2025-02-02 11:22:55'),(903,'01',39,'Modules\\Cash\\Models\\Cash',824,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 12:50:15','2025-02-02 12:50:15'),(904,'01',39,'Modules\\Cash\\Models\\Cash',825,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 13:32:50','2025-02-02 13:32:50'),(905,'01',39,'Modules\\Cash\\Models\\Cash',826,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 14:24:39','2025-02-02 14:24:39'),(906,'01',39,'Modules\\Cash\\Models\\Cash',827,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 15:21:01','2025-02-02 15:21:01'),(907,'01',39,'Modules\\Cash\\Models\\Cash',828,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 15:37:15','2025-02-02 15:37:15'),(908,'01',39,'Modules\\Cash\\Models\\Cash',829,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 15:55:13','2025-02-02 15:55:13'),(909,'01',39,'Modules\\Cash\\Models\\Cash',830,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 17:06:37','2025-02-02 17:06:37'),(910,'01',39,'Modules\\Cash\\Models\\Cash',831,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 17:32:35','2025-02-02 17:32:35'),(911,'01',39,'Modules\\Cash\\Models\\Cash',832,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 18:05:07','2025-02-02 18:05:07'),(912,'01',39,'Modules\\Cash\\Models\\Cash',833,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 18:13:32','2025-02-02 18:13:32'),(913,'01',39,'Modules\\Cash\\Models\\Cash',834,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 18:36:37','2025-02-02 18:36:37'),(914,'01',39,'Modules\\Cash\\Models\\Cash',835,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 19:38:23','2025-02-02 19:38:23'),(915,'01',39,'Modules\\Cash\\Models\\Cash',836,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 19:40:14','2025-02-02 19:40:14'),(916,'01',39,'Modules\\Cash\\Models\\Cash',837,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 19:54:52','2025-02-02 19:54:52'),(917,'01',39,'Modules\\Cash\\Models\\Cash',838,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 20:43:12','2025-02-02 20:43:12'),(918,'01',39,'Modules\\Cash\\Models\\Cash',839,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 20:45:44','2025-02-02 20:45:44'),(919,'01',39,'Modules\\Cash\\Models\\Cash',840,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 20:50:03','2025-02-02 20:50:03'),(920,'01',39,'Modules\\Cash\\Models\\Cash',841,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 22:00:47','2025-02-02 22:00:47'),(921,'01',39,'Modules\\Cash\\Models\\Cash',842,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-02 22:01:28','2025-02-02 22:01:28'),(922,'01',40,'Modules\\Cash\\Models\\Cash',43,'Modules\\Pos\\Models\\CashTransaction',3,'2025-02-03 07:24:40','2025-02-03 07:24:40'),(923,'01',40,'Modules\\Cash\\Models\\Cash',843,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-03 11:12:22','2025-02-03 11:12:22'),(924,'01',40,'Modules\\Cash\\Models\\Cash',844,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-03 11:33:06','2025-02-03 11:33:06'),(925,'01',40,'Modules\\Cash\\Models\\Cash',845,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-03 12:18:12','2025-02-03 12:18:12'),(926,'01',40,'Modules\\Cash\\Models\\Cash',846,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-03 12:34:02','2025-02-03 12:34:02'),(927,'01',40,'Modules\\Cash\\Models\\Cash',847,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-03 13:06:44','2025-02-03 13:06:44'),(928,'01',40,'Modules\\Cash\\Models\\Cash',848,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-03 13:46:32','2025-02-03 13:46:32'),(929,'01',40,'Modules\\Cash\\Models\\Cash',849,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-03 14:26:46','2025-02-03 14:26:46'),(930,'01',41,'Modules\\Cash\\Models\\Cash',44,'Modules\\Pos\\Models\\CashTransaction',4,'2025-02-03 14:44:00','2025-02-03 14:44:00'),(931,'01',41,'Modules\\Cash\\Models\\Cash',850,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-03 15:23:04','2025-02-03 15:23:04'),(932,'01',41,'Modules\\Cash\\Models\\Cash',851,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-03 15:23:20','2025-02-03 15:23:20'),(933,'01',41,'Modules\\Cash\\Models\\Cash',852,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-03 15:23:41','2025-02-03 15:23:41'),(934,'01',41,'Modules\\Cash\\Models\\Cash',853,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-03 15:30:03','2025-02-03 15:30:03'),(935,'01',41,'Modules\\Cash\\Models\\Cash',854,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 15:42:24','2025-02-04 15:42:24'),(936,'01',41,'Modules\\Cash\\Models\\Cash',855,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 15:43:00','2025-02-04 15:43:00'),(937,'01',41,'Modules\\Cash\\Models\\Cash',856,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 15:45:28','2025-02-04 15:45:28'),(938,'01',41,'Modules\\Cash\\Models\\Cash',857,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 15:45:55','2025-02-04 15:45:55'),(939,'01',41,'Modules\\Cash\\Models\\Cash',858,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 15:46:15','2025-02-04 15:46:15'),(940,'01',41,'Modules\\Cash\\Models\\Cash',859,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 15:46:56','2025-02-04 15:46:56'),(942,'01',41,'Modules\\Cash\\Models\\Cash',861,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:16:40','2025-02-04 16:16:40'),(943,'01',41,'Modules\\Cash\\Models\\Cash',862,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:18:12','2025-02-04 16:18:12'),(944,'01',41,'Modules\\Cash\\Models\\Cash',863,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:18:38','2025-02-04 16:18:38'),(945,'01',41,'Modules\\Cash\\Models\\Cash',864,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:19:09','2025-02-04 16:19:09'),(946,'01',41,'Modules\\Cash\\Models\\Cash',865,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:19:26','2025-02-04 16:19:26'),(947,'01',41,'Modules\\Cash\\Models\\Cash',866,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:19:43','2025-02-04 16:19:43'),(948,'01',41,'Modules\\Cash\\Models\\Cash',867,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:20:04','2025-02-04 16:20:04'),(949,'01',41,'Modules\\Cash\\Models\\Cash',868,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:20:22','2025-02-04 16:20:22'),(950,'01',41,'Modules\\Cash\\Models\\Cash',869,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:20:47','2025-02-04 16:20:47'),(951,'01',41,'Modules\\Cash\\Models\\Cash',870,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:21:08','2025-02-04 16:21:08'),(952,'01',41,'Modules\\Cash\\Models\\Cash',871,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:21:31','2025-02-04 16:21:31'),(953,'01',41,'Modules\\Cash\\Models\\Cash',872,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:27:41','2025-02-04 16:27:41'),(954,'01',41,'Modules\\Cash\\Models\\Cash',873,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:28:10','2025-02-04 16:28:10'),(955,'01',41,'Modules\\Cash\\Models\\Cash',874,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:28:30','2025-02-04 16:28:30'),(956,'01',41,'Modules\\Cash\\Models\\Cash',875,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:28:46','2025-02-04 16:28:46'),(957,'01',41,'Modules\\Cash\\Models\\Cash',876,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:29:05','2025-02-04 16:29:05'),(958,'01',41,'Modules\\Cash\\Models\\Cash',877,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:29:55','2025-02-04 16:29:55'),(959,'01',41,'Modules\\Cash\\Models\\Cash',878,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:30:19','2025-02-04 16:30:19'),(960,'01',41,'Modules\\Cash\\Models\\Cash',879,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 16:30:36','2025-02-04 16:30:36'),(961,'01',41,'Modules\\Cash\\Models\\Cash',880,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 17:06:39','2025-02-04 17:06:39'),(962,'01',42,'Modules\\Cash\\Models\\Cash',45,'Modules\\Pos\\Models\\CashTransaction',4,'2025-02-04 18:09:24','2025-02-04 18:09:24'),(963,'01',43,'Modules\\Cash\\Models\\Cash',46,'Modules\\Pos\\Models\\CashTransaction',3,'2025-02-04 18:11:17','2025-02-04 18:11:17'),(964,'01',43,'Modules\\Cash\\Models\\Cash',881,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:27:32','2025-02-04 18:27:32'),(965,'01',43,'Modules\\Cash\\Models\\Cash',882,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:28:08','2025-02-04 18:28:08'),(966,'01',43,'Modules\\Cash\\Models\\Cash',883,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:31:16','2025-02-04 18:31:16'),(967,'01',43,'Modules\\Cash\\Models\\Cash',884,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:31:36','2025-02-04 18:31:36'),(968,'01',43,'Modules\\Cash\\Models\\Cash',885,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:31:58','2025-02-04 18:31:58'),(969,'01',43,'Modules\\Cash\\Models\\Cash',886,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:32:27','2025-02-04 18:32:27'),(970,'01',43,'Modules\\Cash\\Models\\Cash',887,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:32:51','2025-02-04 18:32:51'),(971,'01',43,'Modules\\Cash\\Models\\Cash',888,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:33:18','2025-02-04 18:33:18'),(972,'01',43,'Modules\\Cash\\Models\\Cash',889,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:33:45','2025-02-04 18:33:45'),(973,'01',43,'Modules\\Cash\\Models\\Cash',890,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:34:02','2025-02-04 18:34:02'),(974,'01',43,'Modules\\Cash\\Models\\Cash',891,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:35:02','2025-02-04 18:35:02'),(975,'01',43,'Modules\\Cash\\Models\\Cash',892,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:37:31','2025-02-04 18:37:31'),(976,'01',43,'Modules\\Cash\\Models\\Cash',893,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:38:26','2025-02-04 18:38:26'),(977,'01',43,'Modules\\Cash\\Models\\Cash',894,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:39:36','2025-02-04 18:39:36'),(978,'01',43,'Modules\\Cash\\Models\\Cash',895,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:40:02','2025-02-04 18:40:02'),(979,'01',43,'Modules\\Cash\\Models\\Cash',896,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:40:27','2025-02-04 18:40:27'),(980,'01',43,'Modules\\Cash\\Models\\Cash',897,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:41:09','2025-02-04 18:41:09'),(981,'01',43,'Modules\\Cash\\Models\\Cash',898,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:41:50','2025-02-04 18:41:50'),(982,'01',43,'Modules\\Cash\\Models\\Cash',899,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:42:11','2025-02-04 18:42:11'),(983,'01',43,'Modules\\Cash\\Models\\Cash',900,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:42:39','2025-02-04 18:42:39'),(984,'01',43,'Modules\\Cash\\Models\\Cash',901,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-04 18:44:28','2025-02-04 18:44:28'),(985,'01',42,'Modules\\Cash\\Models\\Cash',902,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 18:45:57','2025-02-04 18:45:57'),(986,'01',42,'Modules\\Cash\\Models\\Cash',903,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 18:46:20','2025-02-04 18:46:20'),(987,'01',42,'Modules\\Cash\\Models\\Cash',904,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 18:46:43','2025-02-04 18:46:43'),(988,'01',42,'Modules\\Cash\\Models\\Cash',905,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 18:47:06','2025-02-04 18:47:06'),(989,'01',42,'Modules\\Cash\\Models\\Cash',906,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 18:47:41','2025-02-04 18:47:41'),(990,'01',42,'Modules\\Cash\\Models\\Cash',907,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 18:48:00','2025-02-04 18:48:00'),(991,'01',42,'Modules\\Cash\\Models\\Cash',908,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 18:48:25','2025-02-04 18:48:25'),(992,'01',42,'Modules\\Cash\\Models\\Cash',909,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 18:48:43','2025-02-04 18:48:43'),(993,'01',42,'Modules\\Cash\\Models\\Cash',910,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 18:54:55','2025-02-04 18:54:55'),(994,'01',42,'Modules\\Cash\\Models\\Cash',911,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 18:55:16','2025-02-04 18:55:16'),(995,'01',42,'Modules\\Cash\\Models\\Cash',912,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 18:55:35','2025-02-04 18:55:35'),(996,'01',42,'Modules\\Cash\\Models\\Cash',913,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 19:24:56','2025-02-04 19:24:56'),(997,'01',42,'Modules\\Cash\\Models\\Cash',914,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 19:25:19','2025-02-04 19:25:19'),(998,'01',42,'Modules\\Cash\\Models\\Cash',915,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 19:25:37','2025-02-04 19:25:37'),(999,'01',42,'Modules\\Cash\\Models\\Cash',916,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 19:39:07','2025-02-04 19:39:07'),(1000,'01',42,'Modules\\Cash\\Models\\Cash',917,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 19:40:37','2025-02-04 19:40:37'),(1001,'01',42,'Modules\\Cash\\Models\\Cash',918,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 19:41:11','2025-02-04 19:41:11'),(1002,'01',42,'Modules\\Cash\\Models\\Cash',919,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 20:01:17','2025-02-04 20:01:17'),(1003,'01',42,'Modules\\Cash\\Models\\Cash',920,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 20:17:18','2025-02-04 20:17:18'),(1004,'01',42,'Modules\\Cash\\Models\\Cash',921,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 21:40:12','2025-02-04 21:40:12'),(1005,'01',42,'Modules\\Cash\\Models\\Cash',922,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 21:40:47','2025-02-04 21:40:47'),(1006,'01',42,'Modules\\Cash\\Models\\Cash',923,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 21:41:21','2025-02-04 21:41:21'),(1007,'01',42,'Modules\\Cash\\Models\\Cash',924,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 21:41:39','2025-02-04 21:41:39'),(1008,'01',42,'Modules\\Cash\\Models\\Cash',925,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 21:42:07','2025-02-04 21:42:07'),(1009,'01',42,'Modules\\Cash\\Models\\Cash',926,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 21:42:30','2025-02-04 21:42:30'),(1010,'01',42,'Modules\\Cash\\Models\\Cash',927,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 21:43:12','2025-02-04 21:43:12'),(1011,'01',42,'Modules\\Cash\\Models\\Cash',928,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 21:46:00','2025-02-04 21:46:00'),(1012,'01',42,'Modules\\Cash\\Models\\Cash',929,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 21:46:36','2025-02-04 21:46:36'),(1013,'01',42,'Modules\\Cash\\Models\\Cash',930,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 21:47:10','2025-02-04 21:47:10'),(1014,'01',42,'Modules\\Cash\\Models\\Cash',931,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 21:47:43','2025-02-04 21:47:43'),(1015,'01',42,'Modules\\Cash\\Models\\Cash',932,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 22:11:07','2025-02-04 22:11:07'),(1016,'01',42,'Modules\\Cash\\Models\\Cash',933,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-04 22:11:18','2025-02-04 22:11:18'),(1017,'01',44,'Modules\\Cash\\Models\\Cash',47,'Modules\\Pos\\Models\\CashTransaction',3,'2025-02-05 07:25:00','2025-02-05 07:25:00'),(1018,'01',44,'Modules\\Cash\\Models\\Cash',934,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-05 09:26:53','2025-02-05 09:26:53'),(1019,'01',44,'Modules\\Cash\\Models\\Cash',935,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-05 12:26:12','2025-02-05 12:26:12'),(1020,'01',44,'Modules\\Cash\\Models\\Cash',936,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-05 12:56:57','2025-02-05 12:56:57'),(1021,'01',44,'Modules\\Cash\\Models\\Cash',937,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-05 13:14:57','2025-02-05 13:14:57'),(1022,'01',44,'Modules\\Cash\\Models\\Cash',938,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-05 14:03:45','2025-02-05 14:03:45'),(1023,'01',44,'Modules\\Cash\\Models\\Cash',939,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-05 14:30:03','2025-02-05 14:30:03'),(1024,'01',45,'Modules\\Cash\\Models\\Cash',48,'Modules\\Pos\\Models\\CashTransaction',4,'2025-02-05 14:45:00','2025-02-05 14:45:00'),(1025,'01',45,'Modules\\Cash\\Models\\Cash',940,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 14:50:35','2025-02-05 14:50:35'),(1026,'01',45,'Modules\\Cash\\Models\\Cash',941,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 15:19:43','2025-02-05 15:19:43'),(1027,'01',45,'Modules\\Cash\\Models\\Cash',942,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 15:20:50','2025-02-05 15:20:50'),(1028,'01',45,'Modules\\Cash\\Models\\Cash',943,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 15:21:30','2025-02-05 15:21:30'),(1029,'01',45,'Modules\\Cash\\Models\\Cash',944,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 15:21:47','2025-02-05 15:21:47'),(1030,'01',45,'Modules\\Cash\\Models\\Cash',945,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 15:29:35','2025-02-05 15:29:35'),(1031,'01',45,'Modules\\Cash\\Models\\Cash',946,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 17:41:17','2025-02-05 17:41:17'),(1032,'01',45,'Modules\\Cash\\Models\\Cash',947,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 20:26:44','2025-02-05 20:26:44'),(1033,'01',45,'Modules\\Cash\\Models\\Cash',948,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 20:33:18','2025-02-05 20:33:18'),(1034,'01',45,'Modules\\Cash\\Models\\Cash',949,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 20:33:42','2025-02-05 20:33:42'),(1035,'01',45,'Modules\\Cash\\Models\\Cash',950,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 20:34:08','2025-02-05 20:34:08'),(1036,'01',45,'Modules\\Cash\\Models\\Cash',951,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 20:59:15','2025-02-05 20:59:15'),(1037,'01',45,'Modules\\Cash\\Models\\Cash',952,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 21:25:22','2025-02-05 21:25:22'),(1038,'01',45,'Modules\\Cash\\Models\\Cash',953,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 21:49:47','2025-02-05 21:49:47'),(1039,'01',45,'Modules\\Cash\\Models\\Cash',954,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 21:50:05','2025-02-05 21:50:05'),(1040,'01',45,'Modules\\Cash\\Models\\Cash',955,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 22:06:25','2025-02-05 22:06:25'),(1041,'01',45,'Modules\\Cash\\Models\\Cash',956,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 22:21:07','2025-02-05 22:21:07'),(1042,'01',45,'Modules\\Cash\\Models\\Cash',957,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 22:21:31','2025-02-05 22:21:31'),(1043,'01',45,'Modules\\Cash\\Models\\Cash',958,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-05 22:21:48','2025-02-05 22:21:48'),(1044,'01',46,'Modules\\Cash\\Models\\Cash',49,'Modules\\Pos\\Models\\CashTransaction',4,'2025-02-06 14:52:31','2025-02-06 14:52:31'),(1045,'01',47,'Modules\\Cash\\Models\\Cash',50,'Modules\\Pos\\Models\\CashTransaction',3,'2025-02-06 14:53:37','2025-02-06 14:53:37'),(1046,'01',46,'Modules\\Cash\\Models\\Cash',959,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 16:12:08','2025-02-06 16:12:08'),(1047,'01',46,'Modules\\Cash\\Models\\Cash',960,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 20:25:53','2025-02-06 20:25:53'),(1048,'01',46,'Modules\\Cash\\Models\\Cash',961,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 20:26:20','2025-02-06 20:26:20'),(1049,'01',46,'Modules\\Cash\\Models\\Cash',962,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 20:26:37','2025-02-06 20:26:37'),(1050,'01',46,'Modules\\Cash\\Models\\Cash',963,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 20:27:09','2025-02-06 20:27:09'),(1051,'01',46,'Modules\\Cash\\Models\\Cash',964,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 20:27:25','2025-02-06 20:27:25'),(1052,'01',46,'Modules\\Cash\\Models\\Cash',965,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 20:27:47','2025-02-06 20:27:47'),(1053,'01',46,'Modules\\Cash\\Models\\Cash',966,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 20:28:29','2025-02-06 20:28:29'),(1054,'01',46,'Modules\\Cash\\Models\\Cash',967,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 20:28:53','2025-02-06 20:28:53'),(1055,'01',46,'Modules\\Cash\\Models\\Cash',968,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 20:29:28','2025-02-06 20:29:28'),(1056,'01',46,'Modules\\Cash\\Models\\Cash',969,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 20:29:53','2025-02-06 20:29:53'),(1057,'01',46,'Modules\\Cash\\Models\\Cash',970,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 20:30:13','2025-02-06 20:30:13'),(1058,'01',46,'Modules\\Cash\\Models\\Cash',971,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 20:43:35','2025-02-06 20:43:35'),(1059,'01',46,'Modules\\Cash\\Models\\Cash',972,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 20:55:31','2025-02-06 20:55:31'),(1060,'01',46,'Modules\\Cash\\Models\\Cash',973,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 21:04:52','2025-02-06 21:04:52'),(1061,'01',46,'Modules\\Cash\\Models\\Cash',974,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 21:23:03','2025-02-06 21:23:03'),(1062,'01',46,'Modules\\Cash\\Models\\Cash',975,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 21:27:13','2025-02-06 21:27:13'),(1063,'01',46,'Modules\\Cash\\Models\\Cash',976,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 21:30:38','2025-02-06 21:30:38'),(1064,'01',46,'Modules\\Cash\\Models\\Cash',977,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 21:34:37','2025-02-06 21:34:37'),(1065,'01',46,'Modules\\Cash\\Models\\Cash',978,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 21:35:07','2025-02-06 21:35:07'),(1066,'01',46,'Modules\\Cash\\Models\\Cash',979,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 21:35:29','2025-02-06 21:35:29'),(1067,'01',46,'Modules\\Cash\\Models\\Cash',980,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 22:27:53','2025-02-06 22:27:53'),(1068,'01',46,'Modules\\Cash\\Models\\Cash',981,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 22:28:08','2025-02-06 22:28:08'),(1069,'01',46,'Modules\\Cash\\Models\\Cash',982,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 22:35:06','2025-02-06 22:35:06'),(1070,'01',46,'Modules\\Cash\\Models\\Cash',983,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-06 22:35:21','2025-02-06 22:35:21'),(1071,'01',47,'Modules\\Cash\\Models\\Cash',984,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-07 09:06:50','2025-02-07 09:06:50'),(1074,'01',49,'Modules\\Cash\\Models\\Cash',52,'Modules\\Pos\\Models\\CashTransaction',3,'2025-02-07 11:00:44','2025-02-07 11:00:44'),(1075,'01',49,'Modules\\Cash\\Models\\Cash',986,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-07 14:03:21','2025-02-07 14:03:21'),(1076,'01',49,'Modules\\Cash\\Models\\Cash',987,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-07 14:04:43','2025-02-07 14:04:43'),(1077,'01',49,'Modules\\Cash\\Models\\Cash',988,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-07 14:26:15','2025-02-07 14:26:15'),(1078,'01',50,'Modules\\Cash\\Models\\Cash',53,'Modules\\Pos\\Models\\CashTransaction',4,'2025-02-07 15:10:48','2025-02-07 15:10:48'),(1079,'01',50,'Modules\\Cash\\Models\\Cash',989,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 21:38:04','2025-02-07 21:38:04'),(1080,'01',50,'Modules\\Cash\\Models\\Cash',990,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 21:39:39','2025-02-07 21:39:39'),(1081,'01',50,'Modules\\Cash\\Models\\Cash',991,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 21:40:29','2025-02-07 21:40:29'),(1082,'01',50,'Modules\\Cash\\Models\\Cash',992,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 21:41:17','2025-02-07 21:41:17'),(1083,'01',50,'Modules\\Cash\\Models\\Cash',993,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 21:41:37','2025-02-07 21:41:37'),(1084,'01',50,'Modules\\Cash\\Models\\Cash',994,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 21:44:13','2025-02-07 21:44:13'),(1085,'01',50,'Modules\\Cash\\Models\\Cash',995,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 21:51:42','2025-02-07 21:51:42'),(1086,'01',50,'Modules\\Cash\\Models\\Cash',996,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 21:52:10','2025-02-07 21:52:10'),(1087,'01',50,'Modules\\Cash\\Models\\Cash',997,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 21:52:39','2025-02-07 21:52:39'),(1088,'01',50,'Modules\\Cash\\Models\\Cash',998,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 21:53:03','2025-02-07 21:53:03'),(1089,'01',50,'Modules\\Cash\\Models\\Cash',999,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 21:54:09','2025-02-07 21:54:09'),(1090,'01',50,'Modules\\Cash\\Models\\Cash',1000,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 21:55:07','2025-02-07 21:55:07'),(1091,'01',50,'Modules\\Cash\\Models\\Cash',1001,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 21:55:27','2025-02-07 21:55:27'),(1092,'01',50,'Modules\\Cash\\Models\\Cash',1002,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 21:55:48','2025-02-07 21:55:48'),(1093,'01',50,'Modules\\Cash\\Models\\Cash',1003,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 21:57:08','2025-02-07 21:57:08'),(1094,'01',50,'Modules\\Cash\\Models\\Cash',1004,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 21:58:09','2025-02-07 21:58:09'),(1095,'01',50,'Modules\\Cash\\Models\\Cash',1005,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 22:00:28','2025-02-07 22:00:28'),(1096,'01',50,'Modules\\Cash\\Models\\Cash',1006,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 22:00:57','2025-02-07 22:00:57'),(1097,'01',50,'Modules\\Cash\\Models\\Cash',1007,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 22:25:22','2025-02-07 22:25:22'),(1098,'01',50,'Modules\\Cash\\Models\\Cash',1008,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-07 22:30:37','2025-02-07 22:30:37'),(1099,'01',51,'Modules\\Cash\\Models\\Cash',54,'Modules\\Pos\\Models\\CashTransaction',4,'2025-02-08 07:10:30','2025-02-08 07:10:30'),(1100,'01',51,'Modules\\Cash\\Models\\Cash',1009,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 07:28:06','2025-02-08 07:28:06'),(1101,'01',51,'Modules\\Cash\\Models\\Cash',1010,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 07:29:53','2025-02-08 07:29:53'),(1102,'01',51,'Modules\\Cash\\Models\\Cash',1011,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 12:21:56','2025-02-08 12:21:56'),(1103,'01',51,'Modules\\Cash\\Models\\Cash',1012,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 12:22:49','2025-02-08 12:22:49'),(1104,'01',51,'Modules\\Cash\\Models\\Cash',1013,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 12:23:29','2025-02-08 12:23:29'),(1105,'01',51,'Modules\\Cash\\Models\\Cash',1014,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 12:23:47','2025-02-08 12:23:47'),(1106,'01',51,'Modules\\Cash\\Models\\Cash',1015,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 12:24:08','2025-02-08 12:24:08'),(1107,'01',51,'Modules\\Cash\\Models\\Cash',1016,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 12:24:25','2025-02-08 12:24:25'),(1108,'01',51,'Modules\\Cash\\Models\\Cash',1017,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 12:24:48','2025-02-08 12:24:48'),(1109,'01',51,'Modules\\Cash\\Models\\Cash',1018,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 12:25:34','2025-02-08 12:25:34'),(1110,'01',51,'Modules\\Cash\\Models\\Cash',1019,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 17:31:36','2025-02-08 17:31:36'),(1111,'01',51,'Modules\\Cash\\Models\\Cash',1020,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 17:32:00','2025-02-08 17:32:00'),(1112,'01',51,'Modules\\Cash\\Models\\Cash',1021,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 17:32:30','2025-02-08 17:32:30'),(1113,'01',51,'Modules\\Cash\\Models\\Cash',1022,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 17:34:13','2025-02-08 17:34:13'),(1114,'01',51,'Modules\\Cash\\Models\\Cash',1023,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 17:34:55','2025-02-08 17:34:55'),(1115,'01',51,'Modules\\Cash\\Models\\Cash',1024,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 17:35:14','2025-02-08 17:35:14'),(1116,'01',51,'Modules\\Cash\\Models\\Cash',1025,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 17:35:42','2025-02-08 17:35:42'),(1117,'01',51,'Modules\\Cash\\Models\\Cash',1026,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 17:36:01','2025-02-08 17:36:01'),(1118,'01',51,'Modules\\Cash\\Models\\Cash',1027,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 17:36:20','2025-02-08 17:36:20'),(1119,'01',51,'Modules\\Cash\\Models\\Cash',1028,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 18:10:36','2025-02-08 18:10:36'),(1120,'01',51,'Modules\\Cash\\Models\\Cash',1029,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 20:14:01','2025-02-08 20:14:01'),(1121,'01',51,'Modules\\Cash\\Models\\Cash',1030,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 21:02:49','2025-02-08 21:02:49'),(1122,'01',51,'Modules\\Cash\\Models\\Cash',1031,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 21:03:18','2025-02-08 21:03:18'),(1123,'01',51,'Modules\\Cash\\Models\\Cash',1032,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 21:03:38','2025-02-08 21:03:38'),(1124,'01',51,'Modules\\Cash\\Models\\Cash',1033,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 21:04:04','2025-02-08 21:04:04'),(1125,'01',51,'Modules\\Cash\\Models\\Cash',1034,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 21:04:33','2025-02-08 21:04:33'),(1126,'01',51,'Modules\\Cash\\Models\\Cash',1035,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 21:06:38','2025-02-08 21:06:38'),(1127,'01',51,'Modules\\Cash\\Models\\Cash',1036,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 21:07:09','2025-02-08 21:07:09'),(1128,'01',51,'Modules\\Cash\\Models\\Cash',1037,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 21:07:59','2025-02-08 21:07:59'),(1129,'01',51,'Modules\\Cash\\Models\\Cash',1038,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 21:09:00','2025-02-08 21:09:00'),(1130,'01',51,'Modules\\Cash\\Models\\Cash',1039,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 21:09:48','2025-02-08 21:09:48'),(1131,'01',51,'Modules\\Cash\\Models\\Cash',1040,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 21:10:30','2025-02-08 21:10:30'),(1132,'01',51,'Modules\\Cash\\Models\\Cash',1041,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 21:10:49','2025-02-08 21:10:49'),(1133,'01',51,'Modules\\Cash\\Models\\Cash',1042,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 21:14:51','2025-02-08 21:14:51'),(1134,'01',51,'Modules\\Cash\\Models\\Cash',1043,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 21:39:51','2025-02-08 21:39:51'),(1135,'01',51,'Modules\\Cash\\Models\\Cash',1044,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 21:55:45','2025-02-08 21:55:45'),(1136,'01',51,'Modules\\Cash\\Models\\Cash',1045,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 22:02:46','2025-02-08 22:02:46'),(1137,'01',51,'Modules\\Cash\\Models\\Cash',1046,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 22:04:20','2025-02-08 22:04:20'),(1138,'01',51,'Modules\\Cash\\Models\\Cash',1047,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 22:21:19','2025-02-08 22:21:19'),(1139,'01',51,'Modules\\Cash\\Models\\Cash',1048,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 22:21:40','2025-02-08 22:21:40'),(1140,'01',51,'Modules\\Cash\\Models\\Cash',1049,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-08 22:30:33','2025-02-08 22:30:33'),(1141,'01',52,'Modules\\Cash\\Models\\Cash',55,'Modules\\Pos\\Models\\CashTransaction',3,'2025-02-09 08:35:37','2025-02-09 08:35:37'),(1142,'01',52,'Modules\\Cash\\Models\\Cash',1050,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-09 08:44:51','2025-02-09 08:44:51'),(1143,'01',52,'Modules\\Cash\\Models\\Cash',1051,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-09 09:42:16','2025-02-09 09:42:16'),(1144,'01',52,'Modules\\Cash\\Models\\Cash',1052,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-09 12:05:26','2025-02-09 12:05:26'),(1145,'01',52,'Modules\\Cash\\Models\\Cash',1053,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-09 12:29:30','2025-02-09 12:29:30'),(1146,'01',52,'Modules\\Cash\\Models\\Cash',1054,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-09 13:05:56','2025-02-09 13:05:56'),(1147,'01',52,'Modules\\Cash\\Models\\Cash',1055,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-09 14:04:55','2025-02-09 14:04:55'),(1148,'01',52,'Modules\\Cash\\Models\\Cash',1056,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-09 15:14:21','2025-02-09 15:14:21'),(1149,'01',52,'Modules\\Cash\\Models\\Cash',1057,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-09 15:14:39','2025-02-09 15:14:39'),(1150,'01',52,'Modules\\Cash\\Models\\Cash',1058,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-09 15:18:32','2025-02-09 15:18:32'),(1151,'01',52,'Modules\\Cash\\Models\\Cash',1059,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-09 16:04:23','2025-02-09 16:04:23'),(1152,'01',52,'Modules\\Cash\\Models\\Cash',1060,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-09 16:59:33','2025-02-09 16:59:33'),(1153,'01',52,'Modules\\Cash\\Models\\Cash',1061,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-09 17:03:49','2025-02-09 17:03:49'),(1154,'01',52,'Modules\\Cash\\Models\\Cash',1062,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-09 17:52:45','2025-02-09 17:52:45'),(1155,'01',52,'Modules\\Cash\\Models\\Cash',1063,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-09 18:14:17','2025-02-09 18:14:17'),(1156,'01',52,'Modules\\Cash\\Models\\Cash',1064,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-09 19:16:14','2025-02-09 19:16:14'),(1157,'01',52,'Modules\\Cash\\Models\\Cash',1065,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-09 19:25:11','2025-02-09 19:25:11'),(1158,'01',52,'Modules\\Cash\\Models\\Cash',1066,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-10 08:17:11','2025-02-10 08:17:11'),(1159,'01',53,'Modules\\Cash\\Models\\Cash',56,'Modules\\Pos\\Models\\CashTransaction',3,'2025-02-10 08:18:57','2025-02-10 08:18:57'),(1160,'01',53,'Modules\\Cash\\Models\\Cash',1067,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-10 08:25:49','2025-02-10 08:25:49'),(1161,'01',53,'Modules\\Cash\\Models\\Cash',1068,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-10 10:16:55','2025-02-10 10:16:55'),(1162,'01',53,'Modules\\Cash\\Models\\Cash',1069,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-10 11:34:28','2025-02-10 11:34:28'),(1163,'01',53,'Modules\\Cash\\Models\\Cash',1070,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-10 11:42:34','2025-02-10 11:42:34'),(1164,'01',53,'Modules\\Cash\\Models\\Cash',1071,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-10 14:20:53','2025-02-10 14:20:53'),(1165,'01',54,'Modules\\Cash\\Models\\Cash',57,'Modules\\Pos\\Models\\CashTransaction',4,'2025-02-10 14:38:45','2025-02-10 14:38:45'),(1166,'01',54,'Modules\\Cash\\Models\\Cash',1072,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-10 20:41:17','2025-02-10 20:41:17'),(1167,'01',54,'Modules\\Cash\\Models\\Cash',1073,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-10 20:41:33','2025-02-10 20:41:33'),(1168,'01',54,'Modules\\Cash\\Models\\Cash',1074,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-10 20:45:37','2025-02-10 20:45:37'),(1169,'01',54,'Modules\\Cash\\Models\\Cash',1075,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-10 20:46:12','2025-02-10 20:46:12'),(1170,'01',54,'Modules\\Cash\\Models\\Cash',1076,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-10 20:46:40','2025-02-10 20:46:40'),(1171,'01',54,'Modules\\Cash\\Models\\Cash',1077,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-10 20:47:01','2025-02-10 20:47:01'),(1172,'01',54,'Modules\\Cash\\Models\\Cash',1078,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-10 20:53:05','2025-02-10 20:53:05'),(1173,'01',54,'Modules\\Cash\\Models\\Cash',1079,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-10 20:53:23','2025-02-10 20:53:23'),(1174,'01',54,'Modules\\Cash\\Models\\Cash',1080,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-10 20:53:46','2025-02-10 20:53:46'),(1175,'01',54,'Modules\\Cash\\Models\\Cash',1081,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-10 20:53:59','2025-02-10 20:53:59'),(1176,'01',54,'Modules\\Cash\\Models\\Cash',1082,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-10 21:15:08','2025-02-10 21:15:08'),(1177,'01',54,'Modules\\Cash\\Models\\Cash',1083,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-10 21:15:25','2025-02-10 21:15:25'),(1178,'01',54,'Modules\\Cash\\Models\\Cash',1084,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-10 21:15:43','2025-02-10 21:15:43'),(1179,'01',54,'Modules\\Cash\\Models\\Cash',1085,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-10 21:18:03','2025-02-10 21:18:03'),(1180,'01',54,'Modules\\Cash\\Models\\Cash',1086,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-10 21:27:38','2025-02-10 21:27:38'),(1181,'01',54,'Modules\\Cash\\Models\\Cash',1087,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-10 21:46:02','2025-02-10 21:46:02'),(1182,'01',55,'Modules\\Cash\\Models\\Cash',58,'Modules\\Pos\\Models\\CashTransaction',3,'2025-02-11 10:11:08','2025-02-11 10:11:08'),(1183,'01',55,'Modules\\Cash\\Models\\Cash',1088,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-11 10:42:50','2025-02-11 10:42:50'),(1184,'01',55,'Modules\\Cash\\Models\\Cash',1089,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-11 11:08:09','2025-02-11 11:08:09'),(1185,'01',55,'Modules\\Cash\\Models\\Cash',1090,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-11 12:27:44','2025-02-11 12:27:44'),(1186,'01',55,'Modules\\Cash\\Models\\Cash',1091,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-11 12:38:57','2025-02-11 12:38:57'),(1187,'01',55,'Modules\\Cash\\Models\\Cash',1092,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-11 12:41:36','2025-02-11 12:41:36'),(1188,'01',55,'Modules\\Cash\\Models\\Cash',1093,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-11 12:49:11','2025-02-11 12:49:11'),(1189,'01',55,'Modules\\Cash\\Models\\Cash',1094,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-11 13:15:26','2025-02-11 13:15:26'),(1190,'01',55,'Modules\\Cash\\Models\\Cash',1095,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-11 13:16:58','2025-02-11 13:16:58'),(1191,'01',55,'Modules\\Cash\\Models\\Cash',1096,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-11 13:52:34','2025-02-11 13:52:34'),(1192,'01',55,'Modules\\Cash\\Models\\Cash',1097,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-11 13:53:21','2025-02-11 13:53:21'),(1193,'01',55,'Modules\\Cash\\Models\\Cash',1098,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-11 14:05:10','2025-02-11 14:05:10'),(1194,'01',55,'Modules\\Cash\\Models\\Cash',1099,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-11 14:19:27','2025-02-11 14:19:27'),(1195,'01',56,'Modules\\Cash\\Models\\Cash',59,'Modules\\Pos\\Models\\CashTransaction',4,'2025-02-11 14:42:35','2025-02-11 14:42:35'),(1196,'01',56,'Modules\\Cash\\Models\\Cash',1100,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 19:53:28','2025-02-11 19:53:28'),(1197,'01',56,'Modules\\Cash\\Models\\Cash',1101,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 19:53:46','2025-02-11 19:53:46'),(1198,'01',56,'Modules\\Cash\\Models\\Cash',1102,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 19:53:59','2025-02-11 19:53:59'),(1199,'01',56,'Modules\\Cash\\Models\\Cash',1103,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 19:54:20','2025-02-11 19:54:20'),(1200,'01',56,'Modules\\Cash\\Models\\Cash',1104,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 19:54:45','2025-02-11 19:54:45'),(1201,'01',56,'Modules\\Cash\\Models\\Cash',1105,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 19:55:09','2025-02-11 19:55:09'),(1202,'01',56,'Modules\\Cash\\Models\\Cash',1106,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 19:55:33','2025-02-11 19:55:33'),(1203,'01',56,'Modules\\Cash\\Models\\Cash',1107,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 19:55:54','2025-02-11 19:55:54'),(1204,'01',56,'Modules\\Cash\\Models\\Cash',1108,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 20:52:05','2025-02-11 20:52:05'),(1205,'01',56,'Modules\\Cash\\Models\\Cash',1109,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 20:52:23','2025-02-11 20:52:23'),(1206,'01',56,'Modules\\Cash\\Models\\Cash',1110,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 20:52:44','2025-02-11 20:52:44'),(1207,'01',56,'Modules\\Cash\\Models\\Cash',1111,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 20:53:05','2025-02-11 20:53:05'),(1208,'01',56,'Modules\\Cash\\Models\\Cash',1112,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 21:00:03','2025-02-11 21:00:03'),(1209,'01',56,'Modules\\Cash\\Models\\Cash',1113,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 21:00:23','2025-02-11 21:00:23'),(1210,'01',56,'Modules\\Cash\\Models\\Cash',1114,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 21:00:51','2025-02-11 21:00:51'),(1211,'01',56,'Modules\\Cash\\Models\\Cash',1115,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 21:01:22','2025-02-11 21:01:22'),(1212,'01',56,'Modules\\Cash\\Models\\Cash',1116,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 21:01:38','2025-02-11 21:01:38'),(1213,'01',56,'Modules\\Cash\\Models\\Cash',1117,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 21:09:09','2025-02-11 21:09:09'),(1214,'01',56,'Modules\\Cash\\Models\\Cash',1118,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 21:09:53','2025-02-11 21:09:53'),(1215,'01',56,'Modules\\Cash\\Models\\Cash',1119,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 22:21:37','2025-02-11 22:21:37'),(1216,'01',56,'Modules\\Cash\\Models\\Cash',1120,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 22:22:00','2025-02-11 22:22:00'),(1217,'01',56,'Modules\\Cash\\Models\\Cash',1121,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-11 22:22:34','2025-02-11 22:22:34'),(1218,'01',57,'Modules\\Cash\\Models\\Cash',60,'Modules\\Pos\\Models\\CashTransaction',3,'2025-02-12 07:19:19','2025-02-12 07:19:19'),(1219,'01',57,'Modules\\Cash\\Models\\Cash',1122,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-12 07:45:17','2025-02-12 07:45:17'),(1220,'01',57,'Modules\\Cash\\Models\\Cash',1123,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-12 13:09:32','2025-02-12 13:09:32'),(1221,'01',57,'Modules\\Cash\\Models\\Cash',1124,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-12 13:34:56','2025-02-12 13:34:56'),(1222,'01',57,'Modules\\Cash\\Models\\Cash',1125,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-12 14:11:03','2025-02-12 14:11:03'),(1223,'01',58,'Modules\\Cash\\Models\\Cash',61,'Modules\\Pos\\Models\\CashTransaction',4,'2025-02-12 14:34:31','2025-02-12 14:34:31'),(1224,'01',58,'Modules\\Cash\\Models\\Cash',1126,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 14:40:52','2025-02-12 14:40:52'),(1225,'01',58,'Modules\\Cash\\Models\\Cash',1127,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 14:41:52','2025-02-12 14:41:52'),(1226,'01',58,'Modules\\Cash\\Models\\Cash',1128,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 14:42:12','2025-02-12 14:42:12'),(1227,'01',58,'Modules\\Cash\\Models\\Cash',1129,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 14:42:26','2025-02-12 14:42:26'),(1228,'01',58,'Modules\\Cash\\Models\\Cash',1130,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 19:32:08','2025-02-12 19:32:08'),(1229,'01',58,'Modules\\Cash\\Models\\Cash',1131,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 19:32:47','2025-02-12 19:32:47'),(1230,'01',58,'Modules\\Cash\\Models\\Cash',1132,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 19:57:19','2025-02-12 19:57:19'),(1231,'01',58,'Modules\\Cash\\Models\\Cash',1133,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 19:57:37','2025-02-12 19:57:37'),(1232,'01',58,'Modules\\Cash\\Models\\Cash',1134,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 19:58:04','2025-02-12 19:58:04'),(1233,'01',58,'Modules\\Cash\\Models\\Cash',1135,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 19:58:33','2025-02-12 19:58:33'),(1234,'01',58,'Modules\\Cash\\Models\\Cash',1136,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 19:58:57','2025-02-12 19:58:57'),(1235,'01',58,'Modules\\Cash\\Models\\Cash',1137,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 19:59:27','2025-02-12 19:59:27'),(1236,'01',58,'Modules\\Cash\\Models\\Cash',1138,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 20:00:02','2025-02-12 20:00:02'),(1237,'01',58,'Modules\\Cash\\Models\\Cash',1139,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 21:50:51','2025-02-12 21:50:51'),(1238,'01',58,'Modules\\Cash\\Models\\Cash',1140,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 21:51:28','2025-02-12 21:51:28'),(1239,'01',58,'Modules\\Cash\\Models\\Cash',1141,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 21:52:07','2025-02-12 21:52:07'),(1240,'01',58,'Modules\\Cash\\Models\\Cash',1142,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 21:54:05','2025-02-12 21:54:05'),(1241,'01',58,'Modules\\Cash\\Models\\Cash',1143,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 21:56:39','2025-02-12 21:56:39'),(1242,'01',58,'Modules\\Cash\\Models\\Cash',1144,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 22:01:35','2025-02-12 22:01:35'),(1243,'01',58,'Modules\\Cash\\Models\\Cash',1145,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-12 22:02:24','2025-02-12 22:02:24'),(1244,'01',59,'Modules\\Cash\\Models\\Cash',62,'Modules\\Pos\\Models\\CashTransaction',3,'2025-02-13 07:34:10','2025-02-13 07:34:10'),(1245,'01',59,'Modules\\Cash\\Models\\Cash',1146,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-13 11:24:37','2025-02-13 11:24:37'),(1246,'01',59,'Modules\\Cash\\Models\\Cash',1147,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-13 11:36:33','2025-02-13 11:36:33'),(1247,'01',59,'Modules\\Cash\\Models\\Cash',1148,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-13 13:25:53','2025-02-13 13:25:53'),(1248,'01',60,'Modules\\Cash\\Models\\Cash',63,'Modules\\Pos\\Models\\CashTransaction',4,'2025-02-13 14:35:16','2025-02-13 14:35:16'),(1249,'01',60,'Modules\\Cash\\Models\\Cash',1149,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 18:38:22','2025-02-13 18:38:22'),(1250,'01',60,'Modules\\Cash\\Models\\Cash',1150,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 18:38:44','2025-02-13 18:38:44'),(1251,'01',60,'Modules\\Cash\\Models\\Cash',1151,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 18:39:13','2025-02-13 18:39:13'),(1252,'01',60,'Modules\\Cash\\Models\\Cash',1152,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 18:39:28','2025-02-13 18:39:28'),(1253,'01',60,'Modules\\Cash\\Models\\Cash',1153,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 18:40:05','2025-02-13 18:40:05'),(1254,'01',60,'Modules\\Cash\\Models\\Cash',1154,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 18:40:26','2025-02-13 18:40:26'),(1255,'01',60,'Modules\\Cash\\Models\\Cash',1155,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 18:40:45','2025-02-13 18:40:45'),(1256,'01',60,'Modules\\Cash\\Models\\Cash',1156,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 18:45:09','2025-02-13 18:45:09'),(1257,'01',60,'Modules\\Cash\\Models\\Cash',1157,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 18:45:32','2025-02-13 18:45:32'),(1258,'01',60,'Modules\\Cash\\Models\\Cash',1158,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 18:45:52','2025-02-13 18:45:52'),(1259,'01',60,'Modules\\Cash\\Models\\Cash',1159,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 18:46:10','2025-02-13 18:46:10'),(1260,'01',60,'Modules\\Cash\\Models\\Cash',1160,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 18:47:05','2025-02-13 18:47:05'),(1261,'01',60,'Modules\\Cash\\Models\\Cash',1161,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 18:47:34','2025-02-13 18:47:34'),(1262,'01',60,'Modules\\Cash\\Models\\Cash',1162,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 18:47:54','2025-02-13 18:47:54'),(1263,'01',60,'Modules\\Cash\\Models\\Cash',1163,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 18:48:50','2025-02-13 18:48:50'),(1264,'01',60,'Modules\\Cash\\Models\\Cash',1164,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 18:49:13','2025-02-13 18:49:13'),(1265,'01',60,'Modules\\Cash\\Models\\Cash',1165,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 20:41:43','2025-02-13 20:41:43'),(1266,'01',60,'Modules\\Cash\\Models\\Cash',1166,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 20:42:12','2025-02-13 20:42:12'),(1267,'01',60,'Modules\\Cash\\Models\\Cash',1167,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 20:42:32','2025-02-13 20:42:32'),(1268,'01',60,'Modules\\Cash\\Models\\Cash',1168,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 20:42:50','2025-02-13 20:42:50'),(1269,'01',60,'Modules\\Cash\\Models\\Cash',1169,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 20:43:09','2025-02-13 20:43:09'),(1270,'01',60,'Modules\\Cash\\Models\\Cash',1170,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 20:43:28','2025-02-13 20:43:28'),(1271,'01',60,'Modules\\Cash\\Models\\Cash',1171,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 20:43:51','2025-02-13 20:43:51'),(1272,'01',60,'Modules\\Cash\\Models\\Cash',1172,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 20:44:26','2025-02-13 20:44:26'),(1273,'01',60,'Modules\\Cash\\Models\\Cash',1173,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 20:44:46','2025-02-13 20:44:46'),(1274,'01',60,'Modules\\Cash\\Models\\Cash',1174,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 20:45:04','2025-02-13 20:45:04'),(1275,'01',60,'Modules\\Cash\\Models\\Cash',1175,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 20:45:45','2025-02-13 20:45:45'),(1276,'01',60,'Modules\\Cash\\Models\\Cash',1176,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 20:46:05','2025-02-13 20:46:05'),(1277,'01',60,'Modules\\Cash\\Models\\Cash',1177,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 20:53:03','2025-02-13 20:53:03'),(1278,'01',60,'Modules\\Cash\\Models\\Cash',1178,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 20:53:26','2025-02-13 20:53:26'),(1279,'01',60,'Modules\\Cash\\Models\\Cash',1179,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 20:53:53','2025-02-13 20:53:53'),(1280,'01',60,'Modules\\Cash\\Models\\Cash',1180,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 21:07:26','2025-02-13 21:07:26'),(1281,'01',60,'Modules\\Cash\\Models\\Cash',1181,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-13 21:07:50','2025-02-13 21:07:50'),(1282,'01',61,'Modules\\Cash\\Models\\Cash',64,'Modules\\Pos\\Models\\CashTransaction',3,'2025-02-14 07:20:32','2025-02-14 07:20:32'),(1283,'01',61,'Modules\\Cash\\Models\\Cash',1182,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-14 07:35:41','2025-02-14 07:35:41'),(1284,'01',61,'Modules\\Cash\\Models\\Cash',1183,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-14 08:31:57','2025-02-14 08:31:57'),(1285,'01',61,'Modules\\Cash\\Models\\Cash',1184,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-14 10:42:32','2025-02-14 10:42:32'),(1286,'01',61,'Modules\\Cash\\Models\\Cash',1185,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-14 13:10:15','2025-02-14 13:10:15'),(1287,'01',61,'Modules\\Cash\\Models\\Cash',1186,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-14 14:06:28','2025-02-14 14:06:28'),(1288,'01',61,'Modules\\Cash\\Models\\Cash',1187,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-14 15:33:26','2025-02-14 15:33:26'),(1289,'01',61,'Modules\\Cash\\Models\\Cash',1188,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-14 17:16:44','2025-02-14 17:16:44'),(1290,'01',61,'Modules\\Cash\\Models\\Cash',1189,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-14 18:07:18','2025-02-14 18:07:18'),(1291,'01',61,'Modules\\Cash\\Models\\Cash',1190,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-14 20:42:00','2025-02-14 20:42:00'),(1292,'01',61,'Modules\\Cash\\Models\\Cash',1191,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-14 21:03:41','2025-02-14 21:03:41'),(1293,'01',61,'Modules\\Cash\\Models\\Cash',1192,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-14 21:08:43','2025-02-14 21:08:43'),(1294,'01',61,'Modules\\Cash\\Models\\Cash',1193,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-14 21:20:18','2025-02-14 21:20:18'),(1295,'01',61,'Modules\\Cash\\Models\\Cash',1194,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-14 21:42:22','2025-02-14 21:42:22'),(1296,'01',61,'Modules\\Cash\\Models\\Cash',1195,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-14 21:50:35','2025-02-14 21:50:35'),(1297,'01',61,'Modules\\Cash\\Models\\Cash',1196,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-14 22:04:33','2025-02-14 22:04:33'),(1298,'01',62,'Modules\\Cash\\Models\\Cash',65,'Modules\\Pos\\Models\\CashTransaction',4,'2025-02-15 07:31:26','2025-02-15 07:31:26'),(1299,'01',62,'Modules\\Cash\\Models\\Cash',1197,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:38:14','2025-02-15 14:38:14'),(1300,'01',62,'Modules\\Cash\\Models\\Cash',1198,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:38:52','2025-02-15 14:38:52'),(1301,'01',62,'Modules\\Cash\\Models\\Cash',1199,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:39:13','2025-02-15 14:39:13'),(1302,'01',62,'Modules\\Cash\\Models\\Cash',1200,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:39:44','2025-02-15 14:39:44'),(1303,'01',62,'Modules\\Cash\\Models\\Cash',1201,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:40:12','2025-02-15 14:40:12'),(1304,'01',62,'Modules\\Cash\\Models\\Cash',1202,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:40:33','2025-02-15 14:40:33'),(1305,'01',62,'Modules\\Cash\\Models\\Cash',1203,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:40:52','2025-02-15 14:40:52'),(1306,'01',62,'Modules\\Cash\\Models\\Cash',1204,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:41:18','2025-02-15 14:41:18'),(1307,'01',62,'Modules\\Cash\\Models\\Cash',1205,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:41:46','2025-02-15 14:41:46'),(1308,'01',62,'Modules\\Cash\\Models\\Cash',1206,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:42:18','2025-02-15 14:42:18'),(1309,'01',62,'Modules\\Cash\\Models\\Cash',1207,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:42:34','2025-02-15 14:42:34'),(1310,'01',62,'Modules\\Cash\\Models\\Cash',1208,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:43:01','2025-02-15 14:43:01'),(1311,'01',62,'Modules\\Cash\\Models\\Cash',1209,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:43:28','2025-02-15 14:43:28'),(1312,'01',62,'Modules\\Cash\\Models\\Cash',1210,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:44:12','2025-02-15 14:44:12'),(1313,'01',62,'Modules\\Cash\\Models\\Cash',1211,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:44:31','2025-02-15 14:44:31'),(1314,'01',62,'Modules\\Cash\\Models\\Cash',1212,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:44:52','2025-02-15 14:44:52'),(1315,'01',62,'Modules\\Cash\\Models\\Cash',1213,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:45:10','2025-02-15 14:45:10'),(1316,'01',62,'Modules\\Cash\\Models\\Cash',1214,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:45:32','2025-02-15 14:45:32'),(1317,'01',62,'Modules\\Cash\\Models\\Cash',1215,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:46:25','2025-02-15 14:46:25'),(1318,'01',62,'Modules\\Cash\\Models\\Cash',1216,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:46:45','2025-02-15 14:46:45'),(1319,'01',62,'Modules\\Cash\\Models\\Cash',1217,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:47:19','2025-02-15 14:47:19'),(1320,'01',62,'Modules\\Cash\\Models\\Cash',1218,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:47:47','2025-02-15 14:47:47'),(1321,'01',62,'Modules\\Cash\\Models\\Cash',1219,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:48:06','2025-02-15 14:48:06'),(1322,'01',62,'Modules\\Cash\\Models\\Cash',1220,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:48:29','2025-02-15 14:48:29'),(1323,'01',62,'Modules\\Cash\\Models\\Cash',1221,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:48:50','2025-02-15 14:48:50'),(1324,'01',62,'Modules\\Cash\\Models\\Cash',1222,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:49:13','2025-02-15 14:49:13'),(1325,'01',62,'Modules\\Cash\\Models\\Cash',1223,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:49:33','2025-02-15 14:49:33'),(1326,'01',62,'Modules\\Cash\\Models\\Cash',1224,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 14:50:07','2025-02-15 14:50:07'),(1327,'01',62,'Modules\\Cash\\Models\\Cash',1225,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:22:51','2025-02-15 17:22:51'),(1328,'01',62,'Modules\\Cash\\Models\\Cash',1226,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:23:16','2025-02-15 17:23:16'),(1329,'01',62,'Modules\\Cash\\Models\\Cash',1227,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:23:58','2025-02-15 17:23:58'),(1330,'01',62,'Modules\\Cash\\Models\\Cash',1228,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:24:40','2025-02-15 17:24:40'),(1331,'01',62,'Modules\\Cash\\Models\\Cash',1229,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:26:47','2025-02-15 17:26:47'),(1332,'01',62,'Modules\\Cash\\Models\\Cash',1230,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:27:06','2025-02-15 17:27:06'),(1333,'01',62,'Modules\\Cash\\Models\\Cash',1231,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:27:39','2025-02-15 17:27:39'),(1334,'01',62,'Modules\\Cash\\Models\\Cash',1232,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:27:58','2025-02-15 17:27:58'),(1335,'01',62,'Modules\\Cash\\Models\\Cash',1233,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:28:32','2025-02-15 17:28:32'),(1336,'01',62,'Modules\\Cash\\Models\\Cash',1234,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:29:20','2025-02-15 17:29:20'),(1337,'01',62,'Modules\\Cash\\Models\\Cash',1235,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:29:46','2025-02-15 17:29:46'),(1338,'01',62,'Modules\\Cash\\Models\\Cash',1236,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:30:27','2025-02-15 17:30:27'),(1339,'01',62,'Modules\\Cash\\Models\\Cash',1237,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:30:45','2025-02-15 17:30:45'),(1340,'01',62,'Modules\\Cash\\Models\\Cash',1238,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:49:16','2025-02-15 17:49:16'),(1341,'01',62,'Modules\\Cash\\Models\\Cash',1239,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:49:38','2025-02-15 17:49:38'),(1342,'01',62,'Modules\\Cash\\Models\\Cash',1240,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:50:05','2025-02-15 17:50:05'),(1343,'01',62,'Modules\\Cash\\Models\\Cash',1241,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:50:24','2025-02-15 17:50:24'),(1344,'01',62,'Modules\\Cash\\Models\\Cash',1242,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:50:50','2025-02-15 17:50:50'),(1345,'01',62,'Modules\\Cash\\Models\\Cash',1243,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 17:51:13','2025-02-15 17:51:13'),(1346,'01',62,'Modules\\Cash\\Models\\Cash',1244,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 18:46:48','2025-02-15 18:46:48'),(1347,'01',62,'Modules\\Cash\\Models\\Cash',1245,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 18:47:28','2025-02-15 18:47:28'),(1348,'01',62,'Modules\\Cash\\Models\\Cash',1246,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 19:18:37','2025-02-15 19:18:37'),(1349,'01',62,'Modules\\Cash\\Models\\Cash',1247,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 19:29:48','2025-02-15 19:29:48'),(1350,'01',62,'Modules\\Cash\\Models\\Cash',1248,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 19:30:13','2025-02-15 19:30:13'),(1351,'01',62,'Modules\\Cash\\Models\\Cash',1249,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 19:44:06','2025-02-15 19:44:06'),(1352,'01',62,'Modules\\Cash\\Models\\Cash',1250,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 19:48:00','2025-02-15 19:48:00'),(1353,'01',62,'Modules\\Cash\\Models\\Cash',1251,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 19:59:09','2025-02-15 19:59:09'),(1354,'01',62,'Modules\\Cash\\Models\\Cash',1252,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 19:59:59','2025-02-15 19:59:59'),(1355,'01',62,'Modules\\Cash\\Models\\Cash',1253,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 20:01:58','2025-02-15 20:01:58'),(1356,'01',62,'Modules\\Cash\\Models\\Cash',1254,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 20:02:37','2025-02-15 20:02:37'),(1357,'01',62,'Modules\\Cash\\Models\\Cash',1255,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 20:10:52','2025-02-15 20:10:52'),(1358,'01',62,'Modules\\Cash\\Models\\Cash',1256,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 20:11:04','2025-02-15 20:11:04'),(1359,'01',62,'Modules\\Cash\\Models\\Cash',1257,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 20:13:30','2025-02-15 20:13:30'),(1360,'01',62,'Modules\\Cash\\Models\\Cash',1258,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 20:13:53','2025-02-15 20:13:53'),(1361,'01',62,'Modules\\Cash\\Models\\Cash',1259,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 20:15:08','2025-02-15 20:15:08'),(1362,'01',62,'Modules\\Cash\\Models\\Cash',1260,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 20:15:41','2025-02-15 20:15:41'),(1363,'01',62,'Modules\\Cash\\Models\\Cash',1261,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 20:22:17','2025-02-15 20:22:17'),(1364,'01',62,'Modules\\Cash\\Models\\Cash',1262,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 20:50:18','2025-02-15 20:50:18'),(1365,'01',62,'Modules\\Cash\\Models\\Cash',1263,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 20:50:41','2025-02-15 20:50:41'),(1366,'01',62,'Modules\\Cash\\Models\\Cash',1264,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 21:05:22','2025-02-15 21:05:22'),(1367,'01',62,'Modules\\Cash\\Models\\Cash',1265,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 21:05:42','2025-02-15 21:05:42'),(1368,'01',62,'Modules\\Cash\\Models\\Cash',1266,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 21:35:34','2025-02-15 21:35:34'),(1369,'01',62,'Modules\\Cash\\Models\\Cash',1267,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 22:01:21','2025-02-15 22:01:21'),(1370,'01',62,'Modules\\Cash\\Models\\Cash',1268,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 22:12:01','2025-02-15 22:12:01'),(1371,'01',62,'Modules\\Cash\\Models\\Cash',1269,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-15 22:34:26','2025-02-15 22:34:26'),(1372,'01',63,'Modules\\Cash\\Models\\Cash',66,'Modules\\Pos\\Models\\CashTransaction',3,'2025-02-16 07:29:51','2025-02-16 07:29:51'),(1373,'01',63,'Modules\\Cash\\Models\\Cash',1270,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 10:01:41','2025-02-16 10:01:41'),(1374,'01',63,'Modules\\Cash\\Models\\Cash',1271,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 10:28:25','2025-02-16 10:28:25'),(1375,'01',63,'Modules\\Cash\\Models\\Cash',1272,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 10:30:23','2025-02-16 10:30:23'),(1376,'01',63,'Modules\\Cash\\Models\\Cash',1273,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 10:46:45','2025-02-16 10:46:45'),(1377,'01',63,'Modules\\Cash\\Models\\Cash',1274,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 11:23:45','2025-02-16 11:23:45'),(1378,'01',63,'Modules\\Cash\\Models\\Cash',1275,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 12:48:15','2025-02-16 12:48:15'),(1379,'01',63,'Modules\\Cash\\Models\\Cash',1276,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 12:57:42','2025-02-16 12:57:42'),(1380,'01',63,'Modules\\Cash\\Models\\Cash',1277,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 13:15:50','2025-02-16 13:15:50'),(1381,'01',63,'Modules\\Cash\\Models\\Cash',1278,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 13:18:50','2025-02-16 13:18:50'),(1382,'01',63,'Modules\\Cash\\Models\\Cash',1279,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 13:34:24','2025-02-16 13:34:24'),(1383,'01',63,'Modules\\Cash\\Models\\Cash',1280,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 13:40:52','2025-02-16 13:40:52'),(1384,'01',63,'Modules\\Cash\\Models\\Cash',1281,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 14:10:50','2025-02-16 14:10:50'),(1385,'01',63,'Modules\\Cash\\Models\\Cash',1282,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 14:43:45','2025-02-16 14:43:45'),(1386,'01',63,'Modules\\Cash\\Models\\Cash',1283,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 15:01:24','2025-02-16 15:01:24'),(1387,'01',63,'Modules\\Cash\\Models\\Cash',1284,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 15:06:05','2025-02-16 15:06:05'),(1388,'01',63,'Modules\\Cash\\Models\\Cash',1285,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 15:13:23','2025-02-16 15:13:23'),(1389,'01',63,'Modules\\Cash\\Models\\Cash',1286,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 15:32:13','2025-02-16 15:32:13'),(1390,'01',63,'Modules\\Cash\\Models\\Cash',1287,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 16:12:50','2025-02-16 16:12:50'),(1391,'01',63,'Modules\\Cash\\Models\\Cash',1288,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 16:48:12','2025-02-16 16:48:12'),(1392,'01',63,'Modules\\Cash\\Models\\Cash',1289,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 16:55:10','2025-02-16 16:55:10'),(1393,'01',63,'Modules\\Cash\\Models\\Cash',1290,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 20:11:55','2025-02-16 20:11:55'),(1394,'01',63,'Modules\\Cash\\Models\\Cash',1291,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 21:14:37','2025-02-16 21:14:37'),(1395,'01',63,'Modules\\Cash\\Models\\Cash',1292,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-16 21:46:44','2025-02-16 21:46:44'),(1396,'01',64,'Modules\\Cash\\Models\\Cash',67,'Modules\\Pos\\Models\\CashTransaction',3,'2025-02-17 07:50:28','2025-02-17 07:50:28'),(1397,'01',64,'Modules\\Cash\\Models\\Cash',1293,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-17 08:22:18','2025-02-17 08:22:18'),(1398,'01',64,'Modules\\Cash\\Models\\Cash',1294,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-17 09:01:28','2025-02-17 09:01:28'),(1399,'01',64,'Modules\\Cash\\Models\\Cash',1295,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-17 10:27:09','2025-02-17 10:27:09'),(1400,'01',64,'Modules\\Cash\\Models\\Cash',1296,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-17 11:23:47','2025-02-17 11:23:47'),(1401,'01',64,'Modules\\Cash\\Models\\Cash',1297,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-17 11:31:01','2025-02-17 11:31:01'),(1402,'01',64,'Modules\\Cash\\Models\\Cash',1298,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-17 11:56:31','2025-02-17 11:56:31'),(1403,'01',64,'Modules\\Cash\\Models\\Cash',1299,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-17 12:17:36','2025-02-17 12:17:36'),(1404,'01',64,'Modules\\Cash\\Models\\Cash',1300,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-17 12:28:59','2025-02-17 12:28:59'),(1405,'01',64,'Modules\\Cash\\Models\\Cash',1301,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-17 13:29:26','2025-02-17 13:29:26'),(1406,'01',64,'Modules\\Cash\\Models\\Cash',1302,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-17 13:49:25','2025-02-17 13:49:25'),(1407,'01',64,'Modules\\Cash\\Models\\Cash',1303,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-17 13:54:11','2025-02-17 13:54:11'),(1408,'01',64,'Modules\\Cash\\Models\\Cash',1304,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-17 14:09:22','2025-02-17 14:09:22'),(1409,'01',64,'Modules\\Cash\\Models\\Cash',1305,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-17 14:21:25','2025-02-17 14:21:25'),(1410,'01',65,'Modules\\Cash\\Models\\Cash',68,'Modules\\Pos\\Models\\CashTransaction',4,'2025-02-17 15:48:29','2025-02-17 15:48:29'),(1411,'01',65,'Modules\\Cash\\Models\\Cash',1306,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 18:26:05','2025-02-17 18:26:05'),(1412,'01',65,'Modules\\Cash\\Models\\Cash',1307,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 18:26:36','2025-02-17 18:26:36'),(1413,'01',65,'Modules\\Cash\\Models\\Cash',1308,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 18:27:01','2025-02-17 18:27:01'),(1414,'01',65,'Modules\\Cash\\Models\\Cash',1309,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 18:27:33','2025-02-17 18:27:33'),(1415,'01',65,'Modules\\Cash\\Models\\Cash',1310,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 18:28:23','2025-02-17 18:28:23'),(1416,'01',65,'Modules\\Cash\\Models\\Cash',1311,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 18:28:49','2025-02-17 18:28:49'),(1417,'01',65,'Modules\\Cash\\Models\\Cash',1312,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 18:29:10','2025-02-17 18:29:10'),(1418,'01',65,'Modules\\Cash\\Models\\Cash',1313,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 21:56:39','2025-02-17 21:56:39'),(1419,'01',65,'Modules\\Cash\\Models\\Cash',1314,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 21:56:57','2025-02-17 21:56:57'),(1420,'01',65,'Modules\\Cash\\Models\\Cash',1315,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 21:57:49','2025-02-17 21:57:49'),(1421,'01',65,'Modules\\Cash\\Models\\Cash',1316,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 21:58:18','2025-02-17 21:58:18'),(1422,'01',65,'Modules\\Cash\\Models\\Cash',1317,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 21:58:49','2025-02-17 21:58:49'),(1423,'01',65,'Modules\\Cash\\Models\\Cash',1318,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 21:59:08','2025-02-17 21:59:08'),(1424,'01',65,'Modules\\Cash\\Models\\Cash',1319,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 21:59:26','2025-02-17 21:59:26'),(1425,'01',65,'Modules\\Cash\\Models\\Cash',1320,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 21:59:45','2025-02-17 21:59:45'),(1426,'01',65,'Modules\\Cash\\Models\\Cash',1321,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 22:00:03','2025-02-17 22:00:03'),(1427,'01',65,'Modules\\Cash\\Models\\Cash',1322,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 22:10:16','2025-02-17 22:10:16'),(1428,'01',65,'Modules\\Cash\\Models\\Cash',1323,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-17 22:36:35','2025-02-17 22:36:35'),(1429,'01',66,'Modules\\Cash\\Models\\Cash',69,'Modules\\Pos\\Models\\CashTransaction',3,'2025-02-18 07:20:19','2025-02-18 07:20:19'),(1430,'01',66,'Modules\\Cash\\Models\\Cash',1324,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-18 07:59:16','2025-02-18 07:59:16'),(1431,'01',66,'Modules\\Cash\\Models\\Cash',1325,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-18 08:35:21','2025-02-18 08:35:21'),(1432,'01',66,'Modules\\Cash\\Models\\Cash',1326,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-18 08:41:15','2025-02-18 08:41:15'),(1433,'01',66,'Modules\\Cash\\Models\\Cash',1327,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-18 08:43:56','2025-02-18 08:43:56'),(1434,'01',66,'Modules\\Cash\\Models\\Cash',1328,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-18 08:54:08','2025-02-18 08:54:08'),(1435,'01',66,'Modules\\Cash\\Models\\Cash',1329,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-18 10:03:03','2025-02-18 10:03:03'),(1436,'01',66,'Modules\\Cash\\Models\\Cash',1330,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-18 10:21:56','2025-02-18 10:21:56'),(1437,'01',66,'Modules\\Cash\\Models\\Cash',1331,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-18 10:34:58','2025-02-18 10:34:58'),(1438,'01',66,'Modules\\Cash\\Models\\Cash',1332,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-18 10:50:54','2025-02-18 10:50:54'),(1439,'01',66,'Modules\\Cash\\Models\\Cash',1333,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-18 11:12:36','2025-02-18 11:12:36'),(1440,'01',66,'Modules\\Cash\\Models\\Cash',1334,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-18 11:19:01','2025-02-18 11:19:01'),(1441,'01',66,'Modules\\Cash\\Models\\Cash',1335,'Modules\\SaleNote\\Models\\SaleNotePayment',3,'2025-02-18 13:28:47','2025-02-18 13:28:47'),(1442,'01',67,'Modules\\Cash\\Models\\Cash',70,'Modules\\Pos\\Models\\CashTransaction',4,'2025-02-18 14:37:41','2025-02-18 14:37:41'),(1443,'01',67,'Modules\\Cash\\Models\\Cash',1336,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-18 18:50:36','2025-02-18 18:50:36'),(1444,'01',67,'Modules\\Cash\\Models\\Cash',1337,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-18 18:50:55','2025-02-18 18:50:55'),(1445,'01',67,'Modules\\Cash\\Models\\Cash',1338,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-18 18:51:22','2025-02-18 18:51:22'),(1446,'01',67,'Modules\\Cash\\Models\\Cash',1339,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-18 18:51:43','2025-02-18 18:51:43'),(1447,'01',67,'Modules\\Cash\\Models\\Cash',1340,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-18 18:52:03','2025-02-18 18:52:03'),(1448,'01',67,'Modules\\Cash\\Models\\Cash',1341,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-18 18:52:19','2025-02-18 18:52:19'),(1449,'01',67,'Modules\\Cash\\Models\\Cash',1342,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-18 18:52:47','2025-02-18 18:52:47'),(1450,'01',67,'Modules\\Cash\\Models\\Cash',1343,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-18 18:53:06','2025-02-18 18:53:06'),(1451,'01',67,'Modules\\Cash\\Models\\Cash',1344,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-18 19:07:53','2025-02-18 19:07:53'),(1452,'01',67,'Modules\\Cash\\Models\\Cash',1345,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-18 19:40:37','2025-02-18 19:40:37'),(1453,'01',67,'Modules\\Cash\\Models\\Cash',1346,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-18 19:41:18','2025-02-18 19:41:18'),(1454,'01',67,'Modules\\Cash\\Models\\Cash',1347,'Modules\\SaleNote\\Models\\SaleNotePayment',4,'2025-02-18 19:41:43','2025-02-18 19:41:43');
/*!40000 ALTER TABLE `global_payments` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `global_payments` with 1434 row(s)
--

--
-- Table structure for table `groups`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `groups` (
  `id` char(2) NOT NULL,
  `description` varchar(255) NOT NULL,
  KEY `groups_id_index` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `groups`
--

LOCK TABLES `groups` WRITE;
/*!40000 ALTER TABLE `groups` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `groups` VALUES ('01','Facturas'),('02','Boletas');
/*!40000 ALTER TABLE `groups` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `groups` with 2 row(s)
--

--
-- Table structure for table `guides`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `guides` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `external_id` char(36) NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `warehouse_id` int(10) unsigned NOT NULL,
  `soap_type_id` char(2) NOT NULL,
  `document_type_id` char(2) NOT NULL,
  `series` varchar(255) NOT NULL,
  `number` int(11) NOT NULL,
  `date_of_issue` date NOT NULL,
  `time_of_issue` time NOT NULL,
  `inventory_transaction_id` char(255) NOT NULL,
  `guideable_id` int(10) unsigned DEFAULT NULL,
  `guideable_type` varchar(255) DEFAULT NULL,
  `observations` longtext DEFAULT NULL,
  `filename` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `guides_series_number_unique` (`soap_type_id`,`document_type_id`,`series`,`number`),
  KEY `guides_user_id_foreign` (`user_id`),
  KEY `guides_warehouse_id_foreign` (`warehouse_id`),
  KEY `guides_document_type_id_foreign` (`document_type_id`),
  KEY `guides_inventory_transaction_id_foreign` (`inventory_transaction_id`),
  CONSTRAINT `guides_document_type_id_foreign` FOREIGN KEY (`document_type_id`) REFERENCES `cat_document_types` (`id`),
  CONSTRAINT `guides_inventory_transaction_id_foreign` FOREIGN KEY (`inventory_transaction_id`) REFERENCES `inventory_transactions` (`id`),
  CONSTRAINT `guides_soap_type_id_foreign` FOREIGN KEY (`soap_type_id`) REFERENCES `soap_types` (`id`),
  CONSTRAINT `guides_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`),
  CONSTRAINT `guides_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `guides`
--

LOCK TABLES `guides` WRITE;
/*!40000 ALTER TABLE `guides` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `guides` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `guides` with 0 row(s)
--

--
-- Table structure for table `guide_files`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `guide_files` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `filename` text DEFAULT NULL COMMENT 'Nombre de archivo',
  `purchase_id` int(10) unsigned DEFAULT 0 COMMENT 'Relacion con purchases',
  `document_id` int(10) unsigned DEFAULT 0 COMMENT 'Relacion con documents',
  `order_note_id` int(10) unsigned DEFAULT 0 COMMENT 'Relacion con order_notes',
  `quotation_id` int(10) unsigned DEFAULT 0 COMMENT 'Relacion con quotations',
  `sale_note_id` int(10) unsigned DEFAULT 0 COMMENT 'Relacion con sale_notes',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `guide_files`
--

LOCK TABLES `guide_files` WRITE;
/*!40000 ALTER TABLE `guide_files` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `guide_files` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `guide_files` with 0 row(s)
--

--
-- Table structure for table `guide_items`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `guide_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `guide_id` int(10) unsigned NOT NULL,
  `item_id` int(10) unsigned NOT NULL,
  `item_name` varchar(255) NOT NULL,
  `quantity` decimal(20,8) NOT NULL,
  `unit_cost` decimal(20,8) NOT NULL,
  `total` decimal(12,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `guide_items_guide_id_foreign` (`guide_id`),
  KEY `guide_items_item_id_foreign` (`item_id`),
  CONSTRAINT `guide_items_guide_id_foreign` FOREIGN KEY (`guide_id`) REFERENCES `guides` (`id`) ON DELETE CASCADE,
  CONSTRAINT `guide_items_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `items` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `guide_items`
--

LOCK TABLES `guide_items` WRITE;
/*!40000 ALTER TABLE `guide_items` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `guide_items` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `guide_items` with 0 row(s)
--

--
-- Table structure for table `hotel_categories`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hotel_categories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(50) NOT NULL,
  `image` varchar(150) DEFAULT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hotel_categories`
--

LOCK TABLES `hotel_categories` WRITE;
/*!40000 ALTER TABLE `hotel_categories` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `hotel_categories` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `hotel_categories` with 0 row(s)
--

--
-- Table structure for table `hotel_floors`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hotel_floors` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(25) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hotel_floors`
--

LOCK TABLES `hotel_floors` WRITE;
/*!40000 ALTER TABLE `hotel_floors` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `hotel_floors` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `hotel_floors` with 0 row(s)
--

--
-- Table structure for table `hotel_rates`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hotel_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(50) NOT NULL,
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hotel_rates`
--

LOCK TABLES `hotel_rates` WRITE;
/*!40000 ALTER TABLE `hotel_rates` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `hotel_rates` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `hotel_rates` with 0 row(s)
--

--
-- Table structure for table `hotel_rents`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hotel_rents` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `customer_id` int(10) unsigned NOT NULL,
  `customer` text NOT NULL,
  `notes` varchar(250) DEFAULT NULL,
  `towels` int(11) NOT NULL DEFAULT 1,
  `hotel_room_id` int(10) unsigned NOT NULL,
  `hotel_rate_id` int(10) unsigned DEFAULT NULL,
  `duration` int(11) NOT NULL DEFAULT 1,
  `quantity_persons` int(11) NOT NULL DEFAULT 1,
  `input_date` date DEFAULT NULL,
  `input_time` varchar(8) DEFAULT NULL,
  `payment_status` varchar(10) NOT NULL,
  `output_date` date NOT NULL,
  `output_time` varchar(8) NOT NULL,
  `arrears` int(11) NOT NULL DEFAULT 0,
  `status` varchar(10) NOT NULL DEFAULT 'INICIADO',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `hotel_rents_hotel_rate_id_foreign` (`hotel_rate_id`),
  CONSTRAINT `hotel_rents_hotel_rate_id_foreign` FOREIGN KEY (`hotel_rate_id`) REFERENCES `hotel_rates` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hotel_rents`
--

LOCK TABLES `hotel_rents` WRITE;
/*!40000 ALTER TABLE `hotel_rents` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `hotel_rents` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `hotel_rents` with 0 row(s)
--

--
-- Table structure for table `hotel_rent_items`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hotel_rent_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(3) NOT NULL,
  `hotel_rent_id` int(10) unsigned NOT NULL,
  `item_id` int(10) unsigned NOT NULL,
  `item` text DEFAULT NULL,
  `payment_status` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `hotel_rent_items_hotel_rent_id_foreign` (`hotel_rent_id`),
  KEY `hotel_rent_items_item_id_foreign` (`item_id`),
  CONSTRAINT `hotel_rent_items_hotel_rent_id_foreign` FOREIGN KEY (`hotel_rent_id`) REFERENCES `hotel_rents` (`id`) ON DELETE CASCADE,
  CONSTRAINT `hotel_rent_items_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `items` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hotel_rent_items`
--

LOCK TABLES `hotel_rent_items` WRITE;
/*!40000 ALTER TABLE `hotel_rent_items` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `hotel_rent_items` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `hotel_rent_items` with 0 row(s)
--

--
-- Table structure for table `hotel_rent_item_payments`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hotel_rent_item_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hotel_rent_item_id` int(10) unsigned NOT NULL,
  `date_of_payment` date NOT NULL,
  `payment_method_type_id` char(2) NOT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `change` decimal(12,2) DEFAULT NULL,
  `payment` decimal(12,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hotel_rent_item_payments_hotel_rent_item_id_foreign` (`hotel_rent_item_id`),
  KEY `hotel_rent_item_payments_payment_method_type_id_foreign` (`payment_method_type_id`),
  KEY `hotel_rent_item_payments_date_of_payment_index` (`date_of_payment`),
  CONSTRAINT `hotel_rent_item_payments_hotel_rent_item_id_foreign` FOREIGN KEY (`hotel_rent_item_id`) REFERENCES `hotel_rent_items` (`id`) ON DELETE CASCADE,
  CONSTRAINT `hotel_rent_item_payments_payment_method_type_id_foreign` FOREIGN KEY (`payment_method_type_id`) REFERENCES `payment_method_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hotel_rent_item_payments`
--

LOCK TABLES `hotel_rent_item_payments` WRITE;
/*!40000 ALTER TABLE `hotel_rent_item_payments` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `hotel_rent_item_payments` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `hotel_rent_item_payments` with 0 row(s)
--

--
-- Table structure for table `hotel_rooms`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hotel_rooms` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `item_id` int(10) unsigned DEFAULT NULL,
  `hotel_category_id` int(10) unsigned NOT NULL,
  `hotel_floor_id` int(10) unsigned NOT NULL,
  `name` varchar(25) NOT NULL,
  `description` varchar(250) DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT 'DISPONIBLE',
  `active` tinyint(1) NOT NULL DEFAULT 1,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `hotel_rooms_hotel_category_id_foreign` (`hotel_category_id`),
  KEY `hotel_rooms_hotel_floor_id_foreign` (`hotel_floor_id`),
  KEY `hotel_rooms_item_id_foreign` (`item_id`),
  CONSTRAINT `hotel_rooms_hotel_category_id_foreign` FOREIGN KEY (`hotel_category_id`) REFERENCES `hotel_categories` (`id`) ON DELETE CASCADE,
  CONSTRAINT `hotel_rooms_hotel_floor_id_foreign` FOREIGN KEY (`hotel_floor_id`) REFERENCES `hotel_floors` (`id`) ON DELETE CASCADE,
  CONSTRAINT `hotel_rooms_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `items` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hotel_rooms`
--

LOCK TABLES `hotel_rooms` WRITE;
/*!40000 ALTER TABLE `hotel_rooms` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `hotel_rooms` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `hotel_rooms` with 0 row(s)
--

--
-- Table structure for table `hotel_room_rates`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `hotel_room_rates` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hotel_room_id` int(10) unsigned NOT NULL,
  `hotel_rate_id` int(10) unsigned NOT NULL,
  `price` double NOT NULL DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `hotel_room_rates_hotel_room_id_foreign` (`hotel_room_id`),
  KEY `hotel_room_rates_hotel_rate_id_foreign` (`hotel_rate_id`),
  CONSTRAINT `hotel_room_rates_hotel_rate_id_foreign` FOREIGN KEY (`hotel_rate_id`) REFERENCES `hotel_rates` (`id`) ON DELETE CASCADE,
  CONSTRAINT `hotel_room_rates_hotel_room_id_foreign` FOREIGN KEY (`hotel_room_id`) REFERENCES `hotel_rooms` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `hotel_room_rates`
--

LOCK TABLES `hotel_room_rates` WRITE;
/*!40000 ALTER TABLE `hotel_room_rates` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `hotel_room_rates` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `hotel_room_rates` with 0 row(s)
--

--
-- Table structure for table `income`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `income` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int(10) unsigned NOT NULL,
  `income_type_id` int(10) unsigned NOT NULL,
  `income_reason_id` int(10) unsigned NOT NULL,
  `soap_type_id` char(2) NOT NULL,
  `state_type_id` char(2) NOT NULL,
  `establishment_id` int(10) unsigned NOT NULL,
  `customer` varchar(255) NOT NULL,
  `currency_type_id` varchar(255) NOT NULL,
  `external_id` char(36) NOT NULL,
  `number` int(11) NOT NULL,
  `date_of_issue` date NOT NULL,
  `time_of_issue` time NOT NULL,
  `exchange_rate_sale` decimal(13,3) NOT NULL,
  `total` decimal(12,2) NOT NULL,
  `filename` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `income_filename_unique` (`filename`),
  KEY `income_user_id_foreign` (`user_id`),
  KEY `income_establishment_id_foreign` (`establishment_id`),
  KEY `income_income_type_id_foreign` (`income_type_id`),
  KEY `income_income_reason_id_foreign` (`income_reason_id`),
  KEY `income_state_type_id_foreign` (`state_type_id`),
  KEY `income_soap_type_id_foreign` (`soap_type_id`),
  KEY `income_currency_type_id_foreign` (`currency_type_id`),
  KEY `income_number_index` (`number`),
  KEY `income_date_of_issue_index` (`date_of_issue`),
  KEY `income_external_id_index` (`external_id`),
  CONSTRAINT `income_currency_type_id_foreign` FOREIGN KEY (`currency_type_id`) REFERENCES `cat_currency_types` (`id`),
  CONSTRAINT `income_establishment_id_foreign` FOREIGN KEY (`establishment_id`) REFERENCES `establishments` (`id`),
  CONSTRAINT `income_income_reason_id_foreign` FOREIGN KEY (`income_reason_id`) REFERENCES `income_reasons` (`id`),
  CONSTRAINT `income_income_type_id_foreign` FOREIGN KEY (`income_type_id`) REFERENCES `income_types` (`id`),
  CONSTRAINT `income_soap_type_id_foreign` FOREIGN KEY (`soap_type_id`) REFERENCES `soap_types` (`id`),
  CONSTRAINT `income_state_type_id_foreign` FOREIGN KEY (`state_type_id`) REFERENCES `state_types` (`id`),
  CONSTRAINT `income_user_id_foreign` FOREIGN KEY (`user_id`) REFERENCES `users` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `income`
--

LOCK TABLES `income` WRITE;
/*!40000 ALTER TABLE `income` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `income` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `income` with 0 row(s)
--

--
-- Table structure for table `income_items`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `income_items` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `income_id` int(10) unsigned NOT NULL,
  `description` varchar(255) NOT NULL,
  `total` decimal(12,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `income_items_income_id_foreign` (`income_id`),
  CONSTRAINT `income_items_income_id_foreign` FOREIGN KEY (`income_id`) REFERENCES `income` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `income_items`
--

LOCK TABLES `income_items` WRITE;
/*!40000 ALTER TABLE `income_items` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `income_items` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `income_items` with 0 row(s)
--

--
-- Table structure for table `income_payments`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `income_payments` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `income_id` int(10) unsigned NOT NULL,
  `date_of_payment` date NOT NULL,
  `payment_method_type_id` char(2) NOT NULL,
  `has_card` tinyint(1) NOT NULL DEFAULT 0,
  `card_brand_id` char(2) DEFAULT NULL,
  `reference` varchar(255) DEFAULT NULL,
  `change` decimal(12,2) DEFAULT NULL,
  `payment` decimal(12,2) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `income_payments_income_id_foreign` (`income_id`),
  KEY `income_payments_card_brand_id_foreign` (`card_brand_id`),
  KEY `income_payments_payment_method_type_id_foreign` (`payment_method_type_id`),
  CONSTRAINT `income_payments_card_brand_id_foreign` FOREIGN KEY (`card_brand_id`) REFERENCES `card_brands` (`id`),
  CONSTRAINT `income_payments_income_id_foreign` FOREIGN KEY (`income_id`) REFERENCES `income` (`id`) ON DELETE CASCADE,
  CONSTRAINT `income_payments_payment_method_type_id_foreign` FOREIGN KEY (`payment_method_type_id`) REFERENCES `payment_method_types` (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `income_payments`
--

LOCK TABLES `income_payments` WRITE;
/*!40000 ALTER TABLE `income_payments` DISABLE KEYS */;
SET autocommit=0;
/*!40000 ALTER TABLE `income_payments` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `income_payments` with 0 row(s)
--

--
-- Table structure for table `income_reasons`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `income_reasons` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `income_reasons`
--

LOCK TABLES `income_reasons` WRITE;
/*!40000 ALTER TABLE `income_reasons` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `income_reasons` VALUES (1,'Varios');
/*!40000 ALTER TABLE `income_reasons` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `income_reasons` with 1 row(s)
--

--
-- Table structure for table `income_types`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `income_types` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `income_types`
--

LOCK TABLES `income_types` WRITE;
/*!40000 ALTER TABLE `income_types` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `income_types` VALUES (1,'INGRESOS FINANCIEROS','2024-11-10 15:18:33','2024-11-10 15:18:33'),(2,'PRESTAMOS','2024-11-10 15:18:33','2024-11-10 15:18:33'),(3,'OTROS','2024-11-10 15:18:33','2024-11-10 15:18:33');
/*!40000 ALTER TABLE `income_types` ENABLE KEYS */;
UNLOCK TABLES;
COMMIT;

-- Dumped table `income_types` with 3 row(s)
--

--
-- Table structure for table `inventories`
--

/*!40101 SET @saved_cs_client     = @@character_set_client */;
/*!40101 SET character_set_client = utf8 */;
CREATE TABLE `inventories` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `type` enum('1','2','3') DEFAULT NULL,
  `description` varchar(255) NOT NULL,
  `detail` varchar(255) DEFAULT NULL,
  `item_id` int(10) unsigned NOT NULL,
  `warehouse_id` int(10) unsigned NOT NULL,
  `warehouse_destination_id` int(10) unsigned DEFAULT NULL,
  `inventory_transaction_id` varchar(255) DEFAULT NULL,
  `quantity` decimal(12,4) NOT NULL,
  `lot_code` varchar(255) DEFAULT NULL,
  `inventories_transfer_id` int(10) unsigned DEFAULT NULL,
  `comments` varchar(255) DEFAULT NULL,
  `date_of_issue` date DEFAULT NULL,
  `guide_id` int(10) unsigned DEFAULT NULL,
  `system_stock` decimal(12,4) DEFAULT NULL,
  `real_stock` decimal(12,4) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `inventories_item_id_foreign` (`item_id`),
  KEY `inventories_warehouse_id_foreign` (`warehouse_id`),
  KEY `inventories_inventory_transaction_id_foreign` (`inventory_transaction_id`),
  KEY `inventories_inventories_transfer_id_foreign` (`inventories_transfer_id`),
  CONSTRAINT `inventories_inventories_transfer_id_foreign` FOREIGN KEY (`inventories_transfer_id`) REFERENCES `inventories_transfer` (`id`),
  CONSTRAINT `inventories_inventory_transaction_id_foreign` FOREIGN KEY (`inventory_transaction_id`) REFERENCES `inventory_transactions` (`id`),
  CONSTRAINT `inventories_item_id_foreign` FOREIGN KEY (`item_id`) REFERENCES `items` (`id`) ON DELETE CASCADE,
  CONSTRAINT `inventories_warehouse_id_foreign` FOREIGN KEY (`warehouse_id`) REFERENCES `warehouses` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=6334 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/*!40101 SET character_set_client = @saved_cs_client */;

--
-- Dumping data for table `inventories`
--

LOCK TABLES `inventories` WRITE;
/*!40000 ALTER TABLE `inventories` DISABLE KEYS */;
SET autocommit=0;
INSERT INTO `inventories` VALUES (1,'1','Stock inicial',NULL,1,1,NULL,NULL,20.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 15:24:03','2024-11-10 15:24:03'),(2,'1','Stock inicial',NULL,2,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:20','2024-11-10 18:48:20'),(3,'1','Stock inicial',NULL,3,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:20','2024-11-10 18:48:20'),(4,'1','Stock inicial',NULL,4,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:20','2024-11-10 18:48:20'),(5,'1','Stock inicial',NULL,5,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(6,'1','Stock inicial',NULL,6,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(7,'1','Stock inicial',NULL,7,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(8,'1','Stock inicial',NULL,8,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(9,'1','Stock inicial',NULL,9,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(10,'1','Stock inicial',NULL,10,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(11,'1','Stock inicial',NULL,11,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(12,'1','Stock inicial',NULL,12,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(13,'1','Stock inicial',NULL,13,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(14,'1','Stock inicial',NULL,14,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(15,'1','Stock inicial',NULL,15,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(16,'1','Stock inicial',NULL,16,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(17,'1','Stock inicial',NULL,17,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(18,'1','Stock inicial',NULL,18,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(19,'1','Stock inicial',NULL,19,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(20,'1','Stock inicial',NULL,20,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(21,'1','Stock inicial',NULL,21,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(22,'1','Stock inicial',NULL,22,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(23,'1','Stock inicial',NULL,23,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(24,'1','Stock inicial',NULL,24,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(25,'1','Stock inicial',NULL,25,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(26,'1','Stock inicial',NULL,26,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(27,'1','Stock inicial',NULL,27,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(28,'1','Stock inicial',NULL,28,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(29,'1','Stock inicial',NULL,29,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(30,'1','Stock inicial',NULL,30,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(31,'1','Stock inicial',NULL,31,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(32,'1','Stock inicial',NULL,32,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(33,'1','Stock inicial',NULL,33,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(34,'1','Stock inicial',NULL,34,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(35,'1','Stock inicial',NULL,35,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(36,'1','Stock inicial',NULL,36,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(37,'1','Stock inicial',NULL,37,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(38,'1','Stock inicial',NULL,38,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(39,'1','Stock inicial',NULL,39,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(40,'1','Stock inicial',NULL,40,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(41,'1','Stock inicial',NULL,41,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(42,'1','Stock inicial',NULL,42,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(43,'1','Stock inicial',NULL,43,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(44,'1','Stock inicial',NULL,44,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(45,'1','Stock inicial',NULL,45,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(46,'1','Stock inicial',NULL,46,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(47,'1','Stock inicial',NULL,47,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(48,'1','Stock inicial',NULL,48,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(49,'1','Stock inicial',NULL,49,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(50,'1','Stock inicial',NULL,50,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(51,'1','Stock inicial',NULL,51,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(52,'1','Stock inicial',NULL,52,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(53,'1','Stock inicial',NULL,53,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(54,'1','Stock inicial',NULL,54,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(55,'1','Stock inicial',NULL,55,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(56,'1','Stock inicial',NULL,56,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(57,'1','Stock inicial',NULL,57,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(58,'1','Stock inicial',NULL,58,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(59,'1','Stock inicial',NULL,59,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(60,'1','Stock inicial',NULL,60,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(61,'1','Stock inicial',NULL,61,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(62,'1','Stock inicial',NULL,62,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(63,'1','Stock inicial',NULL,63,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(64,'1','Stock inicial',NULL,64,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(65,'1','Stock inicial',NULL,65,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(66,'1','Stock inicial',NULL,66,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(67,'1','Stock inicial',NULL,67,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(68,'1','Stock inicial',NULL,68,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(69,'1','Stock inicial',NULL,69,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(70,'1','Stock inicial',NULL,70,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(71,'1','Stock inicial',NULL,71,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(72,'1','Stock inicial',NULL,72,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(73,'1','Stock inicial',NULL,73,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(74,'1','Stock inicial',NULL,74,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(75,'1','Stock inicial',NULL,75,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(76,'1','Stock inicial',NULL,76,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(77,'1','Stock inicial',NULL,77,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(78,'1','Stock inicial',NULL,78,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(79,'1','Stock inicial',NULL,79,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(80,'1','Stock inicial',NULL,80,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(81,'1','Stock inicial',NULL,81,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(82,'1','Stock inicial',NULL,82,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(83,'1','Stock inicial',NULL,83,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(84,'1','Stock inicial',NULL,84,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(85,'1','Stock inicial',NULL,85,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(86,'1','Stock inicial',NULL,86,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(87,'1','Stock inicial',NULL,87,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(88,'1','Stock inicial',NULL,88,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(89,'1','Stock inicial',NULL,89,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(90,'1','Stock inicial',NULL,90,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(91,'1','Stock inicial',NULL,91,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(92,'1','Stock inicial',NULL,92,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(93,'1','Stock inicial',NULL,93,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(94,'1','Stock inicial',NULL,94,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(95,'1','Stock inicial',NULL,95,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(96,'1','Stock inicial',NULL,96,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(97,'1','Stock inicial',NULL,97,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(98,'1','Stock inicial',NULL,98,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(99,'1','Stock inicial',NULL,99,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(100,'1','Stock inicial',NULL,100,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(101,'1','Stock inicial',NULL,101,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(102,'1','Stock inicial',NULL,102,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(103,'1','Stock inicial',NULL,103,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(104,'1','Stock inicial',NULL,104,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(105,'1','Stock inicial',NULL,105,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(106,'1','Stock inicial',NULL,106,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(107,'1','Stock inicial',NULL,107,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(108,'1','Stock inicial',NULL,108,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(109,'1','Stock inicial',NULL,109,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(110,'1','Stock inicial',NULL,110,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(111,'1','Stock inicial',NULL,111,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(112,'1','Stock inicial',NULL,112,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(113,'1','Stock inicial',NULL,113,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(114,'1','Stock inicial',NULL,114,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(115,'1','Stock inicial',NULL,115,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(116,'1','Stock inicial',NULL,116,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(117,'1','Stock inicial',NULL,117,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(118,'1','Stock inicial',NULL,118,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(119,'1','Stock inicial',NULL,119,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(120,'1','Stock inicial',NULL,120,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(121,'1','Stock inicial',NULL,121,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(122,'1','Stock inicial',NULL,122,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(123,'1','Stock inicial',NULL,123,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:21','2024-11-10 18:48:21'),(124,'1','Stock inicial',NULL,124,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(125,'1','Stock inicial',NULL,125,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(126,'1','Stock inicial',NULL,126,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(127,'1','Stock inicial',NULL,127,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(128,'1','Stock inicial',NULL,128,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(129,'1','Stock inicial',NULL,129,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(130,'1','Stock inicial',NULL,130,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(131,'1','Stock inicial',NULL,131,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(132,'1','Stock inicial',NULL,132,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(133,'1','Stock inicial',NULL,133,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(134,'1','Stock inicial',NULL,134,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(135,'1','Stock inicial',NULL,135,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(136,'1','Stock inicial',NULL,136,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(137,'1','Stock inicial',NULL,137,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(138,'1','Stock inicial',NULL,138,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(139,'1','Stock inicial',NULL,139,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(140,'1','Stock inicial',NULL,140,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(141,'1','Stock inicial',NULL,141,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(142,'1','Stock inicial',NULL,142,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(143,'1','Stock inicial',NULL,143,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(144,'1','Stock inicial',NULL,144,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(145,'1','Stock inicial',NULL,145,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(146,'1','Stock inicial',NULL,146,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(147,'1','Stock inicial',NULL,147,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(148,'1','Stock inicial',NULL,148,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(149,'1','Stock inicial',NULL,149,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(150,'1','Stock inicial',NULL,150,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(151,'1','Stock inicial',NULL,151,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(152,'1','Stock inicial',NULL,152,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(153,'1','Stock inicial',NULL,153,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(154,'1','Stock inicial',NULL,154,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(155,'1','Stock inicial',NULL,155,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(156,'1','Stock inicial',NULL,156,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(157,'1','Stock inicial',NULL,157,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(158,'1','Stock inicial',NULL,158,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(159,'1','Stock inicial',NULL,159,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(160,'1','Stock inicial',NULL,160,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(161,'1','Stock inicial',NULL,161,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(162,'1','Stock inicial',NULL,162,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(163,'1','Stock inicial',NULL,163,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(164,'1','Stock inicial',NULL,164,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(165,'1','Stock inicial',NULL,165,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(166,'1','Stock inicial',NULL,166,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(167,'1','Stock inicial',NULL,167,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(168,'1','Stock inicial',NULL,168,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(169,'1','Stock inicial',NULL,169,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(170,'1','Stock inicial',NULL,170,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(171,'1','Stock inicial',NULL,171,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(172,'1','Stock inicial',NULL,172,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(173,'1','Stock inicial',NULL,173,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(174,'1','Stock inicial',NULL,174,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(175,'1','Stock inicial',NULL,175,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(176,'1','Stock inicial',NULL,176,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(177,'1','Stock inicial',NULL,177,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(178,'1','Stock inicial',NULL,178,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(179,'1','Stock inicial',NULL,179,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(180,'1','Stock inicial',NULL,180,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(181,'1','Stock inicial',NULL,181,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(182,'1','Stock inicial',NULL,182,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(183,'1','Stock inicial',NULL,183,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(184,'1','Stock inicial',NULL,184,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(185,'1','Stock inicial',NULL,185,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(186,'1','Stock inicial',NULL,186,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(187,'1','Stock inicial',NULL,187,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(188,'1','Stock inicial',NULL,188,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(189,'1','Stock inicial',NULL,189,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(190,'1','Stock inicial',NULL,190,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(191,'1','Stock inicial',NULL,191,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(192,'1','Stock inicial',NULL,192,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(193,'1','Stock inicial',NULL,193,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(194,'1','Stock inicial',NULL,194,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(195,'1','Stock inicial',NULL,195,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(196,'1','Stock inicial',NULL,196,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(197,'1','Stock inicial',NULL,197,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(198,'1','Stock inicial',NULL,198,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(199,'1','Stock inicial',NULL,199,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(200,'1','Stock inicial',NULL,200,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(201,'1','Stock inicial',NULL,201,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(202,'1','Stock inicial',NULL,202,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(203,'1','Stock inicial',NULL,203,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(204,'1','Stock inicial',NULL,204,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(205,'1','Stock inicial',NULL,205,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(206,'1','Stock inicial',NULL,206,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(207,'1','Stock inicial',NULL,207,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(208,'1','Stock inicial',NULL,208,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(209,'1','Stock inicial',NULL,209,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(210,'1','Stock inicial',NULL,210,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(211,'1','Stock inicial',NULL,211,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(212,'1','Stock inicial',NULL,212,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(213,'1','Stock inicial',NULL,213,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(214,'1','Stock inicial',NULL,214,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(215,'1','Stock inicial',NULL,215,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(216,'1','Stock inicial',NULL,216,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(217,'1','Stock inicial',NULL,217,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(218,'1','Stock inicial',NULL,218,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(219,'1','Stock inicial',NULL,219,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(220,'1','Stock inicial',NULL,220,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(221,'1','Stock inicial',NULL,221,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(222,'1','Stock inicial',NULL,222,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(223,'1','Stock inicial',NULL,223,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(224,'1','Stock inicial',NULL,224,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(225,'1','Stock inicial',NULL,225,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(226,'1','Stock inicial',NULL,226,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(227,'1','Stock inicial',NULL,227,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(228,'1','Stock inicial',NULL,228,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(229,'1','Stock inicial',NULL,229,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(230,'1','Stock inicial',NULL,230,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(231,'1','Stock inicial',NULL,231,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(232,'1','Stock inicial',NULL,232,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(233,'1','Stock inicial',NULL,233,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(234,'1','Stock inicial',NULL,234,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(235,'1','Stock inicial',NULL,235,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(236,'1','Stock inicial',NULL,236,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(237,'1','Stock inicial',NULL,237,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(238,'1','Stock inicial',NULL,238,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(239,'1','Stock inicial',NULL,239,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(240,'1','Stock inicial',NULL,240,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(241,'1','Stock inicial',NULL,241,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(242,'1','Stock inicial',NULL,242,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(243,'1','Stock inicial',NULL,243,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(244,'1','Stock inicial',NULL,244,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(245,'1','Stock inicial',NULL,245,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:22','2024-11-10 18:48:22'),(246,'1','Stock inicial',NULL,246,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(247,'1','Stock inicial',NULL,247,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(248,'1','Stock inicial',NULL,248,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(249,'1','Stock inicial',NULL,249,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(250,'1','Stock inicial',NULL,250,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(251,'1','Stock inicial',NULL,251,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(252,'1','Stock inicial',NULL,252,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(253,'1','Stock inicial',NULL,253,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(254,'1','Stock inicial',NULL,254,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(255,'1','Stock inicial',NULL,255,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(256,'1','Stock inicial',NULL,256,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(257,'1','Stock inicial',NULL,257,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(258,'1','Stock inicial',NULL,258,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(259,'1','Stock inicial',NULL,259,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(260,'1','Stock inicial',NULL,260,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(261,'1','Stock inicial',NULL,261,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(262,'1','Stock inicial',NULL,262,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(263,'1','Stock inicial',NULL,263,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(264,'1','Stock inicial',NULL,264,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(265,'1','Stock inicial',NULL,265,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(266,'1','Stock inicial',NULL,266,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(267,'1','Stock inicial',NULL,267,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(268,'1','Stock inicial',NULL,268,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(269,'1','Stock inicial',NULL,269,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(270,'1','Stock inicial',NULL,270,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(271,'1','Stock inicial',NULL,271,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(272,'1','Stock inicial',NULL,272,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(273,'1','Stock inicial',NULL,273,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(274,'1','Stock inicial',NULL,274,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(275,'1','Stock inicial',NULL,275,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(276,'1','Stock inicial',NULL,276,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(277,'1','Stock inicial',NULL,277,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(278,'1','Stock inicial',NULL,278,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(279,'1','Stock inicial',NULL,279,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(280,'1','Stock inicial',NULL,280,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(281,'1','Stock inicial',NULL,281,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(282,'1','Stock inicial',NULL,282,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(283,'1','Stock inicial',NULL,283,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(284,'1','Stock inicial',NULL,284,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(285,'1','Stock inicial',NULL,285,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(286,'1','Stock inicial',NULL,286,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(287,'1','Stock inicial',NULL,287,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(288,'1','Stock inicial',NULL,288,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(289,'1','Stock inicial',NULL,289,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(290,'1','Stock inicial',NULL,290,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(291,'1','Stock inicial',NULL,291,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(292,'1','Stock inicial',NULL,292,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(293,'1','Stock inicial',NULL,293,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(294,'1','Stock inicial',NULL,294,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(295,'1','Stock inicial',NULL,295,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(296,'1','Stock inicial',NULL,296,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(297,'1','Stock inicial',NULL,297,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(298,'1','Stock inicial',NULL,298,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(299,'1','Stock inicial',NULL,299,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(300,'1','Stock inicial',NULL,300,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(301,'1','Stock inicial',NULL,301,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(302,'1','Stock inicial',NULL,302,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(303,'1','Stock inicial',NULL,303,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(304,'1','Stock inicial',NULL,304,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(305,'1','Stock inicial',NULL,305,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(306,'1','Stock inicial',NULL,306,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(307,'1','Stock inicial',NULL,307,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(308,'1','Stock inicial',NULL,308,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(309,'1','Stock inicial',NULL,309,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(310,'1','Stock inicial',NULL,310,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(311,'1','Stock inicial',NULL,311,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(312,'1','Stock inicial',NULL,312,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(313,'1','Stock inicial',NULL,313,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(314,'1','Stock inicial',NULL,314,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(315,'1','Stock inicial',NULL,315,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(316,'1','Stock inicial',NULL,316,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(317,'1','Stock inicial',NULL,317,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(318,'1','Stock inicial',NULL,318,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(319,'1','Stock inicial',NULL,319,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(320,'1','Stock inicial',NULL,320,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(321,'1','Stock inicial',NULL,321,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(322,'1','Stock inicial',NULL,322,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(323,'1','Stock inicial',NULL,323,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(324,'1','Stock inicial',NULL,324,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(325,'1','Stock inicial',NULL,325,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(326,'1','Stock inicial',NULL,326,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(327,'1','Stock inicial',NULL,327,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(328,'1','Stock inicial',NULL,328,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(329,'1','Stock inicial',NULL,329,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(330,'1','Stock inicial',NULL,330,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(331,'1','Stock inicial',NULL,331,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(332,'1','Stock inicial',NULL,332,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(333,'1','Stock inicial',NULL,333,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(334,'1','Stock inicial',NULL,334,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(335,'1','Stock inicial',NULL,335,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(336,'1','Stock inicial',NULL,336,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(337,'1','Stock inicial',NULL,337,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(338,'1','Stock inicial',NULL,338,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(339,'1','Stock inicial',NULL,339,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(340,'1','Stock inicial',NULL,340,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(341,'1','Stock inicial',NULL,341,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(342,'1','Stock inicial',NULL,342,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(343,'1','Stock inicial',NULL,343,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(344,'1','Stock inicial',NULL,344,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(345,'1','Stock inicial',NULL,345,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(346,'1','Stock inicial',NULL,346,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(347,'1','Stock inicial',NULL,347,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(348,'1','Stock inicial',NULL,348,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(349,'1','Stock inicial',NULL,349,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(350,'1','Stock inicial',NULL,350,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(351,'1','Stock inicial',NULL,351,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(352,'1','Stock inicial',NULL,352,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(353,'1','Stock inicial',NULL,353,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(354,'1','Stock inicial',NULL,354,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(355,'1','Stock inicial',NULL,355,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(356,'1','Stock inicial',NULL,356,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(357,'1','Stock inicial',NULL,357,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(358,'1','Stock inicial',NULL,358,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(359,'1','Stock inicial',NULL,359,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(360,'1','Stock inicial',NULL,360,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(361,'1','Stock inicial',NULL,361,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(362,'1','Stock inicial',NULL,362,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(363,'1','Stock inicial',NULL,363,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(364,'1','Stock inicial',NULL,364,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(365,'1','Stock inicial',NULL,365,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(366,'1','Stock inicial',NULL,366,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(367,'1','Stock inicial',NULL,367,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(368,'1','Stock inicial',NULL,368,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(369,'1','Stock inicial',NULL,369,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(370,'1','Stock inicial',NULL,370,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(371,'1','Stock inicial',NULL,371,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(372,'1','Stock inicial',NULL,372,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(373,'1','Stock inicial',NULL,373,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:23','2024-11-10 18:48:23'),(374,'1','Stock inicial',NULL,374,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(375,'1','Stock inicial',NULL,375,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(376,'1','Stock inicial',NULL,376,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(377,'1','Stock inicial',NULL,377,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(378,'1','Stock inicial',NULL,378,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(379,'1','Stock inicial',NULL,379,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(380,'1','Stock inicial',NULL,380,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(381,'1','Stock inicial',NULL,381,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(382,'1','Stock inicial',NULL,382,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(383,'1','Stock inicial',NULL,383,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(384,'1','Stock inicial',NULL,384,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(385,'1','Stock inicial',NULL,385,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(386,'1','Stock inicial',NULL,386,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(387,'1','Stock inicial',NULL,387,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(388,'1','Stock inicial',NULL,388,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(389,'1','Stock inicial',NULL,389,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(390,'1','Stock inicial',NULL,390,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(391,'1','Stock inicial',NULL,391,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(392,'1','Stock inicial',NULL,392,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(393,'1','Stock inicial',NULL,393,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(394,'1','Stock inicial',NULL,394,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(395,'1','Stock inicial',NULL,395,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(396,'1','Stock inicial',NULL,396,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(397,'1','Stock inicial',NULL,397,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(398,'1','Stock inicial',NULL,398,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(399,'1','Stock inicial',NULL,399,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(400,'1','Stock inicial',NULL,400,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(401,'1','Stock inicial',NULL,401,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(402,'1','Stock inicial',NULL,402,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(403,'1','Stock inicial',NULL,403,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(404,'1','Stock inicial',NULL,404,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(405,'1','Stock inicial',NULL,405,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(406,'1','Stock inicial',NULL,406,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(407,'1','Stock inicial',NULL,407,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(408,'1','Stock inicial',NULL,408,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(409,'1','Stock inicial',NULL,409,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(410,'1','Stock inicial',NULL,410,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(411,'1','Stock inicial',NULL,411,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(412,'1','Stock inicial',NULL,412,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(413,'1','Stock inicial',NULL,413,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(414,'1','Stock inicial',NULL,414,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(415,'1','Stock inicial',NULL,415,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(416,'1','Stock inicial',NULL,416,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(417,'1','Stock inicial',NULL,417,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(418,'1','Stock inicial',NULL,418,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(419,'1','Stock inicial',NULL,419,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(420,'1','Stock inicial',NULL,420,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(421,'1','Stock inicial',NULL,421,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(422,'1','Stock inicial',NULL,422,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(423,'1','Stock inicial',NULL,423,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(424,'1','Stock inicial',NULL,424,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(425,'1','Stock inicial',NULL,425,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(426,'1','Stock inicial',NULL,426,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(427,'1','Stock inicial',NULL,427,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(428,'1','Stock inicial',NULL,428,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(429,'1','Stock inicial',NULL,429,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(430,'1','Stock inicial',NULL,430,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(431,'1','Stock inicial',NULL,431,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(432,'1','Stock inicial',NULL,432,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(433,'1','Stock inicial',NULL,433,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(434,'1','Stock inicial',NULL,434,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(435,'1','Stock inicial',NULL,435,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(436,'1','Stock inicial',NULL,436,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(437,'1','Stock inicial',NULL,437,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(438,'1','Stock inicial',NULL,438,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(439,'1','Stock inicial',NULL,439,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(440,'1','Stock inicial',NULL,440,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(441,'1','Stock inicial',NULL,441,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(442,'1','Stock inicial',NULL,442,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(443,'1','Stock inicial',NULL,443,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(444,'1','Stock inicial',NULL,444,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(445,'1','Stock inicial',NULL,445,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(446,'1','Stock inicial',NULL,446,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(447,'1','Stock inicial',NULL,447,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(448,'1','Stock inicial',NULL,448,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(449,'1','Stock inicial',NULL,449,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(450,'1','Stock inicial',NULL,450,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(451,'1','Stock inicial',NULL,451,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(452,'1','Stock inicial',NULL,452,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(453,'1','Stock inicial',NULL,453,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(454,'1','Stock inicial',NULL,454,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(455,'1','Stock inicial',NULL,455,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(456,'1','Stock inicial',NULL,456,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(457,'1','Stock inicial',NULL,457,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(458,'1','Stock inicial',NULL,458,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(459,'1','Stock inicial',NULL,459,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(460,'1','Stock inicial',NULL,460,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(461,'1','Stock inicial',NULL,461,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(462,'1','Stock inicial',NULL,462,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(463,'1','Stock inicial',NULL,463,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(464,'1','Stock inicial',NULL,464,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(465,'1','Stock inicial',NULL,465,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(466,'1','Stock inicial',NULL,466,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(467,'1','Stock inicial',NULL,467,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(468,'1','Stock inicial',NULL,468,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(469,'1','Stock inicial',NULL,469,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(470,'1','Stock inicial',NULL,470,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(471,'1','Stock inicial',NULL,471,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(472,'1','Stock inicial',NULL,472,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(473,'1','Stock inicial',NULL,473,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(474,'1','Stock inicial',NULL,474,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(475,'1','Stock inicial',NULL,475,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(476,'1','Stock inicial',NULL,476,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(477,'1','Stock inicial',NULL,477,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(478,'1','Stock inicial',NULL,478,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(479,'1','Stock inicial',NULL,479,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(480,'1','Stock inicial',NULL,480,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(481,'1','Stock inicial',NULL,481,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(482,'1','Stock inicial',NULL,482,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(483,'1','Stock inicial',NULL,483,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(484,'1','Stock inicial',NULL,484,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(485,'1','Stock inicial',NULL,485,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(486,'1','Stock inicial',NULL,486,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(487,'1','Stock inicial',NULL,487,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(488,'1','Stock inicial',NULL,488,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(489,'1','Stock inicial',NULL,489,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(490,'1','Stock inicial',NULL,490,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(491,'1','Stock inicial',NULL,491,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(492,'1','Stock inicial',NULL,492,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(493,'1','Stock inicial',NULL,493,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(494,'1','Stock inicial',NULL,494,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(495,'1','Stock inicial',NULL,495,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(496,'1','Stock inicial',NULL,496,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(497,'1','Stock inicial',NULL,497,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(498,'1','Stock inicial',NULL,498,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(499,'1','Stock inicial',NULL,499,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(500,'1','Stock inicial',NULL,500,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:24','2024-11-10 18:48:24'),(501,'1','Stock inicial',NULL,501,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(502,'1','Stock inicial',NULL,502,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(503,'1','Stock inicial',NULL,503,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(504,'1','Stock inicial',NULL,504,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(505,'1','Stock inicial',NULL,505,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(506,'1','Stock inicial',NULL,506,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(507,'1','Stock inicial',NULL,507,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(508,'1','Stock inicial',NULL,508,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(509,'1','Stock inicial',NULL,509,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(510,'1','Stock inicial',NULL,510,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(511,'1','Stock inicial',NULL,511,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(512,'1','Stock inicial',NULL,512,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(513,'1','Stock inicial',NULL,513,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(514,'1','Stock inicial',NULL,514,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(515,'1','Stock inicial',NULL,515,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(516,'1','Stock inicial',NULL,516,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(517,'1','Stock inicial',NULL,517,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(518,'1','Stock inicial',NULL,518,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(519,'1','Stock inicial',NULL,519,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(520,'1','Stock inicial',NULL,520,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(521,'1','Stock inicial',NULL,521,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(522,'1','Stock inicial',NULL,522,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(523,'1','Stock inicial',NULL,523,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(524,'1','Stock inicial',NULL,524,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(525,'1','Stock inicial',NULL,525,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(526,'1','Stock inicial',NULL,526,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(527,'1','Stock inicial',NULL,527,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(528,'1','Stock inicial',NULL,528,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(529,'1','Stock inicial',NULL,529,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(530,'1','Stock inicial',NULL,530,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(531,'1','Stock inicial',NULL,531,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(532,'1','Stock inicial',NULL,532,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(533,'1','Stock inicial',NULL,533,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(534,'1','Stock inicial',NULL,534,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(535,'1','Stock inicial',NULL,535,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(536,'1','Stock inicial',NULL,536,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(537,'1','Stock inicial',NULL,537,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(538,'1','Stock inicial',NULL,538,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(539,'1','Stock inicial',NULL,539,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(540,'1','Stock inicial',NULL,540,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(541,'1','Stock inicial',NULL,541,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(542,'1','Stock inicial',NULL,542,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(543,'1','Stock inicial',NULL,543,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(544,'1','Stock inicial',NULL,544,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(545,'1','Stock inicial',NULL,545,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(546,'1','Stock inicial',NULL,546,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(547,'1','Stock inicial',NULL,547,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(548,'1','Stock inicial',NULL,548,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(549,'1','Stock inicial',NULL,549,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(550,'1','Stock inicial',NULL,550,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(551,'1','Stock inicial',NULL,551,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(552,'1','Stock inicial',NULL,552,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(553,'1','Stock inicial',NULL,553,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(554,'1','Stock inicial',NULL,554,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(555,'1','Stock inicial',NULL,555,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(556,'1','Stock inicial',NULL,556,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(557,'1','Stock inicial',NULL,557,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(558,'1','Stock inicial',NULL,558,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(559,'1','Stock inicial',NULL,559,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(560,'1','Stock inicial',NULL,560,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(561,'1','Stock inicial',NULL,561,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(562,'1','Stock inicial',NULL,562,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(563,'1','Stock inicial',NULL,563,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(564,'1','Stock inicial',NULL,564,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(565,'1','Stock inicial',NULL,565,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(566,'1','Stock inicial',NULL,566,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(567,'1','Stock inicial',NULL,567,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(568,'1','Stock inicial',NULL,568,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(569,'1','Stock inicial',NULL,569,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(570,'1','Stock inicial',NULL,570,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(571,'1','Stock inicial',NULL,571,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(572,'1','Stock inicial',NULL,572,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(573,'1','Stock inicial',NULL,573,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(574,'1','Stock inicial',NULL,574,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(575,'1','Stock inicial',NULL,575,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(576,'1','Stock inicial',NULL,576,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(577,'1','Stock inicial',NULL,577,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(578,'1','Stock inicial',NULL,578,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(579,'1','Stock inicial',NULL,579,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(580,'1','Stock inicial',NULL,580,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(581,'1','Stock inicial',NULL,581,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(582,'1','Stock inicial',NULL,582,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(583,'1','Stock inicial',NULL,583,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(584,'1','Stock inicial',NULL,584,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(585,'1','Stock inicial',NULL,585,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(586,'1','Stock inicial',NULL,586,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(587,'1','Stock inicial',NULL,587,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(588,'1','Stock inicial',NULL,588,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(589,'1','Stock inicial',NULL,589,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(590,'1','Stock inicial',NULL,590,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(591,'1','Stock inicial',NULL,591,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(592,'1','Stock inicial',NULL,592,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(593,'1','Stock inicial',NULL,593,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(594,'1','Stock inicial',NULL,594,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(595,'1','Stock inicial',NULL,595,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(596,'1','Stock inicial',NULL,596,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(597,'1','Stock inicial',NULL,597,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(598,'1','Stock inicial',NULL,598,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(599,'1','Stock inicial',NULL,599,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(600,'1','Stock inicial',NULL,600,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(601,'1','Stock inicial',NULL,601,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(602,'1','Stock inicial',NULL,602,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(603,'1','Stock inicial',NULL,603,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(604,'1','Stock inicial',NULL,604,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(605,'1','Stock inicial',NULL,605,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(606,'1','Stock inicial',NULL,606,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(607,'1','Stock inicial',NULL,607,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(608,'1','Stock inicial',NULL,608,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(609,'1','Stock inicial',NULL,609,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(610,'1','Stock inicial',NULL,610,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(611,'1','Stock inicial',NULL,611,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(612,'1','Stock inicial',NULL,612,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(613,'1','Stock inicial',NULL,613,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(614,'1','Stock inicial',NULL,614,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(615,'1','Stock inicial',NULL,615,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(616,'1','Stock inicial',NULL,616,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(617,'1','Stock inicial',NULL,617,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(618,'1','Stock inicial',NULL,618,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(619,'1','Stock inicial',NULL,619,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(620,'1','Stock inicial',NULL,620,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(621,'1','Stock inicial',NULL,621,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(622,'1','Stock inicial',NULL,622,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(623,'1','Stock inicial',NULL,623,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:25','2024-11-10 18:48:25'),(624,'1','Stock inicial',NULL,624,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(625,'1','Stock inicial',NULL,625,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(626,'1','Stock inicial',NULL,626,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(627,'1','Stock inicial',NULL,627,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(628,'1','Stock inicial',NULL,628,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(629,'1','Stock inicial',NULL,629,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(630,'1','Stock inicial',NULL,630,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(631,'1','Stock inicial',NULL,631,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(632,'1','Stock inicial',NULL,632,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(633,'1','Stock inicial',NULL,633,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(634,'1','Stock inicial',NULL,634,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(635,'1','Stock inicial',NULL,635,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(636,'1','Stock inicial',NULL,636,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(637,'1','Stock inicial',NULL,637,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(638,'1','Stock inicial',NULL,638,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(639,'1','Stock inicial',NULL,639,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(640,'1','Stock inicial',NULL,640,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(641,'1','Stock inicial',NULL,641,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(642,'1','Stock inicial',NULL,642,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(643,'1','Stock inicial',NULL,643,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(644,'1','Stock inicial',NULL,644,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(645,'1','Stock inicial',NULL,645,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(646,'1','Stock inicial',NULL,646,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(647,'1','Stock inicial',NULL,647,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(648,'1','Stock inicial',NULL,648,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(649,'1','Stock inicial',NULL,649,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(650,'1','Stock inicial',NULL,650,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(651,'1','Stock inicial',NULL,651,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(652,'1','Stock inicial',NULL,652,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(653,'1','Stock inicial',NULL,653,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(654,'1','Stock inicial',NULL,654,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(655,'1','Stock inicial',NULL,655,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(656,'1','Stock inicial',NULL,656,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(657,'1','Stock inicial',NULL,657,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(658,'1','Stock inicial',NULL,658,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(659,'1','Stock inicial',NULL,659,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(660,'1','Stock inicial',NULL,660,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(661,'1','Stock inicial',NULL,661,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(662,'1','Stock inicial',NULL,662,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(663,'1','Stock inicial',NULL,663,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(664,'1','Stock inicial',NULL,664,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(665,'1','Stock inicial',NULL,665,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(666,'1','Stock inicial',NULL,666,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(667,'1','Stock inicial',NULL,667,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(668,'1','Stock inicial',NULL,668,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(669,'1','Stock inicial',NULL,669,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(670,'1','Stock inicial',NULL,670,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(671,'1','Stock inicial',NULL,671,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(672,'1','Stock inicial',NULL,672,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(673,'1','Stock inicial',NULL,673,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(674,'1','Stock inicial',NULL,674,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(675,'1','Stock inicial',NULL,675,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(676,'1','Stock inicial',NULL,676,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(677,'1','Stock inicial',NULL,677,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(678,'1','Stock inicial',NULL,678,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(679,'1','Stock inicial',NULL,679,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(680,'1','Stock inicial',NULL,680,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(681,'1','Stock inicial',NULL,681,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(682,'1','Stock inicial',NULL,682,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(683,'1','Stock inicial',NULL,683,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(684,'1','Stock inicial',NULL,684,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(685,'1','Stock inicial',NULL,685,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(686,'1','Stock inicial',NULL,686,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(687,'1','Stock inicial',NULL,687,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(688,'1','Stock inicial',NULL,688,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(689,'1','Stock inicial',NULL,689,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(690,'1','Stock inicial',NULL,690,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(691,'1','Stock inicial',NULL,691,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(692,'1','Stock inicial',NULL,692,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(693,'1','Stock inicial',NULL,693,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(694,'1','Stock inicial',NULL,694,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(695,'1','Stock inicial',NULL,695,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(696,'1','Stock inicial',NULL,696,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(697,'1','Stock inicial',NULL,697,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(698,'1','Stock inicial',NULL,698,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(699,'1','Stock inicial',NULL,699,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(700,'1','Stock inicial',NULL,700,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(701,'1','Stock inicial',NULL,701,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(702,'1','Stock inicial',NULL,702,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(703,'1','Stock inicial',NULL,703,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(704,'1','Stock inicial',NULL,704,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(705,'1','Stock inicial',NULL,705,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(706,'1','Stock inicial',NULL,706,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(707,'1','Stock inicial',NULL,707,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(708,'1','Stock inicial',NULL,708,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(709,'1','Stock inicial',NULL,709,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(710,'1','Stock inicial',NULL,710,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(711,'1','Stock inicial',NULL,711,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(712,'1','Stock inicial',NULL,712,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(713,'1','Stock inicial',NULL,713,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(714,'1','Stock inicial',NULL,714,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(715,'1','Stock inicial',NULL,715,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(716,'1','Stock inicial',NULL,716,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(717,'1','Stock inicial',NULL,717,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(718,'1','Stock inicial',NULL,718,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(719,'1','Stock inicial',NULL,719,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(720,'1','Stock inicial',NULL,720,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(721,'1','Stock inicial',NULL,721,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(722,'1','Stock inicial',NULL,722,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(723,'1','Stock inicial',NULL,723,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(724,'1','Stock inicial',NULL,724,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(725,'1','Stock inicial',NULL,725,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(726,'1','Stock inicial',NULL,726,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(727,'1','Stock inicial',NULL,727,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(728,'1','Stock inicial',NULL,728,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(729,'1','Stock inicial',NULL,729,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(730,'1','Stock inicial',NULL,730,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(731,'1','Stock inicial',NULL,731,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(732,'1','Stock inicial',NULL,732,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(733,'1','Stock inicial',NULL,733,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(734,'1','Stock inicial',NULL,734,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(735,'1','Stock inicial',NULL,735,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(736,'1','Stock inicial',NULL,736,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(737,'1','Stock inicial',NULL,737,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(738,'1','Stock inicial',NULL,738,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(739,'1','Stock inicial',NULL,739,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(740,'1','Stock inicial',NULL,740,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(741,'1','Stock inicial',NULL,741,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(742,'1','Stock inicial',NULL,742,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(743,'1','Stock inicial',NULL,743,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(744,'1','Stock inicial',NULL,744,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(745,'1','Stock inicial',NULL,745,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(746,'1','Stock inicial',NULL,746,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(747,'1','Stock inicial',NULL,747,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(748,'1','Stock inicial',NULL,748,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(749,'1','Stock inicial',NULL,749,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(750,'1','Stock inicial',NULL,750,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(751,'1','Stock inicial',NULL,751,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(752,'1','Stock inicial',NULL,752,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(753,'1','Stock inicial',NULL,753,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(754,'1','Stock inicial',NULL,754,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:26','2024-11-10 18:48:26'),(755,'1','Stock inicial',NULL,755,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(756,'1','Stock inicial',NULL,756,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(757,'1','Stock inicial',NULL,757,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(758,'1','Stock inicial',NULL,758,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(759,'1','Stock inicial',NULL,759,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(760,'1','Stock inicial',NULL,760,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(761,'1','Stock inicial',NULL,761,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(762,'1','Stock inicial',NULL,762,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(763,'1','Stock inicial',NULL,763,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(764,'1','Stock inicial',NULL,764,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(765,'1','Stock inicial',NULL,765,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(766,'1','Stock inicial',NULL,766,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(767,'1','Stock inicial',NULL,767,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(768,'1','Stock inicial',NULL,768,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(769,'1','Stock inicial',NULL,769,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(770,'1','Stock inicial',NULL,770,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(771,'1','Stock inicial',NULL,771,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(772,'1','Stock inicial',NULL,772,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(773,'1','Stock inicial',NULL,773,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(774,'1','Stock inicial',NULL,774,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(775,'1','Stock inicial',NULL,775,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(776,'1','Stock inicial',NULL,776,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(777,'1','Stock inicial',NULL,777,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(778,'1','Stock inicial',NULL,778,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(779,'1','Stock inicial',NULL,779,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(780,'1','Stock inicial',NULL,780,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(781,'1','Stock inicial',NULL,781,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(782,'1','Stock inicial',NULL,782,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(783,'1','Stock inicial',NULL,783,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(784,'1','Stock inicial',NULL,784,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(785,'1','Stock inicial',NULL,785,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(786,'1','Stock inicial',NULL,786,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(787,'1','Stock inicial',NULL,787,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(788,'1','Stock inicial',NULL,788,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(789,'1','Stock inicial',NULL,789,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(790,'1','Stock inicial',NULL,790,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(791,'1','Stock inicial',NULL,791,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(792,'1','Stock inicial',NULL,792,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(793,'1','Stock inicial',NULL,793,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(794,'1','Stock inicial',NULL,794,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(795,'1','Stock inicial',NULL,795,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(796,'1','Stock inicial',NULL,796,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(797,'1','Stock inicial',NULL,797,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(798,'1','Stock inicial',NULL,798,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(799,'1','Stock inicial',NULL,799,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(800,'1','Stock inicial',NULL,800,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(801,'1','Stock inicial',NULL,801,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(802,'1','Stock inicial',NULL,802,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(803,'1','Stock inicial',NULL,803,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(804,'1','Stock inicial',NULL,804,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(805,'1','Stock inicial',NULL,805,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(806,'1','Stock inicial',NULL,806,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(807,'1','Stock inicial',NULL,807,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(808,'1','Stock inicial',NULL,808,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(809,'1','Stock inicial',NULL,809,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(810,'1','Stock inicial',NULL,810,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(811,'1','Stock inicial',NULL,811,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(812,'1','Stock inicial',NULL,812,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(813,'1','Stock inicial',NULL,813,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(814,'1','Stock inicial',NULL,814,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(815,'1','Stock inicial',NULL,815,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(816,'1','Stock inicial',NULL,816,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(817,'1','Stock inicial',NULL,817,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(818,'1','Stock inicial',NULL,818,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(819,'1','Stock inicial',NULL,819,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(820,'1','Stock inicial',NULL,820,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(821,'1','Stock inicial',NULL,821,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(822,'1','Stock inicial',NULL,822,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(823,'1','Stock inicial',NULL,823,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(824,'1','Stock inicial',NULL,824,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(825,'1','Stock inicial',NULL,825,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(826,'1','Stock inicial',NULL,826,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(827,'1','Stock inicial',NULL,827,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(828,'1','Stock inicial',NULL,828,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(829,'1','Stock inicial',NULL,829,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(830,'1','Stock inicial',NULL,830,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(831,'1','Stock inicial',NULL,831,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(832,'1','Stock inicial',NULL,832,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(833,'1','Stock inicial',NULL,833,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(834,'1','Stock inicial',NULL,834,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(835,'1','Stock inicial',NULL,835,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(836,'1','Stock inicial',NULL,836,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(837,'1','Stock inicial',NULL,837,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(838,'1','Stock inicial',NULL,838,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(839,'1','Stock inicial',NULL,839,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(840,'1','Stock inicial',NULL,840,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(841,'1','Stock inicial',NULL,841,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(842,'1','Stock inicial',NULL,842,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(843,'1','Stock inicial',NULL,843,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(844,'1','Stock inicial',NULL,844,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(845,'1','Stock inicial',NULL,845,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(846,'1','Stock inicial',NULL,846,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(847,'1','Stock inicial',NULL,847,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(848,'1','Stock inicial',NULL,848,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(849,'1','Stock inicial',NULL,849,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(850,'1','Stock inicial',NULL,850,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(851,'1','Stock inicial',NULL,851,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(852,'1','Stock inicial',NULL,852,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(853,'1','Stock inicial',NULL,853,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(854,'1','Stock inicial',NULL,854,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(855,'1','Stock inicial',NULL,855,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(856,'1','Stock inicial',NULL,856,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(857,'1','Stock inicial',NULL,857,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(858,'1','Stock inicial',NULL,858,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(859,'1','Stock inicial',NULL,859,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(860,'1','Stock inicial',NULL,860,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(861,'1','Stock inicial',NULL,861,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(862,'1','Stock inicial',NULL,862,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(863,'1','Stock inicial',NULL,863,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(864,'1','Stock inicial',NULL,864,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(865,'1','Stock inicial',NULL,865,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(866,'1','Stock inicial',NULL,866,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(867,'1','Stock inicial',NULL,867,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(868,'1','Stock inicial',NULL,868,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(869,'1','Stock inicial',NULL,869,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(870,'1','Stock inicial',NULL,870,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(871,'1','Stock inicial',NULL,871,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(872,'1','Stock inicial',NULL,872,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(873,'1','Stock inicial',NULL,873,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(874,'1','Stock inicial',NULL,874,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(875,'1','Stock inicial',NULL,875,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(876,'1','Stock inicial',NULL,876,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(877,'1','Stock inicial',NULL,877,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(878,'1','Stock inicial',NULL,878,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(879,'1','Stock inicial',NULL,879,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(880,'1','Stock inicial',NULL,880,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(881,'1','Stock inicial',NULL,881,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(882,'1','Stock inicial',NULL,882,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:27','2024-11-10 18:48:27'),(883,'1','Stock inicial',NULL,883,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(884,'1','Stock inicial',NULL,884,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(885,'1','Stock inicial',NULL,885,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(886,'1','Stock inicial',NULL,886,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(887,'1','Stock inicial',NULL,887,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(888,'1','Stock inicial',NULL,888,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(889,'1','Stock inicial',NULL,889,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(890,'1','Stock inicial',NULL,890,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(891,'1','Stock inicial',NULL,891,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(892,'1','Stock inicial',NULL,892,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(893,'1','Stock inicial',NULL,893,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(894,'1','Stock inicial',NULL,894,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(895,'1','Stock inicial',NULL,895,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(896,'1','Stock inicial',NULL,896,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(897,'1','Stock inicial',NULL,897,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(898,'1','Stock inicial',NULL,898,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(899,'1','Stock inicial',NULL,899,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(900,'1','Stock inicial',NULL,900,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(901,'1','Stock inicial',NULL,901,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(902,'1','Stock inicial',NULL,902,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(903,'1','Stock inicial',NULL,903,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(904,'1','Stock inicial',NULL,904,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(905,'1','Stock inicial',NULL,905,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(906,'1','Stock inicial',NULL,906,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(907,'1','Stock inicial',NULL,907,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(908,'1','Stock inicial',NULL,908,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(909,'1','Stock inicial',NULL,909,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(910,'1','Stock inicial',NULL,910,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(911,'1','Stock inicial',NULL,911,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(912,'1','Stock inicial',NULL,912,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(913,'1','Stock inicial',NULL,913,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(914,'1','Stock inicial',NULL,914,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(915,'1','Stock inicial',NULL,915,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(916,'1','Stock inicial',NULL,916,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(917,'1','Stock inicial',NULL,917,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(918,'1','Stock inicial',NULL,918,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(919,'1','Stock inicial',NULL,919,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(920,'1','Stock inicial',NULL,920,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(921,'1','Stock inicial',NULL,921,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(922,'1','Stock inicial',NULL,922,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(923,'1','Stock inicial',NULL,923,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(924,'1','Stock inicial',NULL,924,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(925,'1','Stock inicial',NULL,925,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(926,'1','Stock inicial',NULL,926,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(927,'1','Stock inicial',NULL,927,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(928,'1','Stock inicial',NULL,928,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(929,'1','Stock inicial',NULL,929,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(930,'1','Stock inicial',NULL,930,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(931,'1','Stock inicial',NULL,931,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(932,'1','Stock inicial',NULL,932,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(933,'1','Stock inicial',NULL,933,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(934,'1','Stock inicial',NULL,934,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(935,'1','Stock inicial',NULL,935,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(936,'1','Stock inicial',NULL,936,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(937,'1','Stock inicial',NULL,937,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(938,'1','Stock inicial',NULL,938,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(939,'1','Stock inicial',NULL,939,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(940,'1','Stock inicial',NULL,940,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(941,'1','Stock inicial',NULL,941,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(942,'1','Stock inicial',NULL,942,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(943,'1','Stock inicial',NULL,943,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(944,'1','Stock inicial',NULL,944,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(945,'1','Stock inicial',NULL,945,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(946,'1','Stock inicial',NULL,946,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(947,'1','Stock inicial',NULL,947,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(948,'1','Stock inicial',NULL,948,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(949,'1','Stock inicial',NULL,949,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(950,'1','Stock inicial',NULL,950,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(951,'1','Stock inicial',NULL,951,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(952,'1','Stock inicial',NULL,952,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(953,'1','Stock inicial',NULL,953,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(954,'1','Stock inicial',NULL,954,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(955,'1','Stock inicial',NULL,955,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(956,'1','Stock inicial',NULL,956,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(957,'1','Stock inicial',NULL,957,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(958,'1','Stock inicial',NULL,958,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(959,'1','Stock inicial',NULL,959,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(960,'1','Stock inicial',NULL,960,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(961,'1','Stock inicial',NULL,961,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(962,'1','Stock inicial',NULL,962,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(963,'1','Stock inicial',NULL,963,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(964,'1','Stock inicial',NULL,964,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(965,'1','Stock inicial',NULL,965,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(966,'1','Stock inicial',NULL,966,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(967,'1','Stock inicial',NULL,967,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(968,'1','Stock inicial',NULL,968,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(969,'1','Stock inicial',NULL,969,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(970,'1','Stock inicial',NULL,970,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(971,'1','Stock inicial',NULL,971,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(972,'1','Stock inicial',NULL,972,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(973,'1','Stock inicial',NULL,973,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(974,'1','Stock inicial',NULL,974,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(975,'1','Stock inicial',NULL,975,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(976,'1','Stock inicial',NULL,976,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(977,'1','Stock inicial',NULL,977,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(978,'1','Stock inicial',NULL,978,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(979,'1','Stock inicial',NULL,979,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(980,'1','Stock inicial',NULL,980,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(981,'1','Stock inicial',NULL,981,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(982,'1','Stock inicial',NULL,982,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(983,'1','Stock inicial',NULL,983,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(984,'1','Stock inicial',NULL,984,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(985,'1','Stock inicial',NULL,985,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(986,'1','Stock inicial',NULL,986,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(987,'1','Stock inicial',NULL,987,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(988,'1','Stock inicial',NULL,988,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(989,'1','Stock inicial',NULL,989,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(990,'1','Stock inicial',NULL,990,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(991,'1','Stock inicial',NULL,991,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(992,'1','Stock inicial',NULL,992,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(993,'1','Stock inicial',NULL,993,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(994,'1','Stock inicial',NULL,994,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(995,'1','Stock inicial',NULL,995,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(996,'1','Stock inicial',NULL,996,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(997,'1','Stock inicial',NULL,997,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(998,'1','Stock inicial',NULL,998,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(999,'1','Stock inicial',NULL,999,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(1000,'1','Stock inicial',NULL,1000,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(1001,'1','Stock inicial',NULL,1001,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(1002,'1','Stock inicial',NULL,1002,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(1003,'1','Stock inicial',NULL,1003,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(1004,'1','Stock inicial',NULL,1004,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(1005,'1','Stock inicial',NULL,1005,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(1006,'1','Stock inicial',NULL,1006,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(1007,'1','Stock inicial',NULL,1007,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(1008,'1','Stock inicial',NULL,1008,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(1009,'1','Stock inicial',NULL,1009,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:28','2024-11-10 18:48:28'),(1010,'1','Stock inicial',NULL,1010,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1011,'1','Stock inicial',NULL,1011,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1012,'1','Stock inicial',NULL,1012,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1013,'1','Stock inicial',NULL,1013,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1014,'1','Stock inicial',NULL,1014,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1015,'1','Stock inicial',NULL,1015,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1016,'1','Stock inicial',NULL,1016,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1017,'1','Stock inicial',NULL,1017,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1018,'1','Stock inicial',NULL,1018,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1019,'1','Stock inicial',NULL,1019,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1020,'1','Stock inicial',NULL,1020,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1021,'1','Stock inicial',NULL,1021,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1022,'1','Stock inicial',NULL,1022,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1023,'1','Stock inicial',NULL,1023,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1024,'1','Stock inicial',NULL,1024,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1025,'1','Stock inicial',NULL,1025,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1026,'1','Stock inicial',NULL,1026,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1027,'1','Stock inicial',NULL,1027,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1028,'1','Stock inicial',NULL,1028,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1029,'1','Stock inicial',NULL,1029,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1030,'1','Stock inicial',NULL,1030,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1031,'1','Stock inicial',NULL,1031,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1032,'1','Stock inicial',NULL,1032,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1033,'1','Stock inicial',NULL,1033,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1034,'1','Stock inicial',NULL,1034,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1035,'1','Stock inicial',NULL,1035,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1036,'1','Stock inicial',NULL,1036,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1037,'1','Stock inicial',NULL,1037,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1038,'1','Stock inicial',NULL,1038,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1039,'1','Stock inicial',NULL,1039,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1040,'1','Stock inicial',NULL,1040,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1041,'1','Stock inicial',NULL,1041,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1042,'1','Stock inicial',NULL,1042,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1043,'1','Stock inicial',NULL,1043,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1044,'1','Stock inicial',NULL,1044,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1045,'1','Stock inicial',NULL,1045,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1046,'1','Stock inicial',NULL,1046,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1047,'1','Stock inicial',NULL,1047,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1048,'1','Stock inicial',NULL,1048,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1049,'1','Stock inicial',NULL,1049,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1050,'1','Stock inicial',NULL,1050,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1051,'1','Stock inicial',NULL,1051,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1052,'1','Stock inicial',NULL,1052,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1053,'1','Stock inicial',NULL,1053,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1054,'1','Stock inicial',NULL,1054,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1055,'1','Stock inicial',NULL,1055,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1056,'1','Stock inicial',NULL,1056,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1057,'1','Stock inicial',NULL,1057,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1058,'1','Stock inicial',NULL,1058,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1059,'1','Stock inicial',NULL,1059,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1060,'1','Stock inicial',NULL,1060,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1061,'1','Stock inicial',NULL,1061,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1062,'1','Stock inicial',NULL,1062,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1063,'1','Stock inicial',NULL,1063,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1064,'1','Stock inicial',NULL,1064,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1065,'1','Stock inicial',NULL,1065,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1066,'1','Stock inicial',NULL,1066,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1067,'1','Stock inicial',NULL,1067,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1068,'1','Stock inicial',NULL,1068,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1069,'1','Stock inicial',NULL,1069,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1070,'1','Stock inicial',NULL,1070,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1071,'1','Stock inicial',NULL,1071,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1072,'1','Stock inicial',NULL,1072,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1073,'1','Stock inicial',NULL,1073,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1074,'1','Stock inicial',NULL,1074,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1075,'1','Stock inicial',NULL,1075,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1076,'1','Stock inicial',NULL,1076,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1077,'1','Stock inicial',NULL,1077,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1078,'1','Stock inicial',NULL,1078,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1079,'1','Stock inicial',NULL,1079,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1080,'1','Stock inicial',NULL,1080,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1081,'1','Stock inicial',NULL,1081,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1082,'1','Stock inicial',NULL,1082,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1083,'1','Stock inicial',NULL,1083,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1084,'1','Stock inicial',NULL,1084,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1085,'1','Stock inicial',NULL,1085,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1086,'1','Stock inicial',NULL,1086,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1087,'1','Stock inicial',NULL,1087,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1088,'1','Stock inicial',NULL,1088,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1089,'1','Stock inicial',NULL,1089,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1090,'1','Stock inicial',NULL,1090,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1091,'1','Stock inicial',NULL,1091,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1092,'1','Stock inicial',NULL,1092,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1093,'1','Stock inicial',NULL,1093,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1094,'1','Stock inicial',NULL,1094,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1095,'1','Stock inicial',NULL,1095,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1096,'1','Stock inicial',NULL,1096,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1097,'1','Stock inicial',NULL,1097,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1098,'1','Stock inicial',NULL,1098,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1099,'1','Stock inicial',NULL,1099,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1100,'1','Stock inicial',NULL,1100,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1101,'1','Stock inicial',NULL,1101,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1102,'1','Stock inicial',NULL,1102,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1103,'1','Stock inicial',NULL,1103,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1104,'1','Stock inicial',NULL,1104,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1105,'1','Stock inicial',NULL,1105,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1106,'1','Stock inicial',NULL,1106,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1107,'1','Stock inicial',NULL,1107,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1108,'1','Stock inicial',NULL,1108,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1109,'1','Stock inicial',NULL,1109,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1110,'1','Stock inicial',NULL,1110,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1111,'1','Stock inicial',NULL,1111,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1112,'1','Stock inicial',NULL,1112,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1113,'1','Stock inicial',NULL,1113,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1114,'1','Stock inicial',NULL,1114,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1115,'1','Stock inicial',NULL,1115,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1116,'1','Stock inicial',NULL,1116,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1117,'1','Stock inicial',NULL,1117,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1118,'1','Stock inicial',NULL,1118,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1119,'1','Stock inicial',NULL,1119,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1120,'1','Stock inicial',NULL,1120,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1121,'1','Stock inicial',NULL,1121,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1122,'1','Stock inicial',NULL,1122,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1123,'1','Stock inicial',NULL,1123,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1124,'1','Stock inicial',NULL,1124,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1125,'1','Stock inicial',NULL,1125,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1126,'1','Stock inicial',NULL,1126,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1127,'1','Stock inicial',NULL,1127,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1128,'1','Stock inicial',NULL,1128,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1129,'1','Stock inicial',NULL,1129,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1130,'1','Stock inicial',NULL,1130,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1131,'1','Stock inicial',NULL,1131,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1132,'1','Stock inicial',NULL,1132,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1133,'1','Stock inicial',NULL,1133,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1134,'1','Stock inicial',NULL,1134,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1135,'1','Stock inicial',NULL,1135,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1136,'1','Stock inicial',NULL,1136,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:29','2024-11-10 18:48:29'),(1137,'1','Stock inicial',NULL,1137,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1138,'1','Stock inicial',NULL,1138,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1139,'1','Stock inicial',NULL,1139,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1140,'1','Stock inicial',NULL,1140,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1141,'1','Stock inicial',NULL,1141,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1142,'1','Stock inicial',NULL,1142,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1143,'1','Stock inicial',NULL,1143,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1144,'1','Stock inicial',NULL,1144,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1145,'1','Stock inicial',NULL,1145,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1146,'1','Stock inicial',NULL,1146,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1147,'1','Stock inicial',NULL,1147,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1148,'1','Stock inicial',NULL,1148,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1149,'1','Stock inicial',NULL,1149,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1150,'1','Stock inicial',NULL,1150,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1151,'1','Stock inicial',NULL,1151,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1152,'1','Stock inicial',NULL,1152,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1153,'1','Stock inicial',NULL,1153,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1154,'1','Stock inicial',NULL,1154,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1155,'1','Stock inicial',NULL,1155,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1156,'1','Stock inicial',NULL,1156,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1157,'1','Stock inicial',NULL,1157,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1158,'1','Stock inicial',NULL,1158,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1159,'1','Stock inicial',NULL,1159,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1160,'1','Stock inicial',NULL,1160,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1161,'1','Stock inicial',NULL,1161,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1162,'1','Stock inicial',NULL,1162,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1163,'1','Stock inicial',NULL,1163,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1164,'1','Stock inicial',NULL,1164,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1165,'1','Stock inicial',NULL,1165,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1166,'1','Stock inicial',NULL,1166,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1167,'1','Stock inicial',NULL,1167,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1168,'1','Stock inicial',NULL,1168,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1169,'1','Stock inicial',NULL,1169,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1170,'1','Stock inicial',NULL,1170,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1171,'1','Stock inicial',NULL,1171,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1172,'1','Stock inicial',NULL,1172,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1173,'1','Stock inicial',NULL,1173,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1174,'1','Stock inicial',NULL,1174,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1175,'1','Stock inicial',NULL,1175,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1176,'1','Stock inicial',NULL,1176,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1177,'1','Stock inicial',NULL,1177,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1178,'1','Stock inicial',NULL,1178,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1179,'1','Stock inicial',NULL,1179,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1180,'1','Stock inicial',NULL,1180,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1181,'1','Stock inicial',NULL,1181,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1182,'1','Stock inicial',NULL,1182,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1183,'1','Stock inicial',NULL,1183,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1184,'1','Stock inicial',NULL,1184,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1185,'1','Stock inicial',NULL,1185,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1186,'1','Stock inicial',NULL,1186,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1187,'1','Stock inicial',NULL,1187,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1188,'1','Stock inicial',NULL,1188,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1189,'1','Stock inicial',NULL,1189,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1190,'1','Stock inicial',NULL,1190,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1191,'1','Stock inicial',NULL,1191,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1192,'1','Stock inicial',NULL,1192,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1193,'1','Stock inicial',NULL,1193,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1194,'1','Stock inicial',NULL,1194,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1195,'1','Stock inicial',NULL,1195,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1196,'1','Stock inicial',NULL,1196,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1197,'1','Stock inicial',NULL,1197,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1198,'1','Stock inicial',NULL,1198,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1199,'1','Stock inicial',NULL,1199,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1200,'1','Stock inicial',NULL,1200,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1201,'1','Stock inicial',NULL,1201,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1202,'1','Stock inicial',NULL,1202,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1203,'1','Stock inicial',NULL,1203,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1204,'1','Stock inicial',NULL,1204,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1205,'1','Stock inicial',NULL,1205,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1206,'1','Stock inicial',NULL,1206,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1207,'1','Stock inicial',NULL,1207,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1208,'1','Stock inicial',NULL,1208,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1209,'1','Stock inicial',NULL,1209,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1210,'1','Stock inicial',NULL,1210,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1211,'1','Stock inicial',NULL,1211,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1212,'1','Stock inicial',NULL,1212,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1213,'1','Stock inicial',NULL,1213,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1214,'1','Stock inicial',NULL,1214,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1215,'1','Stock inicial',NULL,1215,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1216,'1','Stock inicial',NULL,1216,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1217,'1','Stock inicial',NULL,1217,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1218,'1','Stock inicial',NULL,1218,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1219,'1','Stock inicial',NULL,1219,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1220,'1','Stock inicial',NULL,1220,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1221,'1','Stock inicial',NULL,1221,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1222,'1','Stock inicial',NULL,1222,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1223,'1','Stock inicial',NULL,1223,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1224,'1','Stock inicial',NULL,1224,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1225,'1','Stock inicial',NULL,1225,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1226,'1','Stock inicial',NULL,1226,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1227,'1','Stock inicial',NULL,1227,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1228,'1','Stock inicial',NULL,1228,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1229,'1','Stock inicial',NULL,1229,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1230,'1','Stock inicial',NULL,1230,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1231,'1','Stock inicial',NULL,1231,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1232,'1','Stock inicial',NULL,1232,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1233,'1','Stock inicial',NULL,1233,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1234,'1','Stock inicial',NULL,1234,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1235,'1','Stock inicial',NULL,1235,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1236,'1','Stock inicial',NULL,1236,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1237,'1','Stock inicial',NULL,1237,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1238,'1','Stock inicial',NULL,1238,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1239,'1','Stock inicial',NULL,1239,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1240,'1','Stock inicial',NULL,1240,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1241,'1','Stock inicial',NULL,1241,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1242,'1','Stock inicial',NULL,1242,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1243,'1','Stock inicial',NULL,1243,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1244,'1','Stock inicial',NULL,1244,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1245,'1','Stock inicial',NULL,1245,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1246,'1','Stock inicial',NULL,1246,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1247,'1','Stock inicial',NULL,1247,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1248,'1','Stock inicial',NULL,1248,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1249,'1','Stock inicial',NULL,1249,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1250,'1','Stock inicial',NULL,1250,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1251,'1','Stock inicial',NULL,1251,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1252,'1','Stock inicial',NULL,1252,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1253,'1','Stock inicial',NULL,1253,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1254,'1','Stock inicial',NULL,1254,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:30','2024-11-10 18:48:30'),(1255,'1','Stock inicial',NULL,1255,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1256,'1','Stock inicial',NULL,1256,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1257,'1','Stock inicial',NULL,1257,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1258,'1','Stock inicial',NULL,1258,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1259,'1','Stock inicial',NULL,1259,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1260,'1','Stock inicial',NULL,1260,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1261,'1','Stock inicial',NULL,1261,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1262,'1','Stock inicial',NULL,1262,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1263,'1','Stock inicial',NULL,1263,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1264,'1','Stock inicial',NULL,1264,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1265,'1','Stock inicial',NULL,1265,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1266,'1','Stock inicial',NULL,1266,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1267,'1','Stock inicial',NULL,1267,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1268,'1','Stock inicial',NULL,1268,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1269,'1','Stock inicial',NULL,1269,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1270,'1','Stock inicial',NULL,1270,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1271,'1','Stock inicial',NULL,1271,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1272,'1','Stock inicial',NULL,1272,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1273,'1','Stock inicial',NULL,1273,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1274,'1','Stock inicial',NULL,1274,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1275,'1','Stock inicial',NULL,1275,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1276,'1','Stock inicial',NULL,1276,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1277,'1','Stock inicial',NULL,1277,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1278,'1','Stock inicial',NULL,1278,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1279,'1','Stock inicial',NULL,1279,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1280,'1','Stock inicial',NULL,1280,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1281,'1','Stock inicial',NULL,1281,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1282,'1','Stock inicial',NULL,1282,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1283,'1','Stock inicial',NULL,1283,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1284,'1','Stock inicial',NULL,1284,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1285,'1','Stock inicial',NULL,1285,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1286,'1','Stock inicial',NULL,1286,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1287,'1','Stock inicial',NULL,1287,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1288,'1','Stock inicial',NULL,1288,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1289,'1','Stock inicial',NULL,1289,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1290,'1','Stock inicial',NULL,1290,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1291,'1','Stock inicial',NULL,1291,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1292,'1','Stock inicial',NULL,1292,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1293,'1','Stock inicial',NULL,1293,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1294,'1','Stock inicial',NULL,1294,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1295,'1','Stock inicial',NULL,1295,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1296,'1','Stock inicial',NULL,1296,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1297,'1','Stock inicial',NULL,1297,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1298,'1','Stock inicial',NULL,1298,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1299,'1','Stock inicial',NULL,1299,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1300,'1','Stock inicial',NULL,1300,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1301,'1','Stock inicial',NULL,1301,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1302,'1','Stock inicial',NULL,1302,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1303,'1','Stock inicial',NULL,1303,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1304,'1','Stock inicial',NULL,1304,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1305,'1','Stock inicial',NULL,1305,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1306,'1','Stock inicial',NULL,1306,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1307,'1','Stock inicial',NULL,1307,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1308,'1','Stock inicial',NULL,1308,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1309,'1','Stock inicial',NULL,1309,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1310,'1','Stock inicial',NULL,1310,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1311,'1','Stock inicial',NULL,1311,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1312,'1','Stock inicial',NULL,1312,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1313,'1','Stock inicial',NULL,1313,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1314,'1','Stock inicial',NULL,1314,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1315,'1','Stock inicial',NULL,1315,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1316,'1','Stock inicial',NULL,1316,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1317,'1','Stock inicial',NULL,1317,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1318,'1','Stock inicial',NULL,1318,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1319,'1','Stock inicial',NULL,1319,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1320,'1','Stock inicial',NULL,1320,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1321,'1','Stock inicial',NULL,1321,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1322,'1','Stock inicial',NULL,1322,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1323,'1','Stock inicial',NULL,1323,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1324,'1','Stock inicial',NULL,1324,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1325,'1','Stock inicial',NULL,1325,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1326,'1','Stock inicial',NULL,1326,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1327,'1','Stock inicial',NULL,1327,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1328,'1','Stock inicial',NULL,1328,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1329,'1','Stock inicial',NULL,1329,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1330,'1','Stock inicial',NULL,1330,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1331,'1','Stock inicial',NULL,1331,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1332,'1','Stock inicial',NULL,1332,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1333,'1','Stock inicial',NULL,1333,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1334,'1','Stock inicial',NULL,1334,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1335,'1','Stock inicial',NULL,1335,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1336,'1','Stock inicial',NULL,1336,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1337,'1','Stock inicial',NULL,1337,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1338,'1','Stock inicial',NULL,1338,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1339,'1','Stock inicial',NULL,1339,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1340,'1','Stock inicial',NULL,1340,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1341,'1','Stock inicial',NULL,1341,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1342,'1','Stock inicial',NULL,1342,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1343,'1','Stock inicial',NULL,1343,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1344,'1','Stock inicial',NULL,1344,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1345,'1','Stock inicial',NULL,1345,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1346,'1','Stock inicial',NULL,1346,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1347,'1','Stock inicial',NULL,1347,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1348,'1','Stock inicial',NULL,1348,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1349,'1','Stock inicial',NULL,1349,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1350,'1','Stock inicial',NULL,1350,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1351,'1','Stock inicial',NULL,1351,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1352,'1','Stock inicial',NULL,1352,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1353,'1','Stock inicial',NULL,1353,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1354,'1','Stock inicial',NULL,1354,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1355,'1','Stock inicial',NULL,1355,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1356,'1','Stock inicial',NULL,1356,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1357,'1','Stock inicial',NULL,1357,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1358,'1','Stock inicial',NULL,1358,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1359,'1','Stock inicial',NULL,1359,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1360,'1','Stock inicial',NULL,1360,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1361,'1','Stock inicial',NULL,1361,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1362,'1','Stock inicial',NULL,1362,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1363,'1','Stock inicial',NULL,1363,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1364,'1','Stock inicial',NULL,1364,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1365,'1','Stock inicial',NULL,1365,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1366,'1','Stock inicial',NULL,1366,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1367,'1','Stock inicial',NULL,1367,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1368,'1','Stock inicial',NULL,1368,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1369,'1','Stock inicial',NULL,1369,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1370,'1','Stock inicial',NULL,1370,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1371,'1','Stock inicial',NULL,1371,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1372,'1','Stock inicial',NULL,1372,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1373,'1','Stock inicial',NULL,1373,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1374,'1','Stock inicial',NULL,1374,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1375,'1','Stock inicial',NULL,1375,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1376,'1','Stock inicial',NULL,1376,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1377,'1','Stock inicial',NULL,1377,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1378,'1','Stock inicial',NULL,1378,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1379,'1','Stock inicial',NULL,1379,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:31','2024-11-10 18:48:31'),(1380,'1','Stock inicial',NULL,1380,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1381,'1','Stock inicial',NULL,1381,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1382,'1','Stock inicial',NULL,1382,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1383,'1','Stock inicial',NULL,1383,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1384,'1','Stock inicial',NULL,1384,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1385,'1','Stock inicial',NULL,1385,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1386,'1','Stock inicial',NULL,1386,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1387,'1','Stock inicial',NULL,1387,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1388,'1','Stock inicial',NULL,1388,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1389,'1','Stock inicial',NULL,1389,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1390,'1','Stock inicial',NULL,1390,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1391,'1','Stock inicial',NULL,1391,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1392,'1','Stock inicial',NULL,1392,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1393,'1','Stock inicial',NULL,1393,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1394,'1','Stock inicial',NULL,1394,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1395,'1','Stock inicial',NULL,1395,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1396,'1','Stock inicial',NULL,1396,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1397,'1','Stock inicial',NULL,1397,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1398,'1','Stock inicial',NULL,1398,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1399,'1','Stock inicial',NULL,1399,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1400,'1','Stock inicial',NULL,1400,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1401,'1','Stock inicial',NULL,1401,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1402,'1','Stock inicial',NULL,1402,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1403,'1','Stock inicial',NULL,1403,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1404,'1','Stock inicial',NULL,1404,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1405,'1','Stock inicial',NULL,1405,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1406,'1','Stock inicial',NULL,1406,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1407,'1','Stock inicial',NULL,1407,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1408,'1','Stock inicial',NULL,1408,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1409,'1','Stock inicial',NULL,1409,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1410,'1','Stock inicial',NULL,1410,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1411,'1','Stock inicial',NULL,1411,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1412,'1','Stock inicial',NULL,1412,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1413,'1','Stock inicial',NULL,1413,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1414,'1','Stock inicial',NULL,1414,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1415,'1','Stock inicial',NULL,1415,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1416,'1','Stock inicial',NULL,1416,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1417,'1','Stock inicial',NULL,1417,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1418,'1','Stock inicial',NULL,1418,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1419,'1','Stock inicial',NULL,1419,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1420,'1','Stock inicial',NULL,1420,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1421,'1','Stock inicial',NULL,1421,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1422,'1','Stock inicial',NULL,1422,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1423,'1','Stock inicial',NULL,1423,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1424,'1','Stock inicial',NULL,1424,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1425,'1','Stock inicial',NULL,1425,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1426,'1','Stock inicial',NULL,1426,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1427,'1','Stock inicial',NULL,1427,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1428,'1','Stock inicial',NULL,1428,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1429,'1','Stock inicial',NULL,1429,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1430,'1','Stock inicial',NULL,1430,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1431,'1','Stock inicial',NULL,1431,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1432,'1','Stock inicial',NULL,1432,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1433,'1','Stock inicial',NULL,1433,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1434,'1','Stock inicial',NULL,1434,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1435,'1','Stock inicial',NULL,1435,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1436,'1','Stock inicial',NULL,1436,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1437,'1','Stock inicial',NULL,1437,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1438,'1','Stock inicial',NULL,1438,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1439,'1','Stock inicial',NULL,1439,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1440,'1','Stock inicial',NULL,1440,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1441,'1','Stock inicial',NULL,1441,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1442,'1','Stock inicial',NULL,1442,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1443,'1','Stock inicial',NULL,1443,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1444,'1','Stock inicial',NULL,1444,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1445,'1','Stock inicial',NULL,1445,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1446,'1','Stock inicial',NULL,1446,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1447,'1','Stock inicial',NULL,1447,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1448,'1','Stock inicial',NULL,1448,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1449,'1','Stock inicial',NULL,1449,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1450,'1','Stock inicial',NULL,1450,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1451,'1','Stock inicial',NULL,1451,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1452,'1','Stock inicial',NULL,1452,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1453,'1','Stock inicial',NULL,1453,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1454,'1','Stock inicial',NULL,1454,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1455,'1','Stock inicial',NULL,1455,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1456,'1','Stock inicial',NULL,1456,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1457,'1','Stock inicial',NULL,1457,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1458,'1','Stock inicial',NULL,1458,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1459,'1','Stock inicial',NULL,1459,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1460,'1','Stock inicial',NULL,1460,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1461,'1','Stock inicial',NULL,1461,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1462,'1','Stock inicial',NULL,1462,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1463,'1','Stock inicial',NULL,1463,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1464,'1','Stock inicial',NULL,1464,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1465,'1','Stock inicial',NULL,1465,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1466,'1','Stock inicial',NULL,1466,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1467,'1','Stock inicial',NULL,1467,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1468,'1','Stock inicial',NULL,1468,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1469,'1','Stock inicial',NULL,1469,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1470,'1','Stock inicial',NULL,1470,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1471,'1','Stock inicial',NULL,1471,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1472,'1','Stock inicial',NULL,1472,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1473,'1','Stock inicial',NULL,1473,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1474,'1','Stock inicial',NULL,1474,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1475,'1','Stock inicial',NULL,1475,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1476,'1','Stock inicial',NULL,1476,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1477,'1','Stock inicial',NULL,1477,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1478,'1','Stock inicial',NULL,1478,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1479,'1','Stock inicial',NULL,1479,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1480,'1','Stock inicial',NULL,1480,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1481,'1','Stock inicial',NULL,1481,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1482,'1','Stock inicial',NULL,1482,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1483,'1','Stock inicial',NULL,1483,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1484,'1','Stock inicial',NULL,1484,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1485,'1','Stock inicial',NULL,1485,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1486,'1','Stock inicial',NULL,1486,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1487,'1','Stock inicial',NULL,1487,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1488,'1','Stock inicial',NULL,1488,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1489,'1','Stock inicial',NULL,1489,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1490,'1','Stock inicial',NULL,1490,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1491,'1','Stock inicial',NULL,1491,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1492,'1','Stock inicial',NULL,1492,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1493,'1','Stock inicial',NULL,1493,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1494,'1','Stock inicial',NULL,1494,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1495,'1','Stock inicial',NULL,1495,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:32','2024-11-10 18:48:32'),(1496,'1','Stock inicial',NULL,1496,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1497,'1','Stock inicial',NULL,1497,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1498,'1','Stock inicial',NULL,1498,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1499,'1','Stock inicial',NULL,1499,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1500,'1','Stock inicial',NULL,1500,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1501,'1','Stock inicial',NULL,1501,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1502,'1','Stock inicial',NULL,1502,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1503,'1','Stock inicial',NULL,1503,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1504,'1','Stock inicial',NULL,1504,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1505,'1','Stock inicial',NULL,1505,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1506,'1','Stock inicial',NULL,1506,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1507,'1','Stock inicial',NULL,1507,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1508,'1','Stock inicial',NULL,1508,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1509,'1','Stock inicial',NULL,1509,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1510,'1','Stock inicial',NULL,1510,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1511,'1','Stock inicial',NULL,1511,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1512,'1','Stock inicial',NULL,1512,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1513,'1','Stock inicial',NULL,1513,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1514,'1','Stock inicial',NULL,1514,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1515,'1','Stock inicial',NULL,1515,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1516,'1','Stock inicial',NULL,1516,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1517,'1','Stock inicial',NULL,1517,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1518,'1','Stock inicial',NULL,1518,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1519,'1','Stock inicial',NULL,1519,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1520,'1','Stock inicial',NULL,1520,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1521,'1','Stock inicial',NULL,1521,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1522,'1','Stock inicial',NULL,1522,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1523,'1','Stock inicial',NULL,1523,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1524,'1','Stock inicial',NULL,1524,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1525,'1','Stock inicial',NULL,1525,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1526,'1','Stock inicial',NULL,1526,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1527,'1','Stock inicial',NULL,1527,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1528,'1','Stock inicial',NULL,1528,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1529,'1','Stock inicial',NULL,1529,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1530,'1','Stock inicial',NULL,1530,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1531,'1','Stock inicial',NULL,1531,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1532,'1','Stock inicial',NULL,1532,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1533,'1','Stock inicial',NULL,1533,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1534,'1','Stock inicial',NULL,1534,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1535,'1','Stock inicial',NULL,1535,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1536,'1','Stock inicial',NULL,1536,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1537,'1','Stock inicial',NULL,1537,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1538,'1','Stock inicial',NULL,1538,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1539,'1','Stock inicial',NULL,1539,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1540,'1','Stock inicial',NULL,1540,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1541,'1','Stock inicial',NULL,1541,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1542,'1','Stock inicial',NULL,1542,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1543,'1','Stock inicial',NULL,1543,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1544,'1','Stock inicial',NULL,1544,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1545,'1','Stock inicial',NULL,1545,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1546,'1','Stock inicial',NULL,1546,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1547,'1','Stock inicial',NULL,1547,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1548,'1','Stock inicial',NULL,1548,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1549,'1','Stock inicial',NULL,1549,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1550,'1','Stock inicial',NULL,1550,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1551,'1','Stock inicial',NULL,1551,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1552,'1','Stock inicial',NULL,1552,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1553,'1','Stock inicial',NULL,1553,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1554,'1','Stock inicial',NULL,1554,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1555,'1','Stock inicial',NULL,1555,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1556,'1','Stock inicial',NULL,1556,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1557,'1','Stock inicial',NULL,1557,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1558,'1','Stock inicial',NULL,1558,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1559,'1','Stock inicial',NULL,1559,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1560,'1','Stock inicial',NULL,1560,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1561,'1','Stock inicial',NULL,1561,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1562,'1','Stock inicial',NULL,1562,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1563,'1','Stock inicial',NULL,1563,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1564,'1','Stock inicial',NULL,1564,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1565,'1','Stock inicial',NULL,1565,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1566,'1','Stock inicial',NULL,1566,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1567,'1','Stock inicial',NULL,1567,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1568,'1','Stock inicial',NULL,1568,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1569,'1','Stock inicial',NULL,1569,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1570,'1','Stock inicial',NULL,1570,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1571,'1','Stock inicial',NULL,1571,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1572,'1','Stock inicial',NULL,1572,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1573,'1','Stock inicial',NULL,1573,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1574,'1','Stock inicial',NULL,1574,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1575,'1','Stock inicial',NULL,1575,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1576,'1','Stock inicial',NULL,1576,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1577,'1','Stock inicial',NULL,1577,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1578,'1','Stock inicial',NULL,1578,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1579,'1','Stock inicial',NULL,1579,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1580,'1','Stock inicial',NULL,1580,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1581,'1','Stock inicial',NULL,1581,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1582,'1','Stock inicial',NULL,1582,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1583,'1','Stock inicial',NULL,1583,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1584,'1','Stock inicial',NULL,1584,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1585,'1','Stock inicial',NULL,1585,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1586,'1','Stock inicial',NULL,1586,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1587,'1','Stock inicial',NULL,1587,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1588,'1','Stock inicial',NULL,1588,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1589,'1','Stock inicial',NULL,1589,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1590,'1','Stock inicial',NULL,1590,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1591,'1','Stock inicial',NULL,1591,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1592,'1','Stock inicial',NULL,1592,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1593,'1','Stock inicial',NULL,1593,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1594,'1','Stock inicial',NULL,1594,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1595,'1','Stock inicial',NULL,1595,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1596,'1','Stock inicial',NULL,1596,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1597,'1','Stock inicial',NULL,1597,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1598,'1','Stock inicial',NULL,1598,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1599,'1','Stock inicial',NULL,1599,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1600,'1','Stock inicial',NULL,1600,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1601,'1','Stock inicial',NULL,1601,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1602,'1','Stock inicial',NULL,1602,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1603,'1','Stock inicial',NULL,1603,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1604,'1','Stock inicial',NULL,1604,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1605,'1','Stock inicial',NULL,1605,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1606,'1','Stock inicial',NULL,1606,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1607,'1','Stock inicial',NULL,1607,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1608,'1','Stock inicial',NULL,1608,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1609,'1','Stock inicial',NULL,1609,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1610,'1','Stock inicial',NULL,1610,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1611,'1','Stock inicial',NULL,1611,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1612,'1','Stock inicial',NULL,1612,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1613,'1','Stock inicial',NULL,1613,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1614,'1','Stock inicial',NULL,1614,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1615,'1','Stock inicial',NULL,1615,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1616,'1','Stock inicial',NULL,1616,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1617,'1','Stock inicial',NULL,1617,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1618,'1','Stock inicial',NULL,1618,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1619,'1','Stock inicial',NULL,1619,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:33','2024-11-10 18:48:33'),(1620,'1','Stock inicial',NULL,1620,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1621,'1','Stock inicial',NULL,1621,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1622,'1','Stock inicial',NULL,1622,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1623,'1','Stock inicial',NULL,1623,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1624,'1','Stock inicial',NULL,1624,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1625,'1','Stock inicial',NULL,1625,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1626,'1','Stock inicial',NULL,1626,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1627,'1','Stock inicial',NULL,1627,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1628,'1','Stock inicial',NULL,1628,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1629,'1','Stock inicial',NULL,1629,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1630,'1','Stock inicial',NULL,1630,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1631,'1','Stock inicial',NULL,1631,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1632,'1','Stock inicial',NULL,1632,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1633,'1','Stock inicial',NULL,1633,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1634,'1','Stock inicial',NULL,1634,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1635,'1','Stock inicial',NULL,1635,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1636,'1','Stock inicial',NULL,1636,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1637,'1','Stock inicial',NULL,1637,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1638,'1','Stock inicial',NULL,1638,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1639,'1','Stock inicial',NULL,1639,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1640,'1','Stock inicial',NULL,1640,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1641,'1','Stock inicial',NULL,1641,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1642,'1','Stock inicial',NULL,1642,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1643,'1','Stock inicial',NULL,1643,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1644,'1','Stock inicial',NULL,1644,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1645,'1','Stock inicial',NULL,1645,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1646,'1','Stock inicial',NULL,1646,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1647,'1','Stock inicial',NULL,1647,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1648,'1','Stock inicial',NULL,1648,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1649,'1','Stock inicial',NULL,1649,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1650,'1','Stock inicial',NULL,1650,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1651,'1','Stock inicial',NULL,1651,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1652,'1','Stock inicial',NULL,1652,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1653,'1','Stock inicial',NULL,1653,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1654,'1','Stock inicial',NULL,1654,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1655,'1','Stock inicial',NULL,1655,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1656,'1','Stock inicial',NULL,1656,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1657,'1','Stock inicial',NULL,1657,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1658,'1','Stock inicial',NULL,1658,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1659,'1','Stock inicial',NULL,1659,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1660,'1','Stock inicial',NULL,1660,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1661,'1','Stock inicial',NULL,1661,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1662,'1','Stock inicial',NULL,1662,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1663,'1','Stock inicial',NULL,1663,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1664,'1','Stock inicial',NULL,1664,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1665,'1','Stock inicial',NULL,1665,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1666,'1','Stock inicial',NULL,1666,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1667,'1','Stock inicial',NULL,1667,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1668,'1','Stock inicial',NULL,1668,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1669,'1','Stock inicial',NULL,1669,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1670,'1','Stock inicial',NULL,1670,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1671,'1','Stock inicial',NULL,1671,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1672,'1','Stock inicial',NULL,1672,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1673,'1','Stock inicial',NULL,1673,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1674,'1','Stock inicial',NULL,1674,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1675,'1','Stock inicial',NULL,1675,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1676,'1','Stock inicial',NULL,1676,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1677,'1','Stock inicial',NULL,1677,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1678,'1','Stock inicial',NULL,1678,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1679,'1','Stock inicial',NULL,1679,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1680,'1','Stock inicial',NULL,1680,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1681,'1','Stock inicial',NULL,1681,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1682,'1','Stock inicial',NULL,1682,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1683,'1','Stock inicial',NULL,1683,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1684,'1','Stock inicial',NULL,1684,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1685,'1','Stock inicial',NULL,1685,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1686,'1','Stock inicial',NULL,1686,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1687,'1','Stock inicial',NULL,1687,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1688,'1','Stock inicial',NULL,1688,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1689,'1','Stock inicial',NULL,1689,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1690,'1','Stock inicial',NULL,1690,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1691,'1','Stock inicial',NULL,1691,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1692,'1','Stock inicial',NULL,1692,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1693,'1','Stock inicial',NULL,1693,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1694,'1','Stock inicial',NULL,1694,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1695,'1','Stock inicial',NULL,1695,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1696,'1','Stock inicial',NULL,1696,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1697,'1','Stock inicial',NULL,1697,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1698,'1','Stock inicial',NULL,1698,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1699,'1','Stock inicial',NULL,1699,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1700,'1','Stock inicial',NULL,1700,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1701,'1','Stock inicial',NULL,1701,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1702,'1','Stock inicial',NULL,1702,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1703,'1','Stock inicial',NULL,1703,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1704,'1','Stock inicial',NULL,1704,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1705,'1','Stock inicial',NULL,1705,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1706,'1','Stock inicial',NULL,1706,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1707,'1','Stock inicial',NULL,1707,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1708,'1','Stock inicial',NULL,1708,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1709,'1','Stock inicial',NULL,1709,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1710,'1','Stock inicial',NULL,1710,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1711,'1','Stock inicial',NULL,1711,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1712,'1','Stock inicial',NULL,1712,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1713,'1','Stock inicial',NULL,1713,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1714,'1','Stock inicial',NULL,1714,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1715,'1','Stock inicial',NULL,1715,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1716,'1','Stock inicial',NULL,1716,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1717,'1','Stock inicial',NULL,1717,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1718,'1','Stock inicial',NULL,1718,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1719,'1','Stock inicial',NULL,1719,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1720,'1','Stock inicial',NULL,1720,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1721,'1','Stock inicial',NULL,1721,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1722,'1','Stock inicial',NULL,1722,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1723,'1','Stock inicial',NULL,1723,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1724,'1','Stock inicial',NULL,1724,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1725,'1','Stock inicial',NULL,1725,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1726,'1','Stock inicial',NULL,1726,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1727,'1','Stock inicial',NULL,1727,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1728,'1','Stock inicial',NULL,1728,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1729,'1','Stock inicial',NULL,1729,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1730,'1','Stock inicial',NULL,1730,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1731,'1','Stock inicial',NULL,1731,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1732,'1','Stock inicial',NULL,1732,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:34','2024-11-10 18:48:34'),(1733,'1','Stock inicial',NULL,1733,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1734,'1','Stock inicial',NULL,1734,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1735,'1','Stock inicial',NULL,1735,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1736,'1','Stock inicial',NULL,1736,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1737,'1','Stock inicial',NULL,1737,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1738,'1','Stock inicial',NULL,1738,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1739,'1','Stock inicial',NULL,1739,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1740,'1','Stock inicial',NULL,1740,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1741,'1','Stock inicial',NULL,1741,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1742,'1','Stock inicial',NULL,1742,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1743,'1','Stock inicial',NULL,1743,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1744,'1','Stock inicial',NULL,1744,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1745,'1','Stock inicial',NULL,1745,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1746,'1','Stock inicial',NULL,1746,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1747,'1','Stock inicial',NULL,1747,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1748,'1','Stock inicial',NULL,1748,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1749,'1','Stock inicial',NULL,1749,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1750,'1','Stock inicial',NULL,1750,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1751,'1','Stock inicial',NULL,1751,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1752,'1','Stock inicial',NULL,1752,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1753,'1','Stock inicial',NULL,1753,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1754,'1','Stock inicial',NULL,1754,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1755,'1','Stock inicial',NULL,1755,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1756,'1','Stock inicial',NULL,1756,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1757,'1','Stock inicial',NULL,1757,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1758,'1','Stock inicial',NULL,1758,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1759,'1','Stock inicial',NULL,1759,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1760,'1','Stock inicial',NULL,1760,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1761,'1','Stock inicial',NULL,1761,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1762,'1','Stock inicial',NULL,1762,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1763,'1','Stock inicial',NULL,1763,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1764,'1','Stock inicial',NULL,1764,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1765,'1','Stock inicial',NULL,1765,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1766,'1','Stock inicial',NULL,1766,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1767,'1','Stock inicial',NULL,1767,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1768,'1','Stock inicial',NULL,1768,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1769,'1','Stock inicial',NULL,1769,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1770,'1','Stock inicial',NULL,1770,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1771,'1','Stock inicial',NULL,1771,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1772,'1','Stock inicial',NULL,1772,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1773,'1','Stock inicial',NULL,1773,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1774,'1','Stock inicial',NULL,1774,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1775,'1','Stock inicial',NULL,1775,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1776,'1','Stock inicial',NULL,1776,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1777,'1','Stock inicial',NULL,1777,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1778,'1','Stock inicial',NULL,1778,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1779,'1','Stock inicial',NULL,1779,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1780,'1','Stock inicial',NULL,1780,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1781,'1','Stock inicial',NULL,1781,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1782,'1','Stock inicial',NULL,1782,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1783,'1','Stock inicial',NULL,1783,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1784,'1','Stock inicial',NULL,1784,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1785,'1','Stock inicial',NULL,1785,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1786,'1','Stock inicial',NULL,1786,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1787,'1','Stock inicial',NULL,1787,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1788,'1','Stock inicial',NULL,1788,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1789,'1','Stock inicial',NULL,1789,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1790,'1','Stock inicial',NULL,1790,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1791,'1','Stock inicial',NULL,1791,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1792,'1','Stock inicial',NULL,1792,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1793,'1','Stock inicial',NULL,1793,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1794,'1','Stock inicial',NULL,1794,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1795,'1','Stock inicial',NULL,1795,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1796,'1','Stock inicial',NULL,1796,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1797,'1','Stock inicial',NULL,1797,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1798,'1','Stock inicial',NULL,1798,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1799,'1','Stock inicial',NULL,1799,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1800,'1','Stock inicial',NULL,1800,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1801,'1','Stock inicial',NULL,1801,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1802,'1','Stock inicial',NULL,1802,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1803,'1','Stock inicial',NULL,1803,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1804,'1','Stock inicial',NULL,1804,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1805,'1','Stock inicial',NULL,1805,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1806,'1','Stock inicial',NULL,1806,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1807,'1','Stock inicial',NULL,1807,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1808,'1','Stock inicial',NULL,1808,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1809,'1','Stock inicial',NULL,1809,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1810,'1','Stock inicial',NULL,1810,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1811,'1','Stock inicial',NULL,1811,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1812,'1','Stock inicial',NULL,1812,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1813,'1','Stock inicial',NULL,1813,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1814,'1','Stock inicial',NULL,1814,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1815,'1','Stock inicial',NULL,1815,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1816,'1','Stock inicial',NULL,1816,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1817,'1','Stock inicial',NULL,1817,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1818,'1','Stock inicial',NULL,1818,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1819,'1','Stock inicial',NULL,1819,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1820,'1','Stock inicial',NULL,1820,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1821,'1','Stock inicial',NULL,1821,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1822,'1','Stock inicial',NULL,1822,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1823,'1','Stock inicial',NULL,1823,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1824,'1','Stock inicial',NULL,1824,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1825,'1','Stock inicial',NULL,1825,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1826,'1','Stock inicial',NULL,1826,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1827,'1','Stock inicial',NULL,1827,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1828,'1','Stock inicial',NULL,1828,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1829,'1','Stock inicial',NULL,1829,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1830,'1','Stock inicial',NULL,1830,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1831,'1','Stock inicial',NULL,1831,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1832,'1','Stock inicial',NULL,1832,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1833,'1','Stock inicial',NULL,1833,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1834,'1','Stock inicial',NULL,1834,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1835,'1','Stock inicial',NULL,1835,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1836,'1','Stock inicial',NULL,1836,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1837,'1','Stock inicial',NULL,1837,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1838,'1','Stock inicial',NULL,1838,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1839,'1','Stock inicial',NULL,1839,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1840,'1','Stock inicial',NULL,1840,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1841,'1','Stock inicial',NULL,1841,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1842,'1','Stock inicial',NULL,1842,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1843,'1','Stock inicial',NULL,1843,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1844,'1','Stock inicial',NULL,1844,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1845,'1','Stock inicial',NULL,1845,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1846,'1','Stock inicial',NULL,1846,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1847,'1','Stock inicial',NULL,1847,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1848,'1','Stock inicial',NULL,1848,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1849,'1','Stock inicial',NULL,1849,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1850,'1','Stock inicial',NULL,1850,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1851,'1','Stock inicial',NULL,1851,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:35','2024-11-10 18:48:35'),(1852,'1','Stock inicial',NULL,1852,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1853,'1','Stock inicial',NULL,1853,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1854,'1','Stock inicial',NULL,1854,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1855,'1','Stock inicial',NULL,1855,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1856,'1','Stock inicial',NULL,1856,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1857,'1','Stock inicial',NULL,1857,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1858,'1','Stock inicial',NULL,1858,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1859,'1','Stock inicial',NULL,1859,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1860,'1','Stock inicial',NULL,1860,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1861,'1','Stock inicial',NULL,1861,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1862,'1','Stock inicial',NULL,1862,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1863,'1','Stock inicial',NULL,1863,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1864,'1','Stock inicial',NULL,1864,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1865,'1','Stock inicial',NULL,1865,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1866,'1','Stock inicial',NULL,1866,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1867,'1','Stock inicial',NULL,1867,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1868,'1','Stock inicial',NULL,1868,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1869,'1','Stock inicial',NULL,1869,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1870,'1','Stock inicial',NULL,1870,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1871,'1','Stock inicial',NULL,1871,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1872,'1','Stock inicial',NULL,1872,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1873,'1','Stock inicial',NULL,1873,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1874,'1','Stock inicial',NULL,1874,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1875,'1','Stock inicial',NULL,1875,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1876,'1','Stock inicial',NULL,1876,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1877,'1','Stock inicial',NULL,1877,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1878,'1','Stock inicial',NULL,1878,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1879,'1','Stock inicial',NULL,1879,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1880,'1','Stock inicial',NULL,1880,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1881,'1','Stock inicial',NULL,1881,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1882,'1','Stock inicial',NULL,1882,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1883,'1','Stock inicial',NULL,1883,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1884,'1','Stock inicial',NULL,1884,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1885,'1','Stock inicial',NULL,1885,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1886,'1','Stock inicial',NULL,1886,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1887,'1','Stock inicial',NULL,1887,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1888,'1','Stock inicial',NULL,1888,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1889,'1','Stock inicial',NULL,1889,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1890,'1','Stock inicial',NULL,1890,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1891,'1','Stock inicial',NULL,1891,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1892,'1','Stock inicial',NULL,1892,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1893,'1','Stock inicial',NULL,1893,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1894,'1','Stock inicial',NULL,1894,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1895,'1','Stock inicial',NULL,1895,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1896,'1','Stock inicial',NULL,1896,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1897,'1','Stock inicial',NULL,1897,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1898,'1','Stock inicial',NULL,1898,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1899,'1','Stock inicial',NULL,1899,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1900,'1','Stock inicial',NULL,1900,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1901,'1','Stock inicial',NULL,1901,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1902,'1','Stock inicial',NULL,1902,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1903,'1','Stock inicial',NULL,1903,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1904,'1','Stock inicial',NULL,1904,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1905,'1','Stock inicial',NULL,1905,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1906,'1','Stock inicial',NULL,1906,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1907,'1','Stock inicial',NULL,1907,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1908,'1','Stock inicial',NULL,1908,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1909,'1','Stock inicial',NULL,1909,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1910,'1','Stock inicial',NULL,1910,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1911,'1','Stock inicial',NULL,1911,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1912,'1','Stock inicial',NULL,1912,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1913,'1','Stock inicial',NULL,1913,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1914,'1','Stock inicial',NULL,1914,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1915,'1','Stock inicial',NULL,1915,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1916,'1','Stock inicial',NULL,1916,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1917,'1','Stock inicial',NULL,1917,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1918,'1','Stock inicial',NULL,1918,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1919,'1','Stock inicial',NULL,1919,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1920,'1','Stock inicial',NULL,1920,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1921,'1','Stock inicial',NULL,1921,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1922,'1','Stock inicial',NULL,1922,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1923,'1','Stock inicial',NULL,1923,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1924,'1','Stock inicial',NULL,1924,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1925,'1','Stock inicial',NULL,1925,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1926,'1','Stock inicial',NULL,1926,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1927,'1','Stock inicial',NULL,1927,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1928,'1','Stock inicial',NULL,1928,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1929,'1','Stock inicial',NULL,1929,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1930,'1','Stock inicial',NULL,1930,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1931,'1','Stock inicial',NULL,1931,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1932,'1','Stock inicial',NULL,1932,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1933,'1','Stock inicial',NULL,1933,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1934,'1','Stock inicial',NULL,1934,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1935,'1','Stock inicial',NULL,1935,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1936,'1','Stock inicial',NULL,1936,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1937,'1','Stock inicial',NULL,1937,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1938,'1','Stock inicial',NULL,1938,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1939,'1','Stock inicial',NULL,1939,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1940,'1','Stock inicial',NULL,1940,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1941,'1','Stock inicial',NULL,1941,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1942,'1','Stock inicial',NULL,1942,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1943,'1','Stock inicial',NULL,1943,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1944,'1','Stock inicial',NULL,1944,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1945,'1','Stock inicial',NULL,1945,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1946,'1','Stock inicial',NULL,1946,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1947,'1','Stock inicial',NULL,1947,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1948,'1','Stock inicial',NULL,1948,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1949,'1','Stock inicial',NULL,1949,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1950,'1','Stock inicial',NULL,1950,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1951,'1','Stock inicial',NULL,1951,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1952,'1','Stock inicial',NULL,1952,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1953,'1','Stock inicial',NULL,1953,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1954,'1','Stock inicial',NULL,1954,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1955,'1','Stock inicial',NULL,1955,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1956,'1','Stock inicial',NULL,1956,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1957,'1','Stock inicial',NULL,1957,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1958,'1','Stock inicial',NULL,1958,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1959,'1','Stock inicial',NULL,1959,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1960,'1','Stock inicial',NULL,1960,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1961,'1','Stock inicial',NULL,1961,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1962,'1','Stock inicial',NULL,1962,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1963,'1','Stock inicial',NULL,1963,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1964,'1','Stock inicial',NULL,1964,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1965,'1','Stock inicial',NULL,1965,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1966,'1','Stock inicial',NULL,1966,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1967,'1','Stock inicial',NULL,1967,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1968,'1','Stock inicial',NULL,1968,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1969,'1','Stock inicial',NULL,1969,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1970,'1','Stock inicial',NULL,1970,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1971,'1','Stock inicial',NULL,1971,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1972,'1','Stock inicial',NULL,1972,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1973,'1','Stock inicial',NULL,1973,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1974,'1','Stock inicial',NULL,1974,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1975,'1','Stock inicial',NULL,1975,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:36','2024-11-10 18:48:36'),(1976,'1','Stock inicial',NULL,1976,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1977,'1','Stock inicial',NULL,1977,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1978,'1','Stock inicial',NULL,1978,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1979,'1','Stock inicial',NULL,1979,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1980,'1','Stock inicial',NULL,1980,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1981,'1','Stock inicial',NULL,1981,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1982,'1','Stock inicial',NULL,1982,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1983,'1','Stock inicial',NULL,1983,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1984,'1','Stock inicial',NULL,1984,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1985,'1','Stock inicial',NULL,1985,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1986,'1','Stock inicial',NULL,1986,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1987,'1','Stock inicial',NULL,1987,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1988,'1','Stock inicial',NULL,1988,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1989,'1','Stock inicial',NULL,1989,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1990,'1','Stock inicial',NULL,1990,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1991,'1','Stock inicial',NULL,1991,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1992,'1','Stock inicial',NULL,1992,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1993,'1','Stock inicial',NULL,1993,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1994,'1','Stock inicial',NULL,1994,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1995,'1','Stock inicial',NULL,1995,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1996,'1','Stock inicial',NULL,1996,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1997,'1','Stock inicial',NULL,1997,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1998,'1','Stock inicial',NULL,1998,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(1999,'1','Stock inicial',NULL,1999,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2000,'1','Stock inicial',NULL,2000,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2001,'1','Stock inicial',NULL,2001,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2002,'1','Stock inicial',NULL,2002,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2003,'1','Stock inicial',NULL,2003,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2004,'1','Stock inicial',NULL,2004,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2005,'1','Stock inicial',NULL,2005,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2006,'1','Stock inicial',NULL,2006,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2007,'1','Stock inicial',NULL,2007,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2008,'1','Stock inicial',NULL,2008,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2009,'1','Stock inicial',NULL,2009,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2010,'1','Stock inicial',NULL,2010,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2011,'1','Stock inicial',NULL,2011,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2012,'1','Stock inicial',NULL,2012,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2013,'1','Stock inicial',NULL,2013,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2014,'1','Stock inicial',NULL,2014,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2015,'1','Stock inicial',NULL,2015,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2016,'1','Stock inicial',NULL,2016,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2017,'1','Stock inicial',NULL,2017,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2018,'1','Stock inicial',NULL,2018,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2019,'1','Stock inicial',NULL,2019,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2020,'1','Stock inicial',NULL,2020,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2021,'1','Stock inicial',NULL,2021,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2022,'1','Stock inicial',NULL,2022,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2023,'1','Stock inicial',NULL,2023,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2024,'1','Stock inicial',NULL,2024,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2025,'1','Stock inicial',NULL,2025,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2026,'1','Stock inicial',NULL,2026,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2027,'1','Stock inicial',NULL,2027,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2028,'1','Stock inicial',NULL,2028,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2029,'1','Stock inicial',NULL,2029,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2030,'1','Stock inicial',NULL,2030,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2031,'1','Stock inicial',NULL,2031,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2032,'1','Stock inicial',NULL,2032,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2033,'1','Stock inicial',NULL,2033,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2034,'1','Stock inicial',NULL,2034,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2035,'1','Stock inicial',NULL,2035,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2036,'1','Stock inicial',NULL,2036,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2037,'1','Stock inicial',NULL,2037,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2038,'1','Stock inicial',NULL,2038,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2039,'1','Stock inicial',NULL,2039,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2040,'1','Stock inicial',NULL,2040,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2041,'1','Stock inicial',NULL,2041,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2042,'1','Stock inicial',NULL,2042,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2043,'1','Stock inicial',NULL,2043,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2044,'1','Stock inicial',NULL,2044,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2045,'1','Stock inicial',NULL,2045,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2046,'1','Stock inicial',NULL,2046,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2047,'1','Stock inicial',NULL,2047,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2048,'1','Stock inicial',NULL,2048,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2049,'1','Stock inicial',NULL,2049,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2050,'1','Stock inicial',NULL,2050,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2051,'1','Stock inicial',NULL,2051,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2052,'1','Stock inicial',NULL,2052,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2053,'1','Stock inicial',NULL,2053,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2054,'1','Stock inicial',NULL,2054,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2055,'1','Stock inicial',NULL,2055,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2056,'1','Stock inicial',NULL,2056,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2057,'1','Stock inicial',NULL,2057,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2058,'1','Stock inicial',NULL,2058,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2059,'1','Stock inicial',NULL,2059,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2060,'1','Stock inicial',NULL,2060,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2061,'1','Stock inicial',NULL,2061,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2062,'1','Stock inicial',NULL,2062,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2063,'1','Stock inicial',NULL,2063,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2064,'1','Stock inicial',NULL,2064,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2065,'1','Stock inicial',NULL,2065,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2066,'1','Stock inicial',NULL,2066,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2067,'1','Stock inicial',NULL,2067,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2068,'1','Stock inicial',NULL,2068,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2069,'1','Stock inicial',NULL,2069,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2070,'1','Stock inicial',NULL,2070,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2071,'1','Stock inicial',NULL,2071,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2072,'1','Stock inicial',NULL,2072,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2073,'1','Stock inicial',NULL,2073,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2074,'1','Stock inicial',NULL,2074,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2075,'1','Stock inicial',NULL,2075,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2076,'1','Stock inicial',NULL,2076,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2077,'1','Stock inicial',NULL,2077,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2078,'1','Stock inicial',NULL,2078,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2079,'1','Stock inicial',NULL,2079,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2080,'1','Stock inicial',NULL,2080,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2081,'1','Stock inicial',NULL,2081,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2082,'1','Stock inicial',NULL,2082,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2083,'1','Stock inicial',NULL,2083,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2084,'1','Stock inicial',NULL,2084,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2085,'1','Stock inicial',NULL,2085,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2086,'1','Stock inicial',NULL,2086,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2087,'1','Stock inicial',NULL,2087,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:37','2024-11-10 18:48:37'),(2088,'1','Stock inicial',NULL,2088,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2089,'1','Stock inicial',NULL,2089,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2090,'1','Stock inicial',NULL,2090,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2091,'1','Stock inicial',NULL,2091,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2092,'1','Stock inicial',NULL,2092,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2093,'1','Stock inicial',NULL,2093,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2094,'1','Stock inicial',NULL,2094,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2095,'1','Stock inicial',NULL,2095,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2096,'1','Stock inicial',NULL,2096,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2097,'1','Stock inicial',NULL,2097,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2098,'1','Stock inicial',NULL,2098,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2099,'1','Stock inicial',NULL,2099,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2100,'1','Stock inicial',NULL,2100,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2101,'1','Stock inicial',NULL,2101,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2102,'1','Stock inicial',NULL,2102,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2103,'1','Stock inicial',NULL,2103,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2104,'1','Stock inicial',NULL,2104,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2105,'1','Stock inicial',NULL,2105,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2106,'1','Stock inicial',NULL,2106,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2107,'1','Stock inicial',NULL,2107,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2108,'1','Stock inicial',NULL,2108,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2109,'1','Stock inicial',NULL,2109,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2110,'1','Stock inicial',NULL,2110,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2111,'1','Stock inicial',NULL,2111,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2112,'1','Stock inicial',NULL,2112,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2113,'1','Stock inicial',NULL,2113,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2114,'1','Stock inicial',NULL,2114,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2115,'1','Stock inicial',NULL,2115,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2116,'1','Stock inicial',NULL,2116,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2117,'1','Stock inicial',NULL,2117,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2118,'1','Stock inicial',NULL,2118,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2119,'1','Stock inicial',NULL,2119,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2120,'1','Stock inicial',NULL,2120,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2121,'1','Stock inicial',NULL,2121,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2122,'1','Stock inicial',NULL,2122,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2123,'1','Stock inicial',NULL,2123,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2124,'1','Stock inicial',NULL,2124,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2125,'1','Stock inicial',NULL,2125,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2126,'1','Stock inicial',NULL,2126,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2127,'1','Stock inicial',NULL,2127,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2128,'1','Stock inicial',NULL,2128,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2129,'1','Stock inicial',NULL,2129,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2130,'1','Stock inicial',NULL,2130,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2131,'1','Stock inicial',NULL,2131,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2132,'1','Stock inicial',NULL,2132,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2133,'1','Stock inicial',NULL,2133,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2134,'1','Stock inicial',NULL,2134,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2135,'1','Stock inicial',NULL,2135,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2136,'1','Stock inicial',NULL,2136,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2137,'1','Stock inicial',NULL,2137,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2138,'1','Stock inicial',NULL,2138,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2139,'1','Stock inicial',NULL,2139,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2140,'1','Stock inicial',NULL,2140,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2141,'1','Stock inicial',NULL,2141,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2142,'1','Stock inicial',NULL,2142,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2143,'1','Stock inicial',NULL,2143,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2144,'1','Stock inicial',NULL,2144,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2145,'1','Stock inicial',NULL,2145,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2146,'1','Stock inicial',NULL,2146,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2147,'1','Stock inicial',NULL,2147,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2148,'1','Stock inicial',NULL,2148,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2149,'1','Stock inicial',NULL,2149,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2150,'1','Stock inicial',NULL,2150,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2151,'1','Stock inicial',NULL,2151,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2152,'1','Stock inicial',NULL,2152,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2153,'1','Stock inicial',NULL,2153,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2154,'1','Stock inicial',NULL,2154,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2155,'1','Stock inicial',NULL,2155,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2156,'1','Stock inicial',NULL,2156,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2157,'1','Stock inicial',NULL,2157,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2158,'1','Stock inicial',NULL,2158,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2159,'1','Stock inicial',NULL,2159,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2160,'1','Stock inicial',NULL,2160,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2161,'1','Stock inicial',NULL,2161,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2162,'1','Stock inicial',NULL,2162,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2163,'1','Stock inicial',NULL,2163,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2164,'1','Stock inicial',NULL,2164,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2165,'1','Stock inicial',NULL,2165,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2166,'1','Stock inicial',NULL,2166,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2167,'1','Stock inicial',NULL,2167,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2168,'1','Stock inicial',NULL,2168,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2169,'1','Stock inicial',NULL,2169,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2170,'1','Stock inicial',NULL,2170,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2171,'1','Stock inicial',NULL,2171,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2172,'1','Stock inicial',NULL,2172,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2173,'1','Stock inicial',NULL,2173,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2174,'1','Stock inicial',NULL,2174,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2175,'1','Stock inicial',NULL,2175,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2176,'1','Stock inicial',NULL,2176,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:38','2024-11-10 18:48:38'),(2177,'1','Stock inicial',NULL,2177,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2178,'1','Stock inicial',NULL,2178,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2179,'1','Stock inicial',NULL,2179,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2180,'1','Stock inicial',NULL,2180,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2181,'1','Stock inicial',NULL,2181,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2182,'1','Stock inicial',NULL,2182,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2183,'1','Stock inicial',NULL,2183,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2184,'1','Stock inicial',NULL,2184,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2185,'1','Stock inicial',NULL,2185,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2186,'1','Stock inicial',NULL,2186,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2187,'1','Stock inicial',NULL,2187,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2188,'1','Stock inicial',NULL,2188,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2189,'1','Stock inicial',NULL,2189,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2190,'1','Stock inicial',NULL,2190,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2191,'1','Stock inicial',NULL,2191,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2192,'1','Stock inicial',NULL,2192,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2193,'1','Stock inicial',NULL,2193,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2194,'1','Stock inicial',NULL,2194,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2195,'1','Stock inicial',NULL,2195,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2196,'1','Stock inicial',NULL,2196,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2197,'1','Stock inicial',NULL,2197,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2198,'1','Stock inicial',NULL,2198,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2199,'1','Stock inicial',NULL,2199,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2200,'1','Stock inicial',NULL,2200,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2201,'1','Stock inicial',NULL,2201,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2202,'1','Stock inicial',NULL,2202,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2203,'1','Stock inicial',NULL,2203,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2204,'1','Stock inicial',NULL,2204,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2205,'1','Stock inicial',NULL,2205,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2206,'1','Stock inicial',NULL,2206,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2207,'1','Stock inicial',NULL,2207,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2208,'1','Stock inicial',NULL,2208,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2209,'1','Stock inicial',NULL,2209,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2210,'1','Stock inicial',NULL,2210,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2211,'1','Stock inicial',NULL,2211,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2212,'1','Stock inicial',NULL,2212,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2213,'1','Stock inicial',NULL,2213,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2214,'1','Stock inicial',NULL,2214,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2215,'1','Stock inicial',NULL,2215,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2216,'1','Stock inicial',NULL,2216,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2217,'1','Stock inicial',NULL,2217,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2218,'1','Stock inicial',NULL,2218,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2219,'1','Stock inicial',NULL,2219,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2220,'1','Stock inicial',NULL,2220,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2221,'1','Stock inicial',NULL,2221,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2222,'1','Stock inicial',NULL,2222,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2223,'1','Stock inicial',NULL,2223,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2224,'1','Stock inicial',NULL,2224,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2225,'1','Stock inicial',NULL,2225,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2226,'1','Stock inicial',NULL,2226,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2227,'1','Stock inicial',NULL,2227,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2228,'1','Stock inicial',NULL,2228,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2229,'1','Stock inicial',NULL,2229,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2230,'1','Stock inicial',NULL,2230,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2231,'1','Stock inicial',NULL,2231,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2232,'1','Stock inicial',NULL,2232,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2233,'1','Stock inicial',NULL,2233,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2234,'1','Stock inicial',NULL,2234,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2235,'1','Stock inicial',NULL,2235,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2236,'1','Stock inicial',NULL,2236,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2237,'1','Stock inicial',NULL,2237,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2238,'1','Stock inicial',NULL,2238,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2239,'1','Stock inicial',NULL,2239,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2240,'1','Stock inicial',NULL,2240,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2241,'1','Stock inicial',NULL,2241,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2242,'1','Stock inicial',NULL,2242,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2243,'1','Stock inicial',NULL,2243,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2244,'1','Stock inicial',NULL,2244,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2245,'1','Stock inicial',NULL,2245,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2246,'1','Stock inicial',NULL,2246,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2247,'1','Stock inicial',NULL,2247,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2248,'1','Stock inicial',NULL,2248,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2249,'1','Stock inicial',NULL,2249,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2250,'1','Stock inicial',NULL,2250,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2251,'1','Stock inicial',NULL,2251,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2252,'1','Stock inicial',NULL,2252,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2253,'1','Stock inicial',NULL,2253,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2254,'1','Stock inicial',NULL,2254,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2255,'1','Stock inicial',NULL,2255,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2256,'1','Stock inicial',NULL,2256,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2257,'1','Stock inicial',NULL,2257,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2258,'1','Stock inicial',NULL,2258,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2259,'1','Stock inicial',NULL,2259,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2260,'1','Stock inicial',NULL,2260,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2261,'1','Stock inicial',NULL,2261,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2262,'1','Stock inicial',NULL,2262,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2263,'1','Stock inicial',NULL,2263,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2264,'1','Stock inicial',NULL,2264,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2265,'1','Stock inicial',NULL,2265,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2266,'1','Stock inicial',NULL,2266,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2267,'1','Stock inicial',NULL,2267,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2268,'1','Stock inicial',NULL,2268,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2269,'1','Stock inicial',NULL,2269,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2270,'1','Stock inicial',NULL,2270,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2271,'1','Stock inicial',NULL,2271,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2272,'1','Stock inicial',NULL,2272,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2273,'1','Stock inicial',NULL,2273,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:39','2024-11-10 18:48:39'),(2274,'1','Stock inicial',NULL,2274,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2275,'1','Stock inicial',NULL,2275,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2276,'1','Stock inicial',NULL,2276,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2277,'1','Stock inicial',NULL,2277,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2278,'1','Stock inicial',NULL,2278,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2279,'1','Stock inicial',NULL,2279,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2280,'1','Stock inicial',NULL,2280,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2281,'1','Stock inicial',NULL,2281,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2282,'1','Stock inicial',NULL,2282,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2283,'1','Stock inicial',NULL,2283,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2284,'1','Stock inicial',NULL,2284,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2285,'1','Stock inicial',NULL,2285,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2286,'1','Stock inicial',NULL,2286,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2287,'1','Stock inicial',NULL,2287,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2288,'1','Stock inicial',NULL,2288,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2289,'1','Stock inicial',NULL,2289,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2290,'1','Stock inicial',NULL,2290,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2291,'1','Stock inicial',NULL,2291,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2292,'1','Stock inicial',NULL,2292,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2293,'1','Stock inicial',NULL,2293,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2294,'1','Stock inicial',NULL,2294,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2295,'1','Stock inicial',NULL,2295,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2296,'1','Stock inicial',NULL,2296,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2297,'1','Stock inicial',NULL,2297,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2298,'1','Stock inicial',NULL,2298,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2299,'1','Stock inicial',NULL,2299,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2300,'1','Stock inicial',NULL,2300,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2301,'1','Stock inicial',NULL,2301,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2302,'1','Stock inicial',NULL,2302,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2303,'1','Stock inicial',NULL,2303,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2304,'1','Stock inicial',NULL,2304,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2305,'1','Stock inicial',NULL,2305,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2306,'1','Stock inicial',NULL,2306,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2307,'1','Stock inicial',NULL,2307,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2308,'1','Stock inicial',NULL,2308,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2309,'1','Stock inicial',NULL,2309,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2310,'1','Stock inicial',NULL,2310,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2311,'1','Stock inicial',NULL,2311,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2312,'1','Stock inicial',NULL,2312,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2313,'1','Stock inicial',NULL,2313,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2314,'1','Stock inicial',NULL,2314,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2315,'1','Stock inicial',NULL,2315,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2316,'1','Stock inicial',NULL,2316,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2317,'1','Stock inicial',NULL,2317,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2318,'1','Stock inicial',NULL,2318,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2319,'1','Stock inicial',NULL,2319,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2320,'1','Stock inicial',NULL,2320,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2321,'1','Stock inicial',NULL,2321,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2322,'1','Stock inicial',NULL,2322,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2323,'1','Stock inicial',NULL,2323,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2324,'1','Stock inicial',NULL,2324,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2325,'1','Stock inicial',NULL,2325,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2326,'1','Stock inicial',NULL,2326,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2327,'1','Stock inicial',NULL,2327,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2328,'1','Stock inicial',NULL,2328,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2329,'1','Stock inicial',NULL,2329,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2330,'1','Stock inicial',NULL,2330,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2331,'1','Stock inicial',NULL,2331,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2332,'1','Stock inicial',NULL,2332,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2333,'1','Stock inicial',NULL,2333,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2334,'1','Stock inicial',NULL,2334,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2335,'1','Stock inicial',NULL,2335,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2336,'1','Stock inicial',NULL,2336,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2337,'1','Stock inicial',NULL,2337,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2338,'1','Stock inicial',NULL,2338,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2339,'1','Stock inicial',NULL,2339,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2340,'1','Stock inicial',NULL,2340,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2341,'1','Stock inicial',NULL,2341,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2342,'1','Stock inicial',NULL,2342,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2343,'1','Stock inicial',NULL,2343,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2344,'1','Stock inicial',NULL,2344,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2345,'1','Stock inicial',NULL,2345,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2346,'1','Stock inicial',NULL,2346,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2347,'1','Stock inicial',NULL,2347,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2348,'1','Stock inicial',NULL,2348,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2349,'1','Stock inicial',NULL,2349,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2350,'1','Stock inicial',NULL,2350,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2351,'1','Stock inicial',NULL,2351,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2352,'1','Stock inicial',NULL,2352,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2353,'1','Stock inicial',NULL,2353,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2354,'1','Stock inicial',NULL,2354,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2355,'1','Stock inicial',NULL,2355,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2356,'1','Stock inicial',NULL,2356,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2357,'1','Stock inicial',NULL,2357,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2358,'1','Stock inicial',NULL,2358,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2359,'1','Stock inicial',NULL,2359,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2360,'1','Stock inicial',NULL,2360,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2361,'1','Stock inicial',NULL,2361,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2362,'1','Stock inicial',NULL,2362,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2363,'1','Stock inicial',NULL,2363,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2364,'1','Stock inicial',NULL,2364,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2365,'1','Stock inicial',NULL,2365,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2366,'1','Stock inicial',NULL,2366,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2367,'1','Stock inicial',NULL,2367,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2368,'1','Stock inicial',NULL,2368,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2369,'1','Stock inicial',NULL,2369,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2370,'1','Stock inicial',NULL,2370,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2371,'1','Stock inicial',NULL,2371,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2372,'1','Stock inicial',NULL,2372,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2373,'1','Stock inicial',NULL,2373,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2374,'1','Stock inicial',NULL,2374,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2375,'1','Stock inicial',NULL,2375,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2376,'1','Stock inicial',NULL,2376,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2377,'1','Stock inicial',NULL,2377,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2378,'1','Stock inicial',NULL,2378,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2379,'1','Stock inicial',NULL,2379,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2380,'1','Stock inicial',NULL,2380,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2381,'1','Stock inicial',NULL,2381,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2382,'1','Stock inicial',NULL,2382,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2383,'1','Stock inicial',NULL,2383,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:40','2024-11-10 18:48:40'),(2384,'1','Stock inicial',NULL,2384,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2385,'1','Stock inicial',NULL,2385,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2386,'1','Stock inicial',NULL,2386,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2387,'1','Stock inicial',NULL,2387,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2388,'1','Stock inicial',NULL,2388,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2389,'1','Stock inicial',NULL,2389,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2390,'1','Stock inicial',NULL,2390,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2391,'1','Stock inicial',NULL,2391,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2392,'1','Stock inicial',NULL,2392,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2393,'1','Stock inicial',NULL,2393,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2394,'1','Stock inicial',NULL,2394,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2395,'1','Stock inicial',NULL,2395,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2396,'1','Stock inicial',NULL,2396,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2397,'1','Stock inicial',NULL,2397,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2398,'1','Stock inicial',NULL,2398,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2399,'1','Stock inicial',NULL,2399,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2400,'1','Stock inicial',NULL,2400,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2401,'1','Stock inicial',NULL,2401,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2402,'1','Stock inicial',NULL,2402,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2403,'1','Stock inicial',NULL,2403,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2404,'1','Stock inicial',NULL,2404,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2405,'1','Stock inicial',NULL,2405,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2406,'1','Stock inicial',NULL,2406,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2407,'1','Stock inicial',NULL,2407,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2408,'1','Stock inicial',NULL,2408,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2409,'1','Stock inicial',NULL,2409,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2410,'1','Stock inicial',NULL,2410,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2411,'1','Stock inicial',NULL,2411,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2412,'1','Stock inicial',NULL,2412,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2413,'1','Stock inicial',NULL,2413,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2414,'1','Stock inicial',NULL,2414,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2415,'1','Stock inicial',NULL,2415,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2416,'1','Stock inicial',NULL,2416,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2417,'1','Stock inicial',NULL,2417,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2418,'1','Stock inicial',NULL,2418,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2419,'1','Stock inicial',NULL,2419,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2420,'1','Stock inicial',NULL,2420,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2421,'1','Stock inicial',NULL,2421,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2422,'1','Stock inicial',NULL,2422,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2423,'1','Stock inicial',NULL,2423,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2424,'1','Stock inicial',NULL,2424,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2425,'1','Stock inicial',NULL,2425,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2426,'1','Stock inicial',NULL,2426,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2427,'1','Stock inicial',NULL,2427,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2428,'1','Stock inicial',NULL,2428,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2429,'1','Stock inicial',NULL,2429,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2430,'1','Stock inicial',NULL,2430,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2431,'1','Stock inicial',NULL,2431,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2432,'1','Stock inicial',NULL,2432,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2433,'1','Stock inicial',NULL,2433,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2434,'1','Stock inicial',NULL,2434,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2435,'1','Stock inicial',NULL,2435,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2436,'1','Stock inicial',NULL,2436,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2437,'1','Stock inicial',NULL,2437,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2438,'1','Stock inicial',NULL,2438,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2439,'1','Stock inicial',NULL,2439,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2440,'1','Stock inicial',NULL,2440,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2441,'1','Stock inicial',NULL,2441,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2442,'1','Stock inicial',NULL,2442,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2443,'1','Stock inicial',NULL,2443,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2444,'1','Stock inicial',NULL,2444,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2445,'1','Stock inicial',NULL,2445,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2446,'1','Stock inicial',NULL,2446,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2447,'1','Stock inicial',NULL,2447,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2448,'1','Stock inicial',NULL,2448,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2449,'1','Stock inicial',NULL,2449,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2450,'1','Stock inicial',NULL,2450,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2451,'1','Stock inicial',NULL,2451,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2452,'1','Stock inicial',NULL,2452,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2453,'1','Stock inicial',NULL,2453,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2454,'1','Stock inicial',NULL,2454,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2455,'1','Stock inicial',NULL,2455,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2456,'1','Stock inicial',NULL,2456,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2457,'1','Stock inicial',NULL,2457,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2458,'1','Stock inicial',NULL,2458,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2459,'1','Stock inicial',NULL,2459,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2460,'1','Stock inicial',NULL,2460,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2461,'1','Stock inicial',NULL,2461,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2462,'1','Stock inicial',NULL,2462,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2463,'1','Stock inicial',NULL,2463,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2464,'1','Stock inicial',NULL,2464,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2465,'1','Stock inicial',NULL,2465,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2466,'1','Stock inicial',NULL,2466,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2467,'1','Stock inicial',NULL,2467,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2468,'1','Stock inicial',NULL,2468,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2469,'1','Stock inicial',NULL,2469,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2470,'1','Stock inicial',NULL,2470,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2471,'1','Stock inicial',NULL,2471,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2472,'1','Stock inicial',NULL,2472,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2473,'1','Stock inicial',NULL,2473,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2474,'1','Stock inicial',NULL,2474,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2475,'1','Stock inicial',NULL,2475,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2476,'1','Stock inicial',NULL,2476,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2477,'1','Stock inicial',NULL,2477,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2478,'1','Stock inicial',NULL,2478,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2479,'1','Stock inicial',NULL,2479,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2480,'1','Stock inicial',NULL,2480,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2481,'1','Stock inicial',NULL,2481,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2482,'1','Stock inicial',NULL,2482,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2483,'1','Stock inicial',NULL,2483,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2484,'1','Stock inicial',NULL,2484,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2485,'1','Stock inicial',NULL,2485,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2486,'1','Stock inicial',NULL,2486,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2487,'1','Stock inicial',NULL,2487,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2488,'1','Stock inicial',NULL,2488,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2489,'1','Stock inicial',NULL,2489,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2490,'1','Stock inicial',NULL,2490,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2491,'1','Stock inicial',NULL,2491,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2492,'1','Stock inicial',NULL,2492,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2493,'1','Stock inicial',NULL,2493,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:41','2024-11-10 18:48:41'),(2494,'1','Stock inicial',NULL,2494,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2495,'1','Stock inicial',NULL,2495,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2496,'1','Stock inicial',NULL,2496,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2497,'1','Stock inicial',NULL,2497,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2498,'1','Stock inicial',NULL,2498,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2499,'1','Stock inicial',NULL,2499,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2500,'1','Stock inicial',NULL,2500,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2501,'1','Stock inicial',NULL,2501,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2502,'1','Stock inicial',NULL,2502,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2503,'1','Stock inicial',NULL,2503,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2504,'1','Stock inicial',NULL,2504,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2505,'1','Stock inicial',NULL,2505,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2506,'1','Stock inicial',NULL,2506,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2507,'1','Stock inicial',NULL,2507,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2508,'1','Stock inicial',NULL,2508,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2509,'1','Stock inicial',NULL,2509,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2510,'1','Stock inicial',NULL,2510,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2511,'1','Stock inicial',NULL,2511,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2512,'1','Stock inicial',NULL,2512,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2513,'1','Stock inicial',NULL,2513,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2514,'1','Stock inicial',NULL,2514,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2515,'1','Stock inicial',NULL,2515,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2516,'1','Stock inicial',NULL,2516,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2517,'1','Stock inicial',NULL,2517,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2518,'1','Stock inicial',NULL,2518,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2519,'1','Stock inicial',NULL,2519,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2520,'1','Stock inicial',NULL,2520,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2521,'1','Stock inicial',NULL,2521,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2522,'1','Stock inicial',NULL,2522,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2523,'1','Stock inicial',NULL,2523,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2524,'1','Stock inicial',NULL,2524,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2525,'1','Stock inicial',NULL,2525,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2526,'1','Stock inicial',NULL,2526,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2527,'1','Stock inicial',NULL,2527,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2528,'1','Stock inicial',NULL,2528,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2529,'1','Stock inicial',NULL,2529,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2530,'1','Stock inicial',NULL,2530,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2531,'1','Stock inicial',NULL,2531,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2532,'1','Stock inicial',NULL,2532,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2533,'1','Stock inicial',NULL,2533,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2534,'1','Stock inicial',NULL,2534,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2535,'1','Stock inicial',NULL,2535,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2536,'1','Stock inicial',NULL,2536,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2537,'1','Stock inicial',NULL,2537,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2538,'1','Stock inicial',NULL,2538,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2539,'1','Stock inicial',NULL,2539,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2540,'1','Stock inicial',NULL,2540,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2541,'1','Stock inicial',NULL,2541,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2542,'1','Stock inicial',NULL,2542,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2543,'1','Stock inicial',NULL,2543,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2544,'1','Stock inicial',NULL,2544,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2545,'1','Stock inicial',NULL,2545,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2546,'1','Stock inicial',NULL,2546,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2547,'1','Stock inicial',NULL,2547,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2548,'1','Stock inicial',NULL,2548,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2549,'1','Stock inicial',NULL,2549,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2550,'1','Stock inicial',NULL,2550,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2551,'1','Stock inicial',NULL,2551,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2552,'1','Stock inicial',NULL,2552,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2553,'1','Stock inicial',NULL,2553,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2554,'1','Stock inicial',NULL,2554,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2555,'1','Stock inicial',NULL,2555,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2556,'1','Stock inicial',NULL,2556,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2557,'1','Stock inicial',NULL,2557,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2558,'1','Stock inicial',NULL,2558,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2559,'1','Stock inicial',NULL,2559,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2560,'1','Stock inicial',NULL,2560,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2561,'1','Stock inicial',NULL,2561,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2562,'1','Stock inicial',NULL,2562,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2563,'1','Stock inicial',NULL,2563,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2564,'1','Stock inicial',NULL,2564,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2565,'1','Stock inicial',NULL,2565,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2566,'1','Stock inicial',NULL,2566,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2567,'1','Stock inicial',NULL,2567,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2568,'1','Stock inicial',NULL,2568,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2569,'1','Stock inicial',NULL,2569,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2570,'1','Stock inicial',NULL,2570,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2571,'1','Stock inicial',NULL,2571,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2572,'1','Stock inicial',NULL,2572,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2573,'1','Stock inicial',NULL,2573,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2574,'1','Stock inicial',NULL,2574,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2575,'1','Stock inicial',NULL,2575,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2576,'1','Stock inicial',NULL,2576,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2577,'1','Stock inicial',NULL,2577,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2578,'1','Stock inicial',NULL,2578,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2579,'1','Stock inicial',NULL,2579,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2580,'1','Stock inicial',NULL,2580,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2581,'1','Stock inicial',NULL,2581,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2582,'1','Stock inicial',NULL,2582,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2583,'1','Stock inicial',NULL,2583,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2584,'1','Stock inicial',NULL,2584,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2585,'1','Stock inicial',NULL,2585,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2586,'1','Stock inicial',NULL,2586,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2587,'1','Stock inicial',NULL,2587,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2588,'1','Stock inicial',NULL,2588,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2589,'1','Stock inicial',NULL,2589,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2590,'1','Stock inicial',NULL,2590,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2591,'1','Stock inicial',NULL,2591,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2592,'1','Stock inicial',NULL,2592,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2593,'1','Stock inicial',NULL,2593,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2594,'1','Stock inicial',NULL,2594,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2595,'1','Stock inicial',NULL,2595,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2596,'1','Stock inicial',NULL,2596,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2597,'1','Stock inicial',NULL,2597,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2598,'1','Stock inicial',NULL,2598,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2599,'1','Stock inicial',NULL,2599,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2600,'1','Stock inicial',NULL,2600,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2601,'1','Stock inicial',NULL,2601,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2602,'1','Stock inicial',NULL,2602,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2603,'1','Stock inicial',NULL,2603,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2604,'1','Stock inicial',NULL,2604,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2605,'1','Stock inicial',NULL,2605,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2606,'1','Stock inicial',NULL,2606,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2607,'1','Stock inicial',NULL,2607,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2608,'1','Stock inicial',NULL,2608,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2609,'1','Stock inicial',NULL,2609,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2610,'1','Stock inicial',NULL,2610,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2611,'1','Stock inicial',NULL,2611,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2612,'1','Stock inicial',NULL,2612,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2613,'1','Stock inicial',NULL,2613,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2614,'1','Stock inicial',NULL,2614,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:42','2024-11-10 18:48:42'),(2615,'1','Stock inicial',NULL,2615,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2616,'1','Stock inicial',NULL,2616,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2617,'1','Stock inicial',NULL,2617,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2618,'1','Stock inicial',NULL,2618,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2619,'1','Stock inicial',NULL,2619,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2620,'1','Stock inicial',NULL,2620,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2621,'1','Stock inicial',NULL,2621,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2622,'1','Stock inicial',NULL,2622,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2623,'1','Stock inicial',NULL,2623,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2624,'1','Stock inicial',NULL,2624,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2625,'1','Stock inicial',NULL,2625,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2626,'1','Stock inicial',NULL,2626,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2627,'1','Stock inicial',NULL,2627,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2628,'1','Stock inicial',NULL,2628,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2629,'1','Stock inicial',NULL,2629,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2630,'1','Stock inicial',NULL,2630,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2631,'1','Stock inicial',NULL,2631,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2632,'1','Stock inicial',NULL,2632,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2633,'1','Stock inicial',NULL,2633,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2634,'1','Stock inicial',NULL,2634,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2635,'1','Stock inicial',NULL,2635,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2636,'1','Stock inicial',NULL,2636,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2637,'1','Stock inicial',NULL,2637,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2638,'1','Stock inicial',NULL,2638,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2639,'1','Stock inicial',NULL,2639,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2640,'1','Stock inicial',NULL,2640,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2641,'1','Stock inicial',NULL,2641,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2642,'1','Stock inicial',NULL,2642,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2643,'1','Stock inicial',NULL,2643,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2644,'1','Stock inicial',NULL,2644,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2645,'1','Stock inicial',NULL,2645,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2646,'1','Stock inicial',NULL,2646,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2647,'1','Stock inicial',NULL,2647,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2648,'1','Stock inicial',NULL,2648,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2649,'1','Stock inicial',NULL,2649,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2650,'1','Stock inicial',NULL,2650,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2651,'1','Stock inicial',NULL,2651,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2652,'1','Stock inicial',NULL,2652,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2653,'1','Stock inicial',NULL,2653,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2654,'1','Stock inicial',NULL,2654,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2655,'1','Stock inicial',NULL,2655,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2656,'1','Stock inicial',NULL,2656,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2657,'1','Stock inicial',NULL,2657,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2658,'1','Stock inicial',NULL,2658,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2659,'1','Stock inicial',NULL,2659,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2660,'1','Stock inicial',NULL,2660,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2661,'1','Stock inicial',NULL,2661,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2662,'1','Stock inicial',NULL,2662,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2663,'1','Stock inicial',NULL,2663,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2664,'1','Stock inicial',NULL,2664,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2665,'1','Stock inicial',NULL,2665,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2666,'1','Stock inicial',NULL,2666,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2667,'1','Stock inicial',NULL,2667,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2668,'1','Stock inicial',NULL,2668,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2669,'1','Stock inicial',NULL,2669,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2670,'1','Stock inicial',NULL,2670,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2671,'1','Stock inicial',NULL,2671,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2672,'1','Stock inicial',NULL,2672,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2673,'1','Stock inicial',NULL,2673,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2674,'1','Stock inicial',NULL,2674,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2675,'1','Stock inicial',NULL,2675,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2676,'1','Stock inicial',NULL,2676,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2677,'1','Stock inicial',NULL,2677,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2678,'1','Stock inicial',NULL,2678,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2679,'1','Stock inicial',NULL,2679,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2680,'1','Stock inicial',NULL,2680,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2681,'1','Stock inicial',NULL,2681,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2682,'1','Stock inicial',NULL,2682,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2683,'1','Stock inicial',NULL,2683,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2684,'1','Stock inicial',NULL,2684,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2685,'1','Stock inicial',NULL,2685,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2686,'1','Stock inicial',NULL,2686,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2687,'1','Stock inicial',NULL,2687,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2688,'1','Stock inicial',NULL,2688,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2689,'1','Stock inicial',NULL,2689,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2690,'1','Stock inicial',NULL,2690,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2691,'1','Stock inicial',NULL,2691,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2692,'1','Stock inicial',NULL,2692,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2693,'1','Stock inicial',NULL,2693,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2694,'1','Stock inicial',NULL,2694,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2695,'1','Stock inicial',NULL,2695,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2696,'1','Stock inicial',NULL,2696,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2697,'1','Stock inicial',NULL,2697,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2698,'1','Stock inicial',NULL,2698,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2699,'1','Stock inicial',NULL,2699,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2700,'1','Stock inicial',NULL,2700,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2701,'1','Stock inicial',NULL,2701,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2702,'1','Stock inicial',NULL,2702,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2703,'1','Stock inicial',NULL,2703,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2704,'1','Stock inicial',NULL,2704,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2705,'1','Stock inicial',NULL,2705,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2706,'1','Stock inicial',NULL,2706,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2707,'1','Stock inicial',NULL,2707,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2708,'1','Stock inicial',NULL,2708,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2709,'1','Stock inicial',NULL,2709,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2710,'1','Stock inicial',NULL,2710,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2711,'1','Stock inicial',NULL,2711,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2712,'1','Stock inicial',NULL,2712,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2713,'1','Stock inicial',NULL,2713,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2714,'1','Stock inicial',NULL,2714,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2715,'1','Stock inicial',NULL,2715,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2716,'1','Stock inicial',NULL,2716,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2717,'1','Stock inicial',NULL,2717,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2718,'1','Stock inicial',NULL,2718,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2719,'1','Stock inicial',NULL,2719,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2720,'1','Stock inicial',NULL,2720,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2721,'1','Stock inicial',NULL,2721,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2722,'1','Stock inicial',NULL,2722,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2723,'1','Stock inicial',NULL,2723,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2724,'1','Stock inicial',NULL,2724,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2725,'1','Stock inicial',NULL,2725,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2726,'1','Stock inicial',NULL,2726,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2727,'1','Stock inicial',NULL,2727,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2728,'1','Stock inicial',NULL,2728,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2729,'1','Stock inicial',NULL,2729,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2730,'1','Stock inicial',NULL,2730,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2731,'1','Stock inicial',NULL,2731,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:43','2024-11-10 18:48:43'),(2732,'1','Stock inicial',NULL,2732,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2733,'1','Stock inicial',NULL,2733,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2734,'1','Stock inicial',NULL,2734,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2735,'1','Stock inicial',NULL,2735,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2736,'1','Stock inicial',NULL,2736,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2737,'1','Stock inicial',NULL,2737,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2738,'1','Stock inicial',NULL,2738,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2739,'1','Stock inicial',NULL,2739,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2740,'1','Stock inicial',NULL,2740,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2741,'1','Stock inicial',NULL,2741,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2742,'1','Stock inicial',NULL,2742,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2743,'1','Stock inicial',NULL,2743,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2744,'1','Stock inicial',NULL,2744,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2745,'1','Stock inicial',NULL,2745,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2746,'1','Stock inicial',NULL,2746,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2747,'1','Stock inicial',NULL,2747,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2748,'1','Stock inicial',NULL,2748,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2749,'1','Stock inicial',NULL,2749,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2750,'1','Stock inicial',NULL,2750,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2751,'1','Stock inicial',NULL,2751,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2752,'1','Stock inicial',NULL,2752,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2753,'1','Stock inicial',NULL,2753,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2754,'1','Stock inicial',NULL,2754,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2755,'1','Stock inicial',NULL,2755,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2756,'1','Stock inicial',NULL,2756,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2757,'1','Stock inicial',NULL,2757,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2758,'1','Stock inicial',NULL,2758,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2759,'1','Stock inicial',NULL,2759,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2760,'1','Stock inicial',NULL,2760,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2761,'1','Stock inicial',NULL,2761,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2762,'1','Stock inicial',NULL,2762,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2763,'1','Stock inicial',NULL,2763,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2764,'1','Stock inicial',NULL,2764,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2765,'1','Stock inicial',NULL,2765,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2766,'1','Stock inicial',NULL,2766,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2767,'1','Stock inicial',NULL,2767,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2768,'1','Stock inicial',NULL,2768,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2769,'1','Stock inicial',NULL,2769,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2770,'1','Stock inicial',NULL,2770,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2771,'1','Stock inicial',NULL,2771,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2772,'1','Stock inicial',NULL,2772,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2773,'1','Stock inicial',NULL,2773,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2774,'1','Stock inicial',NULL,2774,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2775,'1','Stock inicial',NULL,2775,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2776,'1','Stock inicial',NULL,2776,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2777,'1','Stock inicial',NULL,2777,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2778,'1','Stock inicial',NULL,2778,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2779,'1','Stock inicial',NULL,2779,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2780,'1','Stock inicial',NULL,2780,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2781,'1','Stock inicial',NULL,2781,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2782,'1','Stock inicial',NULL,2782,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2783,'1','Stock inicial',NULL,2783,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2784,'1','Stock inicial',NULL,2784,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2785,'1','Stock inicial',NULL,2785,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2786,'1','Stock inicial',NULL,2786,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2787,'1','Stock inicial',NULL,2787,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2788,'1','Stock inicial',NULL,2788,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2789,'1','Stock inicial',NULL,2789,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2790,'1','Stock inicial',NULL,2790,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2791,'1','Stock inicial',NULL,2791,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2792,'1','Stock inicial',NULL,2792,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2793,'1','Stock inicial',NULL,2793,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2794,'1','Stock inicial',NULL,2794,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2795,'1','Stock inicial',NULL,2795,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2796,'1','Stock inicial',NULL,2796,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2797,'1','Stock inicial',NULL,2797,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2798,'1','Stock inicial',NULL,2798,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2799,'1','Stock inicial',NULL,2799,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2800,'1','Stock inicial',NULL,2800,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2801,'1','Stock inicial',NULL,2801,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2802,'1','Stock inicial',NULL,2802,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2803,'1','Stock inicial',NULL,2803,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2804,'1','Stock inicial',NULL,2804,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2805,'1','Stock inicial',NULL,2805,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2806,'1','Stock inicial',NULL,2806,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2807,'1','Stock inicial',NULL,2807,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2808,'1','Stock inicial',NULL,2808,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2809,'1','Stock inicial',NULL,2809,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2810,'1','Stock inicial',NULL,2810,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2811,'1','Stock inicial',NULL,2811,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2812,'1','Stock inicial',NULL,2812,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2813,'1','Stock inicial',NULL,2813,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2814,'1','Stock inicial',NULL,2814,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2815,'1','Stock inicial',NULL,2815,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2816,'1','Stock inicial',NULL,2816,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2817,'1','Stock inicial',NULL,2817,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2818,'1','Stock inicial',NULL,2818,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2819,'1','Stock inicial',NULL,2819,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2820,'1','Stock inicial',NULL,2820,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2821,'1','Stock inicial',NULL,2821,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2822,'1','Stock inicial',NULL,2822,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2823,'1','Stock inicial',NULL,2823,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2824,'1','Stock inicial',NULL,2824,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2825,'1','Stock inicial',NULL,2825,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2826,'1','Stock inicial',NULL,2826,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2827,'1','Stock inicial',NULL,2827,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2828,'1','Stock inicial',NULL,2828,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2829,'1','Stock inicial',NULL,2829,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2830,'1','Stock inicial',NULL,2830,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2831,'1','Stock inicial',NULL,2831,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2832,'1','Stock inicial',NULL,2832,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2833,'1','Stock inicial',NULL,2833,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2834,'1','Stock inicial',NULL,2834,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2835,'1','Stock inicial',NULL,2835,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2836,'1','Stock inicial',NULL,2836,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2837,'1','Stock inicial',NULL,2837,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2838,'1','Stock inicial',NULL,2838,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2839,'1','Stock inicial',NULL,2839,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2840,'1','Stock inicial',NULL,2840,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:44','2024-11-10 18:48:44'),(2841,'1','Stock inicial',NULL,2841,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2842,'1','Stock inicial',NULL,2842,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2843,'1','Stock inicial',NULL,2843,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2844,'1','Stock inicial',NULL,2844,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2845,'1','Stock inicial',NULL,2845,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2846,'1','Stock inicial',NULL,2846,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2847,'1','Stock inicial',NULL,2847,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2848,'1','Stock inicial',NULL,2848,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2849,'1','Stock inicial',NULL,2849,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2850,'1','Stock inicial',NULL,2850,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2851,'1','Stock inicial',NULL,2851,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2852,'1','Stock inicial',NULL,2852,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2853,'1','Stock inicial',NULL,2853,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2854,'1','Stock inicial',NULL,2854,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2855,'1','Stock inicial',NULL,2855,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2856,'1','Stock inicial',NULL,2856,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2857,'1','Stock inicial',NULL,2857,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2858,'1','Stock inicial',NULL,2858,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2859,'1','Stock inicial',NULL,2859,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2860,'1','Stock inicial',NULL,2860,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2861,'1','Stock inicial',NULL,2861,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2862,'1','Stock inicial',NULL,2862,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2863,'1','Stock inicial',NULL,2863,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2864,'1','Stock inicial',NULL,2864,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2865,'1','Stock inicial',NULL,2865,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2866,'1','Stock inicial',NULL,2866,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2867,'1','Stock inicial',NULL,2867,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2868,'1','Stock inicial',NULL,2868,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2869,'1','Stock inicial',NULL,2869,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2870,'1','Stock inicial',NULL,2870,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2871,'1','Stock inicial',NULL,2871,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2872,'1','Stock inicial',NULL,2872,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2873,'1','Stock inicial',NULL,2873,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2874,'1','Stock inicial',NULL,2874,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2875,'1','Stock inicial',NULL,2875,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2876,'1','Stock inicial',NULL,2876,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2877,'1','Stock inicial',NULL,2877,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2878,'1','Stock inicial',NULL,2878,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2879,'1','Stock inicial',NULL,2879,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2880,'1','Stock inicial',NULL,2880,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2881,'1','Stock inicial',NULL,2881,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2882,'1','Stock inicial',NULL,2882,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2883,'1','Stock inicial',NULL,2883,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2884,'1','Stock inicial',NULL,2884,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2885,'1','Stock inicial',NULL,2885,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2886,'1','Stock inicial',NULL,2886,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2887,'1','Stock inicial',NULL,2887,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2888,'1','Stock inicial',NULL,2888,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2889,'1','Stock inicial',NULL,2889,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2890,'1','Stock inicial',NULL,2890,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2891,'1','Stock inicial',NULL,2891,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2892,'1','Stock inicial',NULL,2892,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2893,'1','Stock inicial',NULL,2893,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2894,'1','Stock inicial',NULL,2894,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2895,'1','Stock inicial',NULL,2895,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2896,'1','Stock inicial',NULL,2896,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2897,'1','Stock inicial',NULL,2897,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2898,'1','Stock inicial',NULL,2898,1,NULL,NULL,100.0000,NULL,NULL,NULL,NULL,NULL,NULL,NULL,'2024-11-10 18:48:45','2024-11-10 18:48:45'),(2899,'1','Stock inicial',NULL,2899,1,NULL,NULL,100.0